import 'dart:io';
import 'dart:math' as math;
import 'dart:convert';

main() async {
  var server = await HttpServer.bind(InternetAddress.LOOPBACK_IP_V4, 4049);
  await for (var req in server) {
    ContentType contentType = req.headers.contentType;

    req.response.headers
      ..set('Access-Control-Allow-Origin', '*')
      ..set('Access-Control-Allow-Methods', 'GET,POST,PUT,DELETE,OPTIONS')
      ..set('Access-Control-Allow-Headers',
          'Content-Type, Access-Control-Allow-Headers, Cache-Control, Authorization, X-Requested-With');

    if (req.method == 'OPTIONS') {
      // Nohting to do
    } else if (req.method == 'POST') {
//      if (new math.Random().nextInt(4) != 1) {
//        print("HI");
//        req.response..statusCode = HttpStatus.METHOD_NOT_ALLOWED;
//      }
      req.response..write("Success");
    } else {
      req.response
        ..statusCode = HttpStatus.METHOD_NOT_ALLOWED
        ..write("Unsupported request: ${req.method}.");
    }
    req.response.close();
  }
}
