// Generated by CoffeeScript 1.10.0
(function() {
  var google, matchFont, matchFontInLibraries, matchFontInLibrary, normalize, processFont, typekit;

  google = require('./fonts/google');

  typekit = require('./fonts/typekit');

  normalize = function(str) {
    return str.toLowerCase().replace(/( |-)/g, '');
  };

  matchFontInLibrary = function(name, normalizedName, library) {
    var font, i, len, normalizedFont, ref, result;
    result = null;
    ref = library.getNames();
    for (i = 0, len = ref.length; i < len; i++) {
      font = ref[i];
      normalizedFont = normalize(font);
      if (name === font || normalizedName === normalizedFont) {
        result = font;
        break;
      } else if (normalizedName.indexOf(normalizedFont) > -1 || normalizedFont.indexOf(normalizedName) > -1) {
        result = font;
      }
    }
    if (result) {
      return {
        library: library,
        name: result
      };
    }
  };

  matchFontInLibraries = function(name, libraries) {
    var normalizedName, xf;
    normalizedName = normalize(name);
    xf = function(result, library) {
      var match;
      match = matchFontInLibrary(name, normalizedName, library);
      if (match) {
        result.push(processFont(match));
      }
      return result;
    };
    return libraries.reduce(xf, []);
  };

  processFont = function(arg) {
    var library, name;
    library = arg.library, name = arg.name;
    return {
      library: library,
      name: library.normalizeName(name),
      link: library.getLink(name)
    };
  };

  matchFont = function(name) {
    var libraries;
    libraries = [typekit, google];
    return matchFontInLibraries(name, libraries);
  };

  module.exports = {
    matchFontInLibraries: matchFontInLibraries,
    matchFont: matchFont,
    libraries: {
      google: google,
      typekit: typekit
    }
  };

}).call(this);
