<?php
function setupILIASDatabase()
{
	global $ilDB;



//
// acc_access_key
//
$fields = array (
	"lang_key" => array (
		"notnull" => true
		,"length" => 2
		,"default" => ""
		,"fixed" => true
		,"type" => "text"
	)
	,"function_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"access_key" => array (
		"notnull" => false
		,"length" => 1
		,"fixed" => true
		,"type" => "text"
	)
);
$ilDB->createTable("acc_access_key", $fields);

$pk_fields = array("lang_key","function_id");
$ilDB->addPrimaryKey("acc_access_key", $pk_fields);


//
// acc_cache
//
$fields = array (
	"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"time" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"result" => array (
		"notnull" => false
		,"type" => "clob"
	)
);
$ilDB->createTable("acc_cache", $fields);

$pk_fields = array("user_id");
$ilDB->addPrimaryKey("acc_cache", $pk_fields);


//
// acc_criterion_to_doc
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"doc_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"criterion_id" => array (
		"notnull" => true
		,"length" => 50
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"criterion_value" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"assigned_ts" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"modification_ts" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"owner_usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"last_modified_usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("acc_criterion_to_doc", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("acc_criterion_to_doc", $pk_fields);

$ilDB->createSequence("acc_criterion_to_doc", 1);


//
// acc_documents
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"creation_ts" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"modification_ts" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sorting" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"owner_usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"last_modified_usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"text" => array (
		"notnull" => false
		,"type" => "clob"
	)
);
$ilDB->createTable("acc_documents", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("acc_documents", $pk_fields);

$ilDB->createSequence("acc_documents", 1);


//
// acc_user_access_key
//
$fields = array (
	"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"function_id" => array (
		"notnull" => true
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"access_key" => array (
		"notnull" => false
		,"length" => 1
		,"fixed" => true
		,"type" => "text"
	)
);
$ilDB->createTable("acc_user_access_key", $fields);

$pk_fields = array("user_id","function_id");
$ilDB->addPrimaryKey("acc_user_access_key", $pk_fields);


//
// acl_ws
//
$fields = array (
	"node_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"object_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"extended_data" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"tstamp" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("acl_ws", $fields);

$pk_fields = array("node_id","object_id");
$ilDB->addPrimaryKey("acl_ws", $pk_fields);


//
// addressbook_mlist
//
$fields = array (
	"ml_id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"description" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"createdate" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"changedate" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"lmode" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
);
$ilDB->createTable("addressbook_mlist", $fields);

$pk_fields = array("ml_id");
$ilDB->addPrimaryKey("addressbook_mlist", $pk_fields);

$in_fields = array("user_id");
$ilDB->addIndex("addressbook_mlist", $in_fields, "i1", false);

$ilDB->createSequence("addressbook_mlist", 1);


//
// addressbook_mlist_ass
//
$fields = array (
	"a_id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"ml_id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usr_id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("addressbook_mlist_ass", $fields);

$pk_fields = array("a_id");
$ilDB->addPrimaryKey("addressbook_mlist_ass", $pk_fields);

$in_fields = array("ml_id");
$ilDB->addIndex("addressbook_mlist_ass", $in_fields, "i1", false);

$in_fields = array("usr_id");
$ilDB->addIndex("addressbook_mlist_ass", $in_fields, "i2", false);

$ilDB->createSequence("addressbook_mlist_ass", 1);


//
// adl_shared_data
//
$fields = array (
	"slm_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"target_id" => array (
		"notnull" => true
		,"length" => 4000
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"store" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"cp_node_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("adl_shared_data", $fields);

$pk_fields = array("cp_node_id","user_id");
$ilDB->addPrimaryKey("adl_shared_data", $pk_fields);


//
// adm_set_templ_hide_tab
//
$fields = array (
	"template_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"tab_id" => array (
		"notnull" => true
		,"length" => 80
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("adm_set_templ_hide_tab", $fields);

$pk_fields = array("template_id","tab_id");
$ilDB->addPrimaryKey("adm_set_templ_hide_tab", $pk_fields);


//
// adm_set_templ_value
//
$fields = array (
	"template_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"setting" => array (
		"notnull" => true
		,"length" => 40
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"value" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"hide" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("adm_set_templ_value", $fields);

$pk_fields = array("template_id","setting");
$ilDB->addPrimaryKey("adm_set_templ_value", $pk_fields);

$ilDB->insert("adm_set_templ_value", array(
'template_id' => array('integer', '1'), 'setting' => array('text', 'pass_scoring'), 'value' => array('text', '0'), 'hide' => array('integer', '1')));

$ilDB->insert("adm_set_templ_value", array(
'template_id' => array('integer', '2'), 'setting' => array('text', 'pass_scoring'), 'value' => array('text', '0'), 'hide' => array('integer', '1')));


//
// adm_settings_template
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"type" => array (
		"notnull" => true
		,"length" => 5
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"title" => array (
		"notnull" => true
		,"length" => 100
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"description" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"auto_generated" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("adm_settings_template", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("adm_settings_template", $pk_fields);

$ilDB->createSequence("adm_settings_template", 3);

$ilDB->insert("adm_settings_template", array(
'id' => array('integer', '1'), 'type' => array('text', 'tst'), 'title' => array('text', 'il_astpl_loc_initial'), 'description' => array('clob', 'il_astpl_loc_initial_desc'), 'auto_generated' => array('integer', '1')));

$ilDB->insert("adm_settings_template", array(
'id' => array('integer', '2'), 'type' => array('text', 'tst'), 'title' => array('text', 'il_astpl_loc_qualified'), 'description' => array('clob', 'il_astpl_loc_qualified_desc'), 'auto_generated' => array('integer', '1')));


//
// adv_md_field_int
//
$fields = array (
	"field_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 128
		,"fixed" => false
		,"type" => "text"
	)
	,"description" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"lang_code" => array (
		"notnull" => true
		,"length" => 5
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("adv_md_field_int", $fields);

$pk_fields = array("field_id","lang_code");
$ilDB->addPrimaryKey("adv_md_field_int", $pk_fields);


//
// adv_md_obj_rec_select
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sub_type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => "-"
		,"fixed" => false
		,"type" => "text"
	)
	,"rec_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("adv_md_obj_rec_select", $fields);

$pk_fields = array("obj_id","sub_type","rec_id");
$ilDB->addPrimaryKey("adv_md_obj_rec_select", $pk_fields);


//
// adv_md_record
//
$fields = array (
	"record_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"import_id" => array (
		"notnull" => false
		,"length" => 64
		,"fixed" => false
		,"type" => "text"
	)
	,"active" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 128
		,"fixed" => false
		,"type" => "text"
	)
	,"description" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"parent_obj" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"gpos" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"lang_default" => array (
		"notnull" => false
		,"length" => 2
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("adv_md_record", $fields);

$pk_fields = array("record_id");
$ilDB->addPrimaryKey("adv_md_record", $pk_fields);

$ilDB->createSequence("adv_md_record", 1);


//
// adv_md_record_int
//
$fields = array (
	"record_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 128
		,"fixed" => false
		,"type" => "text"
	)
	,"description" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"lang_code" => array (
		"notnull" => true
		,"length" => 5
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("adv_md_record_int", $fields);

$pk_fields = array("record_id","lang_code");
$ilDB->addPrimaryKey("adv_md_record_int", $pk_fields);


//
// adv_md_record_obj_ord
//
$fields = array (
	"record_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"position" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
);
$ilDB->createTable("adv_md_record_obj_ord", $fields);

$pk_fields = array("record_id","obj_id");
$ilDB->addPrimaryKey("adv_md_record_obj_ord", $pk_fields);


//
// adv_md_record_objs
//
$fields = array (
	"record_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => true
		,"length" => 6
		,"default" => ""
		,"fixed" => true
		,"type" => "text"
	)
	,"sub_type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => "-"
		,"fixed" => false
		,"type" => "text"
	)
	,"optional" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("adv_md_record_objs", $fields);

$pk_fields = array("record_id","obj_type","sub_type");
$ilDB->addPrimaryKey("adv_md_record_objs", $pk_fields);


//
// adv_md_record_scope
//
$fields = array (
	"scope_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"record_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
);
$ilDB->createTable("adv_md_record_scope", $fields);

$pk_fields = array("scope_id");
$ilDB->addPrimaryKey("adv_md_record_scope", $pk_fields);

$ilDB->createSequence("adv_md_record_scope", 1);


//
// adv_md_substitutions
//
$fields = array (
	"obj_type" => array (
		"notnull" => true
		,"length" => 4
		,"default" => " "
		,"fixed" => false
		,"type" => "text"
	)
	,"substitution" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"hide_description" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"hide_field_names" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("adv_md_substitutions", $fields);

$pk_fields = array("obj_type");
$ilDB->addPrimaryKey("adv_md_substitutions", $pk_fields);


//
// adv_md_values_date
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sub_type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => "-"
		,"fixed" => false
		,"type" => "text"
	)
	,"sub_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"field_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"value" => array (
		"notnull" => false
		,"type" => "date"
	)
	,"disabled" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("adv_md_values_date", $fields);

$pk_fields = array("obj_id","sub_type","sub_id","field_id");
$ilDB->addPrimaryKey("adv_md_values_date", $pk_fields);


//
// adv_md_values_datetime
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sub_type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => "-"
		,"fixed" => false
		,"type" => "text"
	)
	,"sub_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"field_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"value" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"disabled" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("adv_md_values_datetime", $fields);

$pk_fields = array("obj_id","sub_type","sub_id","field_id");
$ilDB->addPrimaryKey("adv_md_values_datetime", $pk_fields);


//
// adv_md_values_enum
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sub_type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => "-"
		,"fixed" => false
		,"type" => "text"
	)
	,"sub_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"field_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"disabled" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"value_index" => array (
		"notnull" => true
		,"length" => 16
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("adv_md_values_enum", $fields);

$pk_fields = array("obj_id","sub_type","sub_id","field_id","value_index");
$ilDB->addPrimaryKey("adv_md_values_enum", $pk_fields);


//
// adv_md_values_extlink
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sub_type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => "-"
		,"fixed" => false
		,"type" => "text"
	)
	,"sub_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"field_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"value" => array (
		"notnull" => false
		,"length" => 500
		,"fixed" => false
		,"type" => "text"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 500
		,"fixed" => false
		,"type" => "text"
	)
	,"disabled" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("adv_md_values_extlink", $fields);

$pk_fields = array("obj_id","sub_type","sub_id","field_id");
$ilDB->addPrimaryKey("adv_md_values_extlink", $pk_fields);


//
// adv_md_values_float
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sub_type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => "-"
		,"fixed" => false
		,"type" => "text"
	)
	,"sub_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"field_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"value" => array (
		"notnull" => false
		,"type" => "float"
	)
	,"disabled" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("adv_md_values_float", $fields);

$pk_fields = array("obj_id","sub_type","sub_id","field_id");
$ilDB->addPrimaryKey("adv_md_values_float", $pk_fields);


//
// adv_md_values_int
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sub_type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => "-"
		,"fixed" => false
		,"type" => "text"
	)
	,"sub_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"field_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"value" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"disabled" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("adv_md_values_int", $fields);

$pk_fields = array("obj_id","sub_type","sub_id","field_id");
$ilDB->addPrimaryKey("adv_md_values_int", $pk_fields);


//
// adv_md_values_intlink
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sub_type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => "-"
		,"fixed" => false
		,"type" => "text"
	)
	,"sub_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"field_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"value" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"disabled" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("adv_md_values_intlink", $fields);

$pk_fields = array("obj_id","sub_type","sub_id","field_id");
$ilDB->addPrimaryKey("adv_md_values_intlink", $pk_fields);


//
// adv_md_values_location
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sub_type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => "-"
		,"fixed" => false
		,"type" => "text"
	)
	,"sub_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"field_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"loc_lat" => array (
		"notnull" => false
		,"type" => "float"
	)
	,"loc_long" => array (
		"notnull" => false
		,"type" => "float"
	)
	,"loc_zoom" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"disabled" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("adv_md_values_location", $fields);

$pk_fields = array("obj_id","sub_type","sub_id","field_id");
$ilDB->addPrimaryKey("adv_md_values_location", $pk_fields);


//
// adv_md_values_ltext
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sub_type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => "-"
		,"fixed" => false
		,"type" => "text"
	)
	,"sub_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"field_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"value_index" => array (
		"notnull" => true
		,"length" => 16
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"value" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"disabled" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("adv_md_values_ltext", $fields);

$pk_fields = array("obj_id","sub_type","sub_id","field_id","value_index");
$ilDB->addPrimaryKey("adv_md_values_ltext", $pk_fields);


//
// adv_md_values_text
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"field_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"value" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"disabled" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sub_type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => "-"
		,"fixed" => false
		,"type" => "text"
	)
	,"sub_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("adv_md_values_text", $fields);

$pk_fields = array("obj_id","field_id","sub_type","sub_id");
$ilDB->addPrimaryKey("adv_md_values_text", $pk_fields);

$in_fields = array("obj_id");
$ilDB->addIndex("adv_md_values_text", $in_fields, "i1", false);


//
// adv_mdf_definition
//
$fields = array (
	"field_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"record_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"import_id" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"position" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"field_type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"field_values" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"description" => array (
		"notnull" => false
		,"length" => 2000
		,"fixed" => false
		,"type" => "text"
	)
	,"searchable" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"required" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("adv_mdf_definition", $fields);

$pk_fields = array("field_id");
$ilDB->addPrimaryKey("adv_mdf_definition", $pk_fields);

$ilDB->createSequence("adv_mdf_definition", 1);


//
// adv_mdf_enum
//
$fields = array (
	"field_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"lang_code" => array (
		"notnull" => true
		,"length" => 5
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"idx" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"value" => array (
		"notnull" => true
		,"length" => 4000
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("adv_mdf_enum", $fields);

$pk_fields = array("field_id","lang_code","idx");
$ilDB->addPrimaryKey("adv_mdf_enum", $pk_fields);


//
// aicc_course
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"course_creator" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"course_id" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"course_system" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"course_title" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"c_level" => array (
		"notnull" => false
		,"length" => 5
		,"fixed" => false
		,"type" => "text"
	)
	,"max_fields_cst" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"max_fields_ort" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"total_aus" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"total_blocks" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"total_complex_obj" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"total_objectives" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"version" => array (
		"notnull" => false
		,"length" => 10
		,"fixed" => false
		,"type" => "text"
	)
	,"max_normal" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"description" => array (
		"notnull" => false
		,"type" => "clob"
	)
);
$ilDB->createTable("aicc_course", $fields);

$pk_fields = array("obj_id");
$ilDB->addPrimaryKey("aicc_course", $pk_fields);


//
// aicc_object
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"slm_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"system_id" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"description" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"developer_id" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"c_type" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("aicc_object", $fields);

$pk_fields = array("obj_id");
$ilDB->addPrimaryKey("aicc_object", $pk_fields);

$in_fields = array("slm_id");
$ilDB->addIndex("aicc_object", $in_fields, "i1", false);

$ilDB->createSequence("aicc_object", 1);


//
// aicc_units
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"c_type" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"command_line" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"max_time_allowed" => array (
		"notnull" => false
		,"type" => "time"
	)
	,"time_limit_action" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"max_score" => array (
		"notnull" => false
		,"type" => "float"
	)
	,"core_vendor" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"system_vendor" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"file_name" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"mastery_score" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"web_launch" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"au_password" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("aicc_units", $fields);

$pk_fields = array("obj_id");
$ilDB->addPrimaryKey("aicc_units", $pk_fields);

$ilDB->createSequence("aicc_units", 1);


//
// ass_log
//
$fields = array (
	"ass_log_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_fi" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_fi" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"logtext" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"question_fi" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"original_fi" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"ref_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"test_only" => array (
		"notnull" => false
		,"length" => 1
		,"default" => "0"
		,"fixed" => false
		,"type" => "text"
	)
	,"tstamp" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("ass_log", $fields);

$pk_fields = array("ass_log_id");
$ilDB->addPrimaryKey("ass_log", $pk_fields);

$in_fields = array("user_fi","obj_fi");
$ilDB->addIndex("ass_log", $in_fields, "i1", false);

$in_fields = array("obj_fi");
$ilDB->addIndex("ass_log", $in_fields, "i2", false);

$ilDB->createSequence("ass_log", 1);


//
// auth_ext_attr_mapping
//
$fields = array (
	"auth_src_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"attribute" => array (
		"notnull" => true
		,"length" => 75
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"ext_attribute" => array (
		"notnull" => false
		,"length" => 1000
		,"fixed" => false
		,"type" => "text"
	)
	,"update_automatically" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"auth_mode" => array (
		"notnull" => true
		,"length" => 50
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("auth_ext_attr_mapping", $fields);

$pk_fields = array("auth_mode","auth_src_id","attribute");
$ilDB->addPrimaryKey("auth_ext_attr_mapping", $pk_fields);


//
// background_task
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"handler" => array (
		"notnull" => false
		,"length" => 1000
		,"fixed" => false
		,"type" => "text"
	)
	,"steps" => array (
		"notnull" => true
		,"length" => 3
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"cstep" => array (
		"notnull" => false
		,"length" => 3
		,"unsigned" => false
		,"type" => "integer"
	)
	,"start_date" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"status" => array (
		"notnull" => false
		,"length" => 100
		,"fixed" => false
		,"type" => "text"
	)
	,"params" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("background_task", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("background_task", $pk_fields);

$ilDB->createSequence("background_task", 1);


//
// badge_badge
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"parent_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"type_id" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"active" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"descr" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"conf" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"image" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"valid" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"crit" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("badge_badge", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("badge_badge", $pk_fields);

$ilDB->createSequence("badge_badge", 1);


//
// badge_image_templ_type
//
$fields = array (
	"tmpl_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"type_id" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("badge_image_templ_type", $fields);

$pk_fields = array("tmpl_id","type_id");
$ilDB->addPrimaryKey("badge_image_templ_type", $pk_fields);


//
// badge_image_template
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"image" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("badge_image_template", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("badge_image_template", $pk_fields);

$ilDB->createSequence("badge_image_template", 1);


//
// badge_user_badge
//
$fields = array (
	"badge_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"tstamp" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"awarded_by" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"pos" => array (
		"notnull" => false
		,"length" => 2
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("badge_user_badge", $fields);

$pk_fields = array("badge_id","user_id");
$ilDB->addPrimaryKey("badge_user_badge", $pk_fields);


//
// benchmark
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"cdate" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"module" => array (
		"notnull" => false
		,"length" => 150
		,"fixed" => false
		,"type" => "text"
	)
	,"benchmark" => array (
		"notnull" => false
		,"length" => 150
		,"fixed" => false
		,"type" => "text"
	)
	,"duration" => array (
		"notnull" => false
		,"type" => "float"
	)
	,"sql_stmt" => array (
		"notnull" => false
		,"type" => "clob"
	)
);
$ilDB->createTable("benchmark", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("benchmark", $pk_fields);

$in_fields = array("module","benchmark");
$ilDB->addIndex("benchmark", $in_fields, "i1", false);

$ilDB->createSequence("benchmark", 1);


//
// book_obj_use_book
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"book_ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("book_obj_use_book", $fields);

$pk_fields = array("obj_id","book_ref_id");
$ilDB->addPrimaryKey("book_obj_use_book", $pk_fields);


//
// booking_entry
//
$fields = array (
	"booking_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"deadline" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"num_bookings" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"target_obj_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"booking_group" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("booking_entry", $fields);

$pk_fields = array("booking_id");
$ilDB->addPrimaryKey("booking_entry", $pk_fields);

$ilDB->createSequence("booking_entry", 1);


//
// booking_member
//
$fields = array (
	"participant_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"booking_pool_id" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"assigner_user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("booking_member", $fields);

$pk_fields = array("participant_id","user_id","booking_pool_id");
$ilDB->addPrimaryKey("booking_member", $pk_fields);

$ilDB->createSequence("booking_member", 1);


//
// booking_obj_assignment
//
$fields = array (
	"booking_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"target_obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("booking_obj_assignment", $fields);

$pk_fields = array("booking_id","target_obj_id");
$ilDB->addPrimaryKey("booking_obj_assignment", $pk_fields);


//
// booking_object
//
$fields = array (
	"booking_object_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"schedule_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"pool_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"description" => array (
		"notnull" => false
		,"length" => 1000
		,"fixed" => false
		,"type" => "text"
	)
	,"nr_items" => array (
		"notnull" => true
		,"length" => 2
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"info_file" => array (
		"notnull" => false
		,"length" => 500
		,"fixed" => false
		,"type" => "text"
	)
	,"post_text" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"post_file" => array (
		"notnull" => false
		,"length" => 500
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("booking_object", $fields);

$pk_fields = array("booking_object_id");
$ilDB->addPrimaryKey("booking_object", $pk_fields);

$in_fields = array("pool_id");
$ilDB->addIndex("booking_object", $in_fields, "i1", false);

$ilDB->createSequence("booking_object", 1);


//
// booking_preferences
//
$fields = array (
	"book_pool_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"book_obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("booking_preferences", $fields);

$pk_fields = array("book_pool_id","user_id","book_obj_id");
$ilDB->addPrimaryKey("booking_preferences", $pk_fields);


//
// booking_reservation
//
$fields = array (
	"booking_reservation_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"object_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"date_from" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"date_to" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"status" => array (
		"notnull" => false
		,"length" => 2
		,"unsigned" => false
		,"type" => "integer"
	)
	,"group_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"assigner_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"context_obj_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("booking_reservation", $fields);

$pk_fields = array("booking_reservation_id");
$ilDB->addPrimaryKey("booking_reservation", $pk_fields);

$in_fields = array("user_id");
$ilDB->addIndex("booking_reservation", $in_fields, "i1", false);

$in_fields = array("object_id");
$ilDB->addIndex("booking_reservation", $in_fields, "i2", false);

$in_fields = array("date_from");
$ilDB->addIndex("booking_reservation", $in_fields, "i3", false);

$in_fields = array("date_to");
$ilDB->addIndex("booking_reservation", $in_fields, "i4", false);

$ilDB->createSequence("booking_reservation", 1);


//
// booking_schedule
//
$fields = array (
	"booking_schedule_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"pool_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"deadline" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"rent_min" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"rent_max" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"raster" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"auto_break" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"av_from" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"av_to" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("booking_schedule", $fields);

$pk_fields = array("booking_schedule_id");
$ilDB->addPrimaryKey("booking_schedule", $pk_fields);

$ilDB->createSequence("booking_schedule", 1);


//
// booking_schedule_slot
//
$fields = array (
	"booking_schedule_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"day_id" => array (
		"notnull" => true
		,"length" => 2
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"slot_id" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"times" => array (
		"notnull" => true
		,"length" => 50
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("booking_schedule_slot", $fields);

$pk_fields = array("booking_schedule_id","day_id","slot_id");
$ilDB->addPrimaryKey("booking_schedule_slot", $pk_fields);


//
// booking_settings
//
$fields = array (
	"booking_pool_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"public_log" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"pool_offline" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"slots_no" => array (
		"notnull" => false
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"schedule_type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"ovlimit" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"rsv_filter_period" => array (
		"notnull" => false
		,"length" => 2
		,"unsigned" => false
		,"type" => "integer"
	)
	,"reminder_status" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"reminder_day" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"last_remind_ts" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"preference_nr" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"pref_deadline" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"pref_booking_hash" => array (
		"notnull" => true
		,"length" => 23
		,"default" => "0"
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("booking_settings", $fields);

$pk_fields = array("booking_pool_id");
$ilDB->addPrimaryKey("booking_settings", $pk_fields);


//
// booking_user
//
$fields = array (
	"entry_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"tstamp" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"booking_message" => array (
		"notnull" => false
		,"length" => 1024
		,"fixed" => false
		,"type" => "text"
	)
	,"notification_sent" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("booking_user", $fields);

$pk_fields = array("entry_id","user_id");
$ilDB->addPrimaryKey("booking_user", $pk_fields);


//
// bookmark_data
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"description" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"target" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"type" => array (
		"notnull" => false
		,"length" => 4
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("bookmark_data", $fields);

$pk_fields = array("obj_id","user_id");
$ilDB->addPrimaryKey("bookmark_data", $pk_fields);

$ilDB->createSequence("bookmark_data", 2);

$ilDB->insert("bookmark_data", array(
'obj_id' => array('integer', '1'), 'user_id' => array('integer', '0'), 'title' => array('text', 'dummy_folder'), 'description' => array('text', ''), 'target' => array('text', ''), 'type' => array('text', 'bmf')));


//
// bookmark_tree
//
$fields = array (
	"tree" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"child" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"parent" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"lft" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rgt" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"depth" => array (
		"notnull" => true
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("bookmark_tree", $fields);

$pk_fields = array("tree","child");
$ilDB->addPrimaryKey("bookmark_tree", $pk_fields);

$in_fields = array("child");
$ilDB->addIndex("bookmark_tree", $in_fields, "i1", false);

$in_fields = array("parent");
$ilDB->addIndex("bookmark_tree", $in_fields, "i2", false);

$in_fields = array("child","tree");
$ilDB->addIndex("bookmark_tree", $in_fields, "i3", false);

$ilDB->insert("bookmark_tree", array(
'tree' => array('integer', '6'), 'child' => array('integer', '1'), 'parent' => array('integer', '0'), 'lft' => array('integer', '1'), 'rgt' => array('integer', '2'), 'depth' => array('integer', '1')));


//
// buddylist
//
$fields = array (
	"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"buddy_usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"ts" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("buddylist", $fields);

$pk_fields = array("usr_id","buddy_usr_id");
$ilDB->addPrimaryKey("buddylist", $pk_fields);


//
// buddylist_requests
//
$fields = array (
	"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"buddy_usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"ignored" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"ts" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("buddylist_requests", $fields);

$pk_fields = array("usr_id","buddy_usr_id");
$ilDB->addPrimaryKey("buddylist_requests", $pk_fields);

$in_fields = array("buddy_usr_id","ignored");
$ilDB->addIndex("buddylist_requests", $in_fields, "i1", false);


//
// cache_clob
//
$fields = array (
	"component" => array (
		"notnull" => true
		,"length" => 50
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"name" => array (
		"notnull" => true
		,"length" => 50
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"entry_id" => array (
		"notnull" => true
		,"length" => 50
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"value" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"expire_time" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"ilias_version" => array (
		"notnull" => false
		,"length" => 10
		,"fixed" => false
		,"type" => "text"
	)
	,"int_key_1" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"int_key_2" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"text_key_1" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
	,"text_key_2" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("cache_clob", $fields);

$pk_fields = array("component","name","entry_id");
$ilDB->addPrimaryKey("cache_clob", $pk_fields);

$in_fields = array("expire_time");
$ilDB->addIndex("cache_clob", $in_fields, "et", false);

$in_fields = array("ilias_version");
$ilDB->addIndex("cache_clob", $in_fields, "iv", false);


//
// cache_text
//
$fields = array (
	"component" => array (
		"notnull" => true
		,"length" => 50
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"name" => array (
		"notnull" => true
		,"length" => 50
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"entry_id" => array (
		"notnull" => true
		,"length" => 50
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"value" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"expire_time" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"ilias_version" => array (
		"notnull" => false
		,"length" => 10
		,"fixed" => false
		,"type" => "text"
	)
	,"int_key_1" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"int_key_2" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"text_key_1" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
	,"text_key_2" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("cache_text", $fields);

$pk_fields = array("component","name","entry_id");
$ilDB->addPrimaryKey("cache_text", $pk_fields);

$in_fields = array("expire_time");
$ilDB->addIndex("cache_text", $in_fields, "et", false);

$in_fields = array("ilias_version");
$ilDB->addIndex("cache_text", $in_fields, "iv", false);


//
// cal_auth_token
//
$fields = array (
	"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"hash" => array (
		"notnull" => true
		,"length" => 32
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"selection" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"calendar" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"ical" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"c_time" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("cal_auth_token", $fields);

$pk_fields = array("user_id","hash");
$ilDB->addPrimaryKey("cal_auth_token", $pk_fields);

$in_fields = array("hash");
$ilDB->addIndex("cal_auth_token", $in_fields, "i1", false);


//
// cal_cat_assignments
//
$fields = array (
	"cal_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"cat_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("cal_cat_assignments", $fields);

$pk_fields = array("cal_id","cat_id");
$ilDB->addPrimaryKey("cal_cat_assignments", $pk_fields);

$in_fields = array("cat_id");
$ilDB->addIndex("cal_cat_assignments", $in_fields, "i2", false);


//
// cal_cat_visibility
//
$fields = array (
	"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"cat_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"visible" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("cal_cat_visibility", $fields);

$pk_fields = array("user_id","cat_id","obj_id");
$ilDB->addPrimaryKey("cal_cat_visibility", $pk_fields);

$in_fields = array("cat_id");
$ilDB->addIndex("cal_cat_visibility", $in_fields, "i1", false);


//
// cal_categories
//
$fields = array (
	"cat_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 128
		,"fixed" => true
		,"type" => "text"
	)
	,"color" => array (
		"notnull" => false
		,"length" => 8
		,"fixed" => true
		,"type" => "text"
	)
	,"type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"loc_type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"remote_url" => array (
		"notnull" => false
		,"length" => 500
		,"fixed" => false
		,"type" => "text"
	)
	,"remote_user" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"remote_pass" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"remote_sync" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
);
$ilDB->createTable("cal_categories", $fields);

$pk_fields = array("cat_id");
$ilDB->addPrimaryKey("cal_categories", $pk_fields);

$in_fields = array("obj_id");
$ilDB->addIndex("cal_categories", $in_fields, "i2", false);

$in_fields = array("type");
$ilDB->addIndex("cal_categories", $in_fields, "i3", false);

$ilDB->createSequence("cal_categories", 1);


//
// cal_ch_group
//
$fields = array (
	"grp_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"multiple_assignments" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 512
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("cal_ch_group", $fields);

$pk_fields = array("grp_id");
$ilDB->addPrimaryKey("cal_ch_group", $pk_fields);

$ilDB->createSequence("cal_ch_group", 1);


//
// cal_ch_settings
//
$fields = array (
	"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"admin_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("cal_ch_settings", $fields);

$pk_fields = array("user_id","admin_id");
$ilDB->addPrimaryKey("cal_ch_settings", $pk_fields);


//
// cal_entries
//
$fields = array (
	"cal_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"last_update" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 128
		,"fixed" => true
		,"type" => "text"
	)
	,"subtitle" => array (
		"notnull" => false
		,"length" => 64
		,"fixed" => true
		,"type" => "text"
	)
	,"description" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"location" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"fullday" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"starta" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"enda" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"informations" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"auto_generated" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"context_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"translation_type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"is_milestone" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"completion" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"notification" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"context_info" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("cal_entries", $fields);

$pk_fields = array("cal_id");
$ilDB->addPrimaryKey("cal_entries", $pk_fields);

$in_fields = array("last_update");
$ilDB->addIndex("cal_entries", $in_fields, "i1", false);

$in_fields = array("context_id");
$ilDB->addIndex("cal_entries", $in_fields, "i2", false);

$ilDB->createSequence("cal_entries", 1);


//
// cal_entry_responsible
//
$fields = array (
	"cal_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("cal_entry_responsible", $fields);

$pk_fields = array("cal_id","user_id");
$ilDB->addPrimaryKey("cal_entry_responsible", $pk_fields);


//
// cal_notification
//
$fields = array (
	"notification_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"cal_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"email" => array (
		"notnull" => false
		,"length" => 64
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("cal_notification", $fields);

$pk_fields = array("notification_id");
$ilDB->addPrimaryKey("cal_notification", $pk_fields);

$in_fields = array("cal_id");
$ilDB->addIndex("cal_notification", $in_fields, "i1", false);

$ilDB->createSequence("cal_notification", 1);


//
// cal_rec_exclusion
//
$fields = array (
	"excl_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"cal_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"excl_date" => array (
		"notnull" => false
		,"type" => "date"
	)
);
$ilDB->createTable("cal_rec_exclusion", $fields);

$pk_fields = array("excl_id");
$ilDB->addPrimaryKey("cal_rec_exclusion", $pk_fields);

$in_fields = array("cal_id");
$ilDB->addIndex("cal_rec_exclusion", $in_fields, "i1", false);

$ilDB->createSequence("cal_rec_exclusion", 1);


//
// cal_recurrence_rules
//
$fields = array (
	"rule_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"cal_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"cal_recurrence" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"freq_type" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => true
		,"type" => "text"
	)
	,"freq_until_date" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"freq_until_count" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"intervall" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"byday" => array (
		"notnull" => false
		,"length" => 64
		,"fixed" => true
		,"type" => "text"
	)
	,"byweekno" => array (
		"notnull" => false
		,"length" => 64
		,"default" => "0"
		,"fixed" => true
		,"type" => "text"
	)
	,"bymonth" => array (
		"notnull" => false
		,"length" => 64
		,"fixed" => true
		,"type" => "text"
	)
	,"bymonthday" => array (
		"notnull" => false
		,"length" => 64
		,"fixed" => true
		,"type" => "text"
	)
	,"byyearday" => array (
		"notnull" => false
		,"length" => 64
		,"fixed" => true
		,"type" => "text"
	)
	,"bysetpos" => array (
		"notnull" => false
		,"length" => 64
		,"default" => "0"
		,"fixed" => true
		,"type" => "text"
	)
	,"weekstart" => array (
		"notnull" => false
		,"length" => 2
		,"fixed" => true
		,"type" => "text"
	)
);
$ilDB->createTable("cal_recurrence_rules", $fields);

$pk_fields = array("rule_id");
$ilDB->addPrimaryKey("cal_recurrence_rules", $pk_fields);

$in_fields = array("cal_id");
$ilDB->addIndex("cal_recurrence_rules", $in_fields, "i1", false);

$ilDB->createSequence("cal_recurrence_rules", 1);


//
// cal_registrations
//
$fields = array (
	"cal_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"dstart" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"dend" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("cal_registrations", $fields);

$pk_fields = array("cal_id","usr_id","dstart","dend");
$ilDB->addPrimaryKey("cal_registrations", $pk_fields);


//
// cal_shared
//
$fields = array (
	"cal_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"create_date" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"writable" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("cal_shared", $fields);

$pk_fields = array("cal_id","obj_id");
$ilDB->addPrimaryKey("cal_shared", $pk_fields);

$in_fields = array("obj_id","obj_type");
$ilDB->addIndex("cal_shared", $in_fields, "i1", false);


//
// cal_shared_status
//
$fields = array (
	"cal_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"status" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("cal_shared_status", $fields);

$pk_fields = array("cal_id","usr_id");
$ilDB->addPrimaryKey("cal_shared_status", $pk_fields);


//
// catch_write_events
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"ts" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
);
$ilDB->createTable("catch_write_events", $fields);

$pk_fields = array("obj_id","usr_id");
$ilDB->addPrimaryKey("catch_write_events", $pk_fields);


//
// chatroom_admconfig
//
$fields = array (
	"instance_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"server_settings" => array (
		"notnull" => true
		,"length" => 2000
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"default_config" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"client_settings" => array (
		"notnull" => true
		,"length" => 1000
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("chatroom_admconfig", $fields);

$pk_fields = array("instance_id");
$ilDB->addPrimaryKey("chatroom_admconfig", $pk_fields);

$ilDB->createSequence("chatroom_admconfig", 1);


//
// chatroom_bans
//
$fields = array (
	"room_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"timestamp" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"remark" => array (
		"notnull" => false
		,"length" => 1000
		,"fixed" => false
		,"type" => "text"
	)
	,"actor_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("chatroom_bans", $fields);

$pk_fields = array("room_id","user_id");
$ilDB->addPrimaryKey("chatroom_bans", $pk_fields);


//
// chatroom_history
//
$fields = array (
	"hist_id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"room_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"message" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"timestamp" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sub_room" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("chatroom_history", $fields);

$pk_fields = array("hist_id");
$ilDB->addPrimaryKey("chatroom_history", $pk_fields);

$in_fields = array("room_id","sub_room");
$ilDB->addIndex("chatroom_history", $in_fields, "i1", false);

$ilDB->createSequence("chatroom_history", 1);


//
// chatroom_proomaccess
//
$fields = array (
	"proom_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("chatroom_proomaccess", $fields);

$pk_fields = array("proom_id","user_id");
$ilDB->addPrimaryKey("chatroom_proomaccess", $pk_fields);


//
// chatroom_prooms
//
$fields = array (
	"proom_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"parent_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => true
		,"length" => 200
		,"default" => "0"
		,"fixed" => false
		,"type" => "text"
	)
	,"owner" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"created" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"closed" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"is_public" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
);
$ilDB->createTable("chatroom_prooms", $fields);

$pk_fields = array("proom_id");
$ilDB->addPrimaryKey("chatroom_prooms", $pk_fields);

$in_fields = array("parent_id");
$ilDB->addIndex("chatroom_prooms", $in_fields, "i1", false);

$in_fields = array("owner");
$ilDB->addIndex("chatroom_prooms", $in_fields, "i2", false);

$ilDB->createSequence("chatroom_prooms", 1);


//
// chatroom_psessions
//
$fields = array (
	"psess_id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"proom_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"connected" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"disconnected" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("chatroom_psessions", $fields);

$pk_fields = array("psess_id");
$ilDB->addPrimaryKey("chatroom_psessions", $pk_fields);

$in_fields = array("proom_id","user_id");
$ilDB->addIndex("chatroom_psessions", $in_fields, "i1", false);

$in_fields = array("disconnected");
$ilDB->addIndex("chatroom_psessions", $in_fields, "i2", false);

$ilDB->createSequence("chatroom_psessions", 1);


//
// chatroom_sessions
//
$fields = array (
	"sess_id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"room_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"userdata" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"connected" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"disconnected" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("chatroom_sessions", $fields);

$pk_fields = array("sess_id");
$ilDB->addPrimaryKey("chatroom_sessions", $pk_fields);

$in_fields = array("room_id","user_id");
$ilDB->addIndex("chatroom_sessions", $in_fields, "i1", false);

$in_fields = array("disconnected");
$ilDB->addIndex("chatroom_sessions", $in_fields, "i2", false);

$in_fields = array("user_id");
$ilDB->addIndex("chatroom_sessions", $in_fields, "i3", false);

$ilDB->createSequence("chatroom_sessions", 1);


//
// chatroom_settings
//
$fields = array (
	"room_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"object_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"room_type" => array (
		"notnull" => true
		,"length" => 20
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"allow_anonymous" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"allow_custom_usernames" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"enable_history" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"restrict_history" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"autogen_usernames" => array (
		"notnull" => false
		,"length" => 50
		,"default" => "Anonymous #"
		,"fixed" => false
		,"type" => "text"
	)
	,"allow_private_rooms" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"display_past_msgs" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"private_rooms_enabled" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"online_status" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("chatroom_settings", $fields);

$pk_fields = array("room_id");
$ilDB->addPrimaryKey("chatroom_settings", $pk_fields);

$ilDB->createSequence("chatroom_settings", 3);

$ilDB->insert("chatroom_settings", array(
'room_id' => array('integer', '2'), 'object_id' => array('integer', '185'), 'room_type' => array('text', 'default'), 'allow_anonymous' => array('integer', '0'), 'allow_custom_usernames' => array('integer', '0'), 'enable_history' => array('integer', '0'), 'restrict_history' => array('integer', '0'), 'autogen_usernames' => array('text', 'Anonymous #'), 'allow_private_rooms' => array('integer', '1'), 'display_past_msgs' => array('integer', '0'), 'private_rooms_enabled' => array('integer', '1'), 'online_status' => array('integer', '1')));


//
// chatroom_smilies
//
$fields = array (
	"smiley_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"smiley_keywords" => array (
		"notnull" => false
		,"length" => 100
		,"fixed" => false
		,"type" => "text"
	)
	,"smiley_path" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("chatroom_smilies", $fields);

$pk_fields = array("smiley_id");
$ilDB->addPrimaryKey("chatroom_smilies", $pk_fields);

$ilDB->createSequence("chatroom_smilies", 1);


//
// chatroom_uploads
//
$fields = array (
	"upload_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"room_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"filename" => array (
		"notnull" => true
		,"length" => 200
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"filetype" => array (
		"notnull" => true
		,"length" => 200
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"timestamp" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("chatroom_uploads", $fields);

$pk_fields = array("upload_id");
$ilDB->addPrimaryKey("chatroom_uploads", $pk_fields);

$ilDB->createSequence("chatroom_uploads", 1);


//
// chatroom_users
//
$fields = array (
	"room_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"userdata" => array (
		"notnull" => true
		,"length" => 4000
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"connected" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("chatroom_users", $fields);

$pk_fields = array("room_id","user_id");
$ilDB->addPrimaryKey("chatroom_users", $pk_fields);


//
// cmi_comment
//
$fields = array (
	"cmi_comment_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"cmi_node_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"c_comment" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"c_timestamp" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"location" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"sourceislms" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("cmi_comment", $fields);

$pk_fields = array("cmi_comment_id");
$ilDB->addPrimaryKey("cmi_comment", $pk_fields);

$in_fields = array("cmi_node_id");
$ilDB->addIndex("cmi_comment", $in_fields, "i2", false);

$ilDB->createSequence("cmi_comment", 1);


//
// cmi_correct_response
//
$fields = array (
	"cmi_correct_resp_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"cmi_interaction_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"pattern" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("cmi_correct_response", $fields);

$pk_fields = array("cmi_correct_resp_id");
$ilDB->addPrimaryKey("cmi_correct_response", $pk_fields);

$in_fields = array("cmi_interaction_id");
$ilDB->addIndex("cmi_correct_response", $in_fields, "i1", false);

$ilDB->createSequence("cmi_correct_response", 1);


//
// cmi_custom
//
$fields = array (
	"sco_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"lvalue" => array (
		"notnull" => true
		,"length" => 64
		,"default" => " "
		,"fixed" => false
		,"type" => "text"
	)
	,"rvalue" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"c_timestamp" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
);
$ilDB->createTable("cmi_custom", $fields);

$pk_fields = array("user_id","lvalue","obj_id","sco_id");
$ilDB->addPrimaryKey("cmi_custom", $pk_fields);


//
// cmi_gobjective
//
$fields = array (
	"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"satisfied" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"measure" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"scope_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"status" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"objective_id" => array (
		"notnull" => true
		,"length" => 253
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"score_raw" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"score_min" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"score_max" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"progress_measure" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"completion_status" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("cmi_gobjective", $fields);

$pk_fields = array("user_id","scope_id","objective_id");
$ilDB->addPrimaryKey("cmi_gobjective", $pk_fields);

$in_fields = array("scope_id","objective_id");
$ilDB->addIndex("cmi_gobjective", $in_fields, "i2", false);


//
// cmi_interaction
//
$fields = array (
	"cmi_interaction_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"cmi_node_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"description" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"id" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"latency" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
	,"result" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"c_timestamp" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
	,"c_type" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"weighting" => array (
		"notnull" => false
		,"type" => "float"
	)
	,"learner_response" => array (
		"notnull" => false
		,"type" => "clob"
	)
);
$ilDB->createTable("cmi_interaction", $fields);

$pk_fields = array("cmi_interaction_id");
$ilDB->addPrimaryKey("cmi_interaction", $pk_fields);

$in_fields = array("id");
$ilDB->addIndex("cmi_interaction", $in_fields, "i2", false);

$in_fields = array("c_type");
$ilDB->addIndex("cmi_interaction", $in_fields, "i3", false);

$in_fields = array("cmi_node_id");
$ilDB->addIndex("cmi_interaction", $in_fields, "i4", false);

$ilDB->createSequence("cmi_interaction", 1);


//
// cmi_node
//
$fields = array (
	"accesscount" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"accessduration" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
	,"accessed" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
	,"activityabsduration" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
	,"activityattemptcount" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"activityexpduration" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
	,"activityprogstatus" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"attemptabsduration" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
	,"attemptcomplamount" => array (
		"notnull" => false
		,"type" => "float"
	)
	,"attemptcomplstatus" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"attemptexpduration" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
	,"attemptprogstatus" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"audio_captioning" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"audio_level" => array (
		"notnull" => false
		,"type" => "float"
	)
	,"availablechildren" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"cmi_node_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"completion" => array (
		"notnull" => false
		,"type" => "float"
	)
	,"completion_status" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"completion_threshold" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"cp_node_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"created" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
	,"credit" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"delivery_speed" => array (
		"notnull" => false
		,"type" => "float"
	)
	,"c_entry" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"c_exit" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"c_language" => array (
		"notnull" => false
		,"length" => 5
		,"fixed" => false
		,"type" => "text"
	)
	,"launch_data" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"learner_name" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"location" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"c_max" => array (
		"notnull" => false
		,"type" => "float"
	)
	,"c_min" => array (
		"notnull" => false
		,"type" => "float"
	)
	,"c_mode" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
	,"modified" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
	,"progress_measure" => array (
		"notnull" => false
		,"type" => "float"
	)
	,"c_raw" => array (
		"notnull" => false
		,"type" => "float"
	)
	,"scaled" => array (
		"notnull" => false
		,"type" => "float"
	)
	,"scaled_passing_score" => array (
		"notnull" => false
		,"type" => "float"
	)
	,"session_time" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
	,"success_status" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"suspend_data" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"total_time" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"c_timestamp" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"additional_tables" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("cmi_node", $fields);

$pk_fields = array("cmi_node_id");
$ilDB->addPrimaryKey("cmi_node", $pk_fields);

$in_fields = array("cp_node_id");
$ilDB->addIndex("cmi_node", $in_fields, "i1", false);

$in_fields = array("completion_status");
$ilDB->addIndex("cmi_node", $in_fields, "i2", false);

$in_fields = array("credit");
$ilDB->addIndex("cmi_node", $in_fields, "i3", false);

$in_fields = array("user_id");
$ilDB->addIndex("cmi_node", $in_fields, "i5", false);

$ilDB->createSequence("cmi_node", 1);


//
// cmi_objective
//
$fields = array (
	"cmi_interaction_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"cmi_node_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"cmi_objective_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"description" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"id" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"c_max" => array (
		"notnull" => false
		,"type" => "float"
	)
	,"c_min" => array (
		"notnull" => false
		,"type" => "float"
	)
	,"c_raw" => array (
		"notnull" => false
		,"type" => "float"
	)
	,"scaled" => array (
		"notnull" => false
		,"type" => "float"
	)
	,"progress_measure" => array (
		"notnull" => false
		,"type" => "float"
	)
	,"success_status" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"scope" => array (
		"notnull" => false
		,"length" => 16
		,"fixed" => false
		,"type" => "text"
	)
	,"completion_status" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("cmi_objective", $fields);

$pk_fields = array("cmi_objective_id");
$ilDB->addPrimaryKey("cmi_objective", $pk_fields);

$in_fields = array("cmi_interaction_id");
$ilDB->addIndex("cmi_objective", $in_fields, "i2", false);

$in_fields = array("success_status");
$ilDB->addIndex("cmi_objective", $in_fields, "i4", false);

$ilDB->createSequence("cmi_objective", 1);


//
// cmix_lrs_types
//
$fields = array (
	"type_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"description" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"availability" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"remarks" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"time_to_delete" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"lrs_endpoint" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"lrs_key" => array (
		"notnull" => true
		,"length" => 128
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"lrs_secret" => array (
		"notnull" => true
		,"length" => 128
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"privacy_comment_default" => array (
		"notnull" => true
		,"length" => 2000
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"external_lrs" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"force_privacy_settings" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"bypass_proxy" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"only_moveon" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"achieved" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"answered" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"completed" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"failed" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"initialized" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"passed" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"progressed" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"satisfied" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"c_terminated" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"hide_data" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"c_timestamp" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"duration" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"no_substatements" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"privacy_ident" => array (
		"notnull" => true
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"privacy_name" => array (
		"notnull" => true
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("cmix_lrs_types", $fields);

$pk_fields = array("type_id");
$ilDB->addPrimaryKey("cmix_lrs_types", $pk_fields);

$ilDB->createSequence("cmix_lrs_types", 1);


//
// cmix_results
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"version" => array (
		"notnull" => true
		,"length" => 2
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"score" => array (
		"notnull" => false
		,"type" => "float"
	)
	,"status" => array (
		"notnull" => true
		,"length" => 32
		,"default" => "0"
		,"fixed" => false
		,"type" => "text"
	)
	,"last_update" => array (
		"notnull" => true
		,"default" => "1970-01-01 00:00:00"
		,"type" => "timestamp"
	)
);
$ilDB->createTable("cmix_results", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("cmix_results", $pk_fields);

$in_fields = array("obj_id","usr_id");
$ilDB->addIndex("cmix_results", $in_fields, "i1", false);

$ilDB->createSequence("cmix_results", 1);


//
// cmix_settings
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"lrs_type_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"content_type" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"source_type" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"activity_id" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"instructions" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"offline_status" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"launch_url" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"auth_fetch_url" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"launch_method" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"launch_mode" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"mastery_score" => array (
		"notnull" => true
		,"default" => "0"
		,"type" => "float"
	)
	,"keep_lp" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usr_privacy_comment" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"show_statements" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"xml_manifest" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"version" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"highscore_enabled" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"highscore_achieved_ts" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"highscore_percentage" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"highscore_wtime" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"highscore_own_table" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"highscore_top_table" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"highscore_top_num" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"bypass_proxy" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"only_moveon" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"achieved" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"answered" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"completed" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"failed" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"initialized" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"passed" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"progressed" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"satisfied" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"c_terminated" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"hide_data" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"c_timestamp" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"duration" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"no_substatements" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"privacy_ident" => array (
		"notnull" => true
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"privacy_name" => array (
		"notnull" => true
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("cmix_settings", $fields);

$pk_fields = array("obj_id");
$ilDB->addPrimaryKey("cmix_settings", $pk_fields);


//
// cmix_token
//
$fields = array (
	"token" => array (
		"notnull" => true
		,"length" => 255
		,"default" => "0"
		,"fixed" => false
		,"type" => "text"
	)
	,"valid_until" => array (
		"notnull" => true
		,"default" => "1970-01-01 00:00:00"
		,"type" => "timestamp"
	)
	,"lrs_type_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("cmix_token", $fields);

$pk_fields = array("token");
$ilDB->addPrimaryKey("cmix_token", $pk_fields);

$in_fields = array("token","valid_until");
$ilDB->addIndex("cmix_token", $in_fields, "i1", false);

$in_fields = array("obj_id","usr_id");
$ilDB->addUniqueConstraint("cmix_token", $in_fields, "c1");


//
// cmix_users
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"proxy_success" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"fetched_until" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"usr_ident" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"privacy_ident" => array (
		"notnull" => true
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("cmix_users", $fields);

$pk_fields = array("obj_id","usr_id","privacy_ident");
$ilDB->addPrimaryKey("cmix_users", $pk_fields);


//
// conditions
//
$fields = array (
	"condition_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"target_ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"target_obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"target_type" => array (
		"notnull" => false
		,"length" => 8
		,"fixed" => false
		,"type" => "text"
	)
	,"trigger_ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"trigger_obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"trigger_type" => array (
		"notnull" => false
		,"length" => 8
		,"fixed" => false
		,"type" => "text"
	)
	,"operator" => array (
		"notnull" => false
		,"length" => 64
		,"fixed" => false
		,"type" => "text"
	)
	,"value" => array (
		"notnull" => false
		,"length" => 64
		,"fixed" => false
		,"type" => "text"
	)
	,"ref_handling" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"obligatory" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"num_obligatory" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"hidden_status" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("conditions", $fields);

$pk_fields = array("condition_id");
$ilDB->addPrimaryKey("conditions", $pk_fields);

$in_fields = array("target_obj_id","target_type");
$ilDB->addIndex("conditions", $in_fields, "tot", false);

$in_fields = array("target_obj_id");
$ilDB->addIndex("conditions", $in_fields, "i1", false);

$ilDB->createSequence("conditions", 1);


//
// cont_filter_field
//
$fields = array (
	"ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"record_set_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"field_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("cont_filter_field", $fields);


//
// cont_member_skills
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"tref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"skill_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"level_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"published" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("cont_member_skills", $fields);

$pk_fields = array("obj_id","user_id","skill_id","tref_id");
$ilDB->addPrimaryKey("cont_member_skills", $pk_fields);


//
// cont_skills
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"skill_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"tref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("cont_skills", $fields);

$pk_fields = array("id","skill_id","tref_id");
$ilDB->addPrimaryKey("cont_skills", $pk_fields);


//
// container_reference
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"target_obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title_type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
);
$ilDB->createTable("container_reference", $fields);

$pk_fields = array("obj_id","target_obj_id");
$ilDB->addPrimaryKey("container_reference", $pk_fields);

$in_fields = array("obj_id");
$ilDB->addIndex("container_reference", $in_fields, "i1", false);


//
// container_settings
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"keyword" => array (
		"notnull" => true
		,"length" => 40
		,"default" => ""
		,"fixed" => true
		,"type" => "text"
	)
	,"value" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => true
		,"type" => "text"
	)
);
$ilDB->createTable("container_settings", $fields);

$pk_fields = array("id","keyword");
$ilDB->addPrimaryKey("container_settings", $pk_fields);


//
// container_sorting
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"child_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"position" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"parent_type" => array (
		"notnull" => false
		,"length" => 5
		,"fixed" => false
		,"type" => "text"
	)
	,"parent_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("container_sorting", $fields);

$pk_fields = array("obj_id","child_id","parent_id");
$ilDB->addPrimaryKey("container_sorting", $pk_fields);


//
// container_sorting_bl
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"block_ids" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("container_sorting_bl", $fields);

$pk_fields = array("obj_id");
$ilDB->addPrimaryKey("container_sorting_bl", $pk_fields);


//
// container_sorting_set
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sort_mode" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sort_direction" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"new_items_position" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"new_items_order" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("container_sorting_set", $fields);

$pk_fields = array("obj_id");
$ilDB->addPrimaryKey("container_sorting_set", $pk_fields);


//
// content_object
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"default_layout" => array (
		"notnull" => false
		,"length" => 100
		,"default" => "toc2win"
		,"fixed" => false
		,"type" => "text"
	)
	,"stylesheet" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"page_header" => array (
		"notnull" => false
		,"length" => 8
		,"default" => "st_title"
		,"fixed" => true
		,"type" => "text"
	)
	,"is_online" => array (
		"notnull" => false
		,"length" => 1
		,"default" => "n"
		,"fixed" => true
		,"type" => "text"
	)
	,"toc_active" => array (
		"notnull" => false
		,"length" => 1
		,"default" => "y"
		,"fixed" => true
		,"type" => "text"
	)
	,"lm_menu_active" => array (
		"notnull" => false
		,"length" => 1
		,"default" => "y"
		,"fixed" => true
		,"type" => "text"
	)
	,"toc_mode" => array (
		"notnull" => false
		,"length" => 8
		,"default" => "chapters"
		,"fixed" => true
		,"type" => "text"
	)
	,"clean_frames" => array (
		"notnull" => false
		,"length" => 1
		,"default" => "n"
		,"fixed" => true
		,"type" => "text"
	)
	,"print_view_active" => array (
		"notnull" => false
		,"length" => 1
		,"default" => "y"
		,"fixed" => true
		,"type" => "text"
	)
	,"numbering" => array (
		"notnull" => false
		,"length" => 1
		,"default" => "n"
		,"fixed" => true
		,"type" => "text"
	)
	,"hist_user_comments" => array (
		"notnull" => false
		,"length" => 1
		,"default" => "n"
		,"fixed" => true
		,"type" => "text"
	)
	,"public_access_mode" => array (
		"notnull" => false
		,"length" => 8
		,"default" => "complete"
		,"fixed" => true
		,"type" => "text"
	)
	,"public_html_file" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"public_xml_file" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"downloads_active" => array (
		"notnull" => false
		,"length" => 1
		,"default" => "n"
		,"fixed" => true
		,"type" => "text"
	)
	,"downloads_public_active" => array (
		"notnull" => false
		,"length" => 1
		,"default" => "y"
		,"fixed" => true
		,"type" => "text"
	)
	,"header_page" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"footer_page" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"no_glo_appendix" => array (
		"notnull" => false
		,"length" => 1
		,"default" => "n"
		,"fixed" => true
		,"type" => "text"
	)
	,"layout_per_page" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"public_scorm_file" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"rating" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"hide_head_foot_print" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"disable_def_feedback" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rating_pages" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"progr_icons" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"store_tries" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"restrict_forw_nav" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"for_translation" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("content_object", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("content_object", $pk_fields);


//
// content_page_data
//
$fields = array (
	"content_page_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"stylesheet" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("content_page_data", $fields);

$pk_fields = array("content_page_id");
$ilDB->addPrimaryKey("content_page_data", $pk_fields);


//
// content_page_metrics
//
$fields = array (
	"content_page_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"page_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"lang" => array (
		"notnull" => true
		,"length" => 2
		,"default" => "-"
		,"fixed" => false
		,"type" => "text"
	)
	,"reading_time" => array (
		"notnull" => true
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("content_page_metrics", $fields);

$pk_fields = array("content_page_id","page_id","lang");
$ilDB->addPrimaryKey("content_page_metrics", $pk_fields);


//
// copg_multilang
//
$fields = array (
	"parent_type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => "0"
		,"fixed" => false
		,"type" => "text"
	)
	,"parent_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"master_lang" => array (
		"notnull" => true
		,"length" => 2
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("copg_multilang", $fields);

$pk_fields = array("parent_type","parent_id");
$ilDB->addPrimaryKey("copg_multilang", $pk_fields);


//
// copg_multilang_lang
//
$fields = array (
	"parent_type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => "0"
		,"fixed" => false
		,"type" => "text"
	)
	,"parent_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"lang" => array (
		"notnull" => true
		,"length" => 2
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("copg_multilang_lang", $fields);

$pk_fields = array("parent_type","parent_id","lang");
$ilDB->addPrimaryKey("copg_multilang_lang", $pk_fields);


//
// copg_pc_def
//
$fields = array (
	"pc_type" => array (
		"notnull" => true
		,"length" => 20
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"name" => array (
		"notnull" => true
		,"length" => 40
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"directory" => array (
		"notnull" => false
		,"length" => 40
		,"fixed" => false
		,"type" => "text"
	)
	,"int_links" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"style_classes" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"xsl" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"component" => array (
		"notnull" => false
		,"length" => 40
		,"fixed" => false
		,"type" => "text"
	)
	,"def_enabled" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"top_item" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"order_nr" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("copg_pc_def", $fields);

$pk_fields = array("pc_type");
$ilDB->addPrimaryKey("copg_pc_def", $pk_fields);

$ilDB->insert("copg_pc_def", array(
'pc_type' => array('text', 'cach'), 'name' => array('text', 'ConsultationHours'), 'directory' => array('text', 'classes'), 'int_links' => array('integer', '0'), 'style_classes' => array('integer', '0'), 'xsl' => array('integer', '0'), 'component' => array('text', 'Modules/Portfolio'), 'def_enabled' => array('integer', '0'), 'top_item' => array('integer', '1'), 'order_nr' => array('integer', '127')));

$ilDB->insert("copg_pc_def", array(
'pc_type' => array('text', 'mcrs'), 'name' => array('text', 'MyCourses'), 'directory' => array('text', 'classes'), 'int_links' => array('integer', '0'), 'style_classes' => array('integer', '0'), 'xsl' => array('integer', '0'), 'component' => array('text', 'Modules/Portfolio'), 'def_enabled' => array('integer', '0'), 'top_item' => array('integer', '1'), 'order_nr' => array('integer', '127')));

$ilDB->insert("copg_pc_def", array(
'pc_type' => array('text', 'amdpl'), 'name' => array('text', 'AMDPageList'), 'directory' => array('text', 'classes'), 'int_links' => array('integer', '0'), 'style_classes' => array('integer', '0'), 'xsl' => array('integer', '0'), 'component' => array('text', 'Modules/Wiki'), 'def_enabled' => array('integer', '0'), 'top_item' => array('integer', '1'), 'order_nr' => array('integer', '127')));

$ilDB->insert("copg_pc_def", array(
'pc_type' => array('text', 'blog'), 'name' => array('text', 'Blog'), 'directory' => array('text', 'classes'), 'int_links' => array('integer', '0'), 'style_classes' => array('integer', '0'), 'xsl' => array('integer', '0'), 'component' => array('text', 'Services/COPage'), 'def_enabled' => array('integer', '0'), 'top_item' => array('integer', '1'), 'order_nr' => array('integer', '100')));

$ilDB->insert("copg_pc_def", array(
'pc_type' => array('text', 'incl'), 'name' => array('text', 'ContentInclude'), 'directory' => array('text', 'classes'), 'int_links' => array('integer', '1'), 'style_classes' => array('integer', '1'), 'xsl' => array('integer', '0'), 'component' => array('text', 'Services/COPage'), 'def_enabled' => array('integer', '0'), 'top_item' => array('integer', '1'), 'order_nr' => array('integer', '110')));

$ilDB->insert("copg_pc_def", array(
'pc_type' => array('text', 'flit'), 'name' => array('text', 'FileItem'), 'directory' => array('text', 'classes'), 'int_links' => array('integer', '0'), 'style_classes' => array('integer', '1'), 'xsl' => array('integer', '0'), 'component' => array('text', 'Services/COPage'), 'def_enabled' => array('integer', '1'), 'top_item' => array('integer', '0'), 'order_nr' => array('integer', '0')));

$ilDB->insert("copg_pc_def", array(
'pc_type' => array('text', 'flst'), 'name' => array('text', 'FileList'), 'directory' => array('text', 'classes'), 'int_links' => array('integer', '0'), 'style_classes' => array('integer', '1'), 'xsl' => array('integer', '0'), 'component' => array('text', 'Services/COPage'), 'def_enabled' => array('integer', '1'), 'top_item' => array('integer', '1'), 'order_nr' => array('integer', '40')));

$ilDB->insert("copg_pc_def", array(
'pc_type' => array('text', 'iim'), 'name' => array('text', 'InteractiveImage'), 'directory' => array('text', 'classes'), 'int_links' => array('integer', '1'), 'style_classes' => array('integer', '1'), 'xsl' => array('integer', '0'), 'component' => array('text', 'Services/COPage'), 'def_enabled' => array('integer', '1'), 'top_item' => array('integer', '1'), 'order_nr' => array('integer', '100')));

$ilDB->insert("copg_pc_def", array(
'pc_type' => array('text', 'list'), 'name' => array('text', 'List'), 'directory' => array('text', 'classes'), 'int_links' => array('integer', '0'), 'style_classes' => array('integer', '1'), 'xsl' => array('integer', '0'), 'component' => array('text', 'Services/COPage'), 'def_enabled' => array('integer', '1'), 'top_item' => array('integer', '1'), 'order_nr' => array('integer', '127')));

$ilDB->insert("copg_pc_def", array(
'pc_type' => array('text', 'li'), 'name' => array('text', 'ListItem'), 'directory' => array('text', 'classes'), 'int_links' => array('integer', '0'), 'style_classes' => array('integer', '0'), 'xsl' => array('integer', '0'), 'component' => array('text', 'Services/COPage'), 'def_enabled' => array('integer', '1'), 'top_item' => array('integer', '0'), 'order_nr' => array('integer', '0')));

$ilDB->insert("copg_pc_def", array(
'pc_type' => array('text', 'lpe'), 'name' => array('text', 'LoginPageElement'), 'directory' => array('text', 'classes'), 'int_links' => array('integer', '0'), 'style_classes' => array('integer', '0'), 'xsl' => array('integer', '0'), 'component' => array('text', 'Services/COPage'), 'def_enabled' => array('integer', '0'), 'top_item' => array('integer', '1'), 'order_nr' => array('integer', '120')));

$ilDB->insert("copg_pc_def", array(
'pc_type' => array('text', 'map'), 'name' => array('text', 'Map'), 'directory' => array('text', 'classes'), 'int_links' => array('integer', '0'), 'style_classes' => array('integer', '0'), 'xsl' => array('integer', '0'), 'component' => array('text', 'Services/COPage'), 'def_enabled' => array('integer', '0'), 'top_item' => array('integer', '1'), 'order_nr' => array('integer', '127')));

$ilDB->insert("copg_pc_def", array(
'pc_type' => array('text', 'media'), 'name' => array('text', 'MediaObject'), 'directory' => array('text', 'classes'), 'int_links' => array('integer', '0'), 'style_classes' => array('integer', '1'), 'xsl' => array('integer', '0'), 'component' => array('text', 'Services/COPage'), 'def_enabled' => array('integer', '1'), 'top_item' => array('integer', '1'), 'order_nr' => array('integer', '20')));

$ilDB->insert("copg_pc_def", array(
'pc_type' => array('text', 'par'), 'name' => array('text', 'Paragraph'), 'directory' => array('text', 'classes'), 'int_links' => array('integer', '1'), 'style_classes' => array('integer', '1'), 'xsl' => array('integer', '0'), 'component' => array('text', 'Services/COPage'), 'def_enabled' => array('integer', '1'), 'top_item' => array('integer', '1'), 'order_nr' => array('integer', '10')));

$ilDB->insert("copg_pc_def", array(
'pc_type' => array('text', 'plach'), 'name' => array('text', 'PlaceHolder'), 'directory' => array('text', 'classes'), 'int_links' => array('integer', '0'), 'style_classes' => array('integer', '1'), 'xsl' => array('integer', '0'), 'component' => array('text', 'Services/COPage'), 'def_enabled' => array('integer', '0'), 'top_item' => array('integer', '1'), 'order_nr' => array('integer', '90')));

$ilDB->insert("copg_pc_def", array(
'pc_type' => array('text', 'plug'), 'name' => array('text', 'Plugged'), 'directory' => array('text', 'classes'), 'int_links' => array('integer', '0'), 'style_classes' => array('integer', '0'), 'xsl' => array('integer', '0'), 'component' => array('text', 'Services/COPage'), 'def_enabled' => array('integer', '0'), 'top_item' => array('integer', '1'), 'order_nr' => array('integer', '127')));

$ilDB->insert("copg_pc_def", array(
'pc_type' => array('text', 'prof'), 'name' => array('text', 'Profile'), 'directory' => array('text', 'classes'), 'int_links' => array('integer', '0'), 'style_classes' => array('integer', '0'), 'xsl' => array('integer', '0'), 'component' => array('text', 'Services/COPage'), 'def_enabled' => array('integer', '0'), 'top_item' => array('integer', '1'), 'order_nr' => array('integer', '127')));

$ilDB->insert("copg_pc_def", array(
'pc_type' => array('text', 'pcqst'), 'name' => array('text', 'Question'), 'directory' => array('text', 'classes'), 'int_links' => array('integer', '0'), 'style_classes' => array('integer', '0'), 'xsl' => array('integer', '0'), 'component' => array('text', 'Services/COPage'), 'def_enabled' => array('integer', '0'), 'top_item' => array('integer', '1'), 'order_nr' => array('integer', '70')));

$ilDB->insert("copg_pc_def", array(
'pc_type' => array('text', 'qover'), 'name' => array('text', 'QuestionOverview'), 'directory' => array('text', 'classes'), 'int_links' => array('integer', '0'), 'style_classes' => array('integer', '0'), 'xsl' => array('integer', '0'), 'component' => array('text', 'Services/COPage'), 'def_enabled' => array('integer', '0'), 'top_item' => array('integer', '1'), 'order_nr' => array('integer', '80')));

$ilDB->insert("copg_pc_def", array(
'pc_type' => array('text', 'repobj'), 'name' => array('text', 'Resources'), 'directory' => array('text', 'classes'), 'int_links' => array('integer', '0'), 'style_classes' => array('integer', '0'), 'xsl' => array('integer', '0'), 'component' => array('text', 'Services/COPage'), 'def_enabled' => array('integer', '0'), 'top_item' => array('integer', '1'), 'order_nr' => array('integer', '127')));

$ilDB->insert("copg_pc_def", array(
'pc_type' => array('text', 'sec'), 'name' => array('text', 'Section'), 'directory' => array('text', 'classes'), 'int_links' => array('integer', '0'), 'style_classes' => array('integer', '1'), 'xsl' => array('integer', '0'), 'component' => array('text', 'Services/COPage'), 'def_enabled' => array('integer', '1'), 'top_item' => array('integer', '1'), 'order_nr' => array('integer', '60')));

$ilDB->insert("copg_pc_def", array(
'pc_type' => array('text', 'skills'), 'name' => array('text', 'Skills'), 'directory' => array('text', 'classes'), 'int_links' => array('integer', '0'), 'style_classes' => array('integer', '0'), 'xsl' => array('integer', '0'), 'component' => array('text', 'Services/COPage'), 'def_enabled' => array('integer', '0'), 'top_item' => array('integer', '1'), 'order_nr' => array('integer', '127')));

$ilDB->insert("copg_pc_def", array(
'pc_type' => array('text', 'dtab'), 'name' => array('text', 'DataTable'), 'directory' => array('text', 'classes'), 'int_links' => array('integer', '0'), 'style_classes' => array('integer', '1'), 'xsl' => array('integer', '0'), 'component' => array('text', 'Services/COPage'), 'def_enabled' => array('integer', '1'), 'top_item' => array('integer', '1'), 'order_nr' => array('integer', '50')));

$ilDB->insert("copg_pc_def", array(
'pc_type' => array('text', 'tab'), 'name' => array('text', 'Table'), 'directory' => array('text', 'classes'), 'int_links' => array('integer', '0'), 'style_classes' => array('integer', '1'), 'xsl' => array('integer', '0'), 'component' => array('text', 'Services/COPage'), 'def_enabled' => array('integer', '1'), 'top_item' => array('integer', '1'), 'order_nr' => array('integer', '127')));

$ilDB->insert("copg_pc_def", array(
'pc_type' => array('text', 'td'), 'name' => array('text', 'TableData'), 'directory' => array('text', 'classes'), 'int_links' => array('integer', '0'), 'style_classes' => array('integer', '0'), 'xsl' => array('integer', '0'), 'component' => array('text', 'Services/COPage'), 'def_enabled' => array('integer', '1'), 'top_item' => array('integer', '0'), 'order_nr' => array('integer', '0')));

$ilDB->insert("copg_pc_def", array(
'pc_type' => array('text', 'tabs'), 'name' => array('text', 'Tabs'), 'directory' => array('text', 'classes'), 'int_links' => array('integer', '0'), 'style_classes' => array('integer', '1'), 'xsl' => array('integer', '0'), 'component' => array('text', 'Services/COPage'), 'def_enabled' => array('integer', '1'), 'top_item' => array('integer', '1'), 'order_nr' => array('integer', '127')));

$ilDB->insert("copg_pc_def", array(
'pc_type' => array('text', 'tabstab'), 'name' => array('text', 'Tab'), 'directory' => array('text', 'classes'), 'int_links' => array('integer', '0'), 'style_classes' => array('integer', '0'), 'xsl' => array('integer', '0'), 'component' => array('text', 'Services/COPage'), 'def_enabled' => array('integer', '1'), 'top_item' => array('integer', '0'), 'order_nr' => array('integer', '0')));

$ilDB->insert("copg_pc_def", array(
'pc_type' => array('text', 'vrfc'), 'name' => array('text', 'Verification'), 'directory' => array('text', 'classes'), 'int_links' => array('integer', '0'), 'style_classes' => array('integer', '0'), 'xsl' => array('integer', '0'), 'component' => array('text', 'Services/COPage'), 'def_enabled' => array('integer', '0'), 'top_item' => array('integer', '1'), 'order_nr' => array('integer', '127')));

$ilDB->insert("copg_pc_def", array(
'pc_type' => array('text', 'src'), 'name' => array('text', 'SourceCode'), 'directory' => array('text', 'classes'), 'int_links' => array('integer', '0'), 'style_classes' => array('integer', '0'), 'xsl' => array('integer', '0'), 'component' => array('text', 'Services/COPage'), 'def_enabled' => array('integer', '1'), 'top_item' => array('integer', '1'), 'order_nr' => array('integer', '127')));

$ilDB->insert("copg_pc_def", array(
'pc_type' => array('text', 'templ'), 'name' => array('text', 'ContentTemplate'), 'directory' => array('text', 'classes'), 'int_links' => array('integer', '0'), 'style_classes' => array('integer', '0'), 'xsl' => array('integer', '0'), 'component' => array('text', 'Services/COPage'), 'def_enabled' => array('integer', '0'), 'top_item' => array('integer', '1'), 'order_nr' => array('integer', '127')));

$ilDB->insert("copg_pc_def", array(
'pc_type' => array('text', 'grid'), 'name' => array('text', 'Grid'), 'directory' => array('text', 'classes'), 'int_links' => array('integer', '0'), 'style_classes' => array('integer', '0'), 'xsl' => array('integer', '0'), 'component' => array('text', 'Services/COPage'), 'def_enabled' => array('integer', '1'), 'top_item' => array('integer', '1'), 'order_nr' => array('integer', '127')));

$ilDB->insert("copg_pc_def", array(
'pc_type' => array('text', 'gcell'), 'name' => array('text', 'GridCell'), 'directory' => array('text', 'classes'), 'int_links' => array('integer', '0'), 'style_classes' => array('integer', '0'), 'xsl' => array('integer', '0'), 'component' => array('text', 'Services/COPage'), 'def_enabled' => array('integer', '1'), 'top_item' => array('integer', '0'), 'order_nr' => array('integer', '0')));

$ilDB->insert("copg_pc_def", array(
'pc_type' => array('text', 'lhist'), 'name' => array('text', 'LearningHistory'), 'directory' => array('text', 'classes'), 'int_links' => array('integer', '0'), 'style_classes' => array('integer', '0'), 'xsl' => array('integer', '0'), 'component' => array('text', 'Services/LearningHistory'), 'def_enabled' => array('integer', '0'), 'top_item' => array('integer', '1'), 'order_nr' => array('integer', '127')));


//
// copg_pobj_def
//
$fields = array (
	"parent_type" => array (
		"notnull" => true
		,"length" => 20
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"class_name" => array (
		"notnull" => true
		,"length" => 80
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"directory" => array (
		"notnull" => false
		,"length" => 40
		,"fixed" => false
		,"type" => "text"
	)
	,"component" => array (
		"notnull" => false
		,"length" => 40
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("copg_pobj_def", $fields);

$pk_fields = array("parent_type");
$ilDB->addPrimaryKey("copg_pobj_def", $pk_fields);

$ilDB->insert("copg_pobj_def", array(
'parent_type' => array('text', 'blp'), 'class_name' => array('text', 'ilBlogPosting'), 'directory' => array('text', 'classes'), 'component' => array('text', 'Modules/Blog')));

$ilDB->insert("copg_pobj_def", array(
'parent_type' => array('text', 'lm'), 'class_name' => array('text', 'ilLMPage'), 'directory' => array('text', 'classes'), 'component' => array('text', 'Modules/LearningModule')));

$ilDB->insert("copg_pobj_def", array(
'parent_type' => array('text', 'gdf'), 'class_name' => array('text', 'ilGlossaryDefPage'), 'directory' => array('text', 'classes'), 'component' => array('text', 'Modules/Glossary')));

$ilDB->insert("copg_pobj_def", array(
'parent_type' => array('text', 'qht'), 'class_name' => array('text', 'ilAssHintPage'), 'directory' => array('text', 'classes'), 'component' => array('text', 'Modules/TestQuestionPool')));

$ilDB->insert("copg_pobj_def", array(
'parent_type' => array('text', 'qpl'), 'class_name' => array('text', 'ilAssQuestionPage'), 'directory' => array('text', 'classes'), 'component' => array('text', 'Modules/TestQuestionPool')));

$ilDB->insert("copg_pobj_def", array(
'parent_type' => array('text', 'qfbg'), 'class_name' => array('text', 'ilAssGenFeedbackPage'), 'directory' => array('text', 'classes/feedback'), 'component' => array('text', 'Modules/TestQuestionPool')));

$ilDB->insert("copg_pobj_def", array(
'parent_type' => array('text', 'qfbs'), 'class_name' => array('text', 'ilAssSpecFeedbackPage'), 'directory' => array('text', 'classes/feedback'), 'component' => array('text', 'Modules/TestQuestionPool')));

$ilDB->insert("copg_pobj_def", array(
'parent_type' => array('text', 'dclf'), 'class_name' => array('text', 'ilDclDetailedViewDefinition'), 'directory' => array('text', 'classes/DetailedView'), 'component' => array('text', 'Modules/DataCollection')));

$ilDB->insert("copg_pobj_def", array(
'parent_type' => array('text', 'prtf'), 'class_name' => array('text', 'ilPortfolioPage'), 'directory' => array('text', 'classes'), 'component' => array('text', 'Modules/Portfolio')));

$ilDB->insert("copg_pobj_def", array(
'parent_type' => array('text', 'prtt'), 'class_name' => array('text', 'ilPortfolioTemplatePage'), 'directory' => array('text', 'classes'), 'component' => array('text', 'Modules/Portfolio')));

$ilDB->insert("copg_pobj_def", array(
'parent_type' => array('text', 'sahs'), 'class_name' => array('text', 'ilSCORM2004Page'), 'directory' => array('text', 'classes'), 'component' => array('text', 'Modules/Scorm2004')));

$ilDB->insert("copg_pobj_def", array(
'parent_type' => array('text', 'lobj'), 'class_name' => array('text', 'ilLOPage'), 'directory' => array('text', 'classes/Objectives'), 'component' => array('text', 'Modules/Course')));

$ilDB->insert("copg_pobj_def", array(
'parent_type' => array('text', 'copa'), 'class_name' => array('text', 'ilContentPagePage'), 'directory' => array('text', 'classes'), 'component' => array('text', 'Modules/ContentPage')));

$ilDB->insert("copg_pobj_def", array(
'parent_type' => array('text', 'mep'), 'class_name' => array('text', 'ilMediaPoolPage'), 'directory' => array('text', 'classes'), 'component' => array('text', 'Modules/MediaPool')));

$ilDB->insert("copg_pobj_def", array(
'parent_type' => array('text', 'wpg'), 'class_name' => array('text', 'ilWikiPage'), 'directory' => array('text', 'classes'), 'component' => array('text', 'Modules/Wiki')));

$ilDB->insert("copg_pobj_def", array(
'parent_type' => array('text', 'impr'), 'class_name' => array('text', 'ilImprint'), 'directory' => array('text', 'classes'), 'component' => array('text', 'Services/Imprint')));

$ilDB->insert("copg_pobj_def", array(
'parent_type' => array('text', 'auth'), 'class_name' => array('text', 'ilLoginPage'), 'directory' => array('text', 'classes'), 'component' => array('text', 'Services/Authentication')));

$ilDB->insert("copg_pobj_def", array(
'parent_type' => array('text', 'stys'), 'class_name' => array('text', 'ilPageLayoutPage'), 'directory' => array('text', 'Layout/classes'), 'component' => array('text', 'Services/COPage')));

$ilDB->insert("copg_pobj_def", array(
'parent_type' => array('text', 'cont'), 'class_name' => array('text', 'ilContainerPage'), 'directory' => array('text', 'classes'), 'component' => array('text', 'Services/Container')));

$ilDB->insert("copg_pobj_def", array(
'parent_type' => array('text', 'cstr'), 'class_name' => array('text', 'ilContainerStartObjectsPage'), 'directory' => array('text', 'classes'), 'component' => array('text', 'Services/Container')));


//
// copg_section_timings
//
$fields = array (
	"page_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"parent_type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"unix_ts" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("copg_section_timings", $fields);

$pk_fields = array("page_id","parent_type","unix_ts");
$ilDB->addPrimaryKey("copg_section_timings", $pk_fields);


//
// copy_wizard_options
//
$fields = array (
	"copy_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"source_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"options" => array (
		"notnull" => false
		,"type" => "clob"
	)
);
$ilDB->createTable("copy_wizard_options", $fields);

$pk_fields = array("copy_id","source_id");
$ilDB->addPrimaryKey("copy_wizard_options", $pk_fields);


//
// cp_auxilaryresource
//
$fields = array (
	"auxiliaryresourceid" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"cp_node_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"purpose" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("cp_auxilaryresource", $fields);

$pk_fields = array("cp_node_id");
$ilDB->addPrimaryKey("cp_auxilaryresource", $pk_fields);


//
// cp_condition
//
$fields = array (
	"c_condition" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"cp_node_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"measurethreshold" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"c_operator" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"referencedobjective" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("cp_condition", $fields);

$pk_fields = array("cp_node_id");
$ilDB->addPrimaryKey("cp_condition", $pk_fields);


//
// cp_datamap
//
$fields = array (
	"sco_node_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"cp_node_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"slm_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"target_id" => array (
		"notnull" => true
		,"length" => 4000
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"read_shared_data" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"write_shared_data" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
);
$ilDB->createTable("cp_datamap", $fields);

$pk_fields = array("cp_node_id");
$ilDB->addPrimaryKey("cp_datamap", $pk_fields);


//
// cp_dependency
//
$fields = array (
	"cp_node_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"resourceid" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("cp_dependency", $fields);

$pk_fields = array("cp_node_id");
$ilDB->addPrimaryKey("cp_dependency", $pk_fields);

$in_fields = array("resourceid");
$ilDB->addIndex("cp_dependency", $in_fields, "i2", false);


//
// cp_file
//
$fields = array (
	"cp_node_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"href" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("cp_file", $fields);

$pk_fields = array("cp_node_id");
$ilDB->addPrimaryKey("cp_file", $pk_fields);


//
// cp_hidelmsui
//
$fields = array (
	"cp_node_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"value" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("cp_hidelmsui", $fields);

$pk_fields = array("cp_node_id");
$ilDB->addPrimaryKey("cp_hidelmsui", $pk_fields);

$in_fields = array("value");
$ilDB->addIndex("cp_hidelmsui", $in_fields, "i1", false);


//
// cp_item
//
$fields = array (
	"completionthreshold" => array (
		"notnull" => false
		,"length" => 50
		,"default" => "1.0"
		,"fixed" => false
		,"type" => "text"
	)
	,"cp_node_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"datafromlms" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"id" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"isvisible" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"parameters" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"resourceid" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"sequencingid" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"timelimitaction" => array (
		"notnull" => false
		,"length" => 30
		,"fixed" => false
		,"type" => "text"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"progressweight" => array (
		"notnull" => false
		,"length" => 50
		,"default" => "1.0"
		,"fixed" => false
		,"type" => "text"
	)
	,"completedbymeasure" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("cp_item", $fields);

$pk_fields = array("cp_node_id");
$ilDB->addPrimaryKey("cp_item", $pk_fields);

$in_fields = array("id");
$ilDB->addIndex("cp_item", $in_fields, "i1", false);

$in_fields = array("sequencingid");
$ilDB->addIndex("cp_item", $in_fields, "i2", false);


//
// cp_manifest
//
$fields = array (
	"base" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"cp_node_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"defaultorganization" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"id" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"uri" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"version" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("cp_manifest", $fields);

$pk_fields = array("cp_node_id");
$ilDB->addPrimaryKey("cp_manifest", $pk_fields);

$in_fields = array("id");
$ilDB->addIndex("cp_manifest", $in_fields, "i1", false);


//
// cp_mapinfo
//
$fields = array (
	"cp_node_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"readnormalmeasure" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"readsatisfiedstatus" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"targetobjectiveid" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"writenormalmeasure" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"writesatisfiedstatus" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("cp_mapinfo", $fields);

$pk_fields = array("cp_node_id");
$ilDB->addPrimaryKey("cp_mapinfo", $pk_fields);

$in_fields = array("targetobjectiveid");
$ilDB->addIndex("cp_mapinfo", $in_fields, "i1", false);


//
// cp_node
//
$fields = array (
	"cp_node_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"nodename" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"slm_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("cp_node", $fields);

$pk_fields = array("cp_node_id");
$ilDB->addPrimaryKey("cp_node", $pk_fields);

$in_fields = array("nodename");
$ilDB->addIndex("cp_node", $in_fields, "i2", false);

$in_fields = array("slm_id");
$ilDB->addIndex("cp_node", $in_fields, "i3", false);

$ilDB->createSequence("cp_node", 1);


//
// cp_objective
//
$fields = array (
	"cp_node_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"minnormalmeasure" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"objectiveid" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"c_primary" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"satisfiedbymeasure" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("cp_objective", $fields);

$pk_fields = array("cp_node_id");
$ilDB->addPrimaryKey("cp_objective", $pk_fields);


//
// cp_organization
//
$fields = array (
	"cp_node_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"id" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"objectivesglobtosys" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"sequencingid" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"structure" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("cp_organization", $fields);

$pk_fields = array("cp_node_id");
$ilDB->addPrimaryKey("cp_organization", $pk_fields);

$in_fields = array("id");
$ilDB->addIndex("cp_organization", $in_fields, "i1", false);

$in_fields = array("sequencingid");
$ilDB->addIndex("cp_organization", $in_fields, "i2", false);


//
// cp_package
//
$fields = array (
	"created" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
	,"c_identifier" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"jsdata" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"modified" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"persistprevattempts" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"c_settings" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"xmldata" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"activitytree" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"global_to_system" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"shared_data_global_to_system" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
);
$ilDB->createTable("cp_package", $fields);

$pk_fields = array("obj_id");
$ilDB->addPrimaryKey("cp_package", $pk_fields);

$in_fields = array("c_identifier");
$ilDB->addIndex("cp_package", $in_fields, "i1", false);


//
// cp_resource
//
$fields = array (
	"base" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"cp_node_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"href" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"id" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"scormtype" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"c_type" => array (
		"notnull" => false
		,"length" => 30
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("cp_resource", $fields);

$pk_fields = array("cp_node_id");
$ilDB->addPrimaryKey("cp_resource", $pk_fields);

$in_fields = array("id");
$ilDB->addIndex("cp_resource", $in_fields, "i1", false);


//
// cp_rule
//
$fields = array (
	"action" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"childactivityset" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"conditioncombination" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"cp_node_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"minimumcount" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"minimumpercent" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"c_type" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("cp_rule", $fields);

$pk_fields = array("cp_node_id");
$ilDB->addPrimaryKey("cp_rule", $pk_fields);


//
// cp_sequencing
//
$fields = array (
	"activityabsdurlimit" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
	,"activityexpdurlimit" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
	,"attemptabsdurlimit" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
	,"attemptexpdurlimit" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
	,"attemptlimit" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"begintimelimit" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
	,"choice" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"choiceexit" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"completionbycontent" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"constrainchoice" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"cp_node_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"endtimelimit" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
	,"flow" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"forwardonly" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"id" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"measuresatisfactive" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"objectivemeasweight" => array (
		"notnull" => false
		,"type" => "float"
	)
	,"objectivebycontent" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"preventactivation" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"randomizationtiming" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"reorderchildren" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"requiredcompleted" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"requiredincomplete" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"requirednotsatisfied" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"requiredforsatisfied" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"rollupobjectivesatis" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"rollupprogcompletion" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"selectcount" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"selectiontiming" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"sequencingid" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"tracked" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"usecurattemptobjinfo" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"usecurattemptproginfo" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("cp_sequencing", $fields);

$pk_fields = array("cp_node_id");
$ilDB->addPrimaryKey("cp_sequencing", $pk_fields);

$in_fields = array("id");
$ilDB->addIndex("cp_sequencing", $in_fields, "i1", false);


//
// cp_suspend
//
$fields = array (
	"data" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
);
$ilDB->createTable("cp_suspend", $fields);

$pk_fields = array("user_id","obj_id");
$ilDB->addPrimaryKey("cp_suspend", $pk_fields);


//
// cp_tree
//
$fields = array (
	"child" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"depth" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"lft" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"parent" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"rgt" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("cp_tree", $fields);

$pk_fields = array("obj_id","child");
$ilDB->addPrimaryKey("cp_tree", $pk_fields);

$in_fields = array("child");
$ilDB->addIndex("cp_tree", $in_fields, "i1", false);

$in_fields = array("obj_id");
$ilDB->addIndex("cp_tree", $in_fields, "i2", false);

$in_fields = array("parent");
$ilDB->addIndex("cp_tree", $in_fields, "i3", false);


//
// cron_job
//
$fields = array (
	"job_id" => array (
		"notnull" => true
		,"length" => 50
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"component" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"schedule_type" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"schedule_value" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"job_status" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"job_status_user_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"job_status_type" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"job_status_ts" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"job_result_status" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"job_result_user_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"job_result_code" => array (
		"notnull" => false
		,"length" => 64
		,"fixed" => false
		,"type" => "text"
	)
	,"job_result_message" => array (
		"notnull" => false
		,"length" => 400
		,"fixed" => false
		,"type" => "text"
	)
	,"job_result_type" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"job_result_ts" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"class" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"path" => array (
		"notnull" => false
		,"length" => 400
		,"fixed" => false
		,"type" => "text"
	)
	,"running_ts" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"job_result_dur" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"alive_ts" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("cron_job", $fields);

$pk_fields = array("job_id");
$ilDB->addPrimaryKey("cron_job", $pk_fields);

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'book_pref_book'), 'component' => array('text', 'Modules/BookingManager'), 'schedule_type' => array('integer', '1'), 'schedule_value' => array('integer', ''), 'job_status' => array('integer', '1'), 'job_status_user_id' => array('integer', '0'), 'job_status_type' => array('integer', '0'), 'job_status_ts' => array('integer', '1605888798'), 'job_result_status' => array('integer', ''), 'job_result_user_id' => array('integer', ''), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', ''), 'job_result_ts' => array('integer', ''), 'class' => array('text', 'ilBookingPrefBookCron'), 'path' => array('text', ''), 'running_ts' => array('integer', ''), 'job_result_dur' => array('integer', ''), 'alive_ts' => array('integer', '')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'cal_consultation'), 'component' => array('text', 'Services/Calendar'), 'schedule_type' => array('integer', '0'), 'schedule_value' => array('integer', '0'), 'job_status' => array('integer', '0'), 'job_status_user_id' => array('integer', '0'), 'job_status_type' => array('integer', '0'), 'job_status_ts' => array('integer', '0'), 'job_result_status' => array('integer', '0'), 'job_result_user_id' => array('integer', '0'), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', '0'), 'job_result_ts' => array('integer', '0'), 'class' => array('text', 'ilConsultationHourCron'), 'path' => array('text', 'Services/Calendar/classes/ConsultationHours/'), 'running_ts' => array('integer', '0'), 'job_result_dur' => array('integer', '0'), 'alive_ts' => array('integer', '0')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'exc_feedback_notification'), 'component' => array('text', 'Modules/Exercise'), 'schedule_type' => array('integer', '0'), 'schedule_value' => array('integer', '0'), 'job_status' => array('integer', '1'), 'job_status_user_id' => array('integer', '0'), 'job_status_type' => array('integer', '0'), 'job_status_ts' => array('integer', '1381511097'), 'job_result_status' => array('integer', '0'), 'job_result_user_id' => array('integer', '0'), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', '0'), 'job_result_ts' => array('integer', '0'), 'class' => array('text', 'ilExcCronFeedbackNotification'), 'path' => array('text', ''), 'running_ts' => array('integer', '0'), 'job_result_dur' => array('integer', '0'), 'alive_ts' => array('integer', '0')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'finish_unfinished_passes'), 'component' => array('text', 'Modules/Test'), 'schedule_type' => array('integer', '1'), 'schedule_value' => array('integer', '0'), 'job_status' => array('integer', '0'), 'job_status_user_id' => array('integer', '0'), 'job_status_type' => array('integer', '0'), 'job_status_ts' => array('integer', '0'), 'job_result_status' => array('integer', '0'), 'job_result_user_id' => array('integer', '0'), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', '0'), 'job_result_ts' => array('integer', '0'), 'class' => array('text', 'ilCronFinishUnfinishedTestPasses'), 'path' => array('text', ''), 'running_ts' => array('integer', '0'), 'job_result_dur' => array('integer', '0'), 'alive_ts' => array('integer', '0')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'frm_notification'), 'component' => array('text', 'Modules/Forum'), 'schedule_type' => array('integer', '3'), 'schedule_value' => array('integer', '1'), 'job_status' => array('integer', '0'), 'job_status_user_id' => array('integer', '0'), 'job_status_type' => array('integer', '0'), 'job_status_ts' => array('integer', '0'), 'job_result_status' => array('integer', '0'), 'job_result_user_id' => array('integer', '0'), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', '0'), 'job_result_ts' => array('integer', '0'), 'class' => array('text', 'ilForumCronNotification'), 'path' => array('text', ''), 'running_ts' => array('integer', '0'), 'job_result_dur' => array('integer', '0'), 'alive_ts' => array('integer', '0')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'ldap_sync'), 'component' => array('text', 'Services/LDAP'), 'schedule_type' => array('integer', '0'), 'schedule_value' => array('integer', '0'), 'job_status' => array('integer', '0'), 'job_status_user_id' => array('integer', '0'), 'job_status_type' => array('integer', '0'), 'job_status_ts' => array('integer', '0'), 'job_result_status' => array('integer', '0'), 'job_result_user_id' => array('integer', '0'), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', '0'), 'job_result_ts' => array('integer', '0'), 'class' => array('text', 'ilLDAPCronSynchronization'), 'path' => array('text', ''), 'running_ts' => array('integer', '0'), 'job_result_dur' => array('integer', '0'), 'alive_ts' => array('integer', '0')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'lm_link_check'), 'component' => array('text', 'Modules/LearningModule'), 'schedule_type' => array('integer', '0'), 'schedule_value' => array('integer', '0'), 'job_status' => array('integer', '0'), 'job_status_user_id' => array('integer', '0'), 'job_status_type' => array('integer', '0'), 'job_status_ts' => array('integer', '0'), 'job_result_status' => array('integer', '0'), 'job_result_user_id' => array('integer', '0'), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', '0'), 'job_result_ts' => array('integer', '0'), 'class' => array('text', 'ilLearningModuleCronLinkCheck'), 'path' => array('text', ''), 'running_ts' => array('integer', '0'), 'job_result_dur' => array('integer', '0'), 'alive_ts' => array('integer', '0')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'log_error_file_cleanup'), 'component' => array('text', 'Services/Logging'), 'schedule_type' => array('integer', '4'), 'schedule_value' => array('integer', '10'), 'job_status' => array('integer', '0'), 'job_status_user_id' => array('integer', '0'), 'job_status_type' => array('integer', '0'), 'job_status_ts' => array('integer', '0'), 'job_result_status' => array('integer', '0'), 'job_result_user_id' => array('integer', '0'), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', '0'), 'job_result_ts' => array('integer', '0'), 'class' => array('text', 'ilLoggerCronCleanErrorFiles'), 'path' => array('text', 'Services/Logging/classes/error/'), 'running_ts' => array('integer', '0'), 'job_result_dur' => array('integer', '0'), 'alive_ts' => array('integer', '0')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'lp_object_statistics'), 'component' => array('text', 'Services/Tracking'), 'schedule_type' => array('integer', '0'), 'schedule_value' => array('integer', '0'), 'job_status' => array('integer', '1'), 'job_status_user_id' => array('integer', '0'), 'job_status_type' => array('integer', '0'), 'job_status_ts' => array('integer', '1381511103'), 'job_result_status' => array('integer', '0'), 'job_result_user_id' => array('integer', '0'), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', '0'), 'job_result_ts' => array('integer', '0'), 'class' => array('text', 'ilLPCronObjectStatistics'), 'path' => array('text', ''), 'running_ts' => array('integer', '0'), 'job_result_dur' => array('integer', '0'), 'alive_ts' => array('integer', '0')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'mail_notification'), 'component' => array('text', 'Services/Mail'), 'schedule_type' => array('integer', '0'), 'schedule_value' => array('integer', '0'), 'job_status' => array('integer', '1'), 'job_status_user_id' => array('integer', '6'), 'job_status_type' => array('integer', '1'), 'job_status_ts' => array('integer', '1481898063'), 'job_result_status' => array('integer', ''), 'job_result_user_id' => array('integer', '6'), 'job_result_code' => array('text', 'job_manual_reset'), 'job_result_message' => array('text', 'Cron job re-activated by admin'), 'job_result_type' => array('integer', '1'), 'job_result_ts' => array('integer', '0'), 'class' => array('text', 'ilMailCronNotification'), 'path' => array('text', ''), 'running_ts' => array('integer', '0'), 'job_result_dur' => array('integer', '0'), 'alive_ts' => array('integer', '0')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'mail_orphaned_mails'), 'component' => array('text', 'Services/Mail'), 'schedule_type' => array('integer', '1'), 'schedule_value' => array('integer', '1'), 'job_status' => array('integer', '0'), 'job_status_user_id' => array('integer', '0'), 'job_status_type' => array('integer', '0'), 'job_status_ts' => array('integer', '0'), 'job_result_status' => array('integer', '0'), 'job_result_user_id' => array('integer', '0'), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', '0'), 'job_result_ts' => array('integer', '0'), 'class' => array('text', 'ilMailCronOrphanedMails'), 'path' => array('text', ''), 'running_ts' => array('integer', '0'), 'job_result_dur' => array('integer', '0'), 'alive_ts' => array('integer', '0')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'mem_min_members'), 'component' => array('text', 'Services/Membership'), 'schedule_type' => array('integer', '0'), 'schedule_value' => array('integer', '0'), 'job_status' => array('integer', '1'), 'job_status_user_id' => array('integer', '0'), 'job_status_type' => array('integer', '0'), 'job_status_ts' => array('integer', '1443610661'), 'job_result_status' => array('integer', '0'), 'job_result_user_id' => array('integer', '0'), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', '0'), 'job_result_ts' => array('integer', '0'), 'class' => array('text', 'ilMembershipCronMinMembers'), 'path' => array('text', ''), 'running_ts' => array('integer', '0'), 'job_result_dur' => array('integer', '0'), 'alive_ts' => array('integer', '0')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'mem_notification'), 'component' => array('text', 'Services/Membership'), 'schedule_type' => array('integer', '1'), 'schedule_value' => array('integer', '0'), 'job_status' => array('integer', '0'), 'job_status_user_id' => array('integer', '0'), 'job_status_type' => array('integer', '0'), 'job_status_ts' => array('integer', '0'), 'job_result_status' => array('integer', '0'), 'job_result_user_id' => array('integer', '0'), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', '0'), 'job_result_ts' => array('integer', '0'), 'class' => array('text', 'ilMembershipCronNotifications'), 'path' => array('text', ''), 'running_ts' => array('integer', '0'), 'job_result_dur' => array('integer', '0'), 'alive_ts' => array('integer', '0')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'orgunit_paths'), 'component' => array('text', 'Modules/OrgUnit'), 'schedule_type' => array('integer', '1'), 'schedule_value' => array('integer', '0'), 'job_status' => array('integer', '1'), 'job_status_user_id' => array('integer', '0'), 'job_status_type' => array('integer', '0'), 'job_status_ts' => array('integer', '1472816001'), 'job_result_status' => array('integer', '0'), 'job_result_user_id' => array('integer', '0'), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', '0'), 'job_result_ts' => array('integer', '0'), 'class' => array('text', 'ilCronUpdateOrgUnitPaths'), 'path' => array('text', ''), 'running_ts' => array('integer', '0'), 'job_result_dur' => array('integer', '0'), 'alive_ts' => array('integer', '0')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'book_notification'), 'component' => array('text', 'Modules/BookingManager'), 'schedule_type' => array('integer', ''), 'schedule_value' => array('integer', ''), 'job_status' => array('integer', ''), 'job_status_user_id' => array('integer', ''), 'job_status_type' => array('integer', ''), 'job_status_ts' => array('integer', ''), 'job_result_status' => array('integer', ''), 'job_result_user_id' => array('integer', ''), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', ''), 'job_result_ts' => array('integer', ''), 'class' => array('text', 'ilBookCronNotification'), 'path' => array('text', ''), 'running_ts' => array('integer', ''), 'job_result_dur' => array('integer', ''), 'alive_ts' => array('integer', '')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'src_lucene_indexer'), 'component' => array('text', 'Services/Search'), 'schedule_type' => array('integer', '1'), 'schedule_value' => array('integer', '0'), 'job_status' => array('integer', '0'), 'job_status_user_id' => array('integer', '0'), 'job_status_type' => array('integer', '0'), 'job_status_ts' => array('integer', '0'), 'job_result_status' => array('integer', '0'), 'job_result_user_id' => array('integer', '0'), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', '0'), 'job_result_ts' => array('integer', '0'), 'class' => array('text', 'ilLuceneIndexer'), 'path' => array('text', 'Services/Search/classes/Lucene/'), 'running_ts' => array('integer', '0'), 'job_result_dur' => array('integer', '0'), 'alive_ts' => array('integer', '0')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'survey_notification'), 'component' => array('text', 'Modules/Survey'), 'schedule_type' => array('integer', '0'), 'schedule_value' => array('integer', '0'), 'job_status' => array('integer', '1'), 'job_status_user_id' => array('integer', '0'), 'job_status_type' => array('integer', '0'), 'job_status_ts' => array('integer', '1381511099'), 'job_result_status' => array('integer', '0'), 'job_result_user_id' => array('integer', '0'), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', '0'), 'job_result_ts' => array('integer', '0'), 'class' => array('text', 'ilSurveyCronNotification'), 'path' => array('text', ''), 'running_ts' => array('integer', '0'), 'job_result_dur' => array('integer', '0'), 'alive_ts' => array('integer', '0')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'sysc_trash'), 'component' => array('text', 'Services/SystemCheck'), 'schedule_type' => array('integer', '5'), 'schedule_value' => array('integer', '1'), 'job_status' => array('integer', '0'), 'job_status_user_id' => array('integer', '0'), 'job_status_type' => array('integer', '0'), 'job_status_ts' => array('integer', '0'), 'job_result_status' => array('integer', '0'), 'job_result_user_id' => array('integer', '0'), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', '0'), 'job_result_ts' => array('integer', '0'), 'class' => array('text', 'ilSCCronTrash'), 'path' => array('text', ''), 'running_ts' => array('integer', '0'), 'job_result_dur' => array('integer', '0'), 'alive_ts' => array('integer', '0')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'user_check_accounts'), 'component' => array('text', 'Services/User'), 'schedule_type' => array('integer', '0'), 'schedule_value' => array('integer', '0'), 'job_status' => array('integer', '0'), 'job_status_user_id' => array('integer', '0'), 'job_status_type' => array('integer', '0'), 'job_status_ts' => array('integer', '0'), 'job_result_status' => array('integer', '0'), 'job_result_user_id' => array('integer', '0'), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', '0'), 'job_result_ts' => array('integer', '0'), 'class' => array('text', 'ilUserCronCheckAccounts'), 'path' => array('text', ''), 'running_ts' => array('integer', '0'), 'job_result_dur' => array('integer', '0'), 'alive_ts' => array('integer', '0')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'user_inactivated'), 'component' => array('text', 'Services/User'), 'schedule_type' => array('integer', '1'), 'schedule_value' => array('integer', '0'), 'job_status' => array('integer', '0'), 'job_status_user_id' => array('integer', '0'), 'job_status_type' => array('integer', '0'), 'job_status_ts' => array('integer', '0'), 'job_result_status' => array('integer', '0'), 'job_result_user_id' => array('integer', '0'), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', '0'), 'job_result_ts' => array('integer', '0'), 'class' => array('text', 'ilCronDeleteInactivatedUserAccounts'), 'path' => array('text', ''), 'running_ts' => array('integer', '0'), 'job_result_dur' => array('integer', '0'), 'alive_ts' => array('integer', '0')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'user_inactive'), 'component' => array('text', 'Services/User'), 'schedule_type' => array('integer', '1'), 'schedule_value' => array('integer', '0'), 'job_status' => array('integer', '0'), 'job_status_user_id' => array('integer', '0'), 'job_status_type' => array('integer', '0'), 'job_status_ts' => array('integer', '0'), 'job_result_status' => array('integer', '0'), 'job_result_user_id' => array('integer', '0'), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', '0'), 'job_result_ts' => array('integer', '0'), 'class' => array('text', 'ilCronDeleteInactiveUserAccounts'), 'path' => array('text', ''), 'running_ts' => array('integer', '0'), 'job_result_dur' => array('integer', '0'), 'alive_ts' => array('integer', '0')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'webr_link_check'), 'component' => array('text', 'Modules/WebResource'), 'schedule_type' => array('integer', '1'), 'schedule_value' => array('integer', '0'), 'job_status' => array('integer', '0'), 'job_status_user_id' => array('integer', '0'), 'job_status_type' => array('integer', '0'), 'job_status_ts' => array('integer', '0'), 'job_result_status' => array('integer', '0'), 'job_result_user_id' => array('integer', '0'), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', '0'), 'job_result_ts' => array('integer', '0'), 'class' => array('text', 'ilWebResourceCronLinkCheck'), 'path' => array('text', ''), 'running_ts' => array('integer', '0'), 'job_result_dur' => array('integer', '0'), 'alive_ts' => array('integer', '0')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'skll_notification'), 'component' => array('text', 'Services/Skill'), 'schedule_type' => array('integer', '1'), 'schedule_value' => array('integer', ''), 'job_status' => array('integer', ''), 'job_status_user_id' => array('integer', ''), 'job_status_type' => array('integer', ''), 'job_status_ts' => array('integer', ''), 'job_result_status' => array('integer', ''), 'job_result_user_id' => array('integer', ''), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', ''), 'job_result_ts' => array('integer', ''), 'class' => array('text', 'ilSkillNotifications'), 'path' => array('text', ''), 'running_ts' => array('integer', ''), 'job_result_dur' => array('integer', ''), 'alive_ts' => array('integer', '')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'exc_reminders'), 'component' => array('text', 'Modules/Exercise'), 'schedule_type' => array('integer', '1'), 'schedule_value' => array('integer', ''), 'job_status' => array('integer', '1'), 'job_status_user_id' => array('integer', '0'), 'job_status_type' => array('integer', '0'), 'job_status_ts' => array('integer', '1605888798'), 'job_result_status' => array('integer', ''), 'job_result_user_id' => array('integer', ''), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', ''), 'job_result_ts' => array('integer', ''), 'class' => array('text', 'ilExcCronReminders'), 'path' => array('text', ''), 'running_ts' => array('integer', ''), 'job_result_dur' => array('integer', ''), 'alive_ts' => array('integer', '')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'lti_outcome'), 'component' => array('text', 'Services/LTI'), 'schedule_type' => array('integer', '2'), 'schedule_value' => array('integer', '5'), 'job_status' => array('integer', ''), 'job_status_user_id' => array('integer', ''), 'job_status_type' => array('integer', ''), 'job_status_ts' => array('integer', ''), 'job_result_status' => array('integer', ''), 'job_result_user_id' => array('integer', ''), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', ''), 'job_result_ts' => array('integer', ''), 'class' => array('text', 'ilLTICronOutcomeService'), 'path' => array('text', ''), 'running_ts' => array('integer', ''), 'job_result_dur' => array('integer', ''), 'alive_ts' => array('integer', '')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'crs_timings_reminder'), 'component' => array('text', 'Modules/Course'), 'schedule_type' => array('integer', ''), 'schedule_value' => array('integer', ''), 'job_status' => array('integer', ''), 'job_status_user_id' => array('integer', ''), 'job_status_type' => array('integer', ''), 'job_status_ts' => array('integer', ''), 'job_result_status' => array('integer', ''), 'job_result_user_id' => array('integer', ''), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', ''), 'job_result_ts' => array('integer', ''), 'class' => array('text', 'ilTimingsCronReminder'), 'path' => array('text', ''), 'running_ts' => array('integer', ''), 'job_result_dur' => array('integer', ''), 'alive_ts' => array('integer', '')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'prg_invalidate_expired_progresses'), 'component' => array('text', 'Modules/StudyProgramme'), 'schedule_type' => array('integer', '4'), 'schedule_value' => array('integer', '1'), 'job_status' => array('integer', '1'), 'job_status_user_id' => array('integer', '0'), 'job_status_type' => array('integer', '0'), 'job_status_ts' => array('integer', '1605888798'), 'job_result_status' => array('integer', ''), 'job_result_user_id' => array('integer', ''), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', ''), 'job_result_ts' => array('integer', ''), 'class' => array('text', 'ilPrgInvalidateExpiredProgressesCronJob'), 'path' => array('text', ''), 'running_ts' => array('integer', ''), 'job_result_dur' => array('integer', ''), 'alive_ts' => array('integer', '')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'prg_restart_assignments_temporal_progress'), 'component' => array('text', 'Modules/StudyProgramme'), 'schedule_type' => array('integer', '4'), 'schedule_value' => array('integer', '1'), 'job_status' => array('integer', '1'), 'job_status_user_id' => array('integer', '0'), 'job_status_type' => array('integer', '0'), 'job_status_ts' => array('integer', '1605888798'), 'job_result_status' => array('integer', ''), 'job_result_user_id' => array('integer', ''), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', ''), 'job_result_ts' => array('integer', ''), 'class' => array('text', 'ilPrgRestartAssignmentsCronJob'), 'path' => array('text', ''), 'running_ts' => array('integer', ''), 'job_result_dur' => array('integer', ''), 'alive_ts' => array('integer', '')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'prg_user_not_restarted'), 'component' => array('text', 'Modules/StudyProgramme'), 'schedule_type' => array('integer', '4'), 'schedule_value' => array('integer', '1'), 'job_status' => array('integer', '1'), 'job_status_user_id' => array('integer', '0'), 'job_status_type' => array('integer', '0'), 'job_status_ts' => array('integer', '1605888798'), 'job_result_status' => array('integer', ''), 'job_result_user_id' => array('integer', ''), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', ''), 'job_result_ts' => array('integer', ''), 'class' => array('text', 'ilPrgUserNotRestartedCronJob'), 'path' => array('text', ''), 'running_ts' => array('integer', ''), 'job_result_dur' => array('integer', ''), 'alive_ts' => array('integer', '')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'prg_user_risky_to_fail'), 'component' => array('text', 'Modules/StudyProgramme'), 'schedule_type' => array('integer', '4'), 'schedule_value' => array('integer', '1'), 'job_status' => array('integer', '1'), 'job_status_user_id' => array('integer', '0'), 'job_status_type' => array('integer', '0'), 'job_status_ts' => array('integer', '1605888798'), 'job_result_status' => array('integer', ''), 'job_result_user_id' => array('integer', ''), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', ''), 'job_result_ts' => array('integer', ''), 'class' => array('text', 'ilPrgUserRiskyToFailCronJob'), 'path' => array('text', ''), 'running_ts' => array('integer', ''), 'job_result_dur' => array('integer', ''), 'alive_ts' => array('integer', '')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'prg_update_progress'), 'component' => array('text', 'Modules/StudyProgramme'), 'schedule_type' => array('integer', '4'), 'schedule_value' => array('integer', '1'), 'job_status' => array('integer', '1'), 'job_status_user_id' => array('integer', '0'), 'job_status_type' => array('integer', '0'), 'job_status_ts' => array('integer', '1605888798'), 'job_result_status' => array('integer', ''), 'job_result_user_id' => array('integer', ''), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', ''), 'job_result_ts' => array('integer', ''), 'class' => array('text', 'ilPrgUpdateProgressCronJob'), 'path' => array('text', ''), 'running_ts' => array('integer', ''), 'job_result_dur' => array('integer', ''), 'alive_ts' => array('integer', '')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'xapi_results_evaluation'), 'component' => array('text', 'Modules/CmiXapi'), 'schedule_type' => array('integer', '1'), 'schedule_value' => array('integer', ''), 'job_status' => array('integer', ''), 'job_status_user_id' => array('integer', ''), 'job_status_type' => array('integer', ''), 'job_status_ts' => array('integer', ''), 'job_result_status' => array('integer', ''), 'job_result_user_id' => array('integer', ''), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', ''), 'job_result_ts' => array('integer', ''), 'class' => array('text', 'ilXapiResultsCronjob'), 'path' => array('text', ''), 'running_ts' => array('integer', ''), 'job_result_dur' => array('integer', ''), 'alive_ts' => array('integer', '')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'meta_oer_harvester'), 'component' => array('text', 'Services/MetaData'), 'schedule_type' => array('integer', '1'), 'schedule_value' => array('integer', '1'), 'job_status' => array('integer', ''), 'job_status_user_id' => array('integer', ''), 'job_status_type' => array('integer', ''), 'job_status_ts' => array('integer', ''), 'job_result_status' => array('integer', ''), 'job_result_user_id' => array('integer', ''), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', ''), 'job_result_ts' => array('integer', ''), 'class' => array('text', 'ilCronOerHarvester'), 'path' => array('text', ''), 'running_ts' => array('integer', ''), 'job_result_dur' => array('integer', ''), 'alive_ts' => array('integer', '')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'certificate'), 'component' => array('text', 'Services/Certificate'), 'schedule_type' => array('integer', '2'), 'schedule_value' => array('integer', '1'), 'job_status' => array('integer', '1'), 'job_status_user_id' => array('integer', '0'), 'job_status_type' => array('integer', '0'), 'job_status_ts' => array('integer', '1605888798'), 'job_result_status' => array('integer', ''), 'job_result_user_id' => array('integer', ''), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', ''), 'job_result_ts' => array('integer', ''), 'class' => array('text', 'ilCertificateCron'), 'path' => array('text', ''), 'running_ts' => array('integer', ''), 'job_result_dur' => array('integer', ''), 'alive_ts' => array('integer', '')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'user_never_logged_in'), 'component' => array('text', 'Services/User'), 'schedule_type' => array('integer', '1'), 'schedule_value' => array('integer', '1'), 'job_status' => array('integer', ''), 'job_status_user_id' => array('integer', ''), 'job_status_type' => array('integer', ''), 'job_status_ts' => array('integer', ''), 'job_result_status' => array('integer', ''), 'job_result_user_id' => array('integer', ''), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', ''), 'job_result_ts' => array('integer', ''), 'class' => array('text', 'ilCronDeleteNeverLoggedInUserAccounts'), 'path' => array('text', ''), 'running_ts' => array('integer', ''), 'job_result_dur' => array('integer', ''), 'alive_ts' => array('integer', '')));

$ilDB->insert("cron_job", array(
'job_id' => array('text', 'ecs_task_handler'), 'component' => array('text', 'Services/WebServices'), 'schedule_type' => array('integer', '3'), 'schedule_value' => array('integer', '1'), 'job_status' => array('integer', ''), 'job_status_user_id' => array('integer', ''), 'job_status_type' => array('integer', ''), 'job_status_ts' => array('integer', ''), 'job_result_status' => array('integer', ''), 'job_result_user_id' => array('integer', ''), 'job_result_code' => array('text', ''), 'job_result_message' => array('text', ''), 'job_result_type' => array('integer', ''), 'job_result_ts' => array('integer', ''), 'class' => array('text', 'ilCronEcsTaskScheduler'), 'path' => array('text', ''), 'running_ts' => array('integer', ''), 'job_result_dur' => array('integer', ''), 'alive_ts' => array('integer', '')));


//
// crs_archives
//
$fields = array (
	"archive_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"course_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"archive_name" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"archive_type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"archive_date" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"archive_size" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"archive_lang" => array (
		"notnull" => false
		,"length" => 16
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("crs_archives", $fields);

$pk_fields = array("archive_id");
$ilDB->addPrimaryKey("crs_archives", $pk_fields);

$ilDB->createSequence("crs_archives", 1);


//
// crs_f_definitions
//
$fields = array (
	"field_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"field_name" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"field_type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"field_values" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"field_required" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"field_values_opt" => array (
		"notnull" => false
		,"length" => 1000
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("crs_f_definitions", $fields);

$pk_fields = array("field_id");
$ilDB->addPrimaryKey("crs_f_definitions", $pk_fields);

$ilDB->createSequence("crs_f_definitions", 1);


//
// crs_file
//
$fields = array (
	"file_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"course_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"file_name" => array (
		"notnull" => false
		,"length" => 64
		,"fixed" => true
		,"type" => "text"
	)
	,"file_type" => array (
		"notnull" => false
		,"length" => 64
		,"fixed" => true
		,"type" => "text"
	)
	,"file_size" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("crs_file", $fields);

$pk_fields = array("file_id");
$ilDB->addPrimaryKey("crs_file", $pk_fields);

$ilDB->createSequence("crs_file", 1);


//
// crs_groupings
//
$fields = array (
	"crs_grp_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"crs_ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"crs_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"unique_field" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => true
		,"type" => "text"
	)
);
$ilDB->createTable("crs_groupings", $fields);

$pk_fields = array("crs_grp_id");
$ilDB->addPrimaryKey("crs_groupings", $pk_fields);

$in_fields = array("crs_id");
$ilDB->addIndex("crs_groupings", $in_fields, "i1", false);


//
// crs_items
//
$fields = array (
	"parent_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"timing_type" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"timing_start" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"timing_end" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"suggestion_start" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"suggestion_end" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"changeable" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"visible" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"position" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"suggestion_start_rel" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"suggestion_end_rel" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("crs_items", $fields);

$pk_fields = array("parent_id","obj_id");
$ilDB->addPrimaryKey("crs_items", $pk_fields);

$in_fields = array("obj_id");
$ilDB->addIndex("crs_items", $in_fields, "ob", false);

$ilDB->insert("crs_items", array(
'parent_id' => array('integer', '1'), 'obj_id' => array('integer', '9'), 'timing_type' => array('integer', '1'), 'timing_start' => array('integer', '1450792127'), 'timing_end' => array('integer', '1450792127'), 'suggestion_start' => array('integer', '1450792127'), 'suggestion_end' => array('integer', '1450792127'), 'changeable' => array('integer', '0'), 'visible' => array('integer', '0'), 'position' => array('integer', '0'), 'suggestion_start_rel' => array('integer', '0'), 'suggestion_end_rel' => array('integer', '0')));

$ilDB->insert("crs_items", array(
'parent_id' => array('integer', '9'), 'obj_id' => array('integer', '8'), 'timing_type' => array('integer', '1'), 'timing_start' => array('integer', '1450792127'), 'timing_end' => array('integer', '1450792127'), 'suggestion_start' => array('integer', '1450792127'), 'suggestion_end' => array('integer', '1450792127'), 'changeable' => array('integer', '0'), 'visible' => array('integer', '0'), 'position' => array('integer', '0'), 'suggestion_start_rel' => array('integer', '0'), 'suggestion_end_rel' => array('integer', '0')));

$ilDB->insert("crs_items", array(
'parent_id' => array('integer', '9'), 'obj_id' => array('integer', '12'), 'timing_type' => array('integer', '1'), 'timing_start' => array('integer', '1481898045'), 'timing_end' => array('integer', '1481898045'), 'suggestion_start' => array('integer', '1481898045'), 'suggestion_end' => array('integer', '1481898045'), 'changeable' => array('integer', '0'), 'visible' => array('integer', '0'), 'position' => array('integer', '0'), 'suggestion_start_rel' => array('integer', '0'), 'suggestion_end_rel' => array('integer', '0')));

$ilDB->insert("crs_items", array(
'parent_id' => array('integer', '9'), 'obj_id' => array('integer', '16'), 'timing_type' => array('integer', '1'), 'timing_start' => array('integer', '1450795974'), 'timing_end' => array('integer', '1450795974'), 'suggestion_start' => array('integer', '1450795974'), 'suggestion_end' => array('integer', '1450795974'), 'changeable' => array('integer', '0'), 'visible' => array('integer', '0'), 'position' => array('integer', '0'), 'suggestion_start_rel' => array('integer', '0'), 'suggestion_end_rel' => array('integer', '0')));

$ilDB->insert("crs_items", array(
'parent_id' => array('integer', '9'), 'obj_id' => array('integer', '17'), 'timing_type' => array('integer', '1'), 'timing_start' => array('integer', '1481897710'), 'timing_end' => array('integer', '1481897710'), 'suggestion_start' => array('integer', '1481897710'), 'suggestion_end' => array('integer', '1481897710'), 'changeable' => array('integer', '0'), 'visible' => array('integer', '0'), 'position' => array('integer', '0'), 'suggestion_start_rel' => array('integer', '0'), 'suggestion_end_rel' => array('integer', '0')));

$ilDB->insert("crs_items", array(
'parent_id' => array('integer', '9'), 'obj_id' => array('integer', '18'), 'timing_type' => array('integer', '1'), 'timing_start' => array('integer', '1450795859'), 'timing_end' => array('integer', '1450795859'), 'suggestion_start' => array('integer', '1450795859'), 'suggestion_end' => array('integer', '1450795859'), 'changeable' => array('integer', '0'), 'visible' => array('integer', '0'), 'position' => array('integer', '0'), 'suggestion_start_rel' => array('integer', '0'), 'suggestion_end_rel' => array('integer', '0')));

$ilDB->insert("crs_items", array(
'parent_id' => array('integer', '9'), 'obj_id' => array('integer', '22'), 'timing_type' => array('integer', '1'), 'timing_start' => array('integer', '1450796001'), 'timing_end' => array('integer', '1450796001'), 'suggestion_start' => array('integer', '1450796001'), 'suggestion_end' => array('integer', '1450796001'), 'changeable' => array('integer', '0'), 'visible' => array('integer', '0'), 'position' => array('integer', '0'), 'suggestion_start_rel' => array('integer', '0'), 'suggestion_end_rel' => array('integer', '0')));

$ilDB->insert("crs_items", array(
'parent_id' => array('integer', '9'), 'obj_id' => array('integer', '23'), 'timing_type' => array('integer', '1'), 'timing_start' => array('integer', '1450795847'), 'timing_end' => array('integer', '1450795847'), 'suggestion_start' => array('integer', '1450795847'), 'suggestion_end' => array('integer', '1450795847'), 'changeable' => array('integer', '0'), 'visible' => array('integer', '0'), 'position' => array('integer', '0'), 'suggestion_start_rel' => array('integer', '0'), 'suggestion_end_rel' => array('integer', '0')));

$ilDB->insert("crs_items", array(
'parent_id' => array('integer', '9'), 'obj_id' => array('integer', '29'), 'timing_type' => array('integer', '1'), 'timing_start' => array('integer', '1450795894'), 'timing_end' => array('integer', '1450795894'), 'suggestion_start' => array('integer', '1450795894'), 'suggestion_end' => array('integer', '1450795894'), 'changeable' => array('integer', '0'), 'visible' => array('integer', '0'), 'position' => array('integer', '0'), 'suggestion_start_rel' => array('integer', '0'), 'suggestion_end_rel' => array('integer', '0')));

$ilDB->insert("crs_items", array(
'parent_id' => array('integer', '9'), 'obj_id' => array('integer', '30'), 'timing_type' => array('integer', '1'), 'timing_start' => array('integer', '1450796011'), 'timing_end' => array('integer', '1450796011'), 'suggestion_start' => array('integer', '1450796011'), 'suggestion_end' => array('integer', '1450796011'), 'changeable' => array('integer', '0'), 'visible' => array('integer', '0'), 'position' => array('integer', '0'), 'suggestion_start_rel' => array('integer', '0'), 'suggestion_end_rel' => array('integer', '0')));

$ilDB->insert("crs_items", array(
'parent_id' => array('integer', '9'), 'obj_id' => array('integer', '32'), 'timing_type' => array('integer', '1'), 'timing_start' => array('integer', '1481899353'), 'timing_end' => array('integer', '1481899353'), 'suggestion_start' => array('integer', '1481899353'), 'suggestion_end' => array('integer', '1481899353'), 'changeable' => array('integer', '0'), 'visible' => array('integer', '0'), 'position' => array('integer', '0'), 'suggestion_start_rel' => array('integer', '0'), 'suggestion_end_rel' => array('integer', '0')));

$ilDB->insert("crs_items", array(
'parent_id' => array('integer', '9'), 'obj_id' => array('integer', '34'), 'timing_type' => array('integer', '1'), 'timing_start' => array('integer', '1482324927'), 'timing_end' => array('integer', '1482324927'), 'suggestion_start' => array('integer', '1482324927'), 'suggestion_end' => array('integer', '1482324927'), 'changeable' => array('integer', '0'), 'visible' => array('integer', '0'), 'position' => array('integer', '0'), 'suggestion_start_rel' => array('integer', '0'), 'suggestion_end_rel' => array('integer', '0')));

$ilDB->insert("crs_items", array(
'parent_id' => array('integer', '9'), 'obj_id' => array('integer', '36'), 'timing_type' => array('integer', '1'), 'timing_start' => array('integer', '1481898367'), 'timing_end' => array('integer', '1481898367'), 'suggestion_start' => array('integer', '1481898367'), 'suggestion_end' => array('integer', '1481898367'), 'changeable' => array('integer', '0'), 'visible' => array('integer', '0'), 'position' => array('integer', '0'), 'suggestion_start_rel' => array('integer', '0'), 'suggestion_end_rel' => array('integer', '0')));

$ilDB->insert("crs_items", array(
'parent_id' => array('integer', '9'), 'obj_id' => array('integer', '37'), 'timing_type' => array('integer', '1'), 'timing_start' => array('integer', '1450796232'), 'timing_end' => array('integer', '1450796232'), 'suggestion_start' => array('integer', '1450796232'), 'suggestion_end' => array('integer', '1450796232'), 'changeable' => array('integer', '0'), 'visible' => array('integer', '0'), 'position' => array('integer', '0'), 'suggestion_start_rel' => array('integer', '0'), 'suggestion_end_rel' => array('integer', '0')));

$ilDB->insert("crs_items", array(
'parent_id' => array('integer', '9'), 'obj_id' => array('integer', '39'), 'timing_type' => array('integer', '1'), 'timing_start' => array('integer', '1481899398'), 'timing_end' => array('integer', '1481899398'), 'suggestion_start' => array('integer', '1481899398'), 'suggestion_end' => array('integer', '1481899398'), 'changeable' => array('integer', '0'), 'visible' => array('integer', '0'), 'position' => array('integer', '0'), 'suggestion_start_rel' => array('integer', '0'), 'suggestion_end_rel' => array('integer', '0')));

$ilDB->insert("crs_items", array(
'parent_id' => array('integer', '9'), 'obj_id' => array('integer', '52'), 'timing_type' => array('integer', '1'), 'timing_start' => array('integer', '1450795488'), 'timing_end' => array('integer', '1450795488'), 'suggestion_start' => array('integer', '1450795488'), 'suggestion_end' => array('integer', '1450795488'), 'changeable' => array('integer', '0'), 'visible' => array('integer', '0'), 'position' => array('integer', '0'), 'suggestion_start_rel' => array('integer', '0'), 'suggestion_end_rel' => array('integer', '0')));

$ilDB->insert("crs_items", array(
'parent_id' => array('integer', '9'), 'obj_id' => array('integer', '53'), 'timing_type' => array('integer', '1'), 'timing_start' => array('integer', '1450796052'), 'timing_end' => array('integer', '1450796052'), 'suggestion_start' => array('integer', '1450796052'), 'suggestion_end' => array('integer', '1450796052'), 'changeable' => array('integer', '0'), 'visible' => array('integer', '0'), 'position' => array('integer', '0'), 'suggestion_start_rel' => array('integer', '0'), 'suggestion_end_rel' => array('integer', '0')));

$ilDB->insert("crs_items", array(
'parent_id' => array('integer', '9'), 'obj_id' => array('integer', '55'), 'timing_type' => array('integer', '1'), 'timing_start' => array('integer', '1481899451'), 'timing_end' => array('integer', '1481899451'), 'suggestion_start' => array('integer', '1481899451'), 'suggestion_end' => array('integer', '1481899451'), 'changeable' => array('integer', '0'), 'visible' => array('integer', '0'), 'position' => array('integer', '0'), 'suggestion_start_rel' => array('integer', '0'), 'suggestion_end_rel' => array('integer', '0')));

$ilDB->insert("crs_items", array(
'parent_id' => array('integer', '9'), 'obj_id' => array('integer', '57'), 'timing_type' => array('integer', '1'), 'timing_start' => array('integer', '1450796335'), 'timing_end' => array('integer', '1450796335'), 'suggestion_start' => array('integer', '1450796335'), 'suggestion_end' => array('integer', '1450796335'), 'changeable' => array('integer', '0'), 'visible' => array('integer', '0'), 'position' => array('integer', '0'), 'suggestion_start_rel' => array('integer', '0'), 'suggestion_end_rel' => array('integer', '0')));

$ilDB->insert("crs_items", array(
'parent_id' => array('integer', '9'), 'obj_id' => array('integer', '64'), 'timing_type' => array('integer', '1'), 'timing_start' => array('integer', '1450795969'), 'timing_end' => array('integer', '1450795969'), 'suggestion_start' => array('integer', '1450795969'), 'suggestion_end' => array('integer', '1450795969'), 'changeable' => array('integer', '0'), 'visible' => array('integer', '0'), 'position' => array('integer', '0'), 'suggestion_start_rel' => array('integer', '0'), 'suggestion_end_rel' => array('integer', '0')));


//
// crs_lm_history
//
$fields = array (
	"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"crs_ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"lm_ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"lm_page_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"last_access" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("crs_lm_history", $fields);

$pk_fields = array("usr_id","crs_ref_id","lm_ref_id");
$ilDB->addPrimaryKey("crs_lm_history", $pk_fields);


//
// crs_objective_lm
//
$fields = array (
	"lm_ass_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"objective_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"type" => array (
		"notnull" => false
		,"length" => 6
		,"fixed" => true
		,"type" => "text"
	)
	,"position" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("crs_objective_lm", $fields);

$pk_fields = array("lm_ass_id");
$ilDB->addPrimaryKey("crs_objective_lm", $pk_fields);

$ilDB->createSequence("crs_objective_lm", 1);


//
// crs_objective_qst
//
$fields = array (
	"qst_ass_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"objective_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"question_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("crs_objective_qst", $fields);

$pk_fields = array("qst_ass_id");
$ilDB->addPrimaryKey("crs_objective_qst", $pk_fields);

$ilDB->createSequence("crs_objective_qst", 1);


//
// crs_objective_status
//
$fields = array (
	"objective_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"status" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("crs_objective_status", $fields);

$pk_fields = array("objective_id","user_id");
$ilDB->addPrimaryKey("crs_objective_status", $pk_fields);


//
// crs_objective_status_p
//
$fields = array (
	"objective_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("crs_objective_status_p", $fields);

$pk_fields = array("objective_id","user_id");
$ilDB->addPrimaryKey("crs_objective_status_p", $pk_fields);


//
// crs_objective_tst
//
$fields = array (
	"test_objective_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"objective_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"tst_status" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"tst_limit" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"tst_limit_p" => array (
		"notnull" => true
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("crs_objective_tst", $fields);

$pk_fields = array("test_objective_id");
$ilDB->addPrimaryKey("crs_objective_tst", $pk_fields);

$ilDB->createSequence("crs_objective_tst", 1);


//
// crs_objectives
//
$fields = array (
	"crs_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"objective_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 70
		,"fixed" => false
		,"type" => "text"
	)
	,"description" => array (
		"notnull" => false
		,"length" => 500
		,"fixed" => false
		,"type" => "text"
	)
	,"position" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"created" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"active" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"passes" => array (
		"notnull" => false
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("crs_objectives", $fields);

$pk_fields = array("objective_id");
$ilDB->addPrimaryKey("crs_objectives", $pk_fields);

$in_fields = array("crs_id");
$ilDB->addIndex("crs_objectives", $in_fields, "i1", false);

$ilDB->createSequence("crs_objectives", 1);


//
// crs_reference_settings
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"member_update" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("crs_reference_settings", $fields);


//
// crs_settings
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"syllabus" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"contact_name" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"contact_responsibility" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"contact_phone" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"contact_email" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"contact_consultation" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"activation_type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"activation_start" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"activation_end" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"sub_limitation_type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sub_start" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"sub_end" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"sub_type" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"sub_password" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"sub_mem_limit" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sub_max_members" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"sub_notify" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"view_mode" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sortorder" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"archive_start" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"archive_end" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"archive_type" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"abo" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"waiting_list" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"important" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"show_members" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"latitude" => array (
		"notnull" => false
		,"length" => 30
		,"fixed" => false
		,"type" => "text"
	)
	,"longitude" => array (
		"notnull" => false
		,"length" => 30
		,"fixed" => false
		,"type" => "text"
	)
	,"location_zoom" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"enable_course_map" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"session_limit" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"session_prev" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "-1"
		,"type" => "integer"
	)
	,"session_next" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "-1"
		,"type" => "integer"
	)
	,"reg_ac_enabled" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"reg_ac" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"status_dt" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "2"
		,"type" => "integer"
	)
	,"auto_notification" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"mail_members_type" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"crs_start" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"crs_end" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"leave_end" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"auto_wait" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"min_members" => array (
		"notnull" => false
		,"length" => 2
		,"unsigned" => false
		,"type" => "integer"
	)
	,"show_members_export" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"timing_mode" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"period_start" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"period_end" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"period_time_indication" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"target_group" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("crs_settings", $fields);

$pk_fields = array("obj_id");
$ilDB->addPrimaryKey("crs_settings", $pk_fields);


//
// crs_start
//
$fields = array (
	"crs_start_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"crs_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"item_ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"pos" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("crs_start", $fields);

$pk_fields = array("crs_start_id");
$ilDB->addPrimaryKey("crs_start", $pk_fields);

$in_fields = array("crs_id");
$ilDB->addIndex("crs_start", $in_fields, "i1", false);

$ilDB->createSequence("crs_start", 1);


//
// crs_timings_exceeded
//
$fields = array (
	"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sent" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("crs_timings_exceeded", $fields);

$pk_fields = array("user_id","ref_id");
$ilDB->addPrimaryKey("crs_timings_exceeded", $pk_fields);


//
// crs_timings_planed
//
$fields = array (
	"item_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"planed_start" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"planed_end" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("crs_timings_planed", $fields);

$pk_fields = array("item_id","usr_id");
$ilDB->addPrimaryKey("crs_timings_planed", $pk_fields);


//
// crs_timings_started
//
$fields = array (
	"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sent" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("crs_timings_started", $fields);

$pk_fields = array("user_id","ref_id");
$ilDB->addPrimaryKey("crs_timings_started", $pk_fields);


//
// crs_timings_user
//
$fields = array (
	"ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sstart" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"ssend" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("crs_timings_user", $fields);

$pk_fields = array("ref_id","usr_id");
$ilDB->addPrimaryKey("crs_timings_user", $pk_fields);


//
// crs_timings_usr_accept
//
$fields = array (
	"crs_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"accept" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"remark" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"visible" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("crs_timings_usr_accept", $fields);

$pk_fields = array("crs_id","usr_id");
$ilDB->addPrimaryKey("crs_timings_usr_accept", $pk_fields);


//
// crs_user_data
//
$fields = array (
	"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"field_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"value" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("crs_user_data", $fields);

$pk_fields = array("usr_id","field_id");
$ilDB->addPrimaryKey("crs_user_data", $pk_fields);


//
// crs_waiting_list
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sub_time" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("crs_waiting_list", $fields);

$pk_fields = array("obj_id","usr_id");
$ilDB->addPrimaryKey("crs_waiting_list", $pk_fields);


//
// ctrl_calls
//
$fields = array (
	"parent" => array (
		"notnull" => true
		,"length" => 100
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"child" => array (
		"notnull" => true
		,"length" => 100
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"comp_prefix" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("ctrl_calls", $fields);

$pk_fields = array("parent","child");
$ilDB->addPrimaryKey("ctrl_calls", $pk_fields);


//
// ctrl_classfile
//
$fields = array (
	"class" => array (
		"notnull" => true
		,"length" => 100
		,"default" => " "
		,"fixed" => false
		,"type" => "text"
	)
	,"filename" => array (
		"notnull" => false
		,"length" => 250
		,"fixed" => false
		,"type" => "text"
	)
	,"comp_prefix" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"plugin_path" => array (
		"notnull" => false
		,"length" => 250
		,"fixed" => false
		,"type" => "text"
	)
	,"cid" => array (
		"notnull" => false
		,"length" => 4
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("ctrl_classfile", $fields);

$pk_fields = array("class");
$ilDB->addPrimaryKey("ctrl_classfile", $pk_fields);

$in_fields = array("cid");
$ilDB->addIndex("ctrl_classfile", $in_fields, "i1", false);


//
// ctrl_structure
//
$fields = array (
	"root_class" => array (
		"notnull" => true
		,"length" => 40
		,"default" => " "
		,"fixed" => false
		,"type" => "text"
	)
	,"call_node" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"forward" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"parent" => array (
		"notnull" => false
		,"type" => "clob"
	)
);
$ilDB->createTable("ctrl_structure", $fields);

$pk_fields = array("root_class");
$ilDB->addPrimaryKey("ctrl_structure", $pk_fields);


//
// data_cache
//
$fields = array (
	"module" => array (
		"notnull" => true
		,"length" => 50
		,"default" => "common"
		,"fixed" => false
		,"type" => "text"
	)
	,"keyword" => array (
		"notnull" => true
		,"length" => 50
		,"default" => " "
		,"fixed" => false
		,"type" => "text"
	)
	,"value" => array (
		"notnull" => false
		,"type" => "clob"
	)
);
$ilDB->createTable("data_cache", $fields);

$pk_fields = array("module","keyword");
$ilDB->addPrimaryKey("data_cache", $pk_fields);


//
// dav_lock
//
$fields = array (
	"token" => array (
		"notnull" => true
		,"length" => 255
		,"default" => " "
		,"fixed" => false
		,"type" => "text"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"node_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"ilias_owner" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"dav_owner" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"expires" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"depth" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"type" => array (
		"notnull" => false
		,"length" => 1
		,"default" => "w"
		,"fixed" => true
		,"type" => "text"
	)
	,"scope" => array (
		"notnull" => false
		,"length" => 1
		,"default" => "s"
		,"fixed" => true
		,"type" => "text"
	)
);
$ilDB->createTable("dav_lock", $fields);

$pk_fields = array("token");
$ilDB->addPrimaryKey("dav_lock", $pk_fields);

$in_fields = array("obj_id","node_id");
$ilDB->addIndex("dav_lock", $in_fields, "i1", false);

$in_fields = array("obj_id","node_id","token");
$ilDB->addIndex("dav_lock", $in_fields, "i2", false);

$in_fields = array("expires");
$ilDB->addIndex("dav_lock", $in_fields, "i3", false);

$in_fields = array("token");
$ilDB->addUniqueConstraint("dav_lock", $in_fields, "c1");


//
// dav_property
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"node_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"ns" => array (
		"notnull" => true
		,"length" => 120
		,"default" => "DAV:"
		,"fixed" => false
		,"type" => "text"
	)
	,"name" => array (
		"notnull" => true
		,"length" => 120
		,"default" => " "
		,"fixed" => false
		,"type" => "text"
	)
	,"value" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("dav_property", $fields);

$pk_fields = array("obj_id","node_id","name","ns");
$ilDB->addPrimaryKey("dav_property", $pk_fields);

$in_fields = array("obj_id","node_id");
$ilDB->addIndex("dav_property", $in_fields, "i1", false);


//
// dbk_translations
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"tr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("dbk_translations", $fields);

$pk_fields = array("id","tr_id");
$ilDB->addPrimaryKey("dbk_translations", $pk_fields);


//
// desktop_item
//
$fields = array (
	"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"item_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"type" => array (
		"notnull" => false
		,"length" => 4
		,"fixed" => false
		,"type" => "text"
	)
	,"parameters" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("desktop_item", $fields);

$pk_fields = array("user_id","item_id");
$ilDB->addPrimaryKey("desktop_item", $pk_fields);


//
// didactic_tpl_a
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"tpl_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"type_id" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("didactic_tpl_a", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("didactic_tpl_a", $pk_fields);

$ilDB->createSequence("didactic_tpl_a", 3);

$ilDB->insert("didactic_tpl_a", array(
'id' => array('integer', '1'), 'tpl_id' => array('integer', '1'), 'type_id' => array('integer', '1')));

$ilDB->insert("didactic_tpl_a", array(
'id' => array('integer', '2'), 'tpl_id' => array('integer', '2'), 'type_id' => array('integer', '1')));


//
// didactic_tpl_abr
//
$fields = array (
	"action_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"filter_type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("didactic_tpl_abr", $fields);

$pk_fields = array("action_id");
$ilDB->addPrimaryKey("didactic_tpl_abr", $pk_fields);


//
// didactic_tpl_alp
//
$fields = array (
	"action_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"filter_type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"template_type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"template_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("didactic_tpl_alp", $fields);

$pk_fields = array("action_id");
$ilDB->addPrimaryKey("didactic_tpl_alp", $pk_fields);

$ilDB->insert("didactic_tpl_alp", array(
'action_id' => array('integer', '1'), 'filter_type' => array('integer', '3'), 'template_type' => array('integer', '2'), 'template_id' => array('integer', '82')));

$ilDB->insert("didactic_tpl_alp", array(
'action_id' => array('integer', '2'), 'filter_type' => array('integer', '3'), 'template_type' => array('integer', '2'), 'template_id' => array('integer', '269')));


//
// didactic_tpl_alr
//
$fields = array (
	"action_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"role_template_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("didactic_tpl_alr", $fields);

$pk_fields = array("action_id");
$ilDB->addPrimaryKey("didactic_tpl_alr", $pk_fields);


//
// didactic_tpl_en
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"node" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("didactic_tpl_en", $fields);

$pk_fields = array("id","node");
$ilDB->addPrimaryKey("didactic_tpl_en", $pk_fields);


//
// didactic_tpl_fp
//
$fields = array (
	"pattern_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"pattern_type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"pattern_sub_type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"pattern" => array (
		"notnull" => false
		,"length" => 64
		,"fixed" => false
		,"type" => "text"
	)
	,"parent_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"parent_type" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("didactic_tpl_fp", $fields);

$pk_fields = array("pattern_id");
$ilDB->addPrimaryKey("didactic_tpl_fp", $pk_fields);

$ilDB->createSequence("didactic_tpl_fp", 3);

$ilDB->insert("didactic_tpl_fp", array(
'pattern_id' => array('integer', '1'), 'pattern_type' => array('integer', '1'), 'pattern_sub_type' => array('integer', '1'), 'pattern' => array('text', '.*'), 'parent_id' => array('integer', '1'), 'parent_type' => array('text', 'action')));

$ilDB->insert("didactic_tpl_fp", array(
'pattern_id' => array('integer', '2'), 'pattern_type' => array('integer', '1'), 'pattern_sub_type' => array('integer', '1'), 'pattern' => array('text', '.*'), 'parent_id' => array('integer', '2'), 'parent_type' => array('text', 'action')));


//
// didactic_tpl_objs
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"tpl_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("didactic_tpl_objs", $fields);

$pk_fields = array("ref_id","tpl_id");
$ilDB->addPrimaryKey("didactic_tpl_objs", $pk_fields);


//
// didactic_tpl_sa
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => true
		,"length" => 8
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("didactic_tpl_sa", $fields);

$pk_fields = array("id","obj_type");
$ilDB->addPrimaryKey("didactic_tpl_sa", $pk_fields);

$ilDB->insert("didactic_tpl_sa", array(
'id' => array('integer', '1'), 'obj_type' => array('text', 'grp')));

$ilDB->insert("didactic_tpl_sa", array(
'id' => array('integer', '2'), 'obj_type' => array('text', 'sess')));


//
// didactic_tpl_settings
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"enabled" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 64
		,"fixed" => false
		,"type" => "text"
	)
	,"description" => array (
		"notnull" => false
		,"length" => 512
		,"fixed" => false
		,"type" => "text"
	)
	,"info" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"auto_generated" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"exclusive_tpl" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"icon_ide" => array (
		"notnull" => false
		,"length" => 64
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("didactic_tpl_settings", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("didactic_tpl_settings", $pk_fields);

$ilDB->createSequence("didactic_tpl_settings", 3);

$ilDB->insert("didactic_tpl_settings", array(
'id' => array('integer', '1'), 'enabled' => array('integer', '1'), 'type' => array('integer', '1'), 'title' => array('text', 'grp_closed'), 'description' => array('text', 'grp_closed_info'), 'info' => array('text', ''), 'auto_generated' => array('integer', '1'), 'exclusive_tpl' => array('integer', '0'), 'icon_ide' => array('text', '')));

$ilDB->insert("didactic_tpl_settings", array(
'id' => array('integer', '2'), 'enabled' => array('integer', '1'), 'type' => array('integer', '1'), 'title' => array('text', 'sess_closed'), 'description' => array('text', 'sess_closed_info'), 'info' => array('text', ''), 'auto_generated' => array('integer', '1'), 'exclusive_tpl' => array('integer', '0'), 'icon_ide' => array('text', '')));


//
// ecs_cmap_rule
//
$fields = array (
	"rid" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sid" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"mid" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"attribute" => array (
		"notnull" => false
		,"length" => 64
		,"fixed" => false
		,"type" => "text"
	)
	,"ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"is_filter" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"filter" => array (
		"notnull" => false
		,"length" => 512
		,"fixed" => false
		,"type" => "text"
	)
	,"create_subdir" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"subdir_type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"directory" => array (
		"notnull" => false
		,"length" => 64
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("ecs_cmap_rule", $fields);

$pk_fields = array("rid");
$ilDB->addPrimaryKey("ecs_cmap_rule", $pk_fields);

$ilDB->createSequence("ecs_cmap_rule", 1);


//
// ecs_cms_data
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"server_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"mid" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"tree_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 512
		,"fixed" => false
		,"type" => "text"
	)
	,"term" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"status" => array (
		"notnull" => true
		,"length" => 2
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"deleted" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"cms_id" => array (
		"notnull" => false
		,"length" => 512
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("ecs_cms_data", $fields);

$pk_fields = array("obj_id");
$ilDB->addPrimaryKey("ecs_cms_data", $pk_fields);

$ilDB->createSequence("ecs_cms_data", 1);


//
// ecs_cms_tree
//
$fields = array (
	"tree" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"child" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"parent" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"lft" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"rgt" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"depth" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("ecs_cms_tree", $fields);

$pk_fields = array("tree","child");
$ilDB->addPrimaryKey("ecs_cms_tree", $pk_fields);


//
// ecs_community
//
$fields = array (
	"sid" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"cid" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"own_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"cname" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"mids" => array (
		"notnull" => false
		,"length" => 512
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("ecs_community", $fields);

$pk_fields = array("sid","cid");
$ilDB->addPrimaryKey("ecs_community", $pk_fields);


//
// ecs_container_mapping
//
$fields = array (
	"mapping_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"container_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"field_name" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"mapping_type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"mapping_value" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"date_range_start" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"date_range_end" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("ecs_container_mapping", $fields);

$pk_fields = array("mapping_id");
$ilDB->addPrimaryKey("ecs_container_mapping", $pk_fields);

$ilDB->createSequence("ecs_container_mapping", 1);


//
// ecs_course_assignments
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sid" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"mid" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"cms_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usr_id" => array (
		"notnull" => false
		,"length" => 64
		,"fixed" => false
		,"type" => "text"
	)
	,"status" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"cms_sub_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("ecs_course_assignments", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("ecs_course_assignments", $pk_fields);

$ilDB->createSequence("ecs_course_assignments", 1);


//
// ecs_crs_mapping_atts
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sid" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"mid" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"name" => array (
		"notnull" => false
		,"length" => 64
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("ecs_crs_mapping_atts", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("ecs_crs_mapping_atts", $pk_fields);

$ilDB->createSequence("ecs_crs_mapping_atts", 1);


//
// ecs_data_mapping
//
$fields = array (
	"sid" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"mapping_type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"ecs_field" => array (
		"notnull" => true
		,"length" => 32
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"advmd_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("ecs_data_mapping", $fields);

$pk_fields = array("sid","mapping_type","ecs_field");
$ilDB->addPrimaryKey("ecs_data_mapping", $pk_fields);


//
// ecs_events
//
$fields = array (
	"event_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"type" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => true
		,"type" => "text"
	)
	,"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"op" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => true
		,"type" => "text"
	)
	,"server_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("ecs_events", $fields);

$pk_fields = array("event_id");
$ilDB->addPrimaryKey("ecs_events", $pk_fields);

$ilDB->createSequence("ecs_events", 1);


//
// ecs_export
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"econtent_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"server_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("ecs_export", $fields);

$pk_fields = array("server_id","obj_id");
$ilDB->addPrimaryKey("ecs_export", $pk_fields);


//
// ecs_import
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"mid" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"server_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sub_id" => array (
		"notnull" => false
		,"length" => 64
		,"fixed" => false
		,"type" => "text"
	)
	,"ecs_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"content_id" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"econtent_id" => array (
		"notnull" => false
		,"length" => 512
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("ecs_import", $fields);

$pk_fields = array("server_id","obj_id");
$ilDB->addPrimaryKey("ecs_import", $pk_fields);


//
// ecs_node_mapping_a
//
$fields = array (
	"server_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"mid" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"cs_root" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"cs_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"ref_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"title_update" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"position_update" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"tree_update" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("ecs_node_mapping_a", $fields);

$pk_fields = array("server_id","mid","cs_root","cs_id");
$ilDB->addPrimaryKey("ecs_node_mapping_a", $pk_fields);


//
// ecs_part_settings
//
$fields = array (
	"sid" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"mid" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"export" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"import" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"import_type" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"cname" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"token" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"export_types" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"import_types" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"dtoken" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
);
$ilDB->createTable("ecs_part_settings", $fields);

$pk_fields = array("sid","mid");
$ilDB->addPrimaryKey("ecs_part_settings", $pk_fields);


//
// ecs_remote_user
//
$fields = array (
	"eru_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sid" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"mid" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"remote_usr_id" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => true
		,"type" => "text"
	)
);
$ilDB->createTable("ecs_remote_user", $fields);

$pk_fields = array("eru_id");
$ilDB->addPrimaryKey("ecs_remote_user", $pk_fields);

$ilDB->createSequence("ecs_remote_user", 1);


//
// ecs_server
//
$fields = array (
	"server_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"active" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"protocol" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"server" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"port" => array (
		"notnull" => false
		,"length" => 2
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"auth_type" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"client_cert_path" => array (
		"notnull" => false
		,"length" => 512
		,"fixed" => false
		,"type" => "text"
	)
	,"ca_cert_path" => array (
		"notnull" => false
		,"length" => 512
		,"fixed" => false
		,"type" => "text"
	)
	,"key_path" => array (
		"notnull" => false
		,"length" => 512
		,"fixed" => false
		,"type" => "text"
	)
	,"key_password" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"cert_serial" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"polling_time" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"import_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"global_role" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"econtent_rcp" => array (
		"notnull" => false
		,"length" => 512
		,"fixed" => false
		,"type" => "text"
	)
	,"user_rcp" => array (
		"notnull" => false
		,"length" => 512
		,"fixed" => false
		,"type" => "text"
	)
	,"approval_rcp" => array (
		"notnull" => false
		,"length" => 512
		,"fixed" => false
		,"type" => "text"
	)
	,"duration" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 128
		,"fixed" => false
		,"type" => "text"
	)
	,"auth_user" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"auth_pass" => array (
		"notnull" => false
		,"length" => 128
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("ecs_server", $fields);

$pk_fields = array("server_id");
$ilDB->addPrimaryKey("ecs_server", $pk_fields);

$ilDB->createSequence("ecs_server", 1);


//
// event
//
$fields = array (
	"event_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 70
		,"fixed" => false
		,"type" => "text"
	)
	,"description" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"location" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"tutor_name" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"tutor_email" => array (
		"notnull" => false
		,"length" => 127
		,"fixed" => false
		,"type" => "text"
	)
	,"tutor_phone" => array (
		"notnull" => false
		,"length" => 127
		,"fixed" => false
		,"type" => "text"
	)
	,"details" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"registration" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"participation" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"reg_type" => array (
		"notnull" => false
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"reg_limit_users" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"reg_waiting_list" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"reg_limited" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"reg_min_users" => array (
		"notnull" => false
		,"length" => 2
		,"unsigned" => false
		,"type" => "integer"
	)
	,"reg_auto_wait" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"show_members" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"mail_members" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"reg_notification" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"notification_opt" => array (
		"notnull" => false
		,"length" => 50
		,"default" => "notification_option_manual"
		,"fixed" => false
		,"type" => "text"
	)
	,"show_cannot_part" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("event", $fields);

$pk_fields = array("event_id");
$ilDB->addPrimaryKey("event", $pk_fields);

$in_fields = array("obj_id");
$ilDB->addIndex("event", $in_fields, "i1", false);

$ilDB->createSequence("event", 1);


//
// event_appointment
//
$fields = array (
	"appointment_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"event_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"e_start" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"e_end" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"starting_time" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"ending_time" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"fulltime" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("event_appointment", $fields);

$pk_fields = array("appointment_id");
$ilDB->addPrimaryKey("event_appointment", $pk_fields);

$ilDB->createSequence("event_appointment", 1);


//
// event_file
//
$fields = array (
	"file_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"event_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"file_name" => array (
		"notnull" => false
		,"length" => 64
		,"fixed" => true
		,"type" => "text"
	)
	,"file_type" => array (
		"notnull" => false
		,"length" => 64
		,"fixed" => true
		,"type" => "text"
	)
	,"file_size" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("event_file", $fields);

$pk_fields = array("file_id");
$ilDB->addPrimaryKey("event_file", $pk_fields);

$ilDB->createSequence("event_file", 1);


//
// event_items
//
$fields = array (
	"event_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"item_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("event_items", $fields);

$pk_fields = array("event_id","item_id");
$ilDB->addPrimaryKey("event_items", $pk_fields);

$in_fields = array("event_id");
$ilDB->addIndex("event_items", $in_fields, "i1", false);


//
// event_participants
//
$fields = array (
	"event_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"registered" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"participated" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"mark" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"e_comment" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"contact" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"notification_enabled" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"excused" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("event_participants", $fields);

$pk_fields = array("event_id","usr_id");
$ilDB->addPrimaryKey("event_participants", $pk_fields);


//
// exc_ass_file_order
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"assignment_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"filename" => array (
		"notnull" => true
		,"length" => 150
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"order_nr" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("exc_ass_file_order", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("exc_ass_file_order", $pk_fields);

$ilDB->createSequence("exc_ass_file_order", 1);


//
// exc_ass_reminders
//
$fields = array (
	"type" => array (
		"notnull" => true
		,"length" => 32
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"ass_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"exc_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"status" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"start" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"end" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"freq" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"last_send" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"template_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"last_send_day" => array (
		"notnull" => false
		,"type" => "date"
	)
);
$ilDB->createTable("exc_ass_reminders", $fields);

$pk_fields = array("ass_id","exc_id","type");
$ilDB->addPrimaryKey("exc_ass_reminders", $pk_fields);


//
// exc_ass_wiki_team
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"container_ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"template_ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("exc_ass_wiki_team", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("exc_ass_wiki_team", $pk_fields);


//
// exc_assignment
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"exc_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"time_stamp" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"instruction" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"start_time" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"mandatory" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"order_nr" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"peer" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"peer_min" => array (
		"notnull" => true
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"fb_file" => array (
		"notnull" => false
		,"length" => 1000
		,"fixed" => false
		,"type" => "text"
	)
	,"fb_cron" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"fb_cron_done" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"peer_dl" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"peer_file" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"peer_prsl" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"fb_date" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"peer_char" => array (
		"notnull" => false
		,"length" => 2
		,"unsigned" => false
		,"type" => "integer"
	)
	,"peer_unlock" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"peer_valid" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"team_tutor" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"max_file" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"deadline2" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"peer_text" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"peer_rating" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"peer_crit_cat" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"portfolio_template" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"min_char_limit" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"max_char_limit" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"fb_date_custom" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"rmd_submit_status" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"rmd_submit_start" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"rmd_submit_end" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"rmd_submit_freq" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"rmd_grade_status" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"rmd_grade_start" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"rmd_grade_end" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"rmd_grade_freq" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"peer_rmd_status" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"peer_rmd_start" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"peer_rmd_end" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"peer_rmd_freq" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"deadline_mode" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"relative_deadline" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rel_deadline_last_subm" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("exc_assignment", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("exc_assignment", $pk_fields);

$ilDB->createSequence("exc_assignment", 1);


//
// exc_assignment_peer
//
$fields = array (
	"ass_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"giver_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"peer_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"tstamp" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"pcomment" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"is_valid" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("exc_assignment_peer", $fields);

$pk_fields = array("ass_id","giver_id","peer_id");
$ilDB->addPrimaryKey("exc_assignment_peer", $pk_fields);


//
// exc_crit
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"parent" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"type" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"descr" => array (
		"notnull" => false
		,"length" => 1000
		,"fixed" => false
		,"type" => "text"
	)
	,"pos" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"required" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"def" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("exc_crit", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("exc_crit", $pk_fields);

$ilDB->createSequence("exc_crit", 1);


//
// exc_crit_cat
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"parent" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"pos" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("exc_crit_cat", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("exc_crit_cat", $pk_fields);

$ilDB->createSequence("exc_crit_cat", 1);


//
// exc_data
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"instruction" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"time_stamp" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"pass_mode" => array (
		"notnull" => true
		,"length" => 8
		,"default" => "all"
		,"fixed" => false
		,"type" => "text"
	)
	,"pass_nr" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"show_submissions" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"compl_by_submission" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"certificate_visibility" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"tfeedback" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "7"
		,"type" => "integer"
	)
	,"nr_mandatory_random" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("exc_data", $fields);

$pk_fields = array("obj_id");
$ilDB->addPrimaryKey("exc_data", $pk_fields);


//
// exc_idl
//
$fields = array (
	"ass_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"member_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"is_team" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"tstamp" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"starting_ts" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("exc_idl", $fields);

$pk_fields = array("ass_id","member_id","is_team");
$ilDB->addPrimaryKey("exc_idl", $pk_fields);


//
// exc_mandatory_random
//
$fields = array (
	"exc_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"ass_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("exc_mandatory_random", $fields);

$pk_fields = array("exc_id","usr_id","ass_id");
$ilDB->addPrimaryKey("exc_mandatory_random", $pk_fields);


//
// exc_mem_ass_status
//
$fields = array (
	"ass_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"notice" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"returned" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"solved" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"status_time" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"sent" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"sent_time" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"feedback_time" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"feedback" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"status" => array (
		"notnull" => false
		,"length" => 9
		,"default" => "notgraded"
		,"fixed" => true
		,"type" => "text"
	)
	,"mark" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"u_comment" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("exc_mem_ass_status", $fields);

$pk_fields = array("ass_id","usr_id");
$ilDB->addPrimaryKey("exc_mem_ass_status", $pk_fields);


//
// exc_members
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"notice" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"returned" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"solved" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"status_time" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"sent" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"sent_time" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"feedback_time" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"feedback" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"status" => array (
		"notnull" => false
		,"length" => 9
		,"default" => "notgraded"
		,"fixed" => true
		,"type" => "text"
	)
);
$ilDB->createTable("exc_members", $fields);

$pk_fields = array("obj_id","usr_id");
$ilDB->addPrimaryKey("exc_members", $pk_fields);

$in_fields = array("obj_id");
$ilDB->addIndex("exc_members", $in_fields, "ob", false);


//
// exc_returned
//
$fields = array (
	"returned_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"filename" => array (
		"notnull" => false
		,"length" => 1000
		,"fixed" => false
		,"type" => "text"
	)
	,"filetitle" => array (
		"notnull" => false
		,"length" => 1000
		,"fixed" => false
		,"type" => "text"
	)
	,"mimetype" => array (
		"notnull" => false
		,"length" => 150
		,"fixed" => false
		,"type" => "text"
	)
	,"ts" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"ass_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"atext" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"late" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"team_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"web_dir_access_time" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
);
$ilDB->createTable("exc_returned", $fields);

$pk_fields = array("returned_id");
$ilDB->addPrimaryKey("exc_returned", $pk_fields);

$in_fields = array("obj_id");
$ilDB->addIndex("exc_returned", $in_fields, "i1", false);

$in_fields = array("user_id");
$ilDB->addIndex("exc_returned", $in_fields, "i2", false);

$in_fields = array("filetitle");
$ilDB->addIndex("exc_returned", $in_fields, "i3", false);

$ilDB->createSequence("exc_returned", 1);


//
// exc_usr_tutor
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"tutor_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"download_time" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"ass_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("exc_usr_tutor", $fields);

$pk_fields = array("ass_id","usr_id","tutor_id");
$ilDB->addPrimaryKey("exc_usr_tutor", $pk_fields);

$in_fields = array("obj_id");
$ilDB->addIndex("exc_usr_tutor", $in_fields, "ob", false);


//
// export_file_info
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"export_type" => array (
		"notnull" => true
		,"length" => 32
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"file_name" => array (
		"notnull" => true
		,"length" => 64
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"version" => array (
		"notnull" => false
		,"length" => 16
		,"fixed" => false
		,"type" => "text"
	)
	,"create_date" => array (
		"notnull" => true
		,"default" => "1970-01-01 00:00:00"
		,"type" => "timestamp"
	)
	,"filename" => array (
		"notnull" => true
		,"length" => 64
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("export_file_info", $fields);

$pk_fields = array("obj_id","export_type","filename");
$ilDB->addPrimaryKey("export_file_info", $pk_fields);

$in_fields = array("create_date");
$ilDB->addIndex("export_file_info", $in_fields, "i1", false);


//
// export_options
//
$fields = array (
	"export_id" => array (
		"notnull" => true
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"keyword" => array (
		"notnull" => true
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"value" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"pos" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("export_options", $fields);

$pk_fields = array("export_id","keyword","ref_id");
$ilDB->addPrimaryKey("export_options", $pk_fields);


//
// file_based_lm
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"is_online" => array (
		"notnull" => false
		,"length" => 1
		,"default" => "n"
		,"fixed" => true
		,"type" => "text"
	)
	,"startfile" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"show_lic" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"show_bib" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("file_based_lm", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("file_based_lm", $pk_fields);


//
// file_data
//
$fields = array (
	"file_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"file_name" => array (
		"notnull" => false
		,"length" => 250
		,"fixed" => true
		,"type" => "text"
	)
	,"file_type" => array (
		"notnull" => false
		,"length" => 250
		,"fixed" => true
		,"type" => "text"
	)
	,"file_size" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"version" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"f_mode" => array (
		"notnull" => false
		,"length" => 8
		,"default" => "object"
		,"fixed" => true
		,"type" => "text"
	)
	,"rating" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"page_count" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"type" => "integer"
	)
	,"max_version" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"rid" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("file_data", $fields);

$pk_fields = array("file_id");
$ilDB->addPrimaryKey("file_data", $pk_fields);


//
// file_usage
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usage_type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => " "
		,"fixed" => false
		,"type" => "text"
	)
	,"usage_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usage_hist_nr" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usage_lang" => array (
		"notnull" => true
		,"length" => 2
		,"default" => "-"
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("file_usage", $fields);

$pk_fields = array("id","usage_type","usage_id","usage_hist_nr","usage_lang");
$ilDB->addPrimaryKey("file_usage", $pk_fields);


//
// frm_data
//
$fields = array (
	"top_pk" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"top_frm_fk" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"top_name" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"top_description" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"top_num_posts" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"top_num_threads" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"top_last_post" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"top_mods" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"top_date" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"visits" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"top_update" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"update_user" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"top_usr_id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("frm_data", $fields);

$pk_fields = array("top_pk");
$ilDB->addPrimaryKey("frm_data", $pk_fields);

$in_fields = array("top_frm_fk");
$ilDB->addIndex("frm_data", $in_fields, "i1", false);

$ilDB->createSequence("frm_data", 1);


//
// frm_drafts_history
//
$fields = array (
	"history_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"draft_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"post_subject" => array (
		"notnull" => true
		,"length" => 4000
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"post_message" => array (
		"notnull" => true
		,"type" => "clob"
	)
	,"draft_date" => array (
		"notnull" => true
		,"default" => "1970-01-01 00:00:00"
		,"type" => "timestamp"
	)
);
$ilDB->createTable("frm_drafts_history", $fields);

$pk_fields = array("history_id");
$ilDB->addPrimaryKey("frm_drafts_history", $pk_fields);

$in_fields = array("draft_id");
$ilDB->addIndex("frm_drafts_history", $in_fields, "i1", false);

$ilDB->createSequence("frm_drafts_history", 1);


//
// frm_notification
//
$fields = array (
	"notification_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"frm_id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"thread_id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"admin_force_noti" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_toggle_noti" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id_noti" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("frm_notification", $fields);

$pk_fields = array("notification_id");
$ilDB->addPrimaryKey("frm_notification", $pk_fields);

$in_fields = array("user_id","thread_id");
$ilDB->addIndex("frm_notification", $in_fields, "i1", false);

$ilDB->createSequence("frm_notification", 1);


//
// frm_posts
//
$fields = array (
	"pos_pk" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"pos_top_fk" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"pos_thr_fk" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"pos_usr_alias" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"pos_subject" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"pos_date" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"pos_update" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"update_user" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"pos_cens" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"pos_cens_com" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"notify" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"import_name" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"pos_status" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"pos_message" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"pos_author_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"pos_display_user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"is_author_moderator" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"pos_cens_date" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"pos_activation_date" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
);
$ilDB->createTable("frm_posts", $fields);

$pk_fields = array("pos_pk");
$ilDB->addPrimaryKey("frm_posts", $pk_fields);

$in_fields = array("pos_thr_fk");
$ilDB->addIndex("frm_posts", $in_fields, "i1", false);

$in_fields = array("pos_top_fk");
$ilDB->addIndex("frm_posts", $in_fields, "i2", false);

$in_fields = array("pos_date");
$ilDB->addIndex("frm_posts", $in_fields, "i3", false);

$in_fields = array("pos_thr_fk","pos_date");
$ilDB->addIndex("frm_posts", $in_fields, "i5", false);

$ilDB->createSequence("frm_posts", 1);


//
// frm_posts_deleted
//
$fields = array (
	"deleted_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"deleted_date" => array (
		"notnull" => true
		,"default" => "1970-01-01 00:00:00"
		,"type" => "timestamp"
	)
	,"deleted_by" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"forum_title" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"thread_title" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"post_title" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"post_message" => array (
		"notnull" => true
		,"type" => "clob"
	)
	,"post_date" => array (
		"notnull" => true
		,"default" => "1970-01-01 00:00:00"
		,"type" => "timestamp"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"thread_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"forum_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"pos_display_user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"pos_usr_alias" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"is_thread_deleted" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("frm_posts_deleted", $fields);

$pk_fields = array("deleted_id");
$ilDB->addPrimaryKey("frm_posts_deleted", $pk_fields);

$ilDB->createSequence("frm_posts_deleted", 1);


//
// frm_posts_drafts
//
$fields = array (
	"draft_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"post_id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"thread_id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"forum_id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"post_author_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"post_subject" => array (
		"notnull" => true
		,"length" => 4000
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"post_message" => array (
		"notnull" => true
		,"type" => "clob"
	)
	,"post_notify" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"post_date" => array (
		"notnull" => true
		,"default" => "1970-01-01 00:00:00"
		,"type" => "timestamp"
	)
	,"post_update" => array (
		"notnull" => true
		,"default" => "1970-01-01 00:00:00"
		,"type" => "timestamp"
	)
	,"update_user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"post_user_alias" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"pos_display_usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"notify" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("frm_posts_drafts", $fields);

$pk_fields = array("draft_id");
$ilDB->addPrimaryKey("frm_posts_drafts", $pk_fields);

$in_fields = array("post_id");
$ilDB->addIndex("frm_posts_drafts", $in_fields, "i1", false);

$in_fields = array("thread_id");
$ilDB->addIndex("frm_posts_drafts", $in_fields, "i2", false);

$in_fields = array("forum_id");
$ilDB->addIndex("frm_posts_drafts", $in_fields, "i3", false);

$ilDB->createSequence("frm_posts_drafts", 1);


//
// frm_posts_tree
//
$fields = array (
	"fpt_pk" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"thr_fk" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"pos_fk" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"parent_pos" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"lft" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rgt" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"depth" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"fpt_date" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
);
$ilDB->createTable("frm_posts_tree", $fields);

$pk_fields = array("fpt_pk");
$ilDB->addPrimaryKey("frm_posts_tree", $pk_fields);

$in_fields = array("thr_fk");
$ilDB->addIndex("frm_posts_tree", $in_fields, "i1", false);

$in_fields = array("pos_fk");
$ilDB->addIndex("frm_posts_tree", $in_fields, "i2", false);

$in_fields = array("parent_pos");
$ilDB->addIndex("frm_posts_tree", $in_fields, "i3", false);

$ilDB->createSequence("frm_posts_tree", 1);


//
// frm_settings
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"default_view" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"anonymized" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"statistics_enabled" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"post_activation" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"admin_force_noti" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_toggle_noti" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"preset_subject" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"notification_type" => array (
		"notnull" => false
		,"length" => 10
		,"fixed" => false
		,"type" => "text"
	)
	,"add_re_subject" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"mark_mod_posts" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"thread_sorting" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"thread_rating" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"file_upload_allowed" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("frm_settings", $fields);

$pk_fields = array("obj_id");
$ilDB->addPrimaryKey("frm_settings", $pk_fields);


//
// frm_thread_access
//
$fields = array (
	"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"thread_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"access_old" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"access_last" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"access_old_ts" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
);
$ilDB->createTable("frm_thread_access", $fields);

$pk_fields = array("usr_id","obj_id","thread_id");
$ilDB->addPrimaryKey("frm_thread_access", $pk_fields);

$in_fields = array("access_last");
$ilDB->addIndex("frm_thread_access", $in_fields, "i1", false);


//
// frm_threads
//
$fields = array (
	"thr_pk" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"thr_top_fk" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"thr_subject" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"thr_usr_alias" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"thr_num_posts" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"thr_last_post" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"thr_date" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"thr_update" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"visits" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"import_name" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"is_sticky" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"is_closed" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"thread_sorting" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"avg_rating" => array (
		"notnull" => true
		,"default" => "0"
		,"type" => "float"
	)
	,"thr_author_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"thr_display_user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("frm_threads", $fields);

$pk_fields = array("thr_pk");
$ilDB->addPrimaryKey("frm_threads", $pk_fields);

$in_fields = array("thr_top_fk");
$ilDB->addIndex("frm_threads", $in_fields, "i2", false);

$ilDB->createSequence("frm_threads", 1);


//
// frm_user_read
//
$fields = array (
	"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"thread_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"post_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("frm_user_read", $fields);

$pk_fields = array("usr_id","obj_id","thread_id","post_id");
$ilDB->addPrimaryKey("frm_user_read", $pk_fields);

$in_fields = array("usr_id","post_id");
$ilDB->addIndex("frm_user_read", $in_fields, "i1", false);


//
// glo_advmd_col_order
//
$fields = array (
	"glo_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"field_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"order_nr" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("glo_advmd_col_order", $fields);

$pk_fields = array("glo_id","field_id");
$ilDB->addPrimaryKey("glo_advmd_col_order", $pk_fields);


//
// glo_glossaries
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"glo_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("glo_glossaries", $fields);

$pk_fields = array("id","glo_id");
$ilDB->addPrimaryKey("glo_glossaries", $pk_fields);


//
// glo_term_reference
//
$fields = array (
	"glo_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"term_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("glo_term_reference", $fields);

$pk_fields = array("glo_id","term_id");
$ilDB->addPrimaryKey("glo_term_reference", $pk_fields);


//
// glossary
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"is_online" => array (
		"notnull" => false
		,"length" => 1
		,"default" => "n"
		,"fixed" => true
		,"type" => "text"
	)
	,"virtual" => array (
		"notnull" => false
		,"length" => 7
		,"default" => "none"
		,"fixed" => true
		,"type" => "text"
	)
	,"public_html_file" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"public_xml_file" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"glo_menu_active" => array (
		"notnull" => false
		,"length" => 1
		,"default" => "y"
		,"fixed" => true
		,"type" => "text"
	)
	,"downloads_active" => array (
		"notnull" => false
		,"length" => 1
		,"default" => "n"
		,"fixed" => true
		,"type" => "text"
	)
	,"pres_mode" => array (
		"notnull" => true
		,"length" => 10
		,"default" => "table"
		,"fixed" => false
		,"type" => "text"
	)
	,"snippet_length" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "200"
		,"type" => "integer"
	)
	,"show_tax" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("glossary", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("glossary", $pk_fields);


//
// glossary_definition
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"term_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"short_text" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"nr" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"short_text_dirty" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("glossary_definition", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("glossary_definition", $pk_fields);

$ilDB->createSequence("glossary_definition", 1);


//
// glossary_term
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"glo_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"term" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"language" => array (
		"notnull" => false
		,"length" => 2
		,"fixed" => true
		,"type" => "text"
	)
	,"import_id" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"create_date" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"last_update" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
);
$ilDB->createTable("glossary_term", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("glossary_term", $pk_fields);

$in_fields = array("glo_id");
$ilDB->addIndex("glossary_term", $in_fields, "i1", false);

$ilDB->createSequence("glossary_term", 1);


//
// grp_settings
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"information" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"grp_type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"registration_type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"registration_enabled" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"registration_unlimited" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"registration_start" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"registration_end" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"registration_password" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => true
		,"type" => "text"
	)
	,"registration_mem_limit" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"registration_max_members" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"waiting_list" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"latitude" => array (
		"notnull" => false
		,"length" => 30
		,"fixed" => false
		,"type" => "text"
	)
	,"longitude" => array (
		"notnull" => false
		,"length" => 30
		,"fixed" => false
		,"type" => "text"
	)
	,"location_zoom" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"enablemap" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"reg_ac_enabled" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"reg_ac" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"view_mode" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "6"
		,"type" => "integer"
	)
	,"mail_members_type" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"registration_min_members" => array (
		"notnull" => false
		,"length" => 2
		,"unsigned" => false
		,"type" => "integer"
	)
	,"leave_end" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"auto_wait" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"show_members" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"grp_start" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"grp_end" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"period_start" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"period_end" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"period_time_indication" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"auto_notification" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"session_limit" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"session_prev" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "-1"
		,"type" => "integer"
	)
	,"session_next" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "-1"
		,"type" => "integer"
	)
);
$ilDB->createTable("grp_settings", $fields);

$pk_fields = array("obj_id");
$ilDB->addPrimaryKey("grp_settings", $pk_fields);


//
// help_map
//
$fields = array (
	"chap" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"component" => array (
		"notnull" => true
		,"length" => 10
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"screen_id" => array (
		"notnull" => true
		,"length" => 100
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"screen_sub_id" => array (
		"notnull" => true
		,"length" => 100
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"perm" => array (
		"notnull" => true
		,"length" => 20
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"module_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("help_map", $fields);

$pk_fields = array("component","screen_id","screen_sub_id","chap","perm","module_id");
$ilDB->addPrimaryKey("help_map", $pk_fields);

$in_fields = array("screen_id");
$ilDB->addIndex("help_map", $in_fields, "sc", false);

$in_fields = array("chap");
$ilDB->addIndex("help_map", $in_fields, "ch", false);


//
// help_module
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"lm_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("help_module", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("help_module", $pk_fields);

$ilDB->createSequence("help_module", 1);


//
// help_tooltip
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"tt_text" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"tt_id" => array (
		"notnull" => true
		,"length" => 200
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"comp" => array (
		"notnull" => true
		,"length" => 10
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"lang" => array (
		"notnull" => true
		,"length" => 2
		,"default" => "de"
		,"fixed" => true
		,"type" => "text"
	)
	,"module_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("help_tooltip", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("help_tooltip", $pk_fields);

$in_fields = array("tt_id","module_id");
$ilDB->addIndex("help_tooltip", $in_fields, "i1", false);

$ilDB->createSequence("help_tooltip", 1);


//
// history
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => false
		,"length" => 8
		,"fixed" => false
		,"type" => "text"
	)
	,"action" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
	,"hdate" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"info_params" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"user_comment" => array (
		"notnull" => false
		,"type" => "clob"
	)
);
$ilDB->createTable("history", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("history", $pk_fields);

$in_fields = array("obj_id","obj_type");
$ilDB->addIndex("history", $in_fields, "i1", false);

$ilDB->createSequence("history", 1);


//
// iass_info_settings
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"contact" => array (
		"notnull" => false
		,"length" => 100
		,"fixed" => false
		,"type" => "text"
	)
	,"responsibility" => array (
		"notnull" => false
		,"length" => 100
		,"fixed" => false
		,"type" => "text"
	)
	,"phone" => array (
		"notnull" => false
		,"length" => 100
		,"fixed" => false
		,"type" => "text"
	)
	,"mails" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"consultation_hours" => array (
		"notnull" => false
		,"length" => 500
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("iass_info_settings", $fields);

$pk_fields = array("obj_id");
$ilDB->addPrimaryKey("iass_info_settings", $pk_fields);


//
// iass_members
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"examiner_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"record" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"internal_note" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"notify" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"notification_ts" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "-1"
		,"type" => "integer"
	)
	,"learning_progress" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"finalized" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"place" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"event_time" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"type" => "integer"
	)
	,"file_name" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"user_view_file" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"changer_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"change_time" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("iass_members", $fields);

$pk_fields = array("obj_id","usr_id");
$ilDB->addPrimaryKey("iass_members", $pk_fields);


//
// iass_settings
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"content" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"record_template" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"event_time_place_required" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"file_required" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("iass_settings", $fields);

$pk_fields = array("obj_id");
$ilDB->addPrimaryKey("iass_settings", $pk_fields);


//
// il_adn_dismiss
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"usr_id" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"type" => "integer"
	)
	,"notification_id" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("il_adn_dismiss", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_adn_dismiss", $pk_fields);

$ilDB->createSequence("il_adn_dismiss", 1);


//
// il_adn_notifications
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 256
		,"fixed" => false
		,"type" => "text"
	)
	,"body" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"type" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"type_during_event" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"dismissable" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"permanent" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"allowed_users" => array (
		"notnull" => false
		,"length" => 256
		,"fixed" => false
		,"type" => "text"
	)
	,"parent_id" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"type" => "integer"
	)
	,"created_by" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"type" => "integer"
	)
	,"last_update_by" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"type" => "integer"
	)
	,"active" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"limited_to_role_ids" => array (
		"notnull" => false
		,"length" => 256
		,"fixed" => false
		,"type" => "text"
	)
	,"limit_to_roles" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"interruptive" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"link" => array (
		"notnull" => false
		,"length" => 256
		,"fixed" => false
		,"type" => "text"
	)
	,"link_type" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"link_target" => array (
		"notnull" => false
		,"length" => 256
		,"fixed" => false
		,"type" => "text"
	)
	,"event_start" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"event_end" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"display_start" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"display_end" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"create_date" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"last_update" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_adn_notifications", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_adn_notifications", $pk_fields);

$ilDB->createSequence("il_adn_notifications", 1);


//
// il_bibl_attribute
//
$fields = array (
	"entry_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"name" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"value" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_bibl_attribute", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_bibl_attribute", $pk_fields);

$ilDB->createSequence("il_bibl_attribute", 1);


//
// il_bibl_data
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"filename" => array (
		"notnull" => false
		,"length" => 256
		,"fixed" => false
		,"type" => "text"
	)
	,"is_online" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"file_type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_bibl_data", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_bibl_data", $pk_fields);


//
// il_bibl_entry
//
$fields = array (
	"data_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"type" => array (
		"notnull" => false
		,"length" => 128
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("il_bibl_entry", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_bibl_entry", $pk_fields);

$ilDB->createSequence("il_bibl_entry", 1);


//
// il_bibl_field
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"identifier" => array (
		"notnull" => true
		,"length" => 50
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"data_type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"position" => array (
		"notnull" => false
		,"length" => 3
		,"unsigned" => false
		,"type" => "integer"
	)
	,"is_standard_field" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"object_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
);
$ilDB->createTable("il_bibl_field", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_bibl_field", $pk_fields);

$ilDB->createSequence("il_bibl_field", 1);


//
// il_bibl_filter
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"field_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"object_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"filter_type" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("il_bibl_filter", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_bibl_filter", $pk_fields);

$ilDB->createSequence("il_bibl_filter", 1);


//
// il_bibl_overview_model
//
$fields = array (
	"ovm_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"literature_type" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"pattern" => array (
		"notnull" => false
		,"length" => 512
		,"fixed" => false
		,"type" => "text"
	)
	,"file_type_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("il_bibl_overview_model", $fields);

$pk_fields = array("ovm_id");
$ilDB->addPrimaryKey("il_bibl_overview_model", $pk_fields);

$ilDB->insert("il_bibl_overview_model", array(
'ovm_id' => array('integer', '1'), 'literature_type' => array('text', 'default'), 'pattern' => array('text', '[<strong>|bib_default_author|</strong> ][|bib_default_title|]: <Emph>[|bib_default_publisher| ][|bib_default_year| ][|bib_default_address|]</Emph>'), 'file_type_id' => array('integer', '2')));

$ilDB->insert("il_bibl_overview_model", array(
'ovm_id' => array('integer', '2'), 'literature_type' => array('text', 'default'), 'pattern' => array('text', '[<strong>|ris_default_a1|</strong> ][<strong>|ris_default_au|</strong> ][|ris_default_t1|][ |ris_default_ti|]: <Emph>[|ris_default_pb| ][|ris_default_y1| ][|ris_default_py| ][|ris_default_cy|]</Emph>'), 'file_type_id' => array('integer', '1')));


//
// il_bibl_settings
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"name" => array (
		"notnull" => true
		,"length" => 50
		,"default" => "-"
		,"fixed" => false
		,"type" => "text"
	)
	,"url" => array (
		"notnull" => true
		,"length" => 128
		,"default" => "-"
		,"fixed" => false
		,"type" => "text"
	)
	,"img" => array (
		"notnull" => false
		,"length" => 128
		,"fixed" => false
		,"type" => "text"
	)
	,"show_in_list" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_bibl_settings", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_bibl_settings", $pk_fields);

$ilDB->createSequence("il_bibl_settings", 1);


//
// il_bibl_translation
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"field_id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"language_key" => array (
		"notnull" => true
		,"length" => 2
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"translation" => array (
		"notnull" => false
		,"length" => 256
		,"fixed" => false
		,"type" => "text"
	)
	,"description" => array (
		"notnull" => false
		,"type" => "clob"
	)
);
$ilDB->createTable("il_bibl_translation", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_bibl_translation", $pk_fields);

$ilDB->createSequence("il_bibl_translation", 1);


//
// il_block_setting
//
$fields = array (
	"type" => array (
		"notnull" => true
		,"length" => 20
		,"default" => " "
		,"fixed" => false
		,"type" => "text"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"block_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"setting" => array (
		"notnull" => true
		,"length" => 40
		,"default" => " "
		,"fixed" => false
		,"type" => "text"
	)
	,"value" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("il_block_setting", $fields);

$pk_fields = array("type","user_id","block_id","setting");
$ilDB->addPrimaryKey("il_block_setting", $pk_fields);


//
// il_blog
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"bg_color" => array (
		"notnull" => false
		,"length" => 6
		,"fixed" => true
		,"type" => "text"
	)
	,"font_color" => array (
		"notnull" => false
		,"length" => 6
		,"fixed" => true
		,"type" => "text"
	)
	,"img" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"ppic" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"rss_active" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"approval" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"abs_shorten" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"abs_shorten_len" => array (
		"notnull" => false
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"abs_image" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"abs_img_width" => array (
		"notnull" => false
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"abs_img_height" => array (
		"notnull" => false
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"keywords" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"authors" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"nav_mode" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"nav_list_post" => array (
		"notnull" => true
		,"length" => 2
		,"unsigned" => false
		,"default" => "10"
		,"type" => "integer"
	)
	,"nav_list_mon" => array (
		"notnull" => false
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"ov_post" => array (
		"notnull" => false
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"nav_order" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"nav_list_mon_with_post" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "3"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_blog", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_blog", $pk_fields);


//
// il_blog_posting
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"blog_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 400
		,"fixed" => false
		,"type" => "text"
	)
	,"created" => array (
		"notnull" => true
		,"default" => "1970-01-01 00:00:00"
		,"type" => "timestamp"
	)
	,"author" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"approved" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"last_withdrawn" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
);
$ilDB->createTable("il_blog_posting", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_blog_posting", $pk_fields);

$in_fields = array("created");
$ilDB->addIndex("il_blog_posting", $in_fields, "i1", false);

$ilDB->createSequence("il_blog_posting", 1);


//
// il_bt_bucket
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"type" => "integer"
	)
	,"root_task_id" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"type" => "integer"
	)
	,"current_task_id" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"type" => "integer"
	)
	,"state" => array (
		"notnull" => false
		,"length" => 2
		,"unsigned" => false
		,"type" => "integer"
	)
	,"total_number_of_tasks" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"percentage" => array (
		"notnull" => false
		,"length" => 2
		,"unsigned" => false
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"description" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"last_heartbeat" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("il_bt_bucket", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_bt_bucket", $pk_fields);

$ilDB->createSequence("il_bt_bucket", 1);


//
// il_bt_task
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"type" => array (
		"notnull" => false
		,"length" => 256
		,"fixed" => false
		,"type" => "text"
	)
	,"class_path" => array (
		"notnull" => false
		,"length" => 256
		,"fixed" => false
		,"type" => "text"
	)
	,"class_name" => array (
		"notnull" => false
		,"length" => 256
		,"fixed" => false
		,"type" => "text"
	)
	,"bucket_id" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("il_bt_task", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_bt_task", $pk_fields);

$ilDB->createSequence("il_bt_task", 1);


//
// il_bt_value
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"has_parent_task" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"parent_task_id" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"type" => "integer"
	)
	,"hash" => array (
		"notnull" => false
		,"length" => 256
		,"fixed" => false
		,"type" => "text"
	)
	,"type" => array (
		"notnull" => false
		,"length" => 256
		,"fixed" => false
		,"type" => "text"
	)
	,"class_path" => array (
		"notnull" => false
		,"length" => 256
		,"fixed" => false
		,"type" => "text"
	)
	,"class_name" => array (
		"notnull" => false
		,"length" => 256
		,"fixed" => false
		,"type" => "text"
	)
	,"serialized" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"bucket_id" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"type" => "integer"
	)
	,"position" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_bt_value", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_bt_value", $pk_fields);

$in_fields = array("bucket_id");
$ilDB->addIndex("il_bt_value", $in_fields, "i1", false);

$ilDB->createSequence("il_bt_value", 1);


//
// il_bt_value_to_task
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"task_id" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"type" => "integer"
	)
	,"value_id" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"type" => "integer"
	)
	,"bucket_id" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"type" => "integer"
	)
	,"position" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_bt_value_to_task", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_bt_value_to_task", $pk_fields);

$in_fields = array("task_id");
$ilDB->addIndex("il_bt_value_to_task", $in_fields, "i1", false);

$in_fields = array("value_id");
$ilDB->addIndex("il_bt_value_to_task", $in_fields, "i2", false);

$ilDB->createSequence("il_bt_value_to_task", 1);


//
// il_cert_bgtask_migr
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"lock" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"found_items" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"processed_items" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"migrated_items" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"progress" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"state" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"started_ts" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"finished_ts" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("il_cert_bgtask_migr", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_cert_bgtask_migr", $pk_fields);

$in_fields = array("id","usr_id");
$ilDB->addUniqueConstraint("il_cert_bgtask_migr", $in_fields, "con");

$ilDB->createSequence("il_cert_bgtask_migr", 1);


//
// il_cert_cron_queue
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"adapter_class" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"state" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"started_timestamp" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"template_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_cert_cron_queue", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_cert_cron_queue", $pk_fields);

$in_fields = array("obj_id","usr_id");
$ilDB->addIndex("il_cert_cron_queue", $in_fields, "i1", false);

$ilDB->createSequence("il_cert_cron_queue", 1);


//
// il_cert_template
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"certificate_content" => array (
		"notnull" => true
		,"type" => "clob"
	)
	,"certificate_hash" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"template_values" => array (
		"notnull" => true
		,"type" => "clob"
	)
	,"background_image_path" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"version" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"ilias_version" => array (
		"notnull" => true
		,"length" => 255
		,"default" => "v5.4.0"
		,"fixed" => false
		,"type" => "text"
	)
	,"created_timestamp" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"currently_active" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"deleted" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"thumbnail_image_path" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"certificate_content_bu" => array (
		"notnull" => true
		,"type" => "clob"
	)
);
$ilDB->createTable("il_cert_template", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_cert_template", $pk_fields);

$in_fields = array("obj_id");
$ilDB->addIndex("il_cert_template", $in_fields, "i1", false);

$in_fields = array("obj_id","deleted");
$ilDB->addIndex("il_cert_template", $in_fields, "i2", false);

$in_fields = array("obj_id","currently_active","deleted");
$ilDB->addIndex("il_cert_template", $in_fields, "i3", false);

$in_fields = array("obj_type");
$ilDB->addIndex("il_cert_template", $in_fields, "i4", false);

$ilDB->createSequence("il_cert_template", 1);


//
// il_cert_user_cert
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"pattern_certificate_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => true
		,"length" => 255
		,"default" => "0"
		,"fixed" => false
		,"type" => "text"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_name" => array (
		"notnull" => true
		,"length" => 255
		,"default" => "0"
		,"fixed" => false
		,"type" => "text"
	)
	,"acquired_timestamp" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"certificate_content" => array (
		"notnull" => true
		,"type" => "clob"
	)
	,"template_values" => array (
		"notnull" => true
		,"type" => "clob"
	)
	,"valid_until" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"background_image_path" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"version" => array (
		"notnull" => true
		,"length" => 255
		,"default" => "1"
		,"fixed" => false
		,"type" => "text"
	)
	,"ilias_version" => array (
		"notnull" => true
		,"length" => 255
		,"default" => "v5.4.0"
		,"fixed" => false
		,"type" => "text"
	)
	,"currently_active" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"thumbnail_image_path" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"certificate_content_bu" => array (
		"notnull" => true
		,"type" => "clob"
	)
);
$ilDB->createTable("il_cert_user_cert", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_cert_user_cert", $pk_fields);

$in_fields = array("obj_id","pattern_certificate_id");
$ilDB->addIndex("il_cert_user_cert", $in_fields, "i1", false);

$in_fields = array("user_id","currently_active");
$ilDB->addIndex("il_cert_user_cert", $in_fields, "i2", false);

$in_fields = array("user_id","currently_active","acquired_timestamp");
$ilDB->addIndex("il_cert_user_cert", $in_fields, "i3", false);

$in_fields = array("user_id","obj_type","currently_active");
$ilDB->addIndex("il_cert_user_cert", $in_fields, "i4", false);

$in_fields = array("obj_id","currently_active");
$ilDB->addIndex("il_cert_user_cert", $in_fields, "i5", false);

$in_fields = array("user_id","obj_id","currently_active");
$ilDB->addIndex("il_cert_user_cert", $in_fields, "i6", false);

$ilDB->createSequence("il_cert_user_cert", 1);


//
// il_certificate
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_certificate", $fields);

$pk_fields = array("obj_id");
$ilDB->addPrimaryKey("il_certificate", $pk_fields);


//
// il_cld_data
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"is_online" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"service" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"root_folder" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"root_id" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"owner_id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"auth_complete" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("il_cld_data", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_cld_data", $pk_fields);


//
// il_component
//
$fields = array (
	"type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => ""
		,"fixed" => true
		,"type" => "text"
	)
	,"name" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"id" => array (
		"notnull" => true
		,"length" => 10
		,"default" => ""
		,"fixed" => true
		,"type" => "text"
	)
);
$ilDB->createTable("il_component", $fields);

$pk_fields = array("type","id");
$ilDB->addPrimaryKey("il_component", $pk_fields);

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'RemoteLearningModule'), 'id' => array('text', 'rlm')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'IndividualAssessment'), 'id' => array('text', 'iass')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'Blog'), 'id' => array('text', 'blog')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'SystemFolder'), 'id' => array('text', 'adm')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'LearningModule'), 'id' => array('text', 'lm')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'Glossary'), 'id' => array('text', 'glo')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'ScormAicc'), 'id' => array('text', 'sahs')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'CategoryReference'), 'id' => array('text', 'catr')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'RemoteWiki'), 'id' => array('text', 'rwik')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'StudyProgrammeReference'), 'id' => array('text', 'prgr')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'Exercise'), 'id' => array('text', 'exc')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'Folder'), 'id' => array('text', 'fold')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'GroupReference'), 'id' => array('text', 'grpr')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'Cloud'), 'id' => array('text', 'cld')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'Chatroom'), 'id' => array('text', 'chtr')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'HTMLLearningModule'), 'id' => array('text', 'htlm')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'WorkspaceFolder'), 'id' => array('text', 'wfld')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'TestQuestionPool'), 'id' => array('text', 'qpl')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'CourseReference'), 'id' => array('text', 'crsr')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'LearningSequence'), 'id' => array('text', 'lso')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'WebResource'), 'id' => array('text', 'webr')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'Bibliographic'), 'id' => array('text', 'bibl')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'DataCollection'), 'id' => array('text', 'dcl')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'LTIConsumer'), 'id' => array('text', 'lti')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'Session'), 'id' => array('text', 'sess')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'Forum'), 'id' => array('text', 'frm')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'RemoteGlossary'), 'id' => array('text', 'rglo')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'BookingManager'), 'id' => array('text', 'book')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'RemoteCourse'), 'id' => array('text', 'rcrs')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'Test'), 'id' => array('text', 'tst')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'Portfolio'), 'id' => array('text', 'prtf')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'RemoteTest'), 'id' => array('text', 'rtst')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'RemoteCategory'), 'id' => array('text', 'rcat')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'Scorm2004'), 'id' => array('text', 'sc13')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'Course'), 'id' => array('text', 'crs')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'ContentPage'), 'id' => array('text', 'copa')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'RootFolder'), 'id' => array('text', 'root')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'RemoteGroup'), 'id' => array('text', 'rgrp')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'RemoteFile'), 'id' => array('text', 'rfil')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'OrgUnit'), 'id' => array('text', 'orgu')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'File'), 'id' => array('text', 'file')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'ItemGroup'), 'id' => array('text', 'itgr')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'MediaCast'), 'id' => array('text', 'mcst')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'StudyProgramme'), 'id' => array('text', 'prg')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'CmiXapi'), 'id' => array('text', 'cmix')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'Group'), 'id' => array('text', 'grp')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'ExternalFeed'), 'id' => array('text', 'feed')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'Category'), 'id' => array('text', 'cat')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'MediaPool'), 'id' => array('text', 'mep')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'WorkspaceRootFolder'), 'id' => array('text', 'wsrt')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'Poll'), 'id' => array('text', 'poll')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'Wiki'), 'id' => array('text', 'wiki')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'SurveyQuestionPool'), 'id' => array('text', 'spl')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Modules'), 'name' => array('text', 'Survey'), 'id' => array('text', 'svy')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Preview'), 'id' => array('text', 'prvw')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'News'), 'id' => array('text', 'news')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'DataSet'), 'id' => array('text', 'ds')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'PersonalWorkspace'), 'id' => array('text', 'pwsp')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'AuthShibboleth'), 'id' => array('text', 'shiba')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'DidacticTemplate'), 'id' => array('text', 'otpl')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'PrivacySecurity'), 'id' => array('text', 'ps')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Dashboard'), 'id' => array('text', 'dash')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'MetaData'), 'id' => array('text', 'meta')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Imprint'), 'id' => array('text', 'impr')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'AdministrativeNotification'), 'id' => array('text', 'adn')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Taxonomy'), 'id' => array('text', 'tax')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Contact'), 'id' => array('text', 'contact')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'LTI'), 'id' => array('text', 'lti')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'MainMenu'), 'id' => array('text', 'mme')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'AccessControl'), 'id' => array('text', 'ac')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Export'), 'id' => array('text', 'exp')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'TermsOfService'), 'id' => array('text', 'tos')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Membership'), 'id' => array('text', 'mmbr')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Cron'), 'id' => array('text', 'cron')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'AdvancedEditing'), 'id' => array('text', 'adve')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Authentication'), 'id' => array('text', 'auth')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'MyStaff'), 'id' => array('text', 'msta')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Certificate'), 'id' => array('text', 'cert')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Navigation'), 'id' => array('text', 'navh')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'COPage'), 'id' => array('text', 'copg')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'BackgroundTasks'), 'id' => array('text', 'bgtk')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'WorkflowEngine'), 'id' => array('text', 'wfe')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'EventHandling'), 'id' => array('text', 'evnt')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Calendar'), 'id' => array('text', 'cal')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'UIComponent'), 'id' => array('text', 'ui')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Notification'), 'id' => array('text', 'noti')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Container'), 'id' => array('text', 'cont')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Accessibility'), 'id' => array('text', 'acc')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Table'), 'id' => array('text', 'table')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Link'), 'id' => array('text', 'link')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Notes'), 'id' => array('text', 'note')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Tree'), 'id' => array('text', 'tree')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'LDAP'), 'id' => array('text', 'ldap')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Randomization'), 'id' => array('text', 'rnd')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Notifications'), 'id' => array('text', 'nota')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'OpenIdConnect'), 'id' => array('text', 'oidc')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Init'), 'id' => array('text', 'init')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'WebDAV'), 'id' => array('text', 'wbdv')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Search'), 'id' => array('text', 'src')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Language'), 'id' => array('text', 'lang')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'ContainerReference'), 'id' => array('text', 'cntr')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Tagging'), 'id' => array('text', 'tag')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'AdvancedMetaData'), 'id' => array('text', 'amet')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Accordion'), 'id' => array('text', 'accrdn')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Skill'), 'id' => array('text', 'skll')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'MediaObjects'), 'id' => array('text', 'mob')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Repository'), 'id' => array('text', 'rep')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Badge'), 'id' => array('text', 'badge')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Style'), 'id' => array('text', 'styl')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'LinkChecker'), 'id' => array('text', 'lchk')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'User'), 'id' => array('text', 'user')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'SystemCheck'), 'id' => array('text', 'sysc')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Mail'), 'id' => array('text', 'mail')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Database'), 'id' => array('text', 'db')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'OnScreenChat'), 'id' => array('text', 'osch')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Object'), 'id' => array('text', 'obj')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Logging'), 'id' => array('text', 'log')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'LearningHistory'), 'id' => array('text', 'lhist')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Tasks'), 'id' => array('text', 'task')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'PDFGeneration'), 'id' => array('text', 'pdfg')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Component'), 'id' => array('text', 'comp')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Help'), 'id' => array('text', 'help')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'FileServices'), 'id' => array('text', 'fils')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Awareness'), 'id' => array('text', 'awrn')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Administration'), 'id' => array('text', 'adm')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'Tracking'), 'id' => array('text', 'trac')));

$ilDB->insert("il_component", array(
'type' => array('text', 'Services'), 'name' => array('text', 'WebServices'), 'id' => array('text', 'wsrv')));


//
// il_custom_block
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"context_obj_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"context_obj_type" => array (
		"notnull" => false
		,"length" => 10
		,"fixed" => false
		,"type" => "text"
	)
	,"context_sub_obj_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"context_sub_obj_type" => array (
		"notnull" => false
		,"length" => 10
		,"fixed" => false
		,"type" => "text"
	)
	,"type" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("il_custom_block", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_custom_block", $pk_fields);

$ilDB->createSequence("il_custom_block", 1);


//
// il_dcl_data
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"is_online" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"rating" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"public_notes" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"approval" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"notification" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("il_dcl_data", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_dcl_data", $pk_fields);

$ilDB->createSequence("il_dcl_data", 1);


//
// il_dcl_datatype
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 256
		,"fixed" => false
		,"type" => "text"
	)
	,"ildb_type" => array (
		"notnull" => true
		,"length" => 256
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"storage_location" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sort" => array (
		"notnull" => false
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_dcl_datatype", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_dcl_datatype", $pk_fields);

$ilDB->insert("il_dcl_datatype", array(
'id' => array('integer', '1'), 'title' => array('text', 'number'), 'ildb_type' => array('text', 'integer'), 'storage_location' => array('integer', '2'), 'sort' => array('integer', '20')));

$ilDB->insert("il_dcl_datatype", array(
'id' => array('integer', '2'), 'title' => array('text', 'text'), 'ildb_type' => array('text', 'text'), 'storage_location' => array('integer', '1'), 'sort' => array('integer', '0')));

$ilDB->insert("il_dcl_datatype", array(
'id' => array('integer', '3'), 'title' => array('text', 'reference'), 'ildb_type' => array('text', 'text'), 'storage_location' => array('integer', '1'), 'sort' => array('integer', '80')));

$ilDB->insert("il_dcl_datatype", array(
'id' => array('integer', '4'), 'title' => array('text', 'boolean'), 'ildb_type' => array('text', 'integer'), 'storage_location' => array('integer', '2'), 'sort' => array('integer', '30')));

$ilDB->insert("il_dcl_datatype", array(
'id' => array('integer', '5'), 'title' => array('text', 'datetime'), 'ildb_type' => array('text', 'date'), 'storage_location' => array('integer', '3'), 'sort' => array('integer', '40')));

$ilDB->insert("il_dcl_datatype", array(
'id' => array('integer', '6'), 'title' => array('text', 'fileupload'), 'ildb_type' => array('text', 'integer'), 'storage_location' => array('integer', '2'), 'sort' => array('integer', '70')));

$ilDB->insert("il_dcl_datatype", array(
'id' => array('integer', '7'), 'title' => array('text', 'rating'), 'ildb_type' => array('text', 'integer'), 'storage_location' => array('integer', '0'), 'sort' => array('integer', '100')));

$ilDB->insert("il_dcl_datatype", array(
'id' => array('integer', '8'), 'title' => array('text', 'ilias_reference'), 'ildb_type' => array('text', 'integer'), 'storage_location' => array('integer', '2'), 'sort' => array('integer', '90')));

$ilDB->insert("il_dcl_datatype", array(
'id' => array('integer', '9'), 'title' => array('text', 'mob'), 'ildb_type' => array('text', 'integer'), 'storage_location' => array('integer', '2'), 'sort' => array('integer', '60')));

$ilDB->insert("il_dcl_datatype", array(
'id' => array('integer', '11'), 'title' => array('text', 'formula'), 'ildb_type' => array('text', 'text'), 'storage_location' => array('integer', '0'), 'sort' => array('integer', '110')));

$ilDB->insert("il_dcl_datatype", array(
'id' => array('integer', '12'), 'title' => array('text', 'plugin'), 'ildb_type' => array('text', 'text'), 'storage_location' => array('integer', '0'), 'sort' => array('integer', '120')));

$ilDB->insert("il_dcl_datatype", array(
'id' => array('integer', '14'), 'title' => array('text', 'text_selection'), 'ildb_type' => array('text', 'text'), 'storage_location' => array('integer', '1'), 'sort' => array('integer', '10')));

$ilDB->insert("il_dcl_datatype", array(
'id' => array('integer', '15'), 'title' => array('text', 'date_selection'), 'ildb_type' => array('text', 'text'), 'storage_location' => array('integer', '1'), 'sort' => array('integer', '50')));


//
// il_dcl_datatype_prop
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"datatype_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 256
		,"fixed" => false
		,"type" => "text"
	)
	,"inputformat" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_dcl_datatype_prop", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_dcl_datatype_prop", $pk_fields);

$ilDB->insert("il_dcl_datatype_prop", array(
'id' => array('integer', '1'), 'datatype_id' => array('integer', '2'), 'title' => array('text', 'length'), 'inputformat' => array('integer', '1')));

$ilDB->insert("il_dcl_datatype_prop", array(
'id' => array('integer', '2'), 'datatype_id' => array('integer', '2'), 'title' => array('text', 'regex'), 'inputformat' => array('integer', '2')));

$ilDB->insert("il_dcl_datatype_prop", array(
'id' => array('integer', '3'), 'datatype_id' => array('integer', '3'), 'title' => array('text', 'table_id'), 'inputformat' => array('integer', '1')));

$ilDB->insert("il_dcl_datatype_prop", array(
'id' => array('integer', '4'), 'datatype_id' => array('integer', '2'), 'title' => array('text', 'url'), 'inputformat' => array('integer', '4')));

$ilDB->insert("il_dcl_datatype_prop", array(
'id' => array('integer', '5'), 'datatype_id' => array('integer', '2'), 'title' => array('text', 'text_area'), 'inputformat' => array('integer', '4')));

$ilDB->insert("il_dcl_datatype_prop", array(
'id' => array('integer', '6'), 'datatype_id' => array('integer', '3'), 'title' => array('text', 'reference_link'), 'inputformat' => array('integer', '4')));

$ilDB->insert("il_dcl_datatype_prop", array(
'id' => array('integer', '7'), 'datatype_id' => array('integer', '9'), 'title' => array('text', 'width'), 'inputformat' => array('integer', '1')));

$ilDB->insert("il_dcl_datatype_prop", array(
'id' => array('integer', '8'), 'datatype_id' => array('integer', '9'), 'title' => array('text', 'height'), 'inputformat' => array('integer', '1')));

$ilDB->insert("il_dcl_datatype_prop", array(
'id' => array('integer', '9'), 'datatype_id' => array('integer', '8'), 'title' => array('text', 'learning_progress'), 'inputformat' => array('integer', '4')));

$ilDB->insert("il_dcl_datatype_prop", array(
'id' => array('integer', '10'), 'datatype_id' => array('integer', '8'), 'title' => array('text', 'ILIAS_reference_link'), 'inputformat' => array('integer', '4')));

$ilDB->insert("il_dcl_datatype_prop", array(
'id' => array('integer', '11'), 'datatype_id' => array('integer', '3'), 'title' => array('text', 'multiple_selection'), 'inputformat' => array('integer', '4')));

$ilDB->insert("il_dcl_datatype_prop", array(
'id' => array('integer', '12'), 'datatype_id' => array('integer', '11'), 'title' => array('text', 'expression'), 'inputformat' => array('integer', '2')));

$ilDB->insert("il_dcl_datatype_prop", array(
'id' => array('integer', '13'), 'datatype_id' => array('integer', '8'), 'title' => array('text', 'display_action_menu'), 'inputformat' => array('integer', '4')));

$ilDB->insert("il_dcl_datatype_prop", array(
'id' => array('integer', '14'), 'datatype_id' => array('integer', '2'), 'title' => array('text', 'link_detail_page'), 'inputformat' => array('integer', '4')));

$ilDB->insert("il_dcl_datatype_prop", array(
'id' => array('integer', '15'), 'datatype_id' => array('integer', '9'), 'title' => array('text', 'link_detail_page'), 'inputformat' => array('integer', '4')));


//
// il_dcl_field
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"table_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 256
		,"fixed" => false
		,"type" => "text"
	)
	,"description" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"datatype_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"is_unique" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_dcl_field", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_dcl_field", $pk_fields);

$in_fields = array("datatype_id");
$ilDB->addIndex("il_dcl_field", $in_fields, "i1", false);

$in_fields = array("table_id");
$ilDB->addIndex("il_dcl_field", $in_fields, "i2", false);

$ilDB->createSequence("il_dcl_field", 1);


//
// il_dcl_field_prop
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"field_id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"name" => array (
		"notnull" => true
		,"length" => 4000
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"value" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("il_dcl_field_prop", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_dcl_field_prop", $pk_fields);

$ilDB->createSequence("il_dcl_field_prop", 1);


//
// il_dcl_field_prop_b
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"field_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"datatype_prop_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"value" => array (
		"notnull" => false
		,"length" => 256
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("il_dcl_field_prop_b", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_dcl_field_prop_b", $pk_fields);

$in_fields = array("field_id");
$ilDB->addIndex("il_dcl_field_prop_b", $in_fields, "i1", false);

$in_fields = array("datatype_prop_id");
$ilDB->addIndex("il_dcl_field_prop_b", $in_fields, "i2", false);


//
// il_dcl_field_prop_s_b
//
$fields = array (
	"sequence" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_dcl_field_prop_s_b", $fields);

$pk_fields = array("sequence");
$ilDB->addPrimaryKey("il_dcl_field_prop_s_b", $pk_fields);


//
// il_dcl_record
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"table_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"create_date" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"last_update" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"owner" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"last_edit_by" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("il_dcl_record", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_dcl_record", $pk_fields);

$in_fields = array("table_id");
$ilDB->addIndex("il_dcl_record", $in_fields, "i1", false);

$ilDB->createSequence("il_dcl_record", 1);


//
// il_dcl_record_field
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"record_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"field_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_dcl_record_field", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_dcl_record_field", $pk_fields);

$in_fields = array("record_id");
$ilDB->addIndex("il_dcl_record_field", $in_fields, "i1", false);

$in_fields = array("field_id");
$ilDB->addIndex("il_dcl_record_field", $in_fields, "i2", false);

$ilDB->createSequence("il_dcl_record_field", 1);


//
// il_dcl_sel_opts
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"field_id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"opt_id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"sorting" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"value" => array (
		"notnull" => true
		,"length" => 128
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("il_dcl_sel_opts", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_dcl_sel_opts", $pk_fields);

$ilDB->createSequence("il_dcl_sel_opts", 1);


//
// il_dcl_stloc1_default
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"tview_set_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"value" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("il_dcl_stloc1_default", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_dcl_stloc1_default", $pk_fields);

$ilDB->createSequence("il_dcl_stloc1_default", 1);


//
// il_dcl_stloc1_value
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"record_field_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"value" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("il_dcl_stloc1_value", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_dcl_stloc1_value", $pk_fields);

$in_fields = array("record_field_id");
$ilDB->addIndex("il_dcl_stloc1_value", $in_fields, "i1", false);

$ilDB->createSequence("il_dcl_stloc1_value", 1);


//
// il_dcl_stloc2_default
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"tview_set_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"value" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("il_dcl_stloc2_default", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_dcl_stloc2_default", $pk_fields);

$ilDB->createSequence("il_dcl_stloc2_default", 1);


//
// il_dcl_stloc2_value
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"record_field_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"value" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("il_dcl_stloc2_value", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_dcl_stloc2_value", $pk_fields);

$in_fields = array("record_field_id");
$ilDB->addIndex("il_dcl_stloc2_value", $in_fields, "i1", false);

$ilDB->createSequence("il_dcl_stloc2_value", 1);


//
// il_dcl_stloc3_default
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"tview_set_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"value" => array (
		"notnull" => true
		,"default" => ""
		,"type" => "timestamp"
	)
);
$ilDB->createTable("il_dcl_stloc3_default", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_dcl_stloc3_default", $pk_fields);

$ilDB->createSequence("il_dcl_stloc3_default", 1);


//
// il_dcl_stloc3_value
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"record_field_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"value" => array (
		"notnull" => true
		,"default" => "1970-01-01 00:00:00"
		,"type" => "timestamp"
	)
);
$ilDB->createTable("il_dcl_stloc3_value", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_dcl_stloc3_value", $pk_fields);

$in_fields = array("record_field_id");
$ilDB->addIndex("il_dcl_stloc3_value", $in_fields, "i1", false);

$ilDB->createSequence("il_dcl_stloc3_value", 1);


//
// il_dcl_table
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 256
		,"fixed" => false
		,"type" => "text"
	)
	,"add_perm" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"edit_perm" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"delete_perm" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"edit_by_owner" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"limited" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"limit_start" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"limit_end" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"is_visible" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"export_enabled" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"description" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"default_sort_field_id" => array (
		"notnull" => true
		,"length" => 16
		,"default" => "0"
		,"fixed" => false
		,"type" => "text"
	)
	,"default_sort_field_order" => array (
		"notnull" => true
		,"length" => 4
		,"default" => "asc"
		,"fixed" => false
		,"type" => "text"
	)
	,"public_comments" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"view_own_records_perm" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"delete_by_owner" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"save_confirmation" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"import_enabled" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"table_order" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("il_dcl_table", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_dcl_table", $pk_fields);

$in_fields = array("obj_id");
$ilDB->addIndex("il_dcl_table", $in_fields, "i1", false);

$ilDB->createSequence("il_dcl_table", 1);


//
// il_dcl_tableview
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"table_id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => true
		,"length" => 128
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"roles" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"description" => array (
		"notnull" => false
		,"length" => 128
		,"fixed" => false
		,"type" => "text"
	)
	,"tableview_order" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"type" => "integer"
	)
	,"step_vs" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"step_c" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"step_e" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"step_o" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"step_s" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_dcl_tableview", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_dcl_tableview", $pk_fields);

$in_fields = array("table_id");
$ilDB->addIndex("il_dcl_tableview", $in_fields, "t1", false);

$ilDB->createSequence("il_dcl_tableview", 1);


//
// il_dcl_tfield_set
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"table_id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"field" => array (
		"notnull" => true
		,"length" => 128
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"field_order" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"type" => "integer"
	)
	,"exportable" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("il_dcl_tfield_set", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_dcl_tfield_set", $pk_fields);

$in_fields = array("table_id","field");
$ilDB->addIndex("il_dcl_tfield_set", $in_fields, "t2", false);

$ilDB->createSequence("il_dcl_tfield_set", 1);


//
// il_dcl_tview_set
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"tableview_id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"field" => array (
		"notnull" => true
		,"length" => 128
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"visible" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"in_filter" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"filter_value" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"filter_changeable" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"default_value" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"required_create" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"locked_create" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"visible_create" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"visible_edit" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"required_edit" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"locked_edit" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_dcl_tview_set", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_dcl_tview_set", $pk_fields);

$ilDB->createSequence("il_dcl_tview_set", 1);


//
// il_event_handling
//
$fields = array (
	"component" => array (
		"notnull" => true
		,"length" => 50
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"id" => array (
		"notnull" => true
		,"length" => 100
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("il_event_handling", $fields);

$pk_fields = array("component","type","id");
$ilDB->addPrimaryKey("il_event_handling", $pk_fields);

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Category'), 'type' => array('text', 'raise'), 'id' => array('text', 'delete')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Chatroom'), 'type' => array('text', 'raise'), 'id' => array('text', 'chatSettingsChanged')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Course'), 'type' => array('text', 'listen'), 'id' => array('text', 'Modules/Course')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Course'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/AccessControl')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Course'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/Tracking')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Course'), 'type' => array('text', 'raise'), 'id' => array('text', 'addParticipant')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Course'), 'type' => array('text', 'raise'), 'id' => array('text', 'addSubscriber')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Course'), 'type' => array('text', 'raise'), 'id' => array('text', 'addToWaitingList')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Course'), 'type' => array('text', 'raise'), 'id' => array('text', 'create')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Course'), 'type' => array('text', 'raise'), 'id' => array('text', 'delete')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Course'), 'type' => array('text', 'raise'), 'id' => array('text', 'deleteParticipant')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Course'), 'type' => array('text', 'raise'), 'id' => array('text', 'update')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/CourseReference'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/AccessControl')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Exercise'), 'type' => array('text', 'raise'), 'id' => array('text', 'createAssignment')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Exercise'), 'type' => array('text', 'raise'), 'id' => array('text', 'delete')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Exercise'), 'type' => array('text', 'raise'), 'id' => array('text', 'deleteAssignment')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Exercise'), 'type' => array('text', 'raise'), 'id' => array('text', 'updateAssignment')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Forum'), 'type' => array('text', 'listen'), 'id' => array('text', 'Modules/Course')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Forum'), 'type' => array('text', 'listen'), 'id' => array('text', 'Modules/Forum')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Forum'), 'type' => array('text', 'listen'), 'id' => array('text', 'Modules/Group')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Forum'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/News')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Forum'), 'type' => array('text', 'raise'), 'id' => array('text', 'censoredPost')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Forum'), 'type' => array('text', 'raise'), 'id' => array('text', 'createdPost')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Forum'), 'type' => array('text', 'raise'), 'id' => array('text', 'deletedPost')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Forum'), 'type' => array('text', 'raise'), 'id' => array('text', 'updatedPost')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Group'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/AccessControl')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Group'), 'type' => array('text', 'raise'), 'id' => array('text', 'addParticipant')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Group'), 'type' => array('text', 'raise'), 'id' => array('text', 'addSubscriber')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Group'), 'type' => array('text', 'raise'), 'id' => array('text', 'addToWaitingList')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Group'), 'type' => array('text', 'raise'), 'id' => array('text', 'create')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Group'), 'type' => array('text', 'raise'), 'id' => array('text', 'delete')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Group'), 'type' => array('text', 'raise'), 'id' => array('text', 'deleteParticipant')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Group'), 'type' => array('text', 'raise'), 'id' => array('text', 'update')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/LearningSequence'), 'type' => array('text', 'listen'), 'id' => array('text', 'Modules/LearningSequence')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/LearningSequence'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/Object')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/LearningSequence'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/Tracking')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/LearningSequence'), 'type' => array('text', 'raise'), 'id' => array('text', 'addParticipant')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/LearningSequence'), 'type' => array('text', 'raise'), 'id' => array('text', 'addSubscriber')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/LearningSequence'), 'type' => array('text', 'raise'), 'id' => array('text', 'addToWaitingList')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/LearningSequence'), 'type' => array('text', 'raise'), 'id' => array('text', 'create')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/LearningSequence'), 'type' => array('text', 'raise'), 'id' => array('text', 'delete')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/LearningSequence'), 'type' => array('text', 'raise'), 'id' => array('text', 'deleteParticipant')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/LearningSequence'), 'type' => array('text', 'raise'), 'id' => array('text', 'update')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/MediaPool'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/Object')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/OrgUnit'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/Tree')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/OrgUnit'), 'type' => array('text', 'raise'), 'id' => array('text', 'delete')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Portfolio'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/Object')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Session'), 'type' => array('text', 'listen'), 'id' => array('text', 'Modules/Session')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Session'), 'type' => array('text', 'raise'), 'id' => array('text', 'addSubscriber')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Session'), 'type' => array('text', 'raise'), 'id' => array('text', 'addToWaitingList')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Session'), 'type' => array('text', 'raise'), 'id' => array('text', 'create')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Session'), 'type' => array('text', 'raise'), 'id' => array('text', 'delete')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Session'), 'type' => array('text', 'raise'), 'id' => array('text', 'enter')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Session'), 'type' => array('text', 'raise'), 'id' => array('text', 'register')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/Session'), 'type' => array('text', 'raise'), 'id' => array('text', 'update')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/StudyProgramme'), 'type' => array('text', 'listen'), 'id' => array('text', 'Modules/Course')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/StudyProgramme'), 'type' => array('text', 'listen'), 'id' => array('text', 'Modules/Group')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/StudyProgramme'), 'type' => array('text', 'listen'), 'id' => array('text', 'Modules/OrgUnit')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/StudyProgramme'), 'type' => array('text', 'listen'), 'id' => array('text', 'Modules/StudyProgramme')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/StudyProgramme'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/AccessControl')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/StudyProgramme'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/ContainerReference')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/StudyProgramme'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/Object')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/StudyProgramme'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/Tracking')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/StudyProgramme'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/Tree')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/StudyProgramme'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/User')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/StudyProgramme'), 'type' => array('text', 'raise'), 'id' => array('text', 'informUserToRestart')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/StudyProgramme'), 'type' => array('text', 'raise'), 'id' => array('text', 'userAssigned')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/StudyProgramme'), 'type' => array('text', 'raise'), 'id' => array('text', 'userDeassigned')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/StudyProgramme'), 'type' => array('text', 'raise'), 'id' => array('text', 'userReAssigned')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/StudyProgramme'), 'type' => array('text', 'raise'), 'id' => array('text', 'userRiskyToFail')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Modules/StudyProgramme'), 'type' => array('text', 'raise'), 'id' => array('text', 'userSuccessful')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/AccessControl'), 'type' => array('text', 'raise'), 'id' => array('text', 'assignUser')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/AccessControl'), 'type' => array('text', 'raise'), 'id' => array('text', 'deassignUser')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Authentication'), 'type' => array('text', 'raise'), 'id' => array('text', 'afterLogin')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Authentication'), 'type' => array('text', 'raise'), 'id' => array('text', 'afterLogout')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Authentication'), 'type' => array('text', 'raise'), 'id' => array('text', 'beforeLogout')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Authentication'), 'type' => array('text', 'raise'), 'id' => array('text', 'expiredSessionDetected')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Authentication'), 'type' => array('text', 'raise'), 'id' => array('text', 'reachedSessionPoolLimit')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Badge'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/Tracking')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Badge'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/User')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Calendar'), 'type' => array('text', 'listen'), 'id' => array('text', 'Modules/Course')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Calendar'), 'type' => array('text', 'listen'), 'id' => array('text', 'Modules/Exercise')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Calendar'), 'type' => array('text', 'listen'), 'id' => array('text', 'Modules/Group')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Calendar'), 'type' => array('text', 'listen'), 'id' => array('text', 'Modules/Session')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Certificate'), 'type' => array('text', 'listen'), 'id' => array('text', 'Modules/StudyProgramme')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Certificate'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/Certificate')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Certificate'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/Tracking')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Certificate'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/User')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Certificate'), 'type' => array('text', 'raise'), 'id' => array('text', 'certificateIssued')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Contact'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/Contact')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Contact'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/User')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Contact'), 'type' => array('text', 'raise'), 'id' => array('text', 'contactRequested')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/ContainerReference'), 'type' => array('text', 'listen'), 'id' => array('text', 'Modules/Category')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/ContainerReference'), 'type' => array('text', 'listen'), 'id' => array('text', 'Modules/Course')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/ContainerReference'), 'type' => array('text', 'listen'), 'id' => array('text', 'Modules/StudyProgramme')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/ContainerReference'), 'type' => array('text', 'raise'), 'id' => array('text', 'deleteReference')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/LTI'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/Tracking')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/LTI'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/User')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Mail'), 'type' => array('text', 'raise'), 'id' => array('text', 'externalEmailDelegated')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Mail'), 'type' => array('text', 'raise'), 'id' => array('text', 'sentInternalMail')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/News'), 'type' => array('text', 'raise'), 'id' => array('text', 'readNews')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/News'), 'type' => array('text', 'raise'), 'id' => array('text', 'unreadNews')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Notification'), 'type' => array('text', 'listen'), 'id' => array('text', 'Service/Object')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Object'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/Object')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Object'), 'type' => array('text', 'raise'), 'id' => array('text', 'create')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Object'), 'type' => array('text', 'raise'), 'id' => array('text', 'delete')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Object'), 'type' => array('text', 'raise'), 'id' => array('text', 'toTrash')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Object'), 'type' => array('text', 'raise'), 'id' => array('text', 'undelete')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Object'), 'type' => array('text', 'raise'), 'id' => array('text', 'update')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/OnScreenChat'), 'type' => array('text', 'listen'), 'id' => array('text', 'Modules/Chatroom')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/OpenIdConnect'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/Authentication')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Repository'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/Object')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Search'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/Object')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Skill'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/Object')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Skill'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/Tracking')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Tagging'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/Object')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/TermsOfService'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/User')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/TermsOfService'), 'type' => array('text', 'raise'), 'id' => array('text', 'ilTermsOfServiceEventWithdrawn')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Tracking'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/Object')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Tracking'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/Tree')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Tracking'), 'type' => array('text', 'raise'), 'id' => array('text', 'updateStatus')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/Tree'), 'type' => array('text', 'raise'), 'id' => array('text', 'deleteNode')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/User'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/Object')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/User'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/TermsOfService')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/User'), 'type' => array('text', 'raise'), 'id' => array('text', 'afterCreate')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/User'), 'type' => array('text', 'raise'), 'id' => array('text', 'afterUpdate')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/User'), 'type' => array('text', 'raise'), 'id' => array('text', 'deleteUser')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/WebServices'), 'type' => array('text', 'raise'), 'id' => array('text', 'newEcsEvent')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/WebServices/ECS'), 'type' => array('text', 'listen'), 'id' => array('text', 'Modules/Course')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/WebServices/ECS'), 'type' => array('text', 'listen'), 'id' => array('text', 'Modules/Group')));

$ilDB->insert("il_event_handling", array(
'component' => array('text', 'Services/WebServices/ECS'), 'type' => array('text', 'listen'), 'id' => array('text', 'Services/User')));


//
// il_exc_team
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"ass_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_exc_team", $fields);

$pk_fields = array("ass_id","user_id");
$ilDB->addPrimaryKey("il_exc_team", $pk_fields);

$ilDB->createSequence("il_exc_team", 1);


//
// il_exc_team_log
//
$fields = array (
	"log_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"team_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"details" => array (
		"notnull" => false
		,"length" => 500
		,"fixed" => false
		,"type" => "text"
	)
	,"action" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"tstamp" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_exc_team_log", $fields);

$pk_fields = array("log_id");
$ilDB->addPrimaryKey("il_exc_team_log", $pk_fields);

$in_fields = array("team_id");
$ilDB->addIndex("il_exc_team_log", $in_fields, "i1", false);

$ilDB->createSequence("il_exc_team_log", 1);


//
// il_external_feed_block
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"feed_url" => array (
		"notnull" => false
		,"length" => 250
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("il_external_feed_block", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_external_feed_block", $pk_fields);

$ilDB->createSequence("il_external_feed_block", 1);


//
// il_gc_memcache_server
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"status" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"host" => array (
		"notnull" => false
		,"length" => 256
		,"fixed" => false
		,"type" => "text"
	)
	,"port" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"type" => "integer"
	)
	,"weight" => array (
		"notnull" => false
		,"length" => 2
		,"unsigned" => false
		,"type" => "integer"
	)
	,"flush_needed" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("il_gc_memcache_server", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_gc_memcache_server", $pk_fields);

$ilDB->createSequence("il_gc_memcache_server", 1);


//
// il_html_block
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"content" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("il_html_block", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_html_block", $pk_fields);


//
// il_md_cpr_selections
//
$fields = array (
	"entry_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 128
		,"fixed" => false
		,"type" => "text"
	)
	,"description" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"copyright" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"language" => array (
		"notnull" => false
		,"length" => 2
		,"fixed" => true
		,"type" => "text"
	)
	,"costs" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"cpr_restrictions" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"is_default" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"outdated" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"position" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_md_cpr_selections", $fields);

$pk_fields = array("entry_id");
$ilDB->addPrimaryKey("il_md_cpr_selections", $pk_fields);

$ilDB->createSequence("il_md_cpr_selections", 8);

$ilDB->insert("il_md_cpr_selections", array(
'entry_id' => array('integer', '1'), 'title' => array('text', 'Attribution Non-commercial No Derivatives (by-nc-nd)'), 'description' => array('clob', 'Creative Commons License'), 'copyright' => array('clob', '<a rel="license" href="http://creativecommons.org/licenses/by-nc-nd/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by-nc-nd/4.0/88x31.png" /></a><br />This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by-nc-nd/4.0/">Creative Commons Attribution-NonCommercial-NoDerivatives 4.0 International License</a>.'), 'language' => array('text', 'en'), 'costs' => array('integer', '0'), 'cpr_restrictions' => array('integer', '1'), 'is_default' => array('integer', '0'), 'outdated' => array('integer', '0'), 'position' => array('integer', '0')));

$ilDB->insert("il_md_cpr_selections", array(
'entry_id' => array('integer', '2'), 'title' => array('text', 'Attribution Non-commercial Share Alike (by-nc-sa)'), 'description' => array('clob', 'Creative Commons License'), 'copyright' => array('clob', '<a rel="license" href="http://creativecommons.org/licenses/by-nc-sa/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by-nc-sa/4.0/88x31.png" /></a><br />This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by-nc-sa/4.0/">Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License</a>.'), 'language' => array('text', 'en'), 'costs' => array('integer', '0'), 'cpr_restrictions' => array('integer', '1'), 'is_default' => array('integer', '0'), 'outdated' => array('integer', '0'), 'position' => array('integer', '0')));

$ilDB->insert("il_md_cpr_selections", array(
'entry_id' => array('integer', '3'), 'title' => array('text', 'Attribution Non-commercial (by-nc)'), 'description' => array('clob', 'Creative Commons License'), 'copyright' => array('clob', '<a rel="license" href="http://creativecommons.org/licenses/by-nc/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by-nc/4.0/88x31.png" /></a><br />This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by-nc/4.0/">Creative Commons Attribution-NonCommercial 4.0 International License</a>.'), 'language' => array('text', 'en'), 'costs' => array('integer', '0'), 'cpr_restrictions' => array('integer', '1'), 'is_default' => array('integer', '0'), 'outdated' => array('integer', '0'), 'position' => array('integer', '0')));

$ilDB->insert("il_md_cpr_selections", array(
'entry_id' => array('integer', '4'), 'title' => array('text', 'Attribution No Derivatives (by-nd)'), 'description' => array('clob', 'Creative Commons License'), 'copyright' => array('clob', '<a rel="license" href="http://creativecommons.org/licenses/by-nd/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by-nd/4.0/88x31.png" /></a><br />This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by-nd/4.0/">Creative Commons Attribution-NoDerivatives 4.0 International License</a>.'), 'language' => array('text', 'en'), 'costs' => array('integer', '0'), 'cpr_restrictions' => array('integer', '1'), 'is_default' => array('integer', '0'), 'outdated' => array('integer', '0'), 'position' => array('integer', '0')));

$ilDB->insert("il_md_cpr_selections", array(
'entry_id' => array('integer', '5'), 'title' => array('text', 'Attribution Share Alike (by-sa)'), 'description' => array('clob', 'Creative Commons License'), 'copyright' => array('clob', '<a rel="license" href="http://creativecommons.org/licenses/by-sa/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by-sa/4.0/88x31.png" /></a><br />This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by-sa/4.0/">Creative Commons Attribution-ShareAlike 4.0 International License</a>.'), 'language' => array('text', 'en'), 'costs' => array('integer', '0'), 'cpr_restrictions' => array('integer', '1'), 'is_default' => array('integer', '0'), 'outdated' => array('integer', '0'), 'position' => array('integer', '0')));

$ilDB->insert("il_md_cpr_selections", array(
'entry_id' => array('integer', '6'), 'title' => array('text', 'Attribution (by)'), 'description' => array('clob', 'Creative Commons License'), 'copyright' => array('clob', '<a rel="license" href="http://creativecommons.org/licenses/by/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by/4.0/88x31.png" /></a><br />This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by/4.0/">Creative Commons Attribution 4.0 International License</a>.'), 'language' => array('text', 'en'), 'costs' => array('integer', '0'), 'cpr_restrictions' => array('integer', '1'), 'is_default' => array('integer', '0'), 'outdated' => array('integer', '0'), 'position' => array('integer', '0')));

$ilDB->insert("il_md_cpr_selections", array(
'entry_id' => array('integer', '7'), 'title' => array('text', 'All rights reserved'), 'description' => array('clob', ''), 'copyright' => array('clob', 'This work has all rights reserved by the owner.'), 'language' => array('text', 'en'), 'costs' => array('integer', '0'), 'cpr_restrictions' => array('integer', '1'), 'is_default' => array('integer', '1'), 'outdated' => array('integer', '0'), 'position' => array('integer', '0')));


//
// il_media_cast_data
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"is_online" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"public_files" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"downloadable" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"def_access" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sortmode" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "3"
		,"type" => "integer"
	)
	,"viewmode" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("il_media_cast_data", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_media_cast_data", $pk_fields);


//
// il_media_cast_data_ord
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"item_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"pos" => array (
		"notnull" => true
		,"length" => 3
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_media_cast_data_ord", $fields);

$pk_fields = array("obj_id","item_id");
$ilDB->addPrimaryKey("il_media_cast_data_ord", $pk_fields);


//
// il_meta_annotation
//
$fields = array (
	"meta_annotation_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rbac_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => false
		,"length" => 6
		,"fixed" => false
		,"type" => "text"
	)
	,"entity" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"a_date" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"description" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"description_language" => array (
		"notnull" => false
		,"length" => 2
		,"fixed" => true
		,"type" => "text"
	)
);
$ilDB->createTable("il_meta_annotation", $fields);

$pk_fields = array("meta_annotation_id");
$ilDB->addPrimaryKey("il_meta_annotation", $pk_fields);

$in_fields = array("rbac_id","obj_id");
$ilDB->addIndex("il_meta_annotation", $in_fields, "i1", false);

$ilDB->createSequence("il_meta_annotation", 1);


//
// il_meta_classification
//
$fields = array (
	"meta_classification_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rbac_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => false
		,"length" => 6
		,"fixed" => false
		,"type" => "text"
	)
	,"purpose" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"description" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"description_language" => array (
		"notnull" => false
		,"length" => 2
		,"fixed" => true
		,"type" => "text"
	)
);
$ilDB->createTable("il_meta_classification", $fields);

$pk_fields = array("meta_classification_id");
$ilDB->addPrimaryKey("il_meta_classification", $pk_fields);

$in_fields = array("rbac_id","obj_id");
$ilDB->addIndex("il_meta_classification", $in_fields, "i1", false);

$ilDB->createSequence("il_meta_classification", 1);


//
// il_meta_contribute
//
$fields = array (
	"meta_contribute_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rbac_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => false
		,"length" => 6
		,"fixed" => false
		,"type" => "text"
	)
	,"parent_type" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"parent_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"role" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"c_date" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("il_meta_contribute", $fields);

$pk_fields = array("meta_contribute_id");
$ilDB->addPrimaryKey("il_meta_contribute", $pk_fields);

$in_fields = array("rbac_id","obj_id");
$ilDB->addIndex("il_meta_contribute", $in_fields, "i1", false);

$ilDB->createSequence("il_meta_contribute", 1);


//
// il_meta_description
//
$fields = array (
	"meta_description_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rbac_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => false
		,"length" => 6
		,"fixed" => false
		,"type" => "text"
	)
	,"parent_type" => array (
		"notnull" => false
		,"length" => 16
		,"fixed" => false
		,"type" => "text"
	)
	,"parent_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"description" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"description_language" => array (
		"notnull" => false
		,"length" => 2
		,"fixed" => true
		,"type" => "text"
	)
);
$ilDB->createTable("il_meta_description", $fields);

$pk_fields = array("meta_description_id");
$ilDB->addPrimaryKey("il_meta_description", $pk_fields);

$in_fields = array("rbac_id","obj_id");
$ilDB->addIndex("il_meta_description", $in_fields, "i1", false);

$ilDB->createSequence("il_meta_description", 1);


//
// il_meta_educational
//
$fields = array (
	"meta_educational_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rbac_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => false
		,"length" => 6
		,"fixed" => false
		,"type" => "text"
	)
	,"interactivity_type" => array (
		"notnull" => false
		,"length" => 16
		,"fixed" => false
		,"type" => "text"
	)
	,"learning_resource_type" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"interactivity_level" => array (
		"notnull" => false
		,"length" => 16
		,"fixed" => false
		,"type" => "text"
	)
	,"semantic_density" => array (
		"notnull" => false
		,"length" => 16
		,"fixed" => false
		,"type" => "text"
	)
	,"intended_end_user_role" => array (
		"notnull" => false
		,"length" => 16
		,"fixed" => false
		,"type" => "text"
	)
	,"context" => array (
		"notnull" => false
		,"length" => 16
		,"fixed" => false
		,"type" => "text"
	)
	,"difficulty" => array (
		"notnull" => false
		,"length" => 16
		,"fixed" => false
		,"type" => "text"
	)
	,"typical_learning_time" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("il_meta_educational", $fields);

$pk_fields = array("meta_educational_id");
$ilDB->addPrimaryKey("il_meta_educational", $pk_fields);

$in_fields = array("rbac_id","obj_id");
$ilDB->addIndex("il_meta_educational", $in_fields, "i1", false);

$ilDB->createSequence("il_meta_educational", 1);


//
// il_meta_entity
//
$fields = array (
	"meta_entity_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rbac_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => false
		,"length" => 6
		,"fixed" => false
		,"type" => "text"
	)
	,"parent_type" => array (
		"notnull" => false
		,"length" => 16
		,"fixed" => false
		,"type" => "text"
	)
	,"parent_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"entity" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("il_meta_entity", $fields);

$pk_fields = array("meta_entity_id");
$ilDB->addPrimaryKey("il_meta_entity", $pk_fields);

$in_fields = array("rbac_id","obj_id");
$ilDB->addIndex("il_meta_entity", $in_fields, "i1", false);

$ilDB->createSequence("il_meta_entity", 1);


//
// il_meta_format
//
$fields = array (
	"meta_format_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rbac_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => false
		,"length" => 6
		,"fixed" => false
		,"type" => "text"
	)
	,"format" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("il_meta_format", $fields);

$pk_fields = array("meta_format_id");
$ilDB->addPrimaryKey("il_meta_format", $pk_fields);

$in_fields = array("rbac_id","obj_id");
$ilDB->addIndex("il_meta_format", $in_fields, "i1", false);

$in_fields = array("format");
$ilDB->addIndex("il_meta_format", $in_fields, "i2", false);

$ilDB->createSequence("il_meta_format", 1);


//
// il_meta_general
//
$fields = array (
	"meta_general_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rbac_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => false
		,"length" => 6
		,"fixed" => false
		,"type" => "text"
	)
	,"general_structure" => array (
		"notnull" => false
		,"length" => 16
		,"fixed" => false
		,"type" => "text"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"title_language" => array (
		"notnull" => false
		,"length" => 2
		,"fixed" => true
		,"type" => "text"
	)
	,"coverage" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"coverage_language" => array (
		"notnull" => false
		,"length" => 2
		,"fixed" => true
		,"type" => "text"
	)
);
$ilDB->createTable("il_meta_general", $fields);

$pk_fields = array("meta_general_id");
$ilDB->addPrimaryKey("il_meta_general", $pk_fields);

$in_fields = array("rbac_id","obj_id");
$ilDB->addIndex("il_meta_general", $in_fields, "i1", false);

$ilDB->createSequence("il_meta_general", 1);


//
// il_meta_identifier
//
$fields = array (
	"meta_identifier_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rbac_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => false
		,"length" => 6
		,"fixed" => false
		,"type" => "text"
	)
	,"parent_type" => array (
		"notnull" => false
		,"length" => 16
		,"fixed" => false
		,"type" => "text"
	)
	,"parent_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"catalog" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"entry" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("il_meta_identifier", $fields);

$pk_fields = array("meta_identifier_id");
$ilDB->addPrimaryKey("il_meta_identifier", $pk_fields);

$in_fields = array("rbac_id","obj_id");
$ilDB->addIndex("il_meta_identifier", $in_fields, "i1", false);

$ilDB->createSequence("il_meta_identifier", 1);


//
// il_meta_identifier_
//
$fields = array (
	"meta_identifier__id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rbac_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => false
		,"length" => 6
		,"fixed" => false
		,"type" => "text"
	)
	,"parent_type" => array (
		"notnull" => false
		,"length" => 16
		,"fixed" => false
		,"type" => "text"
	)
	,"parent_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"catalog" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"entry" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("il_meta_identifier_", $fields);

$pk_fields = array("meta_identifier__id");
$ilDB->addPrimaryKey("il_meta_identifier_", $pk_fields);

$in_fields = array("rbac_id","obj_id");
$ilDB->addIndex("il_meta_identifier_", $in_fields, "i1", false);

$ilDB->createSequence("il_meta_identifier_", 1);


//
// il_meta_keyword
//
$fields = array (
	"meta_keyword_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rbac_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => false
		,"length" => 6
		,"fixed" => false
		,"type" => "text"
	)
	,"parent_type" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"parent_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"keyword" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"keyword_language" => array (
		"notnull" => false
		,"length" => 2
		,"fixed" => true
		,"type" => "text"
	)
);
$ilDB->createTable("il_meta_keyword", $fields);

$pk_fields = array("meta_keyword_id");
$ilDB->addPrimaryKey("il_meta_keyword", $pk_fields);

$in_fields = array("rbac_id","obj_id");
$ilDB->addIndex("il_meta_keyword", $in_fields, "i1", false);

$ilDB->createSequence("il_meta_keyword", 1);


//
// il_meta_language
//
$fields = array (
	"meta_language_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rbac_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => false
		,"length" => 6
		,"fixed" => true
		,"type" => "text"
	)
	,"parent_type" => array (
		"notnull" => false
		,"length" => 16
		,"fixed" => true
		,"type" => "text"
	)
	,"parent_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"language" => array (
		"notnull" => false
		,"length" => 2
		,"fixed" => true
		,"type" => "text"
	)
);
$ilDB->createTable("il_meta_language", $fields);

$pk_fields = array("meta_language_id");
$ilDB->addPrimaryKey("il_meta_language", $pk_fields);

$in_fields = array("rbac_id","obj_id");
$ilDB->addIndex("il_meta_language", $in_fields, "i1", false);

$ilDB->createSequence("il_meta_language", 1);


//
// il_meta_lifecycle
//
$fields = array (
	"meta_lifecycle_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rbac_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => false
		,"length" => 6
		,"fixed" => false
		,"type" => "text"
	)
	,"lifecycle_status" => array (
		"notnull" => false
		,"length" => 16
		,"fixed" => false
		,"type" => "text"
	)
	,"meta_version" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"version_language" => array (
		"notnull" => false
		,"length" => 2
		,"fixed" => true
		,"type" => "text"
	)
);
$ilDB->createTable("il_meta_lifecycle", $fields);

$pk_fields = array("meta_lifecycle_id");
$ilDB->addPrimaryKey("il_meta_lifecycle", $pk_fields);

$in_fields = array("rbac_id","obj_id");
$ilDB->addIndex("il_meta_lifecycle", $in_fields, "i1", false);

$ilDB->createSequence("il_meta_lifecycle", 1);


//
// il_meta_location
//
$fields = array (
	"meta_location_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rbac_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => false
		,"length" => 6
		,"fixed" => false
		,"type" => "text"
	)
	,"parent_type" => array (
		"notnull" => false
		,"length" => 16
		,"fixed" => false
		,"type" => "text"
	)
	,"parent_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"location" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"location_type" => array (
		"notnull" => false
		,"length" => 16
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("il_meta_location", $fields);

$pk_fields = array("meta_location_id");
$ilDB->addPrimaryKey("il_meta_location", $pk_fields);

$in_fields = array("rbac_id","obj_id");
$ilDB->addIndex("il_meta_location", $in_fields, "i1", false);

$ilDB->createSequence("il_meta_location", 1);


//
// il_meta_meta_data
//
$fields = array (
	"meta_meta_data_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rbac_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => false
		,"length" => 6
		,"fixed" => true
		,"type" => "text"
	)
	,"meta_data_scheme" => array (
		"notnull" => false
		,"length" => 16
		,"fixed" => true
		,"type" => "text"
	)
	,"language" => array (
		"notnull" => false
		,"length" => 2
		,"fixed" => true
		,"type" => "text"
	)
);
$ilDB->createTable("il_meta_meta_data", $fields);

$pk_fields = array("meta_meta_data_id");
$ilDB->addPrimaryKey("il_meta_meta_data", $pk_fields);

$in_fields = array("rbac_id","obj_id");
$ilDB->addIndex("il_meta_meta_data", $in_fields, "i1", false);

$ilDB->createSequence("il_meta_meta_data", 1);


//
// il_meta_oer_stat
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"href_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"blocked" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_meta_oer_stat", $fields);

$pk_fields = array("obj_id");
$ilDB->addPrimaryKey("il_meta_oer_stat", $pk_fields);


//
// il_meta_relation
//
$fields = array (
	"meta_relation_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rbac_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => false
		,"length" => 6
		,"fixed" => true
		,"type" => "text"
	)
	,"kind" => array (
		"notnull" => false
		,"length" => 16
		,"fixed" => true
		,"type" => "text"
	)
);
$ilDB->createTable("il_meta_relation", $fields);

$pk_fields = array("meta_relation_id");
$ilDB->addPrimaryKey("il_meta_relation", $pk_fields);

$in_fields = array("rbac_id","obj_id");
$ilDB->addIndex("il_meta_relation", $in_fields, "i1", false);

$ilDB->createSequence("il_meta_relation", 1);


//
// il_meta_requirement
//
$fields = array (
	"meta_requirement_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rbac_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => false
		,"length" => 6
		,"fixed" => false
		,"type" => "text"
	)
	,"parent_type" => array (
		"notnull" => false
		,"length" => 16
		,"fixed" => false
		,"type" => "text"
	)
	,"parent_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"operating_system_name" => array (
		"notnull" => false
		,"length" => 16
		,"fixed" => false
		,"type" => "text"
	)
	,"os_min_version" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => true
		,"type" => "text"
	)
	,"os_max_version" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => true
		,"type" => "text"
	)
	,"browser_name" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"browser_minimum_version" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => true
		,"type" => "text"
	)
	,"browser_maximum_version" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => true
		,"type" => "text"
	)
	,"or_composite_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_meta_requirement", $fields);

$pk_fields = array("meta_requirement_id");
$ilDB->addPrimaryKey("il_meta_requirement", $pk_fields);

$in_fields = array("rbac_id","obj_id");
$ilDB->addIndex("il_meta_requirement", $in_fields, "i1", false);

$ilDB->createSequence("il_meta_requirement", 1);


//
// il_meta_rights
//
$fields = array (
	"meta_rights_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rbac_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => false
		,"length" => 6
		,"fixed" => false
		,"type" => "text"
	)
	,"costs" => array (
		"notnull" => false
		,"length" => 3
		,"fixed" => true
		,"type" => "text"
	)
	,"cpr_and_or" => array (
		"notnull" => false
		,"length" => 3
		,"fixed" => true
		,"type" => "text"
	)
	,"description" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"description_language" => array (
		"notnull" => false
		,"length" => 2
		,"fixed" => true
		,"type" => "text"
	)
);
$ilDB->createTable("il_meta_rights", $fields);

$pk_fields = array("meta_rights_id");
$ilDB->addPrimaryKey("il_meta_rights", $pk_fields);

$in_fields = array("rbac_id","obj_id");
$ilDB->addIndex("il_meta_rights", $in_fields, "i1", false);

$ilDB->createSequence("il_meta_rights", 1);


//
// il_meta_tar
//
$fields = array (
	"meta_tar_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rbac_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => false
		,"length" => 6
		,"fixed" => false
		,"type" => "text"
	)
	,"parent_type" => array (
		"notnull" => false
		,"length" => 16
		,"fixed" => false
		,"type" => "text"
	)
	,"parent_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"typical_age_range" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"tar_language" => array (
		"notnull" => false
		,"length" => 2
		,"fixed" => true
		,"type" => "text"
	)
	,"tar_min" => array (
		"notnull" => false
		,"length" => 2
		,"fixed" => true
		,"type" => "text"
	)
	,"tar_max" => array (
		"notnull" => false
		,"length" => 2
		,"fixed" => true
		,"type" => "text"
	)
);
$ilDB->createTable("il_meta_tar", $fields);

$pk_fields = array("meta_tar_id");
$ilDB->addPrimaryKey("il_meta_tar", $pk_fields);

$in_fields = array("rbac_id","obj_id");
$ilDB->addIndex("il_meta_tar", $in_fields, "i1", false);

$ilDB->createSequence("il_meta_tar", 1);


//
// il_meta_taxon
//
$fields = array (
	"meta_taxon_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rbac_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => false
		,"length" => 6
		,"fixed" => false
		,"type" => "text"
	)
	,"parent_type" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"parent_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"taxon" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"taxon_language" => array (
		"notnull" => false
		,"length" => 2
		,"fixed" => true
		,"type" => "text"
	)
	,"taxon_id" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("il_meta_taxon", $fields);

$pk_fields = array("meta_taxon_id");
$ilDB->addPrimaryKey("il_meta_taxon", $pk_fields);

$in_fields = array("rbac_id","obj_id");
$ilDB->addIndex("il_meta_taxon", $in_fields, "i1", false);

$ilDB->createSequence("il_meta_taxon", 1);


//
// il_meta_taxon_path
//
$fields = array (
	"meta_taxon_path_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rbac_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => false
		,"length" => 6
		,"fixed" => false
		,"type" => "text"
	)
	,"parent_type" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"parent_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"source" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"source_language" => array (
		"notnull" => false
		,"length" => 2
		,"fixed" => true
		,"type" => "text"
	)
);
$ilDB->createTable("il_meta_taxon_path", $fields);

$pk_fields = array("meta_taxon_path_id");
$ilDB->addPrimaryKey("il_meta_taxon_path", $pk_fields);

$in_fields = array("rbac_id","obj_id");
$ilDB->addIndex("il_meta_taxon_path", $in_fields, "i1", false);

$ilDB->createSequence("il_meta_taxon_path", 1);


//
// il_meta_technical
//
$fields = array (
	"meta_technical_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rbac_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => false
		,"length" => 6
		,"fixed" => false
		,"type" => "text"
	)
	,"t_size" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"ir" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"ir_language" => array (
		"notnull" => false
		,"length" => 2
		,"fixed" => true
		,"type" => "text"
	)
	,"opr" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"opr_language" => array (
		"notnull" => false
		,"length" => 2
		,"fixed" => true
		,"type" => "text"
	)
	,"duration" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("il_meta_technical", $fields);

$pk_fields = array("meta_technical_id");
$ilDB->addPrimaryKey("il_meta_technical", $pk_fields);

$in_fields = array("rbac_id","obj_id");
$ilDB->addIndex("il_meta_technical", $in_fields, "i1", false);

$ilDB->createSequence("il_meta_technical", 1);


//
// il_mm_actions
//
$fields = array (
	"identification" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"action" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"external" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("il_mm_actions", $fields);

$pk_fields = array("identification");
$ilDB->addPrimaryKey("il_mm_actions", $pk_fields);


//
// il_mm_custom_items
//
$fields = array (
	"identifier" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"type" => array (
		"notnull" => false
		,"length" => 128
		,"fixed" => false
		,"type" => "text"
	)
	,"action" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"top_item" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"default_title" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"role_based_visibility" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"global_role_ids" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("il_mm_custom_items", $fields);

$pk_fields = array("identifier");
$ilDB->addPrimaryKey("il_mm_custom_items", $pk_fields);


//
// il_mm_items
//
$fields = array (
	"identification" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"active" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"position" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"parent_identification" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"icon_id" => array (
		"notnull" => false
		,"length" => 250
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("il_mm_items", $fields);

$pk_fields = array("identification");
$ilDB->addPrimaryKey("il_mm_items", $pk_fields);


//
// il_mm_translation
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"identification" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"translation" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"language_key" => array (
		"notnull" => false
		,"length" => 8
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("il_mm_translation", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_mm_translation", $pk_fields);


//
// il_new_item_grp
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"titles" => array (
		"notnull" => false
		,"length" => 1000
		,"fixed" => false
		,"type" => "text"
	)
	,"pos" => array (
		"notnull" => true
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_new_item_grp", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_new_item_grp", $pk_fields);

$ilDB->createSequence("il_new_item_grp", 1);


//
// il_news_item
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"priority" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"content" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"context_obj_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"context_obj_type" => array (
		"notnull" => false
		,"length" => 10
		,"fixed" => false
		,"type" => "text"
	)
	,"context_sub_obj_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"context_sub_obj_type" => array (
		"notnull" => false
		,"length" => 10
		,"fixed" => false
		,"type" => "text"
	)
	,"content_type" => array (
		"notnull" => false
		,"length" => 5
		,"default" => "text"
		,"fixed" => true
		,"type" => "text"
	)
	,"creation_date" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"update_date" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"user_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"visibility" => array (
		"notnull" => false
		,"length" => 6
		,"default" => "users"
		,"fixed" => true
		,"type" => "text"
	)
	,"content_long" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"content_is_lang_var" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"mob_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"playtime" => array (
		"notnull" => false
		,"length" => 8
		,"fixed" => false
		,"type" => "text"
	)
	,"start_date" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"end_date" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"content_text_is_lang_var" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"mob_cnt_download" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"mob_cnt_play" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"content_html" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"update_user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_news_item", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_news_item", $pk_fields);

$in_fields = array("context_obj_id");
$ilDB->addIndex("il_news_item", $in_fields, "i1", false);

$in_fields = array("creation_date");
$ilDB->addIndex("il_news_item", $in_fields, "i2", false);

$in_fields = array("mob_id");
$ilDB->addIndex("il_news_item", $in_fields, "mo", false);

$ilDB->createSequence("il_news_item", 1);


//
// il_news_read
//
$fields = array (
	"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"news_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_news_read", $fields);

$pk_fields = array("user_id","news_id");
$ilDB->addPrimaryKey("il_news_read", $pk_fields);

$in_fields = array("user_id");
$ilDB->addIndex("il_news_read", $in_fields, "i1", false);

$in_fields = array("news_id");
$ilDB->addIndex("il_news_read", $in_fields, "i2", false);


//
// il_news_subscription
//
$fields = array (
	"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_news_subscription", $fields);

$pk_fields = array("user_id","ref_id");
$ilDB->addPrimaryKey("il_news_subscription", $pk_fields);


//
// il_object_def
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 10
		,"default" => ""
		,"fixed" => true
		,"type" => "text"
	)
	,"class_name" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"component" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"location" => array (
		"notnull" => false
		,"length" => 250
		,"fixed" => false
		,"type" => "text"
	)
	,"checkbox" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"inherit" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"translate" => array (
		"notnull" => false
		,"length" => 5
		,"fixed" => true
		,"type" => "text"
	)
	,"devmode" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"allow_link" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"allow_copy" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rbac" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"system" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sideblock" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"default_pos" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"grp" => array (
		"notnull" => false
		,"length" => 10
		,"fixed" => true
		,"type" => "text"
	)
	,"default_pres_pos" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"export" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"repository" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"workspace" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"administration" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"amet" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"orgunit_permissions" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"lti_provider" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"offline_handling" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_object_def", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_object_def", $pk_fields);

$ilDB->insert("il_object_def", array(
'id' => array('text', 'rlm'), 'class_name' => array('text', 'RemoteLearningModule'), 'component' => array('text', 'Modules/RemoteLearningModule'), 'location' => array('text', 'Modules/RemoteLearningModule/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '0'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '30'), 'grp' => array('text', 'lres'), 'default_pres_pos' => array('integer', '40'), 'export' => array('integer', '0'), 'repository' => array('integer', '0'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'iass'), 'class_name' => array('text', 'IndividualAssessment'), 'component' => array('text', 'Modules/IndividualAssessment'), 'location' => array('text', 'Modules/IndividualAssessment/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '1'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '190'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '190'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '1'), 'orgunit_permissions' => array('integer', '1'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'blog'), 'class_name' => array('text', 'Blog'), 'component' => array('text', 'Modules/Blog'), 'location' => array('text', 'Modules/Blog/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '1'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '330'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '330'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '1'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'blga'), 'class_name' => array('text', 'BlogAdministration'), 'component' => array('text', 'Modules/Blog'), 'location' => array('text', 'Modules/Blog/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'adm'), 'class_name' => array('text', 'SystemFolder'), 'component' => array('text', 'Modules/SystemFolder'), 'location' => array('text', 'Modules/SystemFolder/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'lm'), 'class_name' => array('text', 'LearningModule'), 'component' => array('text', 'Modules/LearningModule'), 'location' => array('text', 'Modules/LearningModule/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '1'), 'translate' => array('text', 'db'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '120'), 'grp' => array('text', 'lres'), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '1'), 'offline_handling' => array('integer', '1')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'lrss'), 'class_name' => array('text', 'LearningResourcesSettings'), 'component' => array('text', 'Modules/LearningModule'), 'location' => array('text', 'Modules/LearningModule/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'glo'), 'class_name' => array('text', 'Glossary'), 'component' => array('text', 'Modules/Glossary'), 'location' => array('text', 'Modules/Glossary/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '1'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '160'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '110'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'sahs'), 'class_name' => array('text', 'SAHSLearningModule'), 'component' => array('text', 'Modules/ScormAicc'), 'location' => array('text', 'Modules/ScormAicc/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '1'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '140'), 'grp' => array('text', 'lres'), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '1'), 'offline_handling' => array('integer', '1')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'scov'), 'class_name' => array('text', 'SCORMVerification'), 'component' => array('text', 'Modules/ScormAicc'), 'location' => array('text', 'Modules/ScormAicc/classes/Verification'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '0'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '90'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '150'), 'export' => array('integer', '0'), 'repository' => array('integer', '0'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'catr'), 'class_name' => array('text', 'CategoryReference'), 'component' => array('text', 'Modules/CategoryReference'), 'location' => array('text', 'Modules/CategoryReference/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '0'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '15'), 'grp' => array('text', 'cat'), 'default_pres_pos' => array('integer', '10'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'rwik'), 'class_name' => array('text', 'RemoteWiki'), 'component' => array('text', 'Modules/RemoteWiki'), 'location' => array('text', 'Modules/RemoteWiki/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '0'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '30'), 'grp' => array('text', 'wiki'), 'default_pres_pos' => array('integer', '40'), 'export' => array('integer', '0'), 'repository' => array('integer', '0'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'prgr'), 'class_name' => array('text', 'StudyProgrammeReference'), 'component' => array('text', 'Modules/StudyProgrammeReference'), 'location' => array('text', 'Modules/StudyProgrammeReference/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '0'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '25'), 'grp' => array('text', 'prg'), 'default_pres_pos' => array('integer', '20'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'exc'), 'class_name' => array('text', 'Exercise'), 'component' => array('text', 'Modules/Exercise'), 'location' => array('text', 'Modules/Exercise/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '1'), 'translate' => array('text', ''), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '170'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '160'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '1'), 'orgunit_permissions' => array('integer', '1'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'excs'), 'class_name' => array('text', 'ExerciseAdministration'), 'component' => array('text', 'Modules/Exercise'), 'location' => array('text', 'Modules/Exercise/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'excv'), 'class_name' => array('text', 'ExerciseVerification'), 'component' => array('text', 'Modules/Exercise'), 'location' => array('text', 'Modules/Exercise/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '0'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '100'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '160'), 'export' => array('integer', '0'), 'repository' => array('integer', '0'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'fold'), 'class_name' => array('text', 'Folder'), 'component' => array('text', 'Modules/Folder'), 'location' => array('text', 'Modules/Folder/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '1'), 'translate' => array('text', 'db'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '40'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '20'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'grpr'), 'class_name' => array('text', 'GroupReference'), 'component' => array('text', 'Modules/GroupReference'), 'location' => array('text', 'Modules/GroupReference/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '0'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '51'), 'grp' => array('text', 'grp'), 'default_pres_pos' => array('integer', '20'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'cld'), 'class_name' => array('text', 'Cloud'), 'component' => array('text', 'Modules/Cloud'), 'location' => array('text', 'Modules/Cloud/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '1'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '440'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '440'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'chtr'), 'class_name' => array('text', 'Chatroom'), 'component' => array('text', 'Modules/Chatroom'), 'location' => array('text', 'Modules/Chatroom/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '0'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '90'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '150'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'chta'), 'class_name' => array('text', 'ChatroomAdmin'), 'component' => array('text', 'Modules/Chatroom'), 'location' => array('text', 'Modules/Chatroom/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'htlm'), 'class_name' => array('text', 'FileBasedLM'), 'component' => array('text', 'Modules/HTMLLearningModule'), 'location' => array('text', 'Modules/HTMLLearningModule/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '1'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '130'), 'grp' => array('text', 'lres'), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '1')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'wfld'), 'class_name' => array('text', 'WorkspaceFolder'), 'component' => array('text', 'Modules/WorkspaceFolder'), 'location' => array('text', 'Modules/WorkspaceFolder/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '1'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '0'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '300'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '300'), 'export' => array('integer', '0'), 'repository' => array('integer', '0'), 'workspace' => array('integer', '1'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'qpl'), 'class_name' => array('text', 'QuestionPool'), 'component' => array('text', 'Modules/TestQuestionPool'), 'location' => array('text', 'Modules/TestQuestionPool/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '1'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '210'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '200'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'crsr'), 'class_name' => array('text', 'CourseReference'), 'component' => array('text', 'Modules/CourseReference'), 'location' => array('text', 'Modules/CourseReference/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '0'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '25'), 'grp' => array('text', 'crs'), 'default_pres_pos' => array('integer', '20'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'lso'), 'class_name' => array('text', 'LearningSequence'), 'component' => array('text', 'Modules/LearningSequence'), 'location' => array('text', 'Modules/LearningSequence/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '1'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '30'), 'grp' => array('text', 'lso'), 'default_pres_pos' => array('integer', '300'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'lsos'), 'class_name' => array('text', 'LearningSequenceAdmin'), 'component' => array('text', 'Modules/LearningSequence'), 'location' => array('text', 'Modules/LearningSequence/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'webr'), 'class_name' => array('text', 'LinkResource'), 'component' => array('text', 'Modules/WebResource'), 'location' => array('text', 'Modules/WebResource/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '0'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '100'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '120'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '1'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'wbrs'), 'class_name' => array('text', 'WebResourceAdministration'), 'component' => array('text', 'Modules/WebResource'), 'location' => array('text', 'Modules/WebResource/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'bibl'), 'class_name' => array('text', 'Bibliographic'), 'component' => array('text', 'Modules/Bibliographic'), 'location' => array('text', 'Modules/Bibliographic/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '1'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '360'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '360'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'bibs'), 'class_name' => array('text', 'BibliographicAdmin'), 'component' => array('text', 'Modules/Bibliographic'), 'location' => array('text', 'Modules/Bibliographic/classes/Admin'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'dcl'), 'class_name' => array('text', 'DataCollection'), 'component' => array('text', 'Modules/DataCollection'), 'location' => array('text', 'Modules/DataCollection/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '1'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '340'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '340'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'lti'), 'class_name' => array('text', 'LTIConsumer'), 'component' => array('text', 'Modules/LTIConsumer'), 'location' => array('text', 'Modules/LTIConsumer/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '1'), 'translate' => array('text', 'db'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '120'), 'grp' => array('text', 'lres'), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '1')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'ltiv'), 'class_name' => array('text', 'LTIConsumerVerification'), 'component' => array('text', 'Modules/LTIConsumer'), 'location' => array('text', 'Modules/LTIConsumer/classes/Verification'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '0'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '90'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '150'), 'export' => array('integer', '0'), 'repository' => array('integer', '0'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'sess'), 'class_name' => array('text', 'Session'), 'component' => array('text', 'Modules/Session'), 'location' => array('text', 'Modules/Session/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '0'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '15'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '15'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '1'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'frm'), 'class_name' => array('text', 'Forum'), 'component' => array('text', 'Modules/Forum'), 'location' => array('text', 'Modules/Forum/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '1'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '70'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '90'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'frma'), 'class_name' => array('text', 'ForumAdministration'), 'component' => array('text', 'Modules/Forum'), 'location' => array('text', 'Modules/Forum/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'rglo'), 'class_name' => array('text', 'RemoteGlossary'), 'component' => array('text', 'Modules/RemoteGlossary'), 'location' => array('text', 'Modules/RemoteGlossary/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '0'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '30'), 'grp' => array('text', 'glo'), 'default_pres_pos' => array('integer', '40'), 'export' => array('integer', '0'), 'repository' => array('integer', '0'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'book'), 'class_name' => array('text', 'BookingPool'), 'component' => array('text', 'Modules/BookingManager'), 'location' => array('text', 'Modules/BookingManager/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '1'), 'translate' => array('text', ''), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '250'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '250'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'rcrs'), 'class_name' => array('text', 'RemoteCourse'), 'component' => array('text', 'Modules/RemoteCourse'), 'location' => array('text', 'Modules/RemoteCourse/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '0'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '30'), 'grp' => array('text', 'crs'), 'default_pres_pos' => array('integer', '40'), 'export' => array('integer', '0'), 'repository' => array('integer', '0'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '1'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'tst'), 'class_name' => array('text', 'Test'), 'component' => array('text', 'Modules/Test'), 'location' => array('text', 'Modules/Test/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '1'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '180'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '170'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '1'), 'lti_provider' => array('integer', '1'), 'offline_handling' => array('integer', '1')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'assf'), 'class_name' => array('text', 'AssessmentFolder'), 'component' => array('text', 'Modules/Test'), 'location' => array('text', 'Modules/Test/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'tstv'), 'class_name' => array('text', 'TestVerification'), 'component' => array('text', 'Modules/Test'), 'location' => array('text', 'Modules/Test/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '0'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '90'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '150'), 'export' => array('integer', '0'), 'repository' => array('integer', '0'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'prtf'), 'class_name' => array('text', 'Portfolio'), 'component' => array('text', 'Modules/Portfolio'), 'location' => array('text', 'Modules/Portfolio/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '0'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '0'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'prtt'), 'class_name' => array('text', 'PortfolioTemplate'), 'component' => array('text', 'Modules/Portfolio'), 'location' => array('text', 'Modules/Portfolio/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '500'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '500'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'prfa'), 'class_name' => array('text', 'PortfolioAdministration'), 'component' => array('text', 'Modules/Portfolio'), 'location' => array('text', 'Modules/Portfolio/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'rtst'), 'class_name' => array('text', 'RemoteTest'), 'component' => array('text', 'Modules/RemoteTest'), 'location' => array('text', 'Modules/RemoteTest/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '0'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '30'), 'grp' => array('text', 'tst'), 'default_pres_pos' => array('integer', '40'), 'export' => array('integer', '0'), 'repository' => array('integer', '0'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'rcat'), 'class_name' => array('text', 'RemoteCategory'), 'component' => array('text', 'Modules/RemoteCategory'), 'location' => array('text', 'Modules/RemoteCategory/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '0'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '30'), 'grp' => array('text', 'cat'), 'default_pres_pos' => array('integer', '40'), 'export' => array('integer', '0'), 'repository' => array('integer', '0'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'crs'), 'class_name' => array('text', 'Course'), 'component' => array('text', 'Modules/Course'), 'location' => array('text', 'Modules/Course/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '1'), 'translate' => array('text', 'db'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '20'), 'grp' => array('text', 'crs'), 'default_pres_pos' => array('integer', '30'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '1'), 'orgunit_permissions' => array('integer', '1'), 'lti_provider' => array('integer', '1'), 'offline_handling' => array('integer', '1')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'crss'), 'class_name' => array('text', 'CourseAdministration'), 'component' => array('text', 'Modules/Course'), 'location' => array('text', 'Modules/Course/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'crsv'), 'class_name' => array('text', 'CourseVerification'), 'component' => array('text', 'Modules/Course'), 'location' => array('text', 'Modules/Course/classes/Verification'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '0'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '90'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '150'), 'export' => array('integer', '0'), 'repository' => array('integer', '0'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'copa'), 'class_name' => array('text', 'ContentPage'), 'component' => array('text', 'Modules/ContentPage'), 'location' => array('text', 'Modules/ContentPage/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '1'), 'translate' => array('text', 'db'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '340'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '340'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'cpad'), 'class_name' => array('text', 'ContentPageAdministration'), 'component' => array('text', 'Modules/ContentPage'), 'location' => array('text', 'Modules/ContentPage/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'root'), 'class_name' => array('text', 'RootFolder'), 'component' => array('text', 'Modules/RootFolder'), 'location' => array('text', 'Modules/RootFolder/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'rgrp'), 'class_name' => array('text', 'RemoteGroup'), 'component' => array('text', 'Modules/RemoteGroup'), 'location' => array('text', 'Modules/RemoteGroup/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '0'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '30'), 'grp' => array('text', 'grp'), 'default_pres_pos' => array('integer', '40'), 'export' => array('integer', '0'), 'repository' => array('integer', '0'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'rfil'), 'class_name' => array('text', 'RemoteFile'), 'component' => array('text', 'Modules/RemoteFile'), 'location' => array('text', 'Modules/RemoteFile/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '0'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '30'), 'grp' => array('text', 'file'), 'default_pres_pos' => array('integer', '40'), 'export' => array('integer', '0'), 'repository' => array('integer', '0'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'orgu'), 'class_name' => array('text', 'OrgUnit'), 'component' => array('text', 'Modules/OrgUnit'), 'location' => array('text', 'Modules/OrgUnit/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '1'), 'translate' => array('text', 'db'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '10'), 'grp' => array('text', 'orgu'), 'default_pres_pos' => array('integer', '10'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'file'), 'class_name' => array('text', 'File'), 'component' => array('text', 'Modules/File'), 'location' => array('text', 'Modules/File/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '0'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '90'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '150'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '1'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'facs'), 'class_name' => array('text', 'FileAccessSettings'), 'component' => array('text', 'Modules/File'), 'location' => array('text', 'Modules/File/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'itgr'), 'class_name' => array('text', 'ItemGroup'), 'component' => array('text', 'Modules/ItemGroup'), 'location' => array('text', 'Modules/ItemGroup/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '0'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '45'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '5'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'mcst'), 'class_name' => array('text', 'MediaCast'), 'component' => array('text', 'Modules/MediaCast'), 'location' => array('text', 'Modules/MediaCast/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '1'), 'translate' => array('text', ''), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '110'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '130'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'mcts'), 'class_name' => array('text', 'MediaCastSettings'), 'component' => array('text', 'Modules/MediaCast'), 'location' => array('text', 'Modules/MediaCast/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'prg'), 'class_name' => array('text', 'StudyProgramme'), 'component' => array('text', 'Modules/StudyProgramme'), 'location' => array('text', 'Modules/StudyProgramme/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '1'), 'translate' => array('text', 'db'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '30'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '30'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '1'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'prgs'), 'class_name' => array('text', 'StudyProgrammeAdmin'), 'component' => array('text', 'Modules/StudyProgramme'), 'location' => array('text', 'Modules/StudyProgramme/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'cmix'), 'class_name' => array('text', 'CmiXapi'), 'component' => array('text', 'Modules/CmiXapi'), 'location' => array('text', 'Modules/CmiXapi/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '1'), 'translate' => array('text', 'db'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '120'), 'grp' => array('text', 'lres'), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '1')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'cmis'), 'class_name' => array('text', 'CmiXapiAdministration'), 'component' => array('text', 'Modules/CmiXapi'), 'location' => array('text', 'Modules/CmiXapi/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'cmxv'), 'class_name' => array('text', 'CmiXapiVerification'), 'component' => array('text', 'Modules/CmiXapi'), 'location' => array('text', 'Modules/CmiXapi/classes/Verification'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '0'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '90'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '150'), 'export' => array('integer', '0'), 'repository' => array('integer', '0'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'grp'), 'class_name' => array('text', 'Group'), 'component' => array('text', 'Modules/Group'), 'location' => array('text', 'Modules/Group/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '1'), 'translate' => array('text', 'db'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '50'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '70'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '1'), 'orgunit_permissions' => array('integer', '1'), 'lti_provider' => array('integer', '1'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'grps'), 'class_name' => array('text', 'GroupAdministration'), 'component' => array('text', 'Modules/Group'), 'location' => array('text', 'Modules/Group/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'feed'), 'class_name' => array('text', 'ExternalFeed'), 'component' => array('text', 'Modules/ExternalFeed'), 'location' => array('text', 'Modules/ExternalFeed/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '1'), 'translate' => array('text', ''), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '1'), 'default_pos' => array('integer', '80'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'cat'), 'class_name' => array('text', 'Category'), 'component' => array('text', 'Modules/Category'), 'location' => array('text', 'Modules/Category/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '1'), 'translate' => array('text', 'db'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '10'), 'grp' => array('text', 'cat'), 'default_pres_pos' => array('integer', '10'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '1'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'mep'), 'class_name' => array('text', 'MediaPool'), 'component' => array('text', 'Modules/MediaPool'), 'location' => array('text', 'Modules/MediaPool/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '1'), 'translate' => array('text', 'db'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '200'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '190'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'wsrt'), 'class_name' => array('text', 'WorkspaceRootFolder'), 'component' => array('text', 'Modules/WorkspaceRootFolder'), 'location' => array('text', 'Modules/WorkspaceRootFolder/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '0'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '0'), 'workspace' => array('integer', '1'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'poll'), 'class_name' => array('text', 'Poll'), 'component' => array('text', 'Modules/Poll'), 'location' => array('text', 'Modules/Poll/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '1'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '1'), 'default_pos' => array('integer', '350'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '350'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '1'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'wiki'), 'class_name' => array('text', 'Wiki'), 'component' => array('text', 'Modules/Wiki'), 'location' => array('text', 'Modules/Wiki/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '1'), 'translate' => array('text', ''), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '115'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '140'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'wiks'), 'class_name' => array('text', 'WikiSettings'), 'component' => array('text', 'Modules/Wiki'), 'location' => array('text', 'Modules/Wiki/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'spl'), 'class_name' => array('text', 'SurveyQuestionPool'), 'component' => array('text', 'Modules/SurveyQuestionPool'), 'location' => array('text', 'Modules/SurveyQuestionPool/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '1'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '220'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '210'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'svy'), 'class_name' => array('text', 'Survey'), 'component' => array('text', 'Modules/Survey'), 'location' => array('text', 'Modules/Survey/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '1'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '1'), 'allow_copy' => array('integer', '1'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '190'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '180'), 'export' => array('integer', '1'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '1'), 'lti_provider' => array('integer', '1'), 'offline_handling' => array('integer', '1')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'svyf'), 'class_name' => array('text', 'SurveyAdministration'), 'component' => array('text', 'Modules/Survey'), 'location' => array('text', 'Modules/Survey/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'nwss'), 'class_name' => array('text', 'NewsSettings'), 'component' => array('text', 'Services/News'), 'location' => array('text', 'Services/News/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'prss'), 'class_name' => array('text', 'PersonalWorkspaceSettings'), 'component' => array('text', 'Services/PersonalWorkspace'), 'location' => array('text', 'Services/PersonalWorkspace/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'otpl'), 'class_name' => array('text', 'ObjectTemplateAdministration'), 'component' => array('text', 'Services/DidacticTemplate'), 'location' => array('text', 'Services/DidacticTemplate/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'ps'), 'class_name' => array('text', 'PrivacySecurity'), 'component' => array('text', 'Services/PrivacySecurity'), 'location' => array('text', 'Services/PrivacySecurity/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'dshs'), 'class_name' => array('text', 'DashboardSettings'), 'component' => array('text', 'Services/Dashboard'), 'location' => array('text', 'Services/Dashboard/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'mds'), 'class_name' => array('text', 'MDSettings'), 'component' => array('text', 'Services/MetaData'), 'location' => array('text', 'Services/MetaData/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'adn'), 'class_name' => array('text', 'AdministrativeNotification'), 'component' => array('text', 'Services/AdministrativeNotification'), 'location' => array('text', 'Services/AdministrativeNotification/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'tax'), 'class_name' => array('text', 'Taxonomy'), 'component' => array('text', 'Services/Taxonomy'), 'location' => array('text', 'Services/Taxonomy/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '0'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '0'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'taxs'), 'class_name' => array('text', 'TaxonomyAdministration'), 'component' => array('text', 'Services/Taxonomy'), 'location' => array('text', 'Services/Taxonomy/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'cadm'), 'class_name' => array('text', 'ContactAdministration'), 'component' => array('text', 'Services/Contact'), 'location' => array('text', 'Services/Contact/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '1'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'ltis'), 'class_name' => array('text', 'LTIAdministration'), 'component' => array('text', 'Services/LTI'), 'location' => array('text', 'Services/LTI/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'mme'), 'class_name' => array('text', 'MainMenu'), 'component' => array('text', 'Services/MainMenu'), 'location' => array('text', 'Services/MainMenu/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'rolf'), 'class_name' => array('text', 'RoleFolder'), 'component' => array('text', 'Services/AccessControl'), 'location' => array('text', 'Services/AccessControl/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'role'), 'class_name' => array('text', 'Role'), 'component' => array('text', 'Services/AccessControl'), 'location' => array('text', 'Services/AccessControl/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '0'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '0'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'rolt'), 'class_name' => array('text', 'RoleTemplate'), 'component' => array('text', 'Services/AccessControl'), 'location' => array('text', 'Services/AccessControl/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '0'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '0'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'tos'), 'class_name' => array('text', 'TermsOfService'), 'component' => array('text', 'Services/TermsOfService'), 'location' => array('text', 'Services/TermsOfService/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'adve'), 'class_name' => array('text', 'AdvancedEditing'), 'component' => array('text', 'Services/AdvancedEditing'), 'location' => array('text', 'Services/AdvancedEditing/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'auth'), 'class_name' => array('text', 'AuthSettings'), 'component' => array('text', 'Services/Authentication'), 'location' => array('text', 'Services/Authentication/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'cert'), 'class_name' => array('text', 'CertificateSettings'), 'component' => array('text', 'Services/Certificate'), 'location' => array('text', 'Services/Certificate/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'wfe'), 'class_name' => array('text', 'WorkflowEngine'), 'component' => array('text', 'Services/WorkflowEngine'), 'location' => array('text', 'Services/WorkflowEngine/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'cals'), 'class_name' => array('text', 'CalendarSettings'), 'component' => array('text', 'Services/Calendar'), 'location' => array('text', 'Services/Calendar/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'accs'), 'class_name' => array('text', 'AccessibilitySettings'), 'component' => array('text', 'Services/Accessibility'), 'location' => array('text', 'Services/Accessibility/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'nots'), 'class_name' => array('text', 'NotesSettings'), 'component' => array('text', 'Services/Notes'), 'location' => array('text', 'Services/Notes/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'coms'), 'class_name' => array('text', 'CommentsSettings'), 'component' => array('text', 'Services/Notes'), 'location' => array('text', 'Services/Notes/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'nota'), 'class_name' => array('text', 'NotificationAdmin'), 'component' => array('text', 'Services/Notifications'), 'location' => array('text', 'Services/Notifications/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '0'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'wbdv'), 'class_name' => array('text', 'WebDAV'), 'component' => array('text', 'Services/WebDAV'), 'location' => array('text', 'Services/WebDAV/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'seas'), 'class_name' => array('text', 'SearchSettings'), 'component' => array('text', 'Services/Search'), 'location' => array('text', 'Services/Search/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'lngf'), 'class_name' => array('text', 'LanguageFolder'), 'component' => array('text', 'Services/Language'), 'location' => array('text', 'Services/Language/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'lng'), 'class_name' => array('text', 'Language'), 'component' => array('text', 'Services/Language'), 'location' => array('text', 'Services/Language/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '0'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '0'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'tags'), 'class_name' => array('text', 'TaggingSettings'), 'component' => array('text', 'Services/Tagging'), 'location' => array('text', 'Services/Tagging/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'skmg'), 'class_name' => array('text', 'SkillManagement'), 'component' => array('text', 'Services/Skill'), 'location' => array('text', 'Services/Skill/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'mobs'), 'class_name' => array('text', 'MediaObjectsSettings'), 'component' => array('text', 'Services/MediaObjects'), 'location' => array('text', 'Services/MediaObjects/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'reps'), 'class_name' => array('text', 'RepositorySettings'), 'component' => array('text', 'Services/Repository'), 'location' => array('text', 'Services/Repository/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'bdga'), 'class_name' => array('text', 'BadgeAdministration'), 'component' => array('text', 'Services/Badge'), 'location' => array('text', 'Services/Badge/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'sty'), 'class_name' => array('text', 'StyleSheet'), 'component' => array('text', 'Services/Style'), 'location' => array('text', 'Services/Style/Content/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '0'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '0'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'stys'), 'class_name' => array('text', 'StyleSettings'), 'component' => array('text', 'Services/Style'), 'location' => array('text', 'Services/Style/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'usr'), 'class_name' => array('text', 'User'), 'component' => array('text', 'Services/User'), 'location' => array('text', 'Services/User/classes'), 'checkbox' => array('integer', '1'), 'inherit' => array('integer', '0'), 'translate' => array('text', '0'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '0'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'usrf'), 'class_name' => array('text', 'UserFolder'), 'component' => array('text', 'Services/User'), 'location' => array('text', 'Services/User/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '1'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '1'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'sysc'), 'class_name' => array('text', 'SystemCheck'), 'component' => array('text', 'Services/SystemCheck'), 'location' => array('text', 'Services/SystemCheck/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'mail'), 'class_name' => array('text', 'Mail'), 'component' => array('text', 'Services/Mail'), 'location' => array('text', 'Services/Mail/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '0'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'objf'), 'class_name' => array('text', 'ObjectFolder'), 'component' => array('text', 'Services/Object'), 'location' => array('text', 'Services/Object/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '1'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'logs'), 'class_name' => array('text', 'LoggingSettings'), 'component' => array('text', 'Services/Logging'), 'location' => array('text', 'Services/Logging/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '1'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'lhts'), 'class_name' => array('text', 'LearningHistorySettings'), 'component' => array('text', 'Services/LearningHistory'), 'location' => array('text', 'Services/LearningHistory/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'pdfg'), 'class_name' => array('text', 'PDFGeneration'), 'component' => array('text', 'Services/PDFGeneration'), 'location' => array('text', 'Services/PDFGeneration/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '0'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'cmps'), 'class_name' => array('text', 'ComponentSettings'), 'component' => array('text', 'Services/Component'), 'location' => array('text', 'Services/Component/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'hlps'), 'class_name' => array('text', 'HelpSettings'), 'component' => array('text', 'Services/Help'), 'location' => array('text', 'Services/Help/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'fils'), 'class_name' => array('text', 'FileServices'), 'component' => array('text', 'Services/FileServices'), 'location' => array('text', 'Services/FileServices/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'awra'), 'class_name' => array('text', 'AwarenessAdministration'), 'component' => array('text', 'Services/Awareness'), 'location' => array('text', 'Services/Awareness/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'recf'), 'class_name' => array('text', 'RecoveryFolder'), 'component' => array('text', 'Services/Administration'), 'location' => array('text', 'Services/Administration/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'extt'), 'class_name' => array('text', 'ExternalToolsSettings'), 'component' => array('text', 'Services/Administration'), 'location' => array('text', 'Services/Administration/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'trac'), 'class_name' => array('text', 'UserTracking'), 'component' => array('text', 'Services/Tracking'), 'location' => array('text', 'Services/Tracking/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));

$ilDB->insert("il_object_def", array(
'id' => array('text', 'ecss'), 'class_name' => array('text', 'ECSSettings'), 'component' => array('text', 'Services/WebServices'), 'location' => array('text', 'Services/WebServices/ECS/classes'), 'checkbox' => array('integer', '0'), 'inherit' => array('integer', '0'), 'translate' => array('text', 'sys'), 'devmode' => array('integer', '0'), 'allow_link' => array('integer', '0'), 'allow_copy' => array('integer', '0'), 'rbac' => array('integer', '1'), 'system' => array('integer', '1'), 'sideblock' => array('integer', '0'), 'default_pos' => array('integer', '0'), 'grp' => array('text', ''), 'default_pres_pos' => array('integer', '0'), 'export' => array('integer', '0'), 'repository' => array('integer', '1'), 'workspace' => array('integer', '0'), 'administration' => array('integer', '1'), 'amet' => array('integer', '0'), 'orgunit_permissions' => array('integer', '0'), 'lti_provider' => array('integer', '0'), 'offline_handling' => array('integer', '0')));


//
// il_object_group
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 10
		,"default" => ""
		,"fixed" => true
		,"type" => "text"
	)
	,"name" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"default_pres_pos" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_object_group", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_object_group", $pk_fields);

$ilDB->insert("il_object_group", array(
'id' => array('text', 'iass'), 'name' => array('text', 'IndividualAssessment'), 'default_pres_pos' => array('integer', '170')));

$ilDB->insert("il_object_group", array(
'id' => array('text', 'lres'), 'name' => array('text', 'LearningResources'), 'default_pres_pos' => array('integer', '100')));

$ilDB->insert("il_object_group", array(
'id' => array('text', 'glo'), 'name' => array('text', 'Glossaries'), 'default_pres_pos' => array('integer', '110')));

$ilDB->insert("il_object_group", array(
'id' => array('text', 'lso'), 'name' => array('text', 'LearningSequence'), 'default_pres_pos' => array('integer', '300')));

$ilDB->insert("il_object_group", array(
'id' => array('text', 'tst'), 'name' => array('text', 'Tests'), 'default_pres_pos' => array('integer', '170')));

$ilDB->insert("il_object_group", array(
'id' => array('text', 'crs'), 'name' => array('text', 'Courses'), 'default_pres_pos' => array('integer', '30')));

$ilDB->insert("il_object_group", array(
'id' => array('text', 'orgu'), 'name' => array('text', 'Organisational Unit'), 'default_pres_pos' => array('integer', '10')));

$ilDB->insert("il_object_group", array(
'id' => array('text', 'file'), 'name' => array('text', 'Files'), 'default_pres_pos' => array('integer', '150')));

$ilDB->insert("il_object_group", array(
'id' => array('text', 'prg'), 'name' => array('text', 'StudyProgramme'), 'default_pres_pos' => array('integer', '30')));

$ilDB->insert("il_object_group", array(
'id' => array('text', 'grp'), 'name' => array('text', 'Groups'), 'default_pres_pos' => array('integer', '70')));

$ilDB->insert("il_object_group", array(
'id' => array('text', 'cat'), 'name' => array('text', 'Categories'), 'default_pres_pos' => array('integer', '10')));

$ilDB->insert("il_object_group", array(
'id' => array('text', 'wiki'), 'name' => array('text', 'Wikis'), 'default_pres_pos' => array('integer', '140')));


//
// il_object_sub_type
//
$fields = array (
	"obj_type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"sub_type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"amet" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_object_sub_type", $fields);

$pk_fields = array("obj_type","sub_type");
$ilDB->addPrimaryKey("il_object_sub_type", $pk_fields);

$ilDB->insert("il_object_sub_type", array(
'obj_type' => array('text', 'glo'), 'sub_type' => array('text', 'term'), 'amet' => array('integer', '1')));

$ilDB->insert("il_object_sub_type", array(
'obj_type' => array('text', 'book'), 'sub_type' => array('text', 'bobj'), 'amet' => array('integer', '1')));

$ilDB->insert("il_object_sub_type", array(
'obj_type' => array('text', 'orgu'), 'sub_type' => array('text', 'orgu_type'), 'amet' => array('integer', '1')));

$ilDB->insert("il_object_sub_type", array(
'obj_type' => array('text', 'prg'), 'sub_type' => array('text', 'prg_type'), 'amet' => array('integer', '1')));

$ilDB->insert("il_object_sub_type", array(
'obj_type' => array('text', 'mep'), 'sub_type' => array('text', 'mob'), 'amet' => array('integer', '1')));

$ilDB->insert("il_object_sub_type", array(
'obj_type' => array('text', 'wiki'), 'sub_type' => array('text', 'wpg'), 'amet' => array('integer', '1')));


//
// il_object_subobj
//
$fields = array (
	"parent" => array (
		"notnull" => true
		,"length" => 10
		,"default" => ""
		,"fixed" => true
		,"type" => "text"
	)
	,"subobj" => array (
		"notnull" => true
		,"length" => 10
		,"default" => ""
		,"fixed" => true
		,"type" => "text"
	)
	,"mmax" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_object_subobj", $fields);

$pk_fields = array("parent","subobj");
$ilDB->addPrimaryKey("il_object_subobj", $pk_fields);

$in_fields = array("subobj");
$ilDB->addIndex("il_object_subobj", $in_fields, "i1", false);

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'rlm'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'rlm'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'iass'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'iass'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'fold'), 'subobj' => array('text', 'iass'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'iass'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'iass'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'blog'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'blog'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'fold'), 'subobj' => array('text', 'blog'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'blog'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'blog'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'blog'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'wfld'), 'subobj' => array('text', 'blog'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'wsrt'), 'subobj' => array('text', 'blog'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'blga'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'lm'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'lm'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'fold'), 'subobj' => array('text', 'lm'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'lm'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'lm'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'lm'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'lrss'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'glo'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'glo'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'fold'), 'subobj' => array('text', 'glo'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'glo'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'glo'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'glo'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'sahs'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'sahs'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'fold'), 'subobj' => array('text', 'sahs'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'sahs'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'sahs'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'sahs'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'wsrt'), 'subobj' => array('text', 'scov'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'wfld'), 'subobj' => array('text', 'scov'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'catr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'catr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'catr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'catr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'catr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'rwik'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'rwik'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'prg'), 'subobj' => array('text', 'prgr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'prgr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'prgr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'prgr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'exc'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'exc'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'fold'), 'subobj' => array('text', 'exc'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'exc'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'exc'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'exc'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'excs'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'wsrt'), 'subobj' => array('text', 'excv'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'wfld'), 'subobj' => array('text', 'excv'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'fold'), 'subobj' => array('text', 'fold'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'fold'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'fold'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'fold'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'grpr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'grpr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'grpr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'grpr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'grpr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'cld'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'cld'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'fold'), 'subobj' => array('text', 'cld'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'cld'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'cld'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'cld'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'chtr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'chtr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'fold'), 'subobj' => array('text', 'chtr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'chtr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'chtr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'chtr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'chta'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'htlm'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'htlm'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'fold'), 'subobj' => array('text', 'htlm'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'htlm'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'htlm'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'htlm'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'wfld'), 'subobj' => array('text', 'wfld'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'wsrt'), 'subobj' => array('text', 'wfld'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'qpl'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'qpl'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'fold'), 'subobj' => array('text', 'qpl'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'qpl'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'qpl'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'qpl'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'crsr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'crsr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'crsr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'crsr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'crsr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'lso'), 'subobj' => array('text', 'rolf'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'lso'), 'subobj' => array('text', 'htlm'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'lso'), 'subobj' => array('text', 'sahs'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'lso'), 'subobj' => array('text', 'tst'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'lso'), 'subobj' => array('text', 'svy'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'lso'), 'subobj' => array('text', 'copa'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'lso'), 'subobj' => array('text', 'exc'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'lso'), 'subobj' => array('text', 'lm'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'lso'), 'subobj' => array('text', 'iass'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'lso'), 'subobj' => array('text', 'file'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'lso'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'lso'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'lso'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'lso'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'fold'), 'subobj' => array('text', 'lso'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'lsos'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'webr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'webr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'fold'), 'subobj' => array('text', 'webr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'webr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'webr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'webr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'wfld'), 'subobj' => array('text', 'webr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'wsrt'), 'subobj' => array('text', 'webr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'wbrs'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'bibl'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'bibl'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'fold'), 'subobj' => array('text', 'bibl'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'bibl'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'bibl'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'bibl'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'bibs'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'dcl'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'dcl'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'fold'), 'subobj' => array('text', 'dcl'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'dcl'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'dcl'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'dcl'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'lti'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'lti'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'fold'), 'subobj' => array('text', 'lti'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'lti'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'lti'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'lti'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'wsrt'), 'subobj' => array('text', 'ltiv'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'wfld'), 'subobj' => array('text', 'ltiv'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'sess'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'sess'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'sess'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'fold'), 'subobj' => array('text', 'sess'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'frm'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'frm'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'fold'), 'subobj' => array('text', 'frm'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'frm'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'frm'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'frm'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'frma'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'rglo'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'rglo'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'book'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'book'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'book'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'book'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'fold'), 'subobj' => array('text', 'book'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'rcrs'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'rcrs'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'rcrs'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'rcrs'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'tst'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'tst'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'fold'), 'subobj' => array('text', 'tst'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'tst'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'tst'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'tst'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'assf'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'wsrt'), 'subobj' => array('text', 'tstv'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'wfld'), 'subobj' => array('text', 'tstv'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'prtt'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'prtt'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'fold'), 'subobj' => array('text', 'prtt'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'prtt'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'prtt'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'prtt'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'prfa'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'rtst'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'rtst'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'rcat'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'rcat'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'rcat'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'rcat'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'crs'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'crs'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'crs'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'crss'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'wsrt'), 'subobj' => array('text', 'crsv'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'wfld'), 'subobj' => array('text', 'crsv'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'copa'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'copa'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'fold'), 'subobj' => array('text', 'copa'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'copa'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'copa'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'copa'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'cpad'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'adm'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'rgrp'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'rgrp'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'rgrp'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'rgrp'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'rfil'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'rfil'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'orgu'), 'subobj' => array('text', 'orgu'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'orgu'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'file'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'file'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'fold'), 'subobj' => array('text', 'file'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'file'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'file'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'file'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'wsrt'), 'subobj' => array('text', 'file'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'wfld'), 'subobj' => array('text', 'file'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'facs'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'itgr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'itgr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'fold'), 'subobj' => array('text', 'itgr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'itgr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'itgr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'itgr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'mcst'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'mcst'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'fold'), 'subobj' => array('text', 'mcst'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'mcst'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'mcst'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'mcst'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'mcts'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'prg'), 'subobj' => array('text', 'rolf'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'prg'), 'subobj' => array('text', 'crsr'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'prg'), 'subobj' => array('text', 'prg'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'prg'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'prg'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'prg'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'prgs'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'cmix'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'cmix'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'fold'), 'subobj' => array('text', 'cmix'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'cmix'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'cmix'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'cmix'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'cmis'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'wsrt'), 'subobj' => array('text', 'cmxv'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'wfld'), 'subobj' => array('text', 'cmxv'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'grp'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'grp'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'grp'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'fold'), 'subobj' => array('text', 'grp'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'grp'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'grp'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'grps'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'feed'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'feed'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'feed'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'feed'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'cat'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'cat'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'cat'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'mep'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'mep'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'fold'), 'subobj' => array('text', 'mep'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'mep'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'mep'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'mep'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'poll'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'poll'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'fold'), 'subobj' => array('text', 'poll'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'poll'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'poll'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'poll'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'wiki'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'wiki'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'fold'), 'subobj' => array('text', 'wiki'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'wiki'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'wiki'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'wiki'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'wiks'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'spl'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'spl'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'fold'), 'subobj' => array('text', 'spl'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'spl'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'spl'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'spl'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'cat'), 'subobj' => array('text', 'svy'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'crs'), 'subobj' => array('text', 'svy'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'fold'), 'subobj' => array('text', 'svy'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'grp'), 'subobj' => array('text', 'svy'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'recf'), 'subobj' => array('text', 'svy'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'root'), 'subobj' => array('text', 'svy'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'svyf'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'nwss'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'prss'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'otpl'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'ps'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'dshs'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'mds'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'adn'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'taxs'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'cadm'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'ltis'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'mme'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'rolf'), 'subobj' => array('text', 'rolt'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'rolf'), 'subobj' => array('text', 'role'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'rolf'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'tos'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'adve'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'auth'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'cert'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'wfe'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'cals'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'accs'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'nots'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'coms'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'nota'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'wbdv'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'seas'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'lngf'), 'subobj' => array('text', 'lng'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'lngf'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'tags'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'skmg'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'mobs'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'reps'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'bdga'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'stys'), 'subobj' => array('text', 'sty'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'stys'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'usrf'), 'subobj' => array('text', 'usr'), 'mmax' => array('integer', '0')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'usrf'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'sysc'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'mail'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'objf'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'logs'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'lhts'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'pdfg'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'cmps'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'hlps'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'fils'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'awra'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'recf'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'extt'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'trac'), 'mmax' => array('integer', '1')));

$ilDB->insert("il_object_subobj", array(
'parent' => array('text', 'adm'), 'subobj' => array('text', 'ecss'), 'mmax' => array('integer', '1')));


//
// il_orgu_authority
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"over" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"scope" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"position_id" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("il_orgu_authority", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_orgu_authority", $pk_fields);

$ilDB->createSequence("il_orgu_authority", 2);

$ilDB->insert("il_orgu_authority", array(
'id' => array('integer', '1'), 'over' => array('integer', '1'), 'scope' => array('integer', '1'), 'position_id' => array('integer', '2')));


//
// il_orgu_op_contexts
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"context" => array (
		"notnull" => false
		,"length" => 16
		,"fixed" => false
		,"type" => "text"
	)
	,"parent_context_id" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("il_orgu_op_contexts", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_orgu_op_contexts", $pk_fields);

$ilDB->createSequence("il_orgu_op_contexts", 10);

$ilDB->insert("il_orgu_op_contexts", array(
'id' => array('integer', '1'), 'context' => array('text', 'object'), 'parent_context_id' => array('integer', '0')));

$ilDB->insert("il_orgu_op_contexts", array(
'id' => array('integer', '2'), 'context' => array('text', 'iass'), 'parent_context_id' => array('integer', '1')));

$ilDB->insert("il_orgu_op_contexts", array(
'id' => array('integer', '3'), 'context' => array('text', 'crs'), 'parent_context_id' => array('integer', '1')));

$ilDB->insert("il_orgu_op_contexts", array(
'id' => array('integer', '4'), 'context' => array('text', 'grp'), 'parent_context_id' => array('integer', '1')));

$ilDB->insert("il_orgu_op_contexts", array(
'id' => array('integer', '5'), 'context' => array('text', 'tst'), 'parent_context_id' => array('integer', '1')));

$ilDB->insert("il_orgu_op_contexts", array(
'id' => array('integer', '6'), 'context' => array('text', 'exc'), 'parent_context_id' => array('integer', '1')));

$ilDB->insert("il_orgu_op_contexts", array(
'id' => array('integer', '7'), 'context' => array('text', 'svy'), 'parent_context_id' => array('integer', '1')));

$ilDB->insert("il_orgu_op_contexts", array(
'id' => array('integer', '8'), 'context' => array('text', 'prg'), 'parent_context_id' => array('integer', '1')));

$ilDB->insert("il_orgu_op_contexts", array(
'id' => array('integer', '9'), 'context' => array('text', 'usrf'), 'parent_context_id' => array('integer', '1')));


//
// il_orgu_operations
//
$fields = array (
	"operation_id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"operation_string" => array (
		"notnull" => false
		,"length" => 127
		,"fixed" => false
		,"type" => "text"
	)
	,"description" => array (
		"notnull" => false
		,"length" => 512
		,"fixed" => false
		,"type" => "text"
	)
	,"list_order" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"type" => "integer"
	)
	,"context_id" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("il_orgu_operations", $fields);

$pk_fields = array("operation_id");
$ilDB->addPrimaryKey("il_orgu_operations", $pk_fields);

$in_fields = array("operation_string");
$ilDB->addIndex("il_orgu_operations", $in_fields, "i1", false);

$in_fields = array("list_order");
$ilDB->addIndex("il_orgu_operations", $in_fields, "i3", false);

$in_fields = array("context_id");
$ilDB->addIndex("il_orgu_operations", $in_fields, "i4", false);

$ilDB->createSequence("il_orgu_operations", 29);

$ilDB->insert("il_orgu_operations", array(
'operation_id' => array('integer', '1'), 'operation_string' => array('text', 'read_learning_progress'), 'description' => array('text', 'Read the learning Progress of a User'), 'list_order' => array('integer', '0'), 'context_id' => array('integer', '3')));

$ilDB->insert("il_orgu_operations", array(
'operation_id' => array('integer', '2'), 'operation_string' => array('text', 'read_learning_progress'), 'description' => array('text', 'Read the learning Progress of a User'), 'list_order' => array('integer', '0'), 'context_id' => array('integer', '4')));

$ilDB->insert("il_orgu_operations", array(
'operation_id' => array('integer', '3'), 'operation_string' => array('text', 'read_learning_progress'), 'description' => array('text', 'Read the learning Progress of a User'), 'list_order' => array('integer', '0'), 'context_id' => array('integer', '2')));

$ilDB->insert("il_orgu_operations", array(
'operation_id' => array('integer', '4'), 'operation_string' => array('text', 'read_learning_progress'), 'description' => array('text', 'Read the learning Progress of a User'), 'list_order' => array('integer', '0'), 'context_id' => array('integer', '6')));

$ilDB->insert("il_orgu_operations", array(
'operation_id' => array('integer', '5'), 'operation_string' => array('text', 'read_learning_progress'), 'description' => array('text', 'Read the learning Progress of a User'), 'list_order' => array('integer', '0'), 'context_id' => array('integer', '7')));

$ilDB->insert("il_orgu_operations", array(
'operation_id' => array('integer', '6'), 'operation_string' => array('text', 'manage_members'), 'description' => array('text', 'Edit Members in a course'), 'list_order' => array('integer', '0'), 'context_id' => array('integer', '3')));

$ilDB->insert("il_orgu_operations", array(
'operation_id' => array('integer', '7'), 'operation_string' => array('text', 'manage_members'), 'description' => array('text', 'Edit Members in a group'), 'list_order' => array('integer', '0'), 'context_id' => array('integer', '4')));

$ilDB->insert("il_orgu_operations", array(
'operation_id' => array('integer', '8'), 'operation_string' => array('text', 'edit_submissions_grades'), 'description' => array('text', ''), 'list_order' => array('integer', '0'), 'context_id' => array('integer', '6')));

$ilDB->insert("il_orgu_operations", array(
'operation_id' => array('integer', '9'), 'operation_string' => array('text', 'access_results'), 'description' => array('text', ''), 'list_order' => array('integer', '0'), 'context_id' => array('integer', '7')));

$ilDB->insert("il_orgu_operations", array(
'operation_id' => array('integer', '10'), 'operation_string' => array('text', 'write_learning_progress'), 'description' => array('text', 'Write the learning Progress of a User'), 'list_order' => array('integer', '0'), 'context_id' => array('integer', '2')));

$ilDB->insert("il_orgu_operations", array(
'operation_id' => array('integer', '11'), 'operation_string' => array('text', 'access_enrolments'), 'description' => array('text', 'Access Enrolments in a course'), 'list_order' => array('integer', '0'), 'context_id' => array('integer', '3')));

$ilDB->insert("il_orgu_operations", array(
'operation_id' => array('integer', '12'), 'operation_string' => array('text', 'read_learning_progress'), 'description' => array('text', 'Read Test Participants Learning Progress'), 'list_order' => array('integer', '0'), 'context_id' => array('integer', '5')));

$ilDB->insert("il_orgu_operations", array(
'operation_id' => array('integer', '13'), 'operation_string' => array('text', 'access_results'), 'description' => array('text', 'Access Test Participants Results'), 'list_order' => array('integer', '0'), 'context_id' => array('integer', '5')));

$ilDB->insert("il_orgu_operations", array(
'operation_id' => array('integer', '14'), 'operation_string' => array('text', 'manage_participants'), 'description' => array('text', 'Manage Test Participants'), 'list_order' => array('integer', '0'), 'context_id' => array('integer', '5')));

$ilDB->insert("il_orgu_operations", array(
'operation_id' => array('integer', '15'), 'operation_string' => array('text', 'score_participants'), 'description' => array('text', 'Score Test Participants'), 'list_order' => array('integer', '0'), 'context_id' => array('integer', '5')));

$ilDB->insert("il_orgu_operations", array(
'operation_id' => array('integer', '16'), 'operation_string' => array('text', 'view_members'), 'description' => array('text', 'View Memberships of other users'), 'list_order' => array('integer', '0'), 'context_id' => array('integer', '8')));

$ilDB->insert("il_orgu_operations", array(
'operation_id' => array('integer', '17'), 'operation_string' => array('text', 'read_learning_progress'), 'description' => array('text', 'View learning progress of other users'), 'list_order' => array('integer', '0'), 'context_id' => array('integer', '8')));

$ilDB->insert("il_orgu_operations", array(
'operation_id' => array('integer', '18'), 'operation_string' => array('text', 'view_individual_plan'), 'description' => array('text', 'View Individual Plans of other users'), 'list_order' => array('integer', '0'), 'context_id' => array('integer', '8')));

$ilDB->insert("il_orgu_operations", array(
'operation_id' => array('integer', '19'), 'operation_string' => array('text', 'edit_individual_plan'), 'description' => array('text', 'Edit Individual Plans of other users'), 'list_order' => array('integer', '0'), 'context_id' => array('integer', '8')));

$ilDB->insert("il_orgu_operations", array(
'operation_id' => array('integer', '20'), 'operation_string' => array('text', 'manage_members'), 'description' => array('text', 'Manage Memberships of other users'), 'list_order' => array('integer', '0'), 'context_id' => array('integer', '8')));

$ilDB->insert("il_orgu_operations", array(
'operation_id' => array('integer', '21'), 'operation_string' => array('text', 'edit_user_accounts'), 'description' => array('text', 'Edit User in User Administration'), 'list_order' => array('integer', '0'), 'context_id' => array('integer', '9')));

$ilDB->insert("il_orgu_operations", array(
'operation_id' => array('integer', '22'), 'operation_string' => array('text', 'view_certificates'), 'description' => array('text', 'Read the certificates of a User'), 'list_order' => array('integer', '0'), 'context_id' => array('integer', '5')));

$ilDB->insert("il_orgu_operations", array(
'operation_id' => array('integer', '23'), 'operation_string' => array('text', 'view_certificates'), 'description' => array('text', 'Read the certificates of a User'), 'list_order' => array('integer', '0'), 'context_id' => array('integer', '6')));

$ilDB->insert("il_orgu_operations", array(
'operation_id' => array('integer', '24'), 'operation_string' => array('text', 'view_certificates'), 'description' => array('text', 'Read the certificates of a User'), 'list_order' => array('integer', '0'), 'context_id' => array('integer', '3')));

$ilDB->insert("il_orgu_operations", array(
'operation_id' => array('integer', '25'), 'operation_string' => array('text', 'view_competences'), 'description' => array('text', 'Read the competences of a User'), 'list_order' => array('integer', '0'), 'context_id' => array('integer', '5')));

$ilDB->insert("il_orgu_operations", array(
'operation_id' => array('integer', '26'), 'operation_string' => array('text', 'view_competences'), 'description' => array('text', 'Read the competences of a User'), 'list_order' => array('integer', '0'), 'context_id' => array('integer', '4')));

$ilDB->insert("il_orgu_operations", array(
'operation_id' => array('integer', '27'), 'operation_string' => array('text', 'view_competences'), 'description' => array('text', 'Read the competences of a User'), 'list_order' => array('integer', '0'), 'context_id' => array('integer', '3')));

$ilDB->insert("il_orgu_operations", array(
'operation_id' => array('integer', '28'), 'operation_string' => array('text', 'view_competences'), 'description' => array('text', 'Read the competences of a User'), 'list_order' => array('integer', '0'), 'context_id' => array('integer', '7')));


//
// il_orgu_permissions
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"context_id" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"type" => "integer"
	)
	,"operations" => array (
		"notnull" => false
		,"length" => 256
		,"fixed" => false
		,"type" => "text"
	)
	,"parent_id" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"type" => "integer"
	)
	,"position_id" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"type" => "integer"
	)
	,"protected" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_orgu_permissions", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_orgu_permissions", $pk_fields);

$in_fields = array("context_id");
$ilDB->addIndex("il_orgu_permissions", $in_fields, "co", false);

$in_fields = array("position_id");
$ilDB->addIndex("il_orgu_permissions", $in_fields, "po", false);

$ilDB->createSequence("il_orgu_permissions", 1);


//
// il_orgu_positions
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 512
		,"fixed" => false
		,"type" => "text"
	)
	,"description" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"core_position" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"core_identifier" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("il_orgu_positions", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_orgu_positions", $pk_fields);

$ilDB->createSequence("il_orgu_positions", 3);

$ilDB->insert("il_orgu_positions", array(
'id' => array('integer', '1'), 'title' => array('text', 'Employees'), 'description' => array('text', 'Employees of a OrgUnit'), 'core_position' => array('integer', '1'), 'core_identifier' => array('integer', '1')));

$ilDB->insert("il_orgu_positions", array(
'id' => array('integer', '2'), 'title' => array('text', 'Superiors'), 'description' => array('text', 'Superiors of a OrgUnit'), 'core_position' => array('integer', '1'), 'core_identifier' => array('integer', '2')));


//
// il_orgu_ua
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"type" => "integer"
	)
	,"position_id" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"type" => "integer"
	)
	,"orgu_id" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("il_orgu_ua", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_orgu_ua", $pk_fields);

$in_fields = array("position_id");
$ilDB->addIndex("il_orgu_ua", $in_fields, "pi", false);

$in_fields = array("user_id");
$ilDB->addIndex("il_orgu_ua", $in_fields, "ui", false);

$in_fields = array("orgu_id");
$ilDB->addIndex("il_orgu_ua", $in_fields, "oi", false);

$in_fields = array("position_id","orgu_id");
$ilDB->addIndex("il_orgu_ua", $in_fields, "po", false);

$in_fields = array("position_id","user_id");
$ilDB->addIndex("il_orgu_ua", $in_fields, "pu", false);

$ilDB->createSequence("il_orgu_ua", 1);


//
// il_plugin
//
$fields = array (
	"component_type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => ""
		,"fixed" => true
		,"type" => "text"
	)
	,"component_name" => array (
		"notnull" => true
		,"length" => 90
		,"default" => " "
		,"fixed" => false
		,"type" => "text"
	)
	,"slot_id" => array (
		"notnull" => true
		,"length" => 10
		,"default" => ""
		,"fixed" => true
		,"type" => "text"
	)
	,"name" => array (
		"notnull" => true
		,"length" => 40
		,"default" => " "
		,"fixed" => false
		,"type" => "text"
	)
	,"last_update_version" => array (
		"notnull" => false
		,"length" => 10
		,"fixed" => true
		,"type" => "text"
	)
	,"active" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"db_version" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"plugin_id" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("il_plugin", $fields);

$pk_fields = array("component_type","component_name","slot_id","name");
$ilDB->addPrimaryKey("il_plugin", $pk_fields);


//
// il_pluginslot
//
$fields = array (
	"component" => array (
		"notnull" => true
		,"length" => 200
		,"default" => " "
		,"fixed" => false
		,"type" => "text"
	)
	,"id" => array (
		"notnull" => true
		,"length" => 10
		,"default" => ""
		,"fixed" => true
		,"type" => "text"
	)
	,"name" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("il_pluginslot", $fields);

$pk_fields = array("component","id");
$ilDB->addPrimaryKey("il_pluginslot", $pk_fields);

$ilDB->insert("il_pluginslot", array(
'component' => array('text', 'Modules/Cloud'), 'id' => array('text', 'cldh'), 'name' => array('text', 'CloudHook')));

$ilDB->insert("il_pluginslot", array(
'component' => array('text', 'Modules/TestQuestionPool'), 'id' => array('text', 'qst'), 'name' => array('text', 'Questions')));

$ilDB->insert("il_pluginslot", array(
'component' => array('text', 'Modules/DataCollection'), 'id' => array('text', 'dclfth'), 'name' => array('text', 'FieldTypeHook')));

$ilDB->insert("il_pluginslot", array(
'component' => array('text', 'Modules/Test'), 'id' => array('text', 'texp'), 'name' => array('text', 'Export')));

$ilDB->insert("il_pluginslot", array(
'component' => array('text', 'Modules/Test'), 'id' => array('text', 'tsig'), 'name' => array('text', 'Signature')));

$ilDB->insert("il_pluginslot", array(
'component' => array('text', 'Modules/OrgUnit'), 'id' => array('text', 'orgutypehk'), 'name' => array('text', 'OrgUnitTypeHook')));

$ilDB->insert("il_pluginslot", array(
'component' => array('text', 'Modules/OrgUnit'), 'id' => array('text', 'orguext'), 'name' => array('text', 'OrgUnitExtension')));

$ilDB->insert("il_pluginslot", array(
'component' => array('text', 'Modules/SurveyQuestionPool'), 'id' => array('text', 'svyq'), 'name' => array('text', 'SurveyQuestions')));

$ilDB->insert("il_pluginslot", array(
'component' => array('text', 'Services/Preview'), 'id' => array('text', 'pvre'), 'name' => array('text', 'PreviewRenderer')));

$ilDB->insert("il_pluginslot", array(
'component' => array('text', 'Services/AuthShibboleth'), 'id' => array('text', 'shibhk'), 'name' => array('text', 'ShibbolethAuthenticationHook')));

$ilDB->insert("il_pluginslot", array(
'component' => array('text', 'Services/Cron'), 'id' => array('text', 'crnhk'), 'name' => array('text', 'CronHook')));

$ilDB->insert("il_pluginslot", array(
'component' => array('text', 'Services/Authentication'), 'id' => array('text', 'authhk'), 'name' => array('text', 'AuthenticationHook')));

$ilDB->insert("il_pluginslot", array(
'component' => array('text', 'Services/COPage'), 'id' => array('text', 'pgcp'), 'name' => array('text', 'PageComponent')));

$ilDB->insert("il_pluginslot", array(
'component' => array('text', 'Services/WorkflowEngine'), 'id' => array('text', 'wfeCG'), 'name' => array('text', 'ComplexGateway')));

$ilDB->insert("il_pluginslot", array(
'component' => array('text', 'Services/EventHandling'), 'id' => array('text', 'evhk'), 'name' => array('text', 'EventHook')));

$ilDB->insert("il_pluginslot", array(
'component' => array('text', 'Services/Calendar'), 'id' => array('text', 'capm'), 'name' => array('text', 'AppointmentCustomModal')));

$ilDB->insert("il_pluginslot", array(
'component' => array('text', 'Services/Calendar'), 'id' => array('text', 'capg'), 'name' => array('text', 'AppointmentCustomGrid')));

$ilDB->insert("il_pluginslot", array(
'component' => array('text', 'Services/UIComponent'), 'id' => array('text', 'uihk'), 'name' => array('text', 'UserInterfaceHook')));

$ilDB->insert("il_pluginslot", array(
'component' => array('text', 'Services/LDAP'), 'id' => array('text', 'ldaphk'), 'name' => array('text', 'LDAPHook')));

$ilDB->insert("il_pluginslot", array(
'component' => array('text', 'Services/AdvancedMetaData'), 'id' => array('text', 'amdc'), 'name' => array('text', 'AdvancedMDClaiming')));

$ilDB->insert("il_pluginslot", array(
'component' => array('text', 'Services/Repository'), 'id' => array('text', 'robj'), 'name' => array('text', 'RepositoryObject')));

$ilDB->insert("il_pluginslot", array(
'component' => array('text', 'Services/User'), 'id' => array('text', 'udfc'), 'name' => array('text', 'UDFClaiming')));

$ilDB->insert("il_pluginslot", array(
'component' => array('text', 'Services/User'), 'id' => array('text', 'udfd'), 'name' => array('text', 'UDFDefinition')));

$ilDB->insert("il_pluginslot", array(
'component' => array('text', 'Services/PDFGeneration'), 'id' => array('text', 'renderer'), 'name' => array('text', 'Renderer')));

$ilDB->insert("il_pluginslot", array(
'component' => array('text', 'Services/WebServices'), 'id' => array('text', 'soaphk'), 'name' => array('text', 'SoapHook')));


//
// il_poll
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"question" => array (
		"notnull" => false
		,"length" => 1000
		,"fixed" => false
		,"type" => "text"
	)
	,"image" => array (
		"notnull" => false
		,"length" => 1000
		,"fixed" => false
		,"type" => "text"
	)
	,"online_status" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"view_results" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "3"
		,"type" => "integer"
	)
	,"period" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"period_begin" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"period_end" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"max_answers" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"result_sort" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"non_anon" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"show_results_as" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_poll", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_poll", $pk_fields);


//
// il_poll_answer
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"poll_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"answer" => array (
		"notnull" => false
		,"length" => 1000
		,"fixed" => false
		,"type" => "text"
	)
	,"pos" => array (
		"notnull" => true
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_poll_answer", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_poll_answer", $pk_fields);

$ilDB->createSequence("il_poll_answer", 1);


//
// il_poll_vote
//
$fields = array (
	"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"poll_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"answer_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_poll_vote", $fields);

$pk_fields = array("user_id","poll_id","answer_id");
$ilDB->addPrimaryKey("il_poll_vote", $pk_fields);


//
// il_qpl_qst_fq_res
//
$fields = array (
	"result_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"question_fi" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"result" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"range_min" => array (
		"notnull" => true
		,"default" => "0"
		,"type" => "float"
	)
	,"range_max" => array (
		"notnull" => true
		,"default" => "0"
		,"type" => "float"
	)
	,"tolerance" => array (
		"notnull" => true
		,"default" => "0"
		,"type" => "float"
	)
	,"unit_fi" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"formula" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"rating_simple" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"rating_sign" => array (
		"notnull" => true
		,"default" => "0.25"
		,"type" => "float"
	)
	,"rating_value" => array (
		"notnull" => true
		,"default" => "0.25"
		,"type" => "float"
	)
	,"rating_unit" => array (
		"notnull" => true
		,"default" => "0.25"
		,"type" => "float"
	)
	,"points" => array (
		"notnull" => true
		,"default" => "0"
		,"type" => "float"
	)
	,"resprecision" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"result_type" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"range_min_txt" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"range_max_txt" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("il_qpl_qst_fq_res", $fields);

$pk_fields = array("result_id");
$ilDB->addPrimaryKey("il_qpl_qst_fq_res", $pk_fields);

$ilDB->createSequence("il_qpl_qst_fq_res", 1);


//
// il_qpl_qst_fq_res_unit
//
$fields = array (
	"result_unit_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"result" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"question_fi" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"unit_fi" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_qpl_qst_fq_res_unit", $fields);

$pk_fields = array("result_unit_id");
$ilDB->addPrimaryKey("il_qpl_qst_fq_res_unit", $pk_fields);

$in_fields = array("question_fi","unit_fi");
$ilDB->addIndex("il_qpl_qst_fq_res_unit", $in_fields, "i1", false);

$ilDB->createSequence("il_qpl_qst_fq_res_unit", 1);


//
// il_qpl_qst_fq_ucat
//
$fields = array (
	"category_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"category" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"question_fi" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_qpl_qst_fq_ucat", $fields);

$pk_fields = array("category_id");
$ilDB->addPrimaryKey("il_qpl_qst_fq_ucat", $pk_fields);

$ilDB->createSequence("il_qpl_qst_fq_ucat", 1);


//
// il_qpl_qst_fq_unit
//
$fields = array (
	"unit_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"unit" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"factor" => array (
		"notnull" => true
		,"default" => "0"
		,"type" => "float"
	)
	,"baseunit_fi" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"category_fi" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sequence" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"question_fi" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_qpl_qst_fq_unit", $fields);

$pk_fields = array("unit_id");
$ilDB->addPrimaryKey("il_qpl_qst_fq_unit", $pk_fields);

$in_fields = array("question_fi");
$ilDB->addIndex("il_qpl_qst_fq_unit", $in_fields, "i2", false);

$ilDB->createSequence("il_qpl_qst_fq_unit", 1);


//
// il_qpl_qst_fq_var
//
$fields = array (
	"variable_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"question_fi" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"variable" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"range_min" => array (
		"notnull" => true
		,"default" => "0"
		,"type" => "float"
	)
	,"range_max" => array (
		"notnull" => true
		,"default" => "0"
		,"type" => "float"
	)
	,"unit_fi" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"step_dim_min" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"step_dim_max" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"varprecision" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"intprecision" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"range_min_txt" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"range_max_txt" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("il_qpl_qst_fq_var", $fields);

$pk_fields = array("variable_id");
$ilDB->addPrimaryKey("il_qpl_qst_fq_var", $pk_fields);

$ilDB->createSequence("il_qpl_qst_fq_var", 1);


//
// il_rating
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => ""
		,"fixed" => true
		,"type" => "text"
	)
	,"sub_obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sub_obj_type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => ""
		,"fixed" => true
		,"type" => "text"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rating" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"category_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"tstamp" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("il_rating", $fields);

$pk_fields = array("obj_id","obj_type","sub_obj_id","sub_obj_type","user_id","category_id");
$ilDB->addPrimaryKey("il_rating", $pk_fields);

$in_fields = array("obj_id","obj_type","sub_obj_id","sub_obj_type");
$ilDB->addIndex("il_rating", $in_fields, "obj", false);


//
// il_rating_cat
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"parent_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 100
		,"fixed" => false
		,"type" => "text"
	)
	,"description" => array (
		"notnull" => false
		,"length" => 1000
		,"fixed" => false
		,"type" => "text"
	)
	,"pos" => array (
		"notnull" => true
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_rating_cat", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_rating_cat", $pk_fields);

$ilDB->createSequence("il_rating_cat", 1);


//
// il_request_token
//
$fields = array (
	"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"token" => array (
		"notnull" => true
		,"length" => 64
		,"default" => ""
		,"fixed" => true
		,"type" => "text"
	)
	,"stamp" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"session_id" => array (
		"notnull" => false
		,"length" => 100
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("il_request_token", $fields);

$pk_fields = array("token");
$ilDB->addPrimaryKey("il_request_token", $pk_fields);

$in_fields = array("user_id","session_id");
$ilDB->addIndex("il_request_token", $in_fields, "i1", false);

$in_fields = array("user_id","stamp");
$ilDB->addIndex("il_request_token", $in_fields, "i2", false);

$ilDB->insert("il_request_token", array(
'user_id' => array('integer', '6'), 'token' => array('text', 'a0d2d5b51feec3dcf1842e6fd80092bc'), 'stamp' => array('timestamp', '2016-12-21 13:55:17'), 'session_id' => array('text', 'ssev5rsqvp335hermt971ieuj6')));

$ilDB->insert("il_request_token", array(
'user_id' => array('integer', '6'), 'token' => array('text', 'e94abe3044958d2cf4bebff6e68f6a52'), 'stamp' => array('timestamp', '2016-12-16 14:39:53'), 'session_id' => array('text', '2tfi6g36pme1ivd1tu7nencp41')));


//
// il_resource
//
$fields = array (
	"identification" => array (
		"notnull" => true
		,"length" => 250
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"storage_id" => array (
		"notnull" => false
		,"length" => 8
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("il_resource", $fields);

$pk_fields = array("identification");
$ilDB->addPrimaryKey("il_resource", $pk_fields);


//
// il_resource_info
//
$fields = array (
	"internal" => array (
		"notnull" => true
		,"length" => 250
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"identification" => array (
		"notnull" => false
		,"length" => 250
		,"fixed" => false
		,"type" => "text"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 250
		,"fixed" => false
		,"type" => "text"
	)
	,"suffix" => array (
		"notnull" => false
		,"length" => 64
		,"fixed" => false
		,"type" => "text"
	)
	,"mime_type" => array (
		"notnull" => false
		,"length" => 250
		,"fixed" => false
		,"type" => "text"
	)
	,"size" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"type" => "integer"
	)
	,"creation_date" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_resource_info", $fields);

$pk_fields = array("internal");
$ilDB->addPrimaryKey("il_resource_info", $pk_fields);


//
// il_resource_revision
//
$fields = array (
	"internal" => array (
		"notnull" => true
		,"length" => 250
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"identification" => array (
		"notnull" => false
		,"length" => 250
		,"fixed" => false
		,"type" => "text"
	)
	,"available" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"version_number" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"type" => "integer"
	)
	,"owner_id" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 255
		,"default" => "-"
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("il_resource_revision", $fields);

$pk_fields = array("internal");
$ilDB->addPrimaryKey("il_resource_revision", $pk_fields);


//
// il_resource_stakeh
//
$fields = array (
	"internal" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"identification" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"stakeholder_id" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"stakeholder_class" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("il_resource_stakeh", $fields);

$pk_fields = array("internal");
$ilDB->addPrimaryKey("il_resource_stakeh", $pk_fields);


//
// il_subscribers
//
$fields = array (
	"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"subject" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"sub_time" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_subscribers", $fields);

$pk_fields = array("usr_id","obj_id");
$ilDB->addPrimaryKey("il_subscribers", $pk_fields);


//
// il_tag
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => ""
		,"fixed" => true
		,"type" => "text"
	)
	,"sub_obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sub_obj_type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => ""
		,"fixed" => true
		,"type" => "text"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"tag" => array (
		"notnull" => true
		,"length" => 100
		,"default" => " "
		,"fixed" => false
		,"type" => "text"
	)
	,"is_offline" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_tag", $fields);

$pk_fields = array("obj_id","obj_type","sub_obj_id","sub_obj_type","user_id","tag");
$ilDB->addPrimaryKey("il_tag", $pk_fields);

$in_fields = array("obj_id","obj_type","sub_obj_id","sub_obj_type");
$ilDB->addIndex("il_tag", $in_fields, "i1", false);

$in_fields = array("tag");
$ilDB->addIndex("il_tag", $in_fields, "i2", false);

$in_fields = array("user_id");
$ilDB->addIndex("il_tag", $in_fields, "i3", false);


//
// il_translations
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"id_type" => array (
		"notnull" => true
		,"length" => 50
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"lang_code" => array (
		"notnull" => true
		,"length" => 2
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 256
		,"fixed" => false
		,"type" => "text"
	)
	,"description" => array (
		"notnull" => false
		,"length" => 512
		,"fixed" => false
		,"type" => "text"
	)
	,"lang_default" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_translations", $fields);

$pk_fields = array("id","id_type","lang_code");
$ilDB->addPrimaryKey("il_translations", $pk_fields);


//
// il_verification
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"type" => array (
		"notnull" => true
		,"length" => 100
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"parameters" => array (
		"notnull" => false
		,"length" => 1000
		,"fixed" => false
		,"type" => "text"
	)
	,"raw_data" => array (
		"notnull" => false
		,"type" => "clob"
	)
);
$ilDB->createTable("il_verification", $fields);

$pk_fields = array("id","type");
$ilDB->addPrimaryKey("il_verification", $pk_fields);


//
// il_wac_secure_path
//
$fields = array (
	"path" => array (
		"notnull" => true
		,"length" => 64
		,"default" => " "
		,"fixed" => false
		,"type" => "text"
	)
	,"component_directory" => array (
		"notnull" => false
		,"length" => 256
		,"fixed" => false
		,"type" => "text"
	)
	,"checking_class" => array (
		"notnull" => false
		,"length" => 256
		,"fixed" => false
		,"type" => "text"
	)
	,"in_sec_folder" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("il_wac_secure_path", $fields);

$pk_fields = array("path");
$ilDB->addPrimaryKey("il_wac_secure_path", $pk_fields);


//
// il_wiki_contributor
//
$fields = array (
	"wiki_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"status" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"status_time" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
);
$ilDB->createTable("il_wiki_contributor", $fields);

$pk_fields = array("wiki_id","user_id");
$ilDB->addPrimaryKey("il_wiki_contributor", $pk_fields);


//
// il_wiki_data
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"startpage" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"short" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
	,"is_online" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rating" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"introduction" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"public_notes" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"imp_pages" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"page_toc" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"rating_side" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rating_new" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rating_ext" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rating_overall" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"empty_page_templ" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"link_md_values" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_wiki_data", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_wiki_data", $pk_fields);


//
// il_wiki_imp_pages
//
$fields = array (
	"wiki_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"ord" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"indent" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"page_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_wiki_imp_pages", $fields);

$pk_fields = array("wiki_id","page_id");
$ilDB->addPrimaryKey("il_wiki_imp_pages", $pk_fields);


//
// il_wiki_missing_page
//
$fields = array (
	"wiki_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"source_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"target_name" => array (
		"notnull" => true
		,"length" => 200
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("il_wiki_missing_page", $fields);

$pk_fields = array("wiki_id","source_id","target_name");
$ilDB->addPrimaryKey("il_wiki_missing_page", $pk_fields);

$in_fields = array("wiki_id","target_name");
$ilDB->addIndex("il_wiki_missing_page", $in_fields, "i1", false);


//
// il_wiki_page
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"wiki_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"blocked" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"rating" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"hide_adv_md" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("il_wiki_page", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("il_wiki_page", $pk_fields);

$ilDB->createSequence("il_wiki_page", 1);


//
// int_link
//
$fields = array (
	"source_type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => " "
		,"fixed" => false
		,"type" => "text"
	)
	,"source_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"target_type" => array (
		"notnull" => true
		,"length" => 4
		,"default" => " "
		,"fixed" => false
		,"type" => "text"
	)
	,"target_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"target_inst" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"source_lang" => array (
		"notnull" => true
		,"length" => 2
		,"default" => "-"
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("int_link", $fields);

$pk_fields = array("source_type","source_id","source_lang","target_type","target_id","target_inst");
$ilDB->addPrimaryKey("int_link", $pk_fields);

$in_fields = array("target_type","target_id","target_inst");
$ilDB->addIndex("int_link", $in_fields, "ta", false);

$in_fields = array("source_type","source_id");
$ilDB->addIndex("int_link", $in_fields, "so", false);


//
// item_group_item
//
$fields = array (
	"item_group_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"item_ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("item_group_item", $fields);

$pk_fields = array("item_group_id","item_ref_id");
$ilDB->addPrimaryKey("item_group_item", $pk_fields);


//
// itgr_data
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"hide_title" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"behaviour" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("itgr_data", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("itgr_data", $pk_fields);


//
// last_visited
//
$fields = array (
	"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"nr" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"sub_obj_id" => array (
		"notnull" => false
		,"length" => 40
		,"fixed" => false
		,"type" => "text"
	)
	,"goto_link" => array (
		"notnull" => false
		,"length" => 1000
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("last_visited", $fields);

$pk_fields = array("user_id","nr");
$ilDB->addPrimaryKey("last_visited", $pk_fields);


//
// ldap_attribute_mapping
//
$fields = array (
	"server_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"keyword" => array (
		"notnull" => true
		,"length" => 32
		,"default" => " "
		,"fixed" => false
		,"type" => "text"
	)
	,"value" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"perform_update" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("ldap_attribute_mapping", $fields);

$pk_fields = array("server_id","keyword");
$ilDB->addPrimaryKey("ldap_attribute_mapping", $pk_fields);

$in_fields = array("server_id");
$ilDB->addIndex("ldap_attribute_mapping", $in_fields, "i1", false);


//
// ldap_rg_mapping
//
$fields = array (
	"mapping_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"server_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"url" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"dn" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"member_attribute" => array (
		"notnull" => false
		,"length" => 64
		,"fixed" => false
		,"type" => "text"
	)
	,"member_isdn" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"role" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"mapping_info" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"mapping_info_type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
);
$ilDB->createTable("ldap_rg_mapping", $fields);

$pk_fields = array("mapping_id");
$ilDB->addPrimaryKey("ldap_rg_mapping", $pk_fields);

$ilDB->createSequence("ldap_rg_mapping", 1);


//
// ldap_role_assignments
//
$fields = array (
	"server_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rule_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"dn" => array (
		"notnull" => false
		,"length" => 1000
		,"fixed" => false
		,"type" => "text"
	)
	,"attribute" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"isdn" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"att_name" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"att_value" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"role_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"add_on_update" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"remove_on_update" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"plugin_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("ldap_role_assignments", $fields);

$pk_fields = array("server_id","rule_id");
$ilDB->addPrimaryKey("ldap_role_assignments", $pk_fields);

$ilDB->createSequence("ldap_role_assignments", 1);


//
// ldap_server_settings
//
$fields = array (
	"server_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"active" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"name" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"url" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"version" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"base_dn" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"referrals" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"tls" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"bind_type" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"bind_user" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"bind_pass" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"search_base" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"user_scope" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_attribute" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"filter" => array (
		"notnull" => false
		,"length" => 512
		,"fixed" => false
		,"type" => "text"
	)
	,"group_dn" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"group_scope" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"group_filter" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"group_member" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"group_memberisdn" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"group_name" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"group_attribute" => array (
		"notnull" => false
		,"length" => 64
		,"fixed" => false
		,"type" => "text"
	)
	,"group_optional" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"group_user_filter" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"sync_on_login" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sync_per_cron" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"role_sync_active" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"role_bind_dn" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"role_bind_pass" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"migration" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"authentication" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"authentication_type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"username_filter" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"escape_dn" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("ldap_server_settings", $fields);

$pk_fields = array("server_id");
$ilDB->addPrimaryKey("ldap_server_settings", $pk_fields);

$ilDB->createSequence("ldap_server_settings", 1);


//
// like_data
//
$fields = array (
	"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => true
		,"length" => 40
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"sub_obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sub_obj_type" => array (
		"notnull" => true
		,"length" => 40
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"news_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"like_type" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"exp_ts" => array (
		"notnull" => true
		,"default" => ""
		,"type" => "timestamp"
	)
);
$ilDB->createTable("like_data", $fields);

$pk_fields = array("user_id","obj_id","obj_type","sub_obj_id","sub_obj_type","news_id","like_type");
$ilDB->addPrimaryKey("like_data", $pk_fields);

$in_fields = array("obj_id");
$ilDB->addIndex("like_data", $in_fields, "i1", false);


//
// link_check
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"page_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"url" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"parent_type" => array (
		"notnull" => false
		,"length" => 8
		,"fixed" => false
		,"type" => "text"
	)
	,"http_status_code" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"last_check" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("link_check", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("link_check", $pk_fields);

$in_fields = array("obj_id");
$ilDB->addIndex("link_check", $in_fields, "i1", false);

$ilDB->createSequence("link_check", 1);


//
// link_check_report
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("link_check_report", $fields);

$pk_fields = array("obj_id","usr_id");
$ilDB->addPrimaryKey("link_check_report", $pk_fields);


//
// lm_data
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"type" => array (
		"notnull" => false
		,"length" => 2
		,"fixed" => true
		,"type" => "text"
	)
	,"lm_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"import_id" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"public_access" => array (
		"notnull" => false
		,"length" => 1
		,"default" => "n"
		,"fixed" => true
		,"type" => "text"
	)
	,"create_date" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"last_update" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"active" => array (
		"notnull" => false
		,"length" => 1
		,"default" => "y"
		,"fixed" => true
		,"type" => "text"
	)
	,"layout" => array (
		"notnull" => false
		,"length" => 100
		,"fixed" => false
		,"type" => "text"
	)
	,"short_title" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("lm_data", $fields);

$pk_fields = array("obj_id");
$ilDB->addPrimaryKey("lm_data", $pk_fields);

$in_fields = array("lm_id");
$ilDB->addIndex("lm_data", $in_fields, "i1", false);

$in_fields = array("type");
$ilDB->addIndex("lm_data", $in_fields, "i2", false);

$in_fields = array("import_id");
$ilDB->addIndex("lm_data", $in_fields, "im", false);

$ilDB->createSequence("lm_data", 2);

$ilDB->insert("lm_data", array(
'obj_id' => array('integer', '1'), 'title' => array('text', 'dummy'), 'type' => array('text', 'du'), 'lm_id' => array('integer', '0'), 'import_id' => array('text', ''), 'public_access' => array('text', 'n'), 'create_date' => array('timestamp', ''), 'last_update' => array('timestamp', ''), 'active' => array('text', 'y'), 'layout' => array('text', ''), 'short_title' => array('text', '')));


//
// lm_data_transl
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"lang" => array (
		"notnull" => true
		,"length" => 2
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"create_date" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"last_update" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"short_title" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("lm_data_transl", $fields);

$pk_fields = array("id","lang");
$ilDB->addPrimaryKey("lm_data_transl", $pk_fields);


//
// lm_glossaries
//
$fields = array (
	"lm_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"glo_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("lm_glossaries", $fields);

$pk_fields = array("lm_id","glo_id");
$ilDB->addPrimaryKey("lm_glossaries", $pk_fields);


//
// lm_menu
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"lm_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"link_type" => array (
		"notnull" => false
		,"length" => 6
		,"default" => "extern"
		,"fixed" => true
		,"type" => "text"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"target" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"link_ref_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"active" => array (
		"notnull" => false
		,"length" => 1
		,"default" => "n"
		,"fixed" => true
		,"type" => "text"
	)
);
$ilDB->createTable("lm_menu", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("lm_menu", $pk_fields);

$in_fields = array("link_type");
$ilDB->addIndex("lm_menu", $in_fields, "i1", false);

$in_fields = array("lm_id");
$ilDB->addIndex("lm_menu", $in_fields, "i2", false);

$in_fields = array("active");
$ilDB->addIndex("lm_menu", $in_fields, "i3", false);

$ilDB->createSequence("lm_menu", 1);


//
// lm_read_event
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"read_count" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"spent_seconds" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"last_access" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("lm_read_event", $fields);

$pk_fields = array("obj_id","usr_id");
$ilDB->addPrimaryKey("lm_read_event", $pk_fields);


//
// lm_tree
//
$fields = array (
	"lm_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"child" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"parent" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"lft" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rgt" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"depth" => array (
		"notnull" => true
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("lm_tree", $fields);

$pk_fields = array("lm_id","child");
$ilDB->addPrimaryKey("lm_tree", $pk_fields);

$in_fields = array("child");
$ilDB->addIndex("lm_tree", $in_fields, "i1", false);

$in_fields = array("parent");
$ilDB->addIndex("lm_tree", $in_fields, "i2", false);

$in_fields = array("lm_id");
$ilDB->addIndex("lm_tree", $in_fields, "i3", false);


//
// lng_data
//
$fields = array (
	"module" => array (
		"notnull" => true
		,"length" => 30
		,"default" => " "
		,"fixed" => false
		,"type" => "text"
	)
	,"identifier" => array (
		"notnull" => true
		,"length" => 200
		,"default" => " "
		,"fixed" => false
		,"type" => "text"
	)
	,"lang_key" => array (
		"notnull" => true
		,"length" => 2
		,"default" => ""
		,"fixed" => true
		,"type" => "text"
	)
	,"value" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"local_change" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"remarks" => array (
		"notnull" => false
		,"length" => 250
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("lng_data", $fields);

$pk_fields = array("module","identifier","lang_key");
$ilDB->addPrimaryKey("lng_data", $pk_fields);

$in_fields = array("module");
$ilDB->addIndex("lng_data", $in_fields, "i1", false);

$in_fields = array("lang_key");
$ilDB->addIndex("lng_data", $in_fields, "i2", false);

$in_fields = array("local_change");
$ilDB->addIndex("lng_data", $in_fields, "i3", false);


//
// lng_log
//
$fields = array (
	"module" => array (
		"notnull" => true
		,"length" => 30
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"identifier" => array (
		"notnull" => true
		,"length" => 200
		,"default" => " "
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("lng_log", $fields);

$pk_fields = array("module","identifier");
$ilDB->addPrimaryKey("lng_log", $pk_fields);


//
// lng_modules
//
$fields = array (
	"module" => array (
		"notnull" => true
		,"length" => 30
		,"default" => " "
		,"fixed" => false
		,"type" => "text"
	)
	,"lang_key" => array (
		"notnull" => true
		,"length" => 2
		,"default" => ""
		,"fixed" => true
		,"type" => "text"
	)
	,"lang_array" => array (
		"notnull" => false
		,"type" => "clob"
	)
);
$ilDB->createTable("lng_modules", $fields);

$pk_fields = array("module","lang_key");
$ilDB->addPrimaryKey("lng_modules", $pk_fields);


//
// lo_access
//
$fields = array (
	"timestamp" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"lm_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"lm_title" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("lo_access", $fields);

$pk_fields = array("usr_id","lm_id");
$ilDB->addPrimaryKey("lo_access", $pk_fields);


//
// loc_rnd_qpl
//
$fields = array (
	"container_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"objective_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"tst_type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"tst_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"qp_seq" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"percentage" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("loc_rnd_qpl", $fields);

$pk_fields = array("container_id","objective_id","tst_type","tst_id","qp_seq");
$ilDB->addPrimaryKey("loc_rnd_qpl", $pk_fields);


//
// loc_settings
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"itest" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"qtest" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"qt_vis_all" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"qt_vis_obj" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"reset_results" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"it_type" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "5"
		,"type" => "integer"
	)
	,"qt_type" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"it_start" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"qt_start" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"passed_obj_mode" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
);
$ilDB->createTable("loc_settings", $fields);

$pk_fields = array("obj_id");
$ilDB->addPrimaryKey("loc_settings", $pk_fields);


//
// loc_tst_assignments
//
$fields = array (
	"assignment_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"container_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"assignment_type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"objective_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"tst_ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("loc_tst_assignments", $fields);

$pk_fields = array("assignment_id");
$ilDB->addPrimaryKey("loc_tst_assignments", $pk_fields);

$ilDB->createSequence("loc_tst_assignments", 1);


//
// loc_tst_run
//
$fields = array (
	"container_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"test_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"objective_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"max_points" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"questions" => array (
		"notnull" => false
		,"length" => 1000
		,"default" => "0"
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("loc_tst_run", $fields);

$pk_fields = array("container_id","user_id","test_id","objective_id");
$ilDB->addPrimaryKey("loc_tst_run", $pk_fields);


//
// loc_user_results
//
$fields = array (
	"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"course_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"objective_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"status" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"result_perc" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"limit_perc" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"tries" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"is_final" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"tstamp" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("loc_user_results", $fields);

$pk_fields = array("user_id","course_id","objective_id","type");
$ilDB->addPrimaryKey("loc_user_results", $pk_fields);


//
// log_components
//
$fields = array (
	"component_id" => array (
		"notnull" => true
		,"length" => 20
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"log_level" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("log_components", $fields);

$pk_fields = array("component_id");
$ilDB->addPrimaryKey("log_components", $pk_fields);

$ilDB->insert("log_components", array(
'component_id' => array('text', 'ac'), 'log_level' => array('integer', '0')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'amet'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'auth'), 'log_level' => array('integer', '0')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'awrn'), 'log_level' => array('integer', '0')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'cat'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'chtr'), 'log_level' => array('integer', '0')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'cont'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'contact'), 'log_level' => array('integer', '0')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'copg'), 'log_level' => array('integer', '0')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'crs'), 'log_level' => array('integer', '0')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'db'), 'log_level' => array('integer', '0')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'ds'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'exp'), 'log_level' => array('integer', '0')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'file'), 'log_level' => array('integer', '0')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'glo'), 'log_level' => array('integer', '0')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'grp'), 'log_level' => array('integer', '0')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'init'), 'log_level' => array('integer', '0')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'lchk'), 'log_level' => array('integer', '0')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'lm'), 'log_level' => array('integer', '0')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'log'), 'log_level' => array('integer', '0')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'log_root'), 'log_level' => array('integer', '0')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'mail'), 'log_level' => array('integer', '0')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'meta'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'mob'), 'log_level' => array('integer', '0')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'obj'), 'log_level' => array('integer', '0')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'otpl'), 'log_level' => array('integer', '0')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'rep'), 'log_level' => array('integer', '0')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'sc13'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'skll'), 'log_level' => array('integer', '0')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'spl'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'src'), 'log_level' => array('integer', '0')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'styl'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'svy'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'trac'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'tree'), 'log_level' => array('integer', '0')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'user'), 'log_level' => array('integer', '0')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'webr'), 'log_level' => array('integer', '0')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'wiki'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'wsrv'), 'log_level' => array('integer', '0')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'mmbr'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'cal'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'pdfg'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'lti'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'bgtk'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'frm'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'exc'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'crsr'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'book'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'cmix'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'mep'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'pwsp'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'adn'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'mme'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'tos'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'cert'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'evnt'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'rnd'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'wbdv'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'lang'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'sysc'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'osch'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'lhist'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'fils'), 'log_level' => array('integer', '')));

$ilDB->insert("log_components", array(
'component_id' => array('text', 'adm'), 'log_level' => array('integer', '')));


//
// loginname_history
//
$fields = array (
	"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"login" => array (
		"notnull" => true
		,"length" => 80
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"history_date" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("loginname_history", $fields);

$pk_fields = array("usr_id","login","history_date");
$ilDB->addPrimaryKey("loginname_history", $pk_fields);


//
// lso_activation
//
$fields = array (
	"ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"online" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"effective_online" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"activation_start_ts" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"activation_end_ts" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("lso_activation", $fields);

$pk_fields = array("ref_id");
$ilDB->addPrimaryKey("lso_activation", $pk_fields);


//
// lso_settings
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"abstract" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"extro" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"abstract_image" => array (
		"notnull" => false
		,"length" => 128
		,"fixed" => false
		,"type" => "text"
	)
	,"extro_image" => array (
		"notnull" => false
		,"length" => 128
		,"fixed" => false
		,"type" => "text"
	)
	,"gallery" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("lso_settings", $fields);

$pk_fields = array("obj_id");
$ilDB->addPrimaryKey("lso_settings", $pk_fields);


//
// lso_states
//
$fields = array (
	"lso_ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"current_item" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"states" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"first_access" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"last_access" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("lso_states", $fields);

$pk_fields = array("lso_ref_id","usr_id");
$ilDB->addPrimaryKey("lso_states", $pk_fields);


//
// lti2_consumer
//
$fields = array (
	"consumer_pk" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"name" => array (
		"notnull" => true
		,"length" => 50
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"consumer_key256" => array (
		"notnull" => true
		,"length" => 256
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"consumer_key" => array (
		"notnull" => false
		,"type" => "blob"
	)
	,"secret" => array (
		"notnull" => true
		,"length" => 1024
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"lti_version" => array (
		"notnull" => false
		,"length" => 10
		,"fixed" => false
		,"type" => "text"
	)
	,"consumer_name" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"consumer_version" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"consumer_guid" => array (
		"notnull" => false
		,"length" => 1024
		,"fixed" => false
		,"type" => "text"
	)
	,"profile" => array (
		"notnull" => false
		,"type" => "blob"
	)
	,"tool_proxy" => array (
		"notnull" => false
		,"type" => "blob"
	)
	,"settings" => array (
		"notnull" => false
		,"type" => "blob"
	)
	,"protected" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"enabled" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"enable_from" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"enable_until" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"last_access" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"created" => array (
		"notnull" => true
		,"default" => ""
		,"type" => "timestamp"
	)
	,"updated" => array (
		"notnull" => true
		,"default" => ""
		,"type" => "timestamp"
	)
	,"ext_consumer_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"signature_method" => array (
		"notnull" => true
		,"length" => 15
		,"default" => "HMAC-SHA1"
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("lti2_consumer", $fields);

$pk_fields = array("consumer_pk");
$ilDB->addPrimaryKey("lti2_consumer", $pk_fields);

$ilDB->createSequence("lti2_consumer", 1);


//
// lti2_context
//
$fields = array (
	"context_pk" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"consumer_pk" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"lti_context_id" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"settings" => array (
		"notnull" => false
		,"type" => "blob"
	)
	,"created" => array (
		"notnull" => true
		,"default" => ""
		,"type" => "timestamp"
	)
	,"updated" => array (
		"notnull" => true
		,"default" => ""
		,"type" => "timestamp"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"type" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("lti2_context", $fields);

$pk_fields = array("context_pk");
$ilDB->addPrimaryKey("lti2_context", $pk_fields);

$in_fields = array("consumer_pk");
$ilDB->addIndex("lti2_context", $in_fields, "i1", false);

$ilDB->createSequence("lti2_context", 1);


//
// lti2_nonce
//
$fields = array (
	"consumer_pk" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"value" => array (
		"notnull" => true
		,"length" => 50
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"expires" => array (
		"notnull" => true
		,"default" => ""
		,"type" => "timestamp"
	)
);
$ilDB->createTable("lti2_nonce", $fields);

$pk_fields = array("consumer_pk","value");
$ilDB->addPrimaryKey("lti2_nonce", $pk_fields);


//
// lti2_resource_link
//
$fields = array (
	"resource_link_pk" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"context_pk" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"consumer_pk" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"lti_resource_link_id" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"settings" => array (
		"notnull" => false
		,"type" => "blob"
	)
	,"primary_resource_link_pk" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"share_approved" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"created" => array (
		"notnull" => true
		,"default" => ""
		,"type" => "timestamp"
	)
	,"updated" => array (
		"notnull" => true
		,"default" => ""
		,"type" => "timestamp"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("lti2_resource_link", $fields);

$pk_fields = array("resource_link_pk");
$ilDB->addPrimaryKey("lti2_resource_link", $pk_fields);

$in_fields = array("consumer_pk");
$ilDB->addIndex("lti2_resource_link", $in_fields, "i1", false);

$in_fields = array("context_pk");
$ilDB->addIndex("lti2_resource_link", $in_fields, "i2", false);

$ilDB->createSequence("lti2_resource_link", 1);


//
// lti2_share_key
//
$fields = array (
	"share_key_id" => array (
		"notnull" => true
		,"length" => 32
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"resource_link_pk" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"auto_approve" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"expires" => array (
		"notnull" => true
		,"default" => ""
		,"type" => "timestamp"
	)
);
$ilDB->createTable("lti2_share_key", $fields);

$pk_fields = array("share_key_id");
$ilDB->addPrimaryKey("lti2_share_key", $pk_fields);

$in_fields = array("resource_link_pk");
$ilDB->addIndex("lti2_share_key", $in_fields, "i1", false);


//
// lti2_tool_proxy
//
$fields = array (
	"tool_proxy_pk" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"tool_proxy_id" => array (
		"notnull" => true
		,"length" => 32
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"consumer_pk" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"tool_proxy" => array (
		"notnull" => true
		,"type" => "blob"
	)
	,"created" => array (
		"notnull" => true
		,"default" => ""
		,"type" => "timestamp"
	)
	,"updated" => array (
		"notnull" => true
		,"default" => ""
		,"type" => "timestamp"
	)
);
$ilDB->createTable("lti2_tool_proxy", $fields);

$pk_fields = array("tool_proxy_pk");
$ilDB->addPrimaryKey("lti2_tool_proxy", $pk_fields);

$in_fields = array("consumer_pk");
$ilDB->addIndex("lti2_tool_proxy", $in_fields, "i1", false);

$in_fields = array("tool_proxy_id");
$ilDB->addUniqueConstraint("lti2_tool_proxy", $in_fields, "u1");

$ilDB->createSequence("lti2_tool_proxy", 1);


//
// lti2_user_result
//
$fields = array (
	"user_pk" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"resource_link_pk" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"lti_user_id" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"lti_result_sourcedid" => array (
		"notnull" => true
		,"length" => 1024
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"created" => array (
		"notnull" => true
		,"default" => ""
		,"type" => "timestamp"
	)
	,"updated" => array (
		"notnull" => true
		,"default" => ""
		,"type" => "timestamp"
	)
);
$ilDB->createTable("lti2_user_result", $fields);

$pk_fields = array("user_pk");
$ilDB->addPrimaryKey("lti2_user_result", $pk_fields);

$in_fields = array("resource_link_pk");
$ilDB->addIndex("lti2_user_result", $in_fields, "i1", false);

$ilDB->createSequence("lti2_user_result", 1);


//
// lti_consumer_results
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"result" => array (
		"notnull" => false
		,"type" => "float"
	)
);
$ilDB->createTable("lti_consumer_results", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("lti_consumer_results", $pk_fields);

$in_fields = array("obj_id","usr_id");
$ilDB->addIndex("lti_consumer_results", $in_fields, "i1", false);

$ilDB->createSequence("lti_consumer_results", 1);


//
// lti_consumer_settings
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"provider_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"launch_method" => array (
		"notnull" => true
		,"length" => 16
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"offline_status" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"show_statements" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"highscore_enabled" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"highscore_achieved_ts" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"highscore_percentage" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"highscore_wtime" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"highscore_own_table" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"highscore_top_table" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"highscore_top_num" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"mastery_score" => array (
		"notnull" => true
		,"default" => "0.5"
		,"type" => "float"
	)
	,"keep_lp" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"use_xapi" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"activity_id" => array (
		"notnull" => false
		,"length" => 128
		,"fixed" => false
		,"type" => "text"
	)
	,"launch_key" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"launch_secret" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("lti_consumer_settings", $fields);

$pk_fields = array("obj_id");
$ilDB->addPrimaryKey("lti_consumer_settings", $pk_fields);


//
// lti_ext_consumer
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"description" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"prefix" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"user_language" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"role" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"local_role_always_member" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"default_skin" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"active" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("lti_ext_consumer", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("lti_ext_consumer", $pk_fields);

$ilDB->createSequence("lti_ext_consumer", 1);


//
// lti_ext_consumer_otype
//
$fields = array (
	"consumer_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"object_type" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("lti_ext_consumer_otype", $fields);

$pk_fields = array("consumer_id","object_type");
$ilDB->addPrimaryKey("lti_ext_consumer_otype", $pk_fields);


//
// lti_ext_provider
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"description" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"availability" => array (
		"notnull" => true
		,"length" => 2
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"remarks" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"time_to_delete" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"provider_url" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"provider_key" => array (
		"notnull" => true
		,"length" => 128
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"provider_secret" => array (
		"notnull" => true
		,"length" => 128
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"provider_key_customizable" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"provider_icon" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"provider_xml" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"external_provider" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"launch_method" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"has_outcome" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"mastery_score" => array (
		"notnull" => false
		,"type" => "float"
	)
	,"keep_lp" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"privacy_comment_default" => array (
		"notnull" => true
		,"length" => 2000
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"creator" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"accepted_by" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"global" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"use_xapi" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"xapi_launch_key" => array (
		"notnull" => false
		,"length" => 64
		,"fixed" => false
		,"type" => "text"
	)
	,"xapi_launch_secret" => array (
		"notnull" => false
		,"length" => 64
		,"fixed" => false
		,"type" => "text"
	)
	,"xapi_launch_url" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"custom_params" => array (
		"notnull" => false
		,"length" => 1020
		,"fixed" => false
		,"type" => "text"
	)
	,"use_provider_id" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"always_learner" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"xapi_activity_id" => array (
		"notnull" => false
		,"length" => 128
		,"fixed" => false
		,"type" => "text"
	)
	,"keywords" => array (
		"notnull" => false
		,"length" => 1000
		,"fixed" => false
		,"type" => "text"
	)
	,"inc_usr_pic" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"category" => array (
		"notnull" => true
		,"length" => 16
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"privacy_ident" => array (
		"notnull" => true
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"privacy_name" => array (
		"notnull" => true
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("lti_ext_provider", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("lti_ext_provider", $pk_fields);

$ilDB->createSequence("lti_ext_provider", 1);


//
// lti_int_provider_obj
//
$fields = array (
	"ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"ext_consumer_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"admin" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"tutor" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"member" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("lti_int_provider_obj", $fields);

$pk_fields = array("ref_id","ext_consumer_id");
$ilDB->addPrimaryKey("lti_int_provider_obj", $pk_fields);


//
// mail
//
$fields = array (
	"mail_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"folder_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"sender_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"send_time" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"m_status" => array (
		"notnull" => false
		,"length" => 16
		,"fixed" => false
		,"type" => "text"
	)
	,"m_email" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"m_subject" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"import_name" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"use_placeholders" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"m_message" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"rcp_to" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"rcp_cc" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"rcp_bcc" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"attachments" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"tpl_ctx_id" => array (
		"notnull" => false
		,"length" => 100
		,"fixed" => false
		,"type" => "text"
	)
	,"tpl_ctx_params" => array (
		"notnull" => false
		,"type" => "blob"
	)
);
$ilDB->createTable("mail", $fields);

$pk_fields = array("mail_id");
$ilDB->addPrimaryKey("mail", $pk_fields);

$in_fields = array("user_id");
$ilDB->addIndex("mail", $in_fields, "i1", false);

$in_fields = array("folder_id");
$ilDB->addIndex("mail", $in_fields, "i2", false);

$in_fields = array("m_status");
$ilDB->addIndex("mail", $in_fields, "i3", false);

$in_fields = array("sender_id","user_id");
$ilDB->addIndex("mail", $in_fields, "i4", false);

$ilDB->createSequence("mail", 1);


//
// mail_attachment
//
$fields = array (
	"mail_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"path" => array (
		"notnull" => false
		,"length" => 500
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("mail_attachment", $fields);

$pk_fields = array("mail_id");
$ilDB->addPrimaryKey("mail_attachment", $pk_fields);

$in_fields = array("path");
$ilDB->addIndex("mail_attachment", $in_fields, "i1", false);


//
// mail_cron_orphaned
//
$fields = array (
	"mail_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"folder_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"ts_do_delete" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("mail_cron_orphaned", $fields);

$pk_fields = array("mail_id","folder_id");
$ilDB->addPrimaryKey("mail_cron_orphaned", $pk_fields);


//
// mail_man_tpl
//
$fields = array (
	"tpl_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"context" => array (
		"notnull" => true
		,"length" => 100
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"lang" => array (
		"notnull" => true
		,"length" => 2
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"m_subject" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"m_message" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"is_default" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("mail_man_tpl", $fields);

$pk_fields = array("tpl_id");
$ilDB->addPrimaryKey("mail_man_tpl", $pk_fields);

$in_fields = array("context");
$ilDB->addIndex("mail_man_tpl", $in_fields, "i1", false);

$ilDB->createSequence("mail_man_tpl", 1);


//
// mail_obj_data
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 70
		,"fixed" => true
		,"type" => "text"
	)
	,"m_type" => array (
		"notnull" => false
		,"length" => 16
		,"fixed" => true
		,"type" => "text"
	)
);
$ilDB->createTable("mail_obj_data", $fields);

$pk_fields = array("obj_id");
$ilDB->addPrimaryKey("mail_obj_data", $pk_fields);

$in_fields = array("user_id","m_type");
$ilDB->addIndex("mail_obj_data", $in_fields, "i1", false);

$in_fields = array("obj_id","user_id");
$ilDB->addIndex("mail_obj_data", $in_fields, "i2", false);

$ilDB->createSequence("mail_obj_data", 8);

$ilDB->insert("mail_obj_data", array(
'obj_id' => array('integer', '2'), 'user_id' => array('integer', '6'), 'title' => array('text', 'a_root'), 'm_type' => array('text', 'root')));

$ilDB->insert("mail_obj_data", array(
'obj_id' => array('integer', '3'), 'user_id' => array('integer', '6'), 'title' => array('text', 'b_inbox'), 'm_type' => array('text', 'inbox')));

$ilDB->insert("mail_obj_data", array(
'obj_id' => array('integer', '4'), 'user_id' => array('integer', '6'), 'title' => array('text', 'c_trash'), 'm_type' => array('text', 'trash')));

$ilDB->insert("mail_obj_data", array(
'obj_id' => array('integer', '5'), 'user_id' => array('integer', '6'), 'title' => array('text', 'd_drafts'), 'm_type' => array('text', 'drafts')));

$ilDB->insert("mail_obj_data", array(
'obj_id' => array('integer', '6'), 'user_id' => array('integer', '6'), 'title' => array('text', 'e_sent'), 'm_type' => array('text', 'sent')));

$ilDB->insert("mail_obj_data", array(
'obj_id' => array('integer', '7'), 'user_id' => array('integer', '6'), 'title' => array('text', 'z_local'), 'm_type' => array('text', 'local')));


//
// mail_options
//
$fields = array (
	"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"linebreak" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"signature" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"incoming_type" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"cronjob_notification" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"mail_address_option" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "3"
		,"type" => "integer"
	)
);
$ilDB->createTable("mail_options", $fields);

$pk_fields = array("user_id");
$ilDB->addPrimaryKey("mail_options", $pk_fields);

$in_fields = array("user_id","linebreak");
$ilDB->addIndex("mail_options", $in_fields, "i1", false);

$ilDB->insert("mail_options", array(
'user_id' => array('integer', '6'), 'linebreak' => array('integer', '60'), 'signature' => array('text', ''), 'incoming_type' => array('integer', '0'), 'cronjob_notification' => array('integer', '0'), 'mail_address_option' => array('integer', '3')));


//
// mail_saved
//
$fields = array (
	"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"m_email" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"m_subject" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"use_placeholders" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"m_message" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"rcp_to" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"rcp_cc" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"rcp_bcc" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"attachments" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"tpl_ctx_id" => array (
		"notnull" => false
		,"length" => 100
		,"fixed" => false
		,"type" => "text"
	)
	,"tpl_ctx_params" => array (
		"notnull" => false
		,"type" => "blob"
	)
);
$ilDB->createTable("mail_saved", $fields);

$pk_fields = array("user_id");
$ilDB->addPrimaryKey("mail_saved", $pk_fields);


//
// mail_template
//
$fields = array (
	"lang" => array (
		"notnull" => true
		,"length" => 5
		,"default" => " "
		,"fixed" => false
		,"type" => "text"
	)
	,"subject" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"body" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"sal_f" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"sal_m" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"sal_g" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"type" => array (
		"notnull" => true
		,"length" => 4
		,"default" => " "
		,"fixed" => false
		,"type" => "text"
	)
	,"att_file" => array (
		"notnull" => false
		,"length" => 400
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("mail_template", $fields);

$pk_fields = array("type","lang");
$ilDB->addPrimaryKey("mail_template", $pk_fields);


//
// mail_tpl_ctx
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 100
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"component" => array (
		"notnull" => true
		,"length" => 100
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"class" => array (
		"notnull" => true
		,"length" => 100
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"path" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("mail_tpl_ctx", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("mail_tpl_ctx", $pk_fields);

$ilDB->insert("mail_tpl_ctx", array(
'id' => array('text', 'crs_context_member_manual'), 'component' => array('text', 'Modules/Course'), 'class' => array('text', 'ilCourseMailTemplateMemberContext'), 'path' => array('text', '')));

$ilDB->insert("mail_tpl_ctx", array(
'id' => array('text', 'crs_context_tutor_manual'), 'component' => array('text', 'Modules/Course'), 'class' => array('text', 'ilCourseMailTemplateTutorContext'), 'path' => array('text', '')));

$ilDB->insert("mail_tpl_ctx", array(
'id' => array('text', 'mail_template_generic'), 'component' => array('text', 'Services/Mail'), 'class' => array('text', 'ilMailTemplateGenericContext'), 'path' => array('text', '')));

$ilDB->insert("mail_tpl_ctx", array(
'id' => array('text', 'sahs_context_lp'), 'component' => array('text', 'Modules/ScormAicc'), 'class' => array('text', 'ilScormMailTemplateLPContext'), 'path' => array('text', '')));

$ilDB->insert("mail_tpl_ctx", array(
'id' => array('text', 'svy_context_rmd'), 'component' => array('text', 'Modules/Survey'), 'class' => array('text', 'ilSurveyMailTemplateReminderContext'), 'path' => array('text', '')));

$ilDB->insert("mail_tpl_ctx", array(
'id' => array('text', 'exc_context_submit_rmd'), 'component' => array('text', 'Modules/Exercise'), 'class' => array('text', 'ilExcMailTemplateSubmitReminderContext'), 'path' => array('text', '')));

$ilDB->insert("mail_tpl_ctx", array(
'id' => array('text', 'exc_context_grade_rmd'), 'component' => array('text', 'Modules/Exercise'), 'class' => array('text', 'ilExcMailTemplateGradeReminderContext'), 'path' => array('text', '')));

$ilDB->insert("mail_tpl_ctx", array(
'id' => array('text', 'exc_context_peer_rmd'), 'component' => array('text', 'Modules/Exercise'), 'class' => array('text', 'ilExcMailTemplatePeerReminderContext'), 'path' => array('text', '')));

$ilDB->insert("mail_tpl_ctx", array(
'id' => array('text', 'sess_context_participant_manual'), 'component' => array('text', 'Modules/Session'), 'class' => array('text', 'ilSessionMailTemplateParticipantContext'), 'path' => array('text', '')));

$ilDB->insert("mail_tpl_ctx", array(
'id' => array('text', 'prg_context_manual'), 'component' => array('text', 'Modules/StudyProgramme'), 'class' => array('text', 'ilStudyProgrammeMailTemplateContext'), 'path' => array('text', '')));


//
// mail_tree
//
$fields = array (
	"tree" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"child" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"parent" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"lft" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rgt" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"depth" => array (
		"notnull" => true
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("mail_tree", $fields);

$pk_fields = array("child");
$ilDB->addPrimaryKey("mail_tree", $pk_fields);

$in_fields = array("parent");
$ilDB->addIndex("mail_tree", $in_fields, "i2", false);

$in_fields = array("tree");
$ilDB->addIndex("mail_tree", $in_fields, "i3", false);

$ilDB->insert("mail_tree", array(
'tree' => array('integer', '6'), 'child' => array('integer', '2'), 'parent' => array('integer', '0'), 'lft' => array('integer', '1'), 'rgt' => array('integer', '12'), 'depth' => array('integer', '1')));

$ilDB->insert("mail_tree", array(
'tree' => array('integer', '6'), 'child' => array('integer', '3'), 'parent' => array('integer', '2'), 'lft' => array('integer', '2'), 'rgt' => array('integer', '3'), 'depth' => array('integer', '2')));

$ilDB->insert("mail_tree", array(
'tree' => array('integer', '6'), 'child' => array('integer', '4'), 'parent' => array('integer', '2'), 'lft' => array('integer', '4'), 'rgt' => array('integer', '5'), 'depth' => array('integer', '2')));

$ilDB->insert("mail_tree", array(
'tree' => array('integer', '6'), 'child' => array('integer', '5'), 'parent' => array('integer', '2'), 'lft' => array('integer', '6'), 'rgt' => array('integer', '7'), 'depth' => array('integer', '2')));

$ilDB->insert("mail_tree", array(
'tree' => array('integer', '6'), 'child' => array('integer', '6'), 'parent' => array('integer', '2'), 'lft' => array('integer', '8'), 'rgt' => array('integer', '9'), 'depth' => array('integer', '2')));

$ilDB->insert("mail_tree", array(
'tree' => array('integer', '6'), 'child' => array('integer', '7'), 'parent' => array('integer', '2'), 'lft' => array('integer', '10'), 'rgt' => array('integer', '11'), 'depth' => array('integer', '2')));


//
// map_area
//
$fields = array (
	"item_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"nr" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"shape" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
	,"coords" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"link_type" => array (
		"notnull" => false
		,"length" => 3
		,"fixed" => true
		,"type" => "text"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"href" => array (
		"notnull" => false
		,"length" => 800
		,"fixed" => false
		,"type" => "text"
	)
	,"target" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"type" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
	,"target_frame" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
	,"highlight_mode" => array (
		"notnull" => false
		,"length" => 8
		,"fixed" => false
		,"type" => "text"
	)
	,"highlight_class" => array (
		"notnull" => false
		,"length" => 8
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("map_area", $fields);

$pk_fields = array("item_id","nr");
$ilDB->addPrimaryKey("map_area", $pk_fields);

$in_fields = array("link_type","target");
$ilDB->addIndex("map_area", $in_fields, "lt", false);


//
// media_item
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"width" => array (
		"notnull" => false
		,"length" => 10
		,"fixed" => false
		,"type" => "text"
	)
	,"height" => array (
		"notnull" => false
		,"length" => 10
		,"fixed" => false
		,"type" => "text"
	)
	,"halign" => array (
		"notnull" => false
		,"length" => 10
		,"default" => "Left"
		,"fixed" => true
		,"type" => "text"
	)
	,"caption" => array (
		"notnull" => false
		,"length" => 3000
		,"fixed" => false
		,"type" => "text"
	)
	,"nr" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"purpose" => array (
		"notnull" => false
		,"length" => 20
		,"default" => "Standard"
		,"fixed" => true
		,"type" => "text"
	)
	,"mob_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"location" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"location_type" => array (
		"notnull" => false
		,"length" => 10
		,"default" => "LocalFile"
		,"fixed" => true
		,"type" => "text"
	)
	,"format" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"param" => array (
		"notnull" => false
		,"length" => 2000
		,"fixed" => false
		,"type" => "text"
	)
	,"tried_thumb" => array (
		"notnull" => false
		,"length" => 1
		,"default" => "n"
		,"fixed" => true
		,"type" => "text"
	)
	,"text_representation" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"upload_hash" => array (
		"notnull" => false
		,"length" => 100
		,"fixed" => false
		,"type" => "text"
	)
	,"duration" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("media_item", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("media_item", $pk_fields);

$ilDB->createSequence("media_item", 1);


//
// member_agreement
//
$fields = array (
	"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"accepted" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"acceptance_time" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("member_agreement", $fields);

$pk_fields = array("usr_id","obj_id");
$ilDB->addPrimaryKey("member_agreement", $pk_fields);


//
// member_noti
//
$fields = array (
	"ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"nmode" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("member_noti", $fields);

$pk_fields = array("ref_id");
$ilDB->addPrimaryKey("member_noti", $pk_fields);


//
// member_noti_user
//
$fields = array (
	"ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"status" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("member_noti_user", $fields);

$pk_fields = array("ref_id","user_id");
$ilDB->addPrimaryKey("member_noti_user", $pk_fields);


//
// mep_data
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"default_width" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"default_height" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"for_translation" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("mep_data", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("mep_data", $pk_fields);


//
// mep_item
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"type" => array (
		"notnull" => false
		,"length" => 10
		,"fixed" => false
		,"type" => "text"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 128
		,"fixed" => false
		,"type" => "text"
	)
	,"foreign_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"import_id" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("mep_item", $fields);

$pk_fields = array("obj_id");
$ilDB->addPrimaryKey("mep_item", $pk_fields);

$in_fields = array("foreign_id","type");
$ilDB->addIndex("mep_item", $in_fields, "ft", false);

$ilDB->createSequence("mep_item", 2);

$ilDB->insert("mep_item", array(
'obj_id' => array('integer', '1'), 'type' => array('text', 'dummy'), 'title' => array('text', 'Dummy'), 'foreign_id' => array('integer', '1'), 'import_id' => array('text', '')));


//
// mep_tree
//
$fields = array (
	"mep_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"child" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"parent" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"lft" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rgt" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"depth" => array (
		"notnull" => true
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("mep_tree", $fields);

$pk_fields = array("mep_id","child");
$ilDB->addPrimaryKey("mep_tree", $pk_fields);

$in_fields = array("child");
$ilDB->addIndex("mep_tree", $in_fields, "ch", false);

$in_fields = array("parent");
$ilDB->addIndex("mep_tree", $in_fields, "pa", false);

$in_fields = array("mep_id");
$ilDB->addIndex("mep_tree", $in_fields, "me", false);


//
// mob_parameter
//
$fields = array (
	"med_item_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"name" => array (
		"notnull" => true
		,"length" => 50
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"value" => array (
		"notnull" => false
		,"length" => 2000
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("mob_parameter", $fields);

$pk_fields = array("med_item_id","name");
$ilDB->addPrimaryKey("mob_parameter", $pk_fields);


//
// mob_usage
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usage_type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => " "
		,"fixed" => false
		,"type" => "text"
	)
	,"usage_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usage_hist_nr" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usage_lang" => array (
		"notnull" => true
		,"length" => 2
		,"default" => "-"
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("mob_usage", $fields);

$pk_fields = array("id","usage_type","usage_id","usage_hist_nr","usage_lang");
$ilDB->addPrimaryKey("mob_usage", $pk_fields);

$in_fields = array("id");
$ilDB->addIndex("mob_usage", $in_fields, "mi", false);

$in_fields = array("usage_id");
$ilDB->addIndex("mob_usage", $in_fields, "i1", false);


//
// module_class
//
$fields = array (
	"class" => array (
		"notnull" => true
		,"length" => 100
		,"default" => " "
		,"fixed" => false
		,"type" => "text"
	)
	,"module" => array (
		"notnull" => false
		,"length" => 100
		,"fixed" => false
		,"type" => "text"
	)
	,"dir" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("module_class", $fields);

$pk_fields = array("class");
$ilDB->addPrimaryKey("module_class", $pk_fields);

$ilDB->insert("module_class", array(
'class' => array('text', 'ilObjRemoteLearningModuleGUI'), 'module' => array('text', 'RemoteLearningModule'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilObjIndividualAssessmentGUI'), 'module' => array('text', 'IndividualAssessment'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilSystemSupportContactsGUI'), 'module' => array('text', 'SystemFolder'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilAccessibilitySupportContactsGUI'), 'module' => array('text', 'SystemFolder'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilLMEditorGUI'), 'module' => array('text', 'LearningModule'), 'dir' => array('text', 'Editing/classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilLMPresentationGUI'), 'module' => array('text', 'LearningModule'), 'dir' => array('text', 'Presentation/classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilGlossaryEditorGUI'), 'module' => array('text', 'Glossary'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilGlossaryPresentationGUI'), 'module' => array('text', 'Glossary'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilSAHSPresentationGUI'), 'module' => array('text', 'ScormAicc'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilSAHSEditGUI'), 'module' => array('text', 'ScormAicc'), 'dir' => array('text', 'Editing/classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilObjCategoryReferenceGUI'), 'module' => array('text', 'CategoryReference'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilObjRemoteWikiGUI'), 'module' => array('text', 'RemoteWiki'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilObjStudyProgrammeReferenceGUI'), 'module' => array('text', 'StudyProgrammeReference'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilExerciseHandlerGUI'), 'module' => array('text', 'Exercise'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilObjGroupReferenceGUI'), 'module' => array('text', 'GroupReference'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilObjChatroomGUI'), 'module' => array('text', 'Chatroom'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilObjChatroomAdminGUI'), 'module' => array('text', 'Chatroom'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilHTLMEditorGUI'), 'module' => array('text', 'HTMLLearningModule'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilHTLMPresentationGUI'), 'module' => array('text', 'HTMLLearningModule'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilObjQuestionPoolGUI'), 'module' => array('text', 'TestQuestionPool'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilObjCourseReferenceGUI'), 'module' => array('text', 'CourseReference'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilObjLearningSequenceGUI'), 'module' => array('text', 'LearningSequence'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilLinkResourceHandlerGUI'), 'module' => array('text', 'WebResource'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'LTIConsumerGUI'), 'module' => array('text', 'LTIConsumer'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilObjRemoteGlossaryGUI'), 'module' => array('text', 'RemoteGlossary'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilObjRemoteCourseGUI'), 'module' => array('text', 'RemoteCourse'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilObjTestGUI'), 'module' => array('text', 'Test'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilObjPortfolioGUI'), 'module' => array('text', 'Portfolio'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilPortfolioRepositoryGUI'), 'module' => array('text', 'Portfolio'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilObjRemoteTestGUI'), 'module' => array('text', 'RemoteTest'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilObjRemoteCategoryGUI'), 'module' => array('text', 'RemoteCategory'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilObjRemoteGroupGUI'), 'module' => array('text', 'RemoteGroup'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilObjRemoteFileGUI'), 'module' => array('text', 'RemoteFile'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilMediaCastHandlerGUI'), 'module' => array('text', 'MediaCast'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'CmiXapiGUI'), 'module' => array('text', 'CmiXapi'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilMediaPoolPresentationGUI'), 'module' => array('text', 'MediaPool'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilWikiHandlerGUI'), 'module' => array('text', 'Wiki'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilObjSurveyQuestionPoolGUI'), 'module' => array('text', 'SurveyQuestionPool'), 'dir' => array('text', 'classes')));

$ilDB->insert("module_class", array(
'class' => array('text', 'ilObjSurveyGUI'), 'module' => array('text', 'Survey'), 'dir' => array('text', 'classes')));


//
// note
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rep_obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => false
		,"length" => 10
		,"fixed" => false
		,"type" => "text"
	)
	,"type" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"author" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"note_text" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"label" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"creation_date" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"update_date" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"subject" => array (
		"notnull" => false
		,"length" => 200
		,"fixed" => false
		,"type" => "text"
	)
	,"no_repository" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"news_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("note", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("note", $pk_fields);

$in_fields = array("author");
$ilDB->addIndex("note", $in_fields, "i1", false);

$in_fields = array("rep_obj_id","obj_id","obj_type");
$ilDB->addIndex("note", $in_fields, "i2", false);

$ilDB->createSequence("note", 1);


//
// note_settings
//
$fields = array (
	"rep_obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => "-"
		,"fixed" => false
		,"type" => "text"
	)
	,"activated" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("note_settings", $fields);

$pk_fields = array("rep_obj_id","obj_id","obj_type");
$ilDB->addPrimaryKey("note_settings", $pk_fields);


//
// notification
//
$fields = array (
	"type" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"last_mail" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"page_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"activated" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("notification", $fields);

$pk_fields = array("type","id","user_id");
$ilDB->addPrimaryKey("notification", $pk_fields);


//
// notification_channels
//
$fields = array (
	"channel_name" => array (
		"notnull" => true
		,"length" => 100
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"title" => array (
		"notnull" => true
		,"length" => 100
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"description" => array (
		"notnull" => true
		,"length" => 4000
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"class" => array (
		"notnull" => true
		,"length" => 100
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"include" => array (
		"notnull" => true
		,"length" => 100
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"config_type" => array (
		"notnull" => true
		,"length" => 30
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("notification_channels", $fields);

$pk_fields = array("channel_name");
$ilDB->addPrimaryKey("notification_channels", $pk_fields);

$ilDB->insert("notification_channels", array(
'channel_name' => array('text', 'mail'), 'title' => array('text', 'mail'), 'description' => array('text', 'mail_desc'), 'class' => array('text', 'ilNotificationMailHandler'), 'include' => array('text', 'Services/Notifications/classes/class.ilNotificationMailHandler.php'), 'config_type' => array('text', 'set_by_admin')));

$ilDB->insert("notification_channels", array(
'channel_name' => array('text', 'osd'), 'title' => array('text', 'osd'), 'description' => array('text', 'osd_desc'), 'class' => array('text', 'ilNotificationOSDHandler'), 'include' => array('text', 'Services/Notifications/classes/class.ilNotificationOSDHandler.php'), 'config_type' => array('text', 'set_by_admin')));


//
// notification_data
//
$fields = array (
	"notification_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"serialized" => array (
		"notnull" => true
		,"length" => 4000
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("notification_data", $fields);

$pk_fields = array("notification_id");
$ilDB->addPrimaryKey("notification_data", $pk_fields);

$ilDB->createSequence("notification_data", 1);


//
// notification_listener
//
$fields = array (
	"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"module" => array (
		"notnull" => true
		,"length" => 100
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"sender_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"disabled" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("notification_listener", $fields);

$pk_fields = array("usr_id","module","sender_id");
$ilDB->addPrimaryKey("notification_listener", $pk_fields);


//
// notification_osd
//
$fields = array (
	"notification_osd_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"serialized" => array (
		"notnull" => true
		,"length" => 4000
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"valid_until" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"time_added" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"type" => array (
		"notnull" => true
		,"length" => 100
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"visible_for" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("notification_osd", $fields);

$pk_fields = array("notification_osd_id");
$ilDB->addPrimaryKey("notification_osd", $pk_fields);

$ilDB->createSequence("notification_osd", 1);


//
// notification_queue
//
$fields = array (
	"notification_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"valid_until" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("notification_queue", $fields);

$pk_fields = array("notification_id","usr_id");
$ilDB->addPrimaryKey("notification_queue", $pk_fields);


//
// notification_types
//
$fields = array (
	"type_name" => array (
		"notnull" => true
		,"length" => 100
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"title" => array (
		"notnull" => true
		,"length" => 100
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"description" => array (
		"notnull" => true
		,"length" => 100
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"notification_group" => array (
		"notnull" => true
		,"length" => 100
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"config_type" => array (
		"notnull" => true
		,"length" => 30
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("notification_types", $fields);

$pk_fields = array("type_name");
$ilDB->addPrimaryKey("notification_types", $pk_fields);

$ilDB->insert("notification_types", array(
'type_name' => array('text', 'chat_invitation'), 'title' => array('text', 'chat_invitation'), 'description' => array('text', 'chat_invitation_description'), 'notification_group' => array('text', 'chat'), 'config_type' => array('text', 'set_by_admin')));

$ilDB->insert("notification_types", array(
'type_name' => array('text', 'osd_maint'), 'title' => array('text', 'osd_maint'), 'description' => array('text', 'osd_maint_description'), 'notification_group' => array('text', 'osd_notification'), 'config_type' => array('text', 'set_by_admin')));


//
// notification_usercfg
//
$fields = array (
	"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"module" => array (
		"notnull" => true
		,"length" => 100
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"channel" => array (
		"notnull" => true
		,"length" => 100
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("notification_usercfg", $fields);

$pk_fields = array("usr_id","module","channel");
$ilDB->addPrimaryKey("notification_usercfg", $pk_fields);

$ilDB->insert("notification_usercfg", array(
'usr_id' => array('integer', '-1'), 'module' => array('text', 'buddysystem_request'), 'channel' => array('text', 'mail')));

$ilDB->insert("notification_usercfg", array(
'usr_id' => array('integer', '-1'), 'module' => array('text', 'buddysystem_request'), 'channel' => array('text', 'osd')));

$ilDB->insert("notification_usercfg", array(
'usr_id' => array('integer', '-1'), 'module' => array('text', 'chat_invitation'), 'channel' => array('text', 'mail')));

$ilDB->insert("notification_usercfg", array(
'usr_id' => array('integer', '-1'), 'module' => array('text', 'chat_invitation'), 'channel' => array('text', 'osd')));

$ilDB->insert("notification_usercfg", array(
'usr_id' => array('integer', '-1'), 'module' => array('text', 'osd_main'), 'channel' => array('text', 'osd')));


//
// obj_content_master_lng
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"master_lang" => array (
		"notnull" => true
		,"length" => 2
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"fallback_lang" => array (
		"notnull" => false
		,"length" => 2
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("obj_content_master_lng", $fields);

$pk_fields = array("obj_id");
$ilDB->addPrimaryKey("obj_content_master_lng", $pk_fields);


//
// obj_lp_stat
//
$fields = array (
	"type" => array (
		"notnull" => true
		,"length" => 4
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"yyyy" => array (
		"notnull" => true
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"mm" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"dd" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"fulldate" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"mem_cnt" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"in_progress" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"completed" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"failed" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"not_attempted" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("obj_lp_stat", $fields);

$pk_fields = array("obj_id","fulldate");
$ilDB->addPrimaryKey("obj_lp_stat", $pk_fields);


//
// obj_members
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"blocked" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"notification" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"passed" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"origin" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"origin_ts" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"contact" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"admin" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"tutor" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"member" => array (
		"notnull" => false
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("obj_members", $fields);

$pk_fields = array("obj_id","usr_id");
$ilDB->addPrimaryKey("obj_members", $pk_fields);

$in_fields = array("usr_id");
$ilDB->addIndex("obj_members", $in_fields, "i1", false);


//
// obj_noti_settings
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"noti_mode" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("obj_noti_settings", $fields);

$pk_fields = array("obj_id");
$ilDB->addPrimaryKey("obj_noti_settings", $pk_fields);


//
// obj_stat
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"yyyy" => array (
		"notnull" => true
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"mm" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"dd" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"hh" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"read_count" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"childs_read_count" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"spent_seconds" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"childs_spent_seconds" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("obj_stat", $fields);

$pk_fields = array("obj_id","yyyy","mm","dd","hh");
$ilDB->addPrimaryKey("obj_stat", $pk_fields);


//
// obj_stat_log
//
$fields = array (
	"log_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"tstamp" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"yyyy" => array (
		"notnull" => false
		,"length" => 2
		,"unsigned" => false
		,"type" => "integer"
	)
	,"mm" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"dd" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"hh" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"read_count" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"childs_read_count" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"spent_seconds" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"childs_spent_seconds" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("obj_stat_log", $fields);

$pk_fields = array("log_id");
$ilDB->addPrimaryKey("obj_stat_log", $pk_fields);

$in_fields = array("tstamp");
$ilDB->addIndex("obj_stat_log", $in_fields, "i1", false);

$ilDB->createSequence("obj_stat_log", 1);


//
// obj_stat_tmp
//
$fields = array (
	"log_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"tstamp" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"yyyy" => array (
		"notnull" => false
		,"length" => 2
		,"unsigned" => false
		,"type" => "integer"
	)
	,"mm" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"dd" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"hh" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"read_count" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"childs_read_count" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"spent_seconds" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"childs_spent_seconds" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("obj_stat_tmp", $fields);

$pk_fields = array("log_id");
$ilDB->addPrimaryKey("obj_stat_tmp", $pk_fields);

$in_fields = array("obj_id","obj_type","yyyy","mm","dd","hh");
$ilDB->addIndex("obj_stat_tmp", $in_fields, "i1", false);


//
// obj_type_stat
//
$fields = array (
	"type" => array (
		"notnull" => true
		,"length" => 4
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"yyyy" => array (
		"notnull" => true
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"mm" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"dd" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"fulldate" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"cnt_references" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"cnt_objects" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"cnt_deleted" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("obj_type_stat", $fields);

$pk_fields = array("type","fulldate");
$ilDB->addPrimaryKey("obj_type_stat", $pk_fields);


//
// obj_user_data_hist
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"update_user" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"editing_time" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
);
$ilDB->createTable("obj_user_data_hist", $fields);

$pk_fields = array("obj_id","usr_id");
$ilDB->addPrimaryKey("obj_user_data_hist", $pk_fields);


//
// obj_user_stat
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"yyyy" => array (
		"notnull" => true
		,"length" => 2
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"mm" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"dd" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"fulldate" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"counter" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("obj_user_stat", $fields);

$pk_fields = array("obj_id","fulldate");
$ilDB->addPrimaryKey("obj_user_stat", $pk_fields);


//
// object_data
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"type" => array (
		"notnull" => false
		,"length" => 4
		,"default" => "none"
		,"fixed" => true
		,"type" => "text"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => true
		,"type" => "text"
	)
	,"description" => array (
		"notnull" => false
		,"length" => 128
		,"fixed" => true
		,"type" => "text"
	)
	,"owner" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"create_date" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"last_update" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"import_id" => array (
		"notnull" => false
		,"length" => 50
		,"fixed" => true
		,"type" => "text"
	)
	,"offline" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("object_data", $fields);

$pk_fields = array("obj_id");
$ilDB->addPrimaryKey("object_data", $pk_fields);

$in_fields = array("type");
$ilDB->addIndex("object_data", $in_fields, "i1", false);

$in_fields = array("title");
$ilDB->addIndex("object_data", $in_fields, "i2", false);

$in_fields = array("import_id");
$ilDB->addIndex("object_data", $in_fields, "i4", false);

$in_fields = array("owner");
$ilDB->addIndex("object_data", $in_fields, "i5", false);

$ilDB->createSequence("object_data", 303);

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '1'), 'type' => array('text', 'root'), 'title' => array('text', 'ILIAS'), 'description' => array('text', 'This is the root node of the system!!!'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2002-06-24 15:15:03'), 'last_update' => array('timestamp', '2004-01-20 12:24:12'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '2'), 'type' => array('text', 'role'), 'title' => array('text', 'Administrator'), 'description' => array('text', 'Role for systemadministrators. This role grants access to everything!'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2002-01-16 15:31:45'), 'last_update' => array('timestamp', '2003-08-15 13:18:57'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '3'), 'type' => array('text', 'rolt'), 'title' => array('text', 'Author'), 'description' => array('text', 'Role template for authors with write & create permissions.'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2002-01-16 15:32:50'), 'last_update' => array('timestamp', '2016-12-16 14:58:27'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '4'), 'type' => array('text', 'role'), 'title' => array('text', 'User'), 'description' => array('text', 'Standard role for registered users. Grants read access to most objects.'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2002-01-16 15:34:00'), 'last_update' => array('timestamp', '2016-12-16 14:56:25'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '5'), 'type' => array('text', 'role'), 'title' => array('text', 'Guest'), 'description' => array('text', 'Role grants only a few visible & read permissions.'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2002-01-16 15:34:46'), 'last_update' => array('timestamp', '2016-12-16 14:54:14'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '6'), 'type' => array('text', 'usr'), 'title' => array('text', 'root user'), 'description' => array('text', 'ilias@yourserver.com'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2002-01-16 16:09:22'), 'last_update' => array('timestamp', '2016-12-14 14:44:49'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '7'), 'type' => array('text', 'usrf'), 'title' => array('text', 'User accounts'), 'description' => array('text', 'Manage user accounts here.'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2002-06-27 09:24:06'), 'last_update' => array('timestamp', '2004-01-20 12:23:47'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '8'), 'type' => array('text', 'rolf'), 'title' => array('text', 'Roles'), 'description' => array('text', 'Manage your roles here.'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2002-06-27 09:24:06'), 'last_update' => array('timestamp', '2004-01-20 12:23:40'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '9'), 'type' => array('text', 'adm'), 'title' => array('text', 'System Settings'), 'description' => array('text', 'Folder contains the systems settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2002-07-15 12:37:33'), 'last_update' => array('timestamp', '2002-07-15 12:37:33'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '10'), 'type' => array('text', 'objf'), 'title' => array('text', 'Objectdefinitions'), 'description' => array('text', 'Manage ILIAS object types and object permissions. (only for experts!)'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2002-07-15 12:36:56'), 'last_update' => array('timestamp', '2004-01-20 12:23:53'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '11'), 'type' => array('text', 'lngf'), 'title' => array('text', 'Languages'), 'description' => array('text', 'Manage your system languages here.'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2002-07-15 15:52:51'), 'last_update' => array('timestamp', '2004-01-20 12:24:06'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '12'), 'type' => array('text', 'mail'), 'title' => array('text', 'Mail Settings'), 'description' => array('text', 'Configure global mail settings here.'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2003-08-15 10:07:28'), 'last_update' => array('timestamp', '2004-01-20 12:24:00'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '13'), 'type' => array('text', 'usr'), 'title' => array('text', 'Anonymous'), 'description' => array('text', 'Anonymous user account. DO NOT DELETE!'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2003-08-15 10:07:30'), 'last_update' => array('timestamp', '2003-08-15 10:07:30'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '14'), 'type' => array('text', 'role'), 'title' => array('text', 'Anonymous'), 'description' => array('text', 'Default role for anonymous users (with no account)'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2003-08-15 12:06:19'), 'last_update' => array('timestamp', '2005-07-20 15:15:06'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '15'), 'type' => array('text', 'typ'), 'title' => array('text', 'grp'), 'description' => array('text', 'Group object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2002-07-15 15:54:37'), 'last_update' => array('timestamp', '2002-07-15 15:54:37'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '16'), 'type' => array('text', 'typ'), 'title' => array('text', 'cat'), 'description' => array('text', 'Category object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2002-07-15 15:54:54'), 'last_update' => array('timestamp', '2002-07-15 15:54:54'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '17'), 'type' => array('text', 'typ'), 'title' => array('text', 'crs'), 'description' => array('text', 'Course object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2002-07-15 15:55:08'), 'last_update' => array('timestamp', '2002-07-15 15:55:08'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '18'), 'type' => array('text', 'typ'), 'title' => array('text', 'mob'), 'description' => array('text', 'Multimedia object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', ''), 'last_update' => array('timestamp', '2003-08-15 12:03:20'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '19'), 'type' => array('text', 'typ'), 'title' => array('text', 'mail'), 'description' => array('text', 'Mailmodule object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2002-07-15 15:55:49'), 'last_update' => array('timestamp', '2002-07-15 15:55:49'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '20'), 'type' => array('text', 'typ'), 'title' => array('text', 'sahs'), 'description' => array('text', 'SCORM/AICC Learning Module'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2003-08-15 10:07:28'), 'last_update' => array('timestamp', '2003-08-15 12:23:10'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '21'), 'type' => array('text', 'typ'), 'title' => array('text', 'adm'), 'description' => array('text', 'Administration Panel object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2002-07-15 15:56:38'), 'last_update' => array('timestamp', '2002-07-15 15:56:38'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '22'), 'type' => array('text', 'typ'), 'title' => array('text', 'usrf'), 'description' => array('text', 'User Folder object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2002-07-15 15:56:52'), 'last_update' => array('timestamp', '2002-07-15 15:56:52'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '23'), 'type' => array('text', 'typ'), 'title' => array('text', 'rolf'), 'description' => array('text', 'Role Folder object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2002-07-15 15:57:06'), 'last_update' => array('timestamp', '2002-07-15 15:57:06'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '24'), 'type' => array('text', 'typ'), 'title' => array('text', 'objf'), 'description' => array('text', 'Object-Type Folder object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2002-07-15 15:57:17'), 'last_update' => array('timestamp', '2002-07-15 15:57:17'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '25'), 'type' => array('text', 'typ'), 'title' => array('text', 'usr'), 'description' => array('text', 'User object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2002-07-15 15:53:37'), 'last_update' => array('timestamp', '2003-08-15 12:30:56'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '26'), 'type' => array('text', 'typ'), 'title' => array('text', 'typ'), 'description' => array('text', 'Object Type Definition object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2002-07-15 15:58:16'), 'last_update' => array('timestamp', '2002-07-15 15:58:16'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '27'), 'type' => array('text', 'typ'), 'title' => array('text', 'rolt'), 'description' => array('text', 'Role template object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2002-07-15 15:58:16'), 'last_update' => array('timestamp', '2002-07-15 15:58:16'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '28'), 'type' => array('text', 'typ'), 'title' => array('text', 'lngf'), 'description' => array('text', 'Language Folder object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2002-08-28 14:22:01'), 'last_update' => array('timestamp', '2002-08-28 14:22:01'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '29'), 'type' => array('text', 'typ'), 'title' => array('text', 'lng'), 'description' => array('text', 'Language object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2002-08-30 10:18:29'), 'last_update' => array('timestamp', '2002-08-30 10:18:29'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '30'), 'type' => array('text', 'typ'), 'title' => array('text', 'role'), 'description' => array('text', 'Role Object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2002-08-30 10:21:37'), 'last_update' => array('timestamp', '2002-08-30 10:21:37'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '31'), 'type' => array('text', 'typ'), 'title' => array('text', 'dbk'), 'description' => array('text', 'Digilib Book'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2003-08-15 10:07:29'), 'last_update' => array('timestamp', '2003-08-15 12:30:19'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '32'), 'type' => array('text', 'typ'), 'title' => array('text', 'glo'), 'description' => array('text', 'Glossary'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2003-08-15 10:07:30'), 'last_update' => array('timestamp', '2003-08-15 12:29:54'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '33'), 'type' => array('text', 'typ'), 'title' => array('text', 'root'), 'description' => array('text', 'Root Folder Object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2002-12-21 00:04:00'), 'last_update' => array('timestamp', '2003-08-15 12:04:20'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '34'), 'type' => array('text', 'typ'), 'title' => array('text', 'lm'), 'description' => array('text', 'Learning module Object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2002-07-15 15:54:04'), 'last_update' => array('timestamp', '2003-08-15 12:33:04'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '35'), 'type' => array('text', 'typ'), 'title' => array('text', 'notf'), 'description' => array('text', 'Note Folder Object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2002-12-21 00:04:00'), 'last_update' => array('timestamp', '2002-12-21 00:04:00'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '36'), 'type' => array('text', 'typ'), 'title' => array('text', 'note'), 'description' => array('text', 'Note Object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2002-12-21 00:04:00'), 'last_update' => array('timestamp', '2002-12-21 00:04:00'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '37'), 'type' => array('text', 'typ'), 'title' => array('text', 'frm'), 'description' => array('text', 'Forum object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2002-07-15 15:54:22'), 'last_update' => array('timestamp', '2003-08-15 12:36:40'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '70'), 'type' => array('text', 'lng'), 'title' => array('text', 'en'), 'description' => array('text', 'installed_local'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', ''), 'last_update' => array('timestamp', '2020-11-20 17:13:24'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '71'), 'type' => array('text', 'lng'), 'title' => array('text', 'de'), 'description' => array('text', 'not_installed'), 'owner' => array('integer', '6'), 'create_date' => array('timestamp', '2003-08-15 10:25:19'), 'last_update' => array('timestamp', '2015-12-22 16:29:24'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '72'), 'type' => array('text', 'lng'), 'title' => array('text', 'es'), 'description' => array('text', 'not_installed'), 'owner' => array('integer', '6'), 'create_date' => array('timestamp', '2003-08-15 10:25:19'), 'last_update' => array('timestamp', '2003-08-15 10:25:19'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '73'), 'type' => array('text', 'lng'), 'title' => array('text', 'it'), 'description' => array('text', 'not_installed'), 'owner' => array('integer', '6'), 'create_date' => array('timestamp', '2003-08-15 10:25:19'), 'last_update' => array('timestamp', '2003-08-15 10:25:19'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '80'), 'type' => array('text', 'rolt'), 'title' => array('text', 'il_grp_admin'), 'description' => array('text', 'Administrator role template of groups'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2003-08-15 10:07:28'), 'last_update' => array('timestamp', '2016-12-16 15:05:30'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '81'), 'type' => array('text', 'rolt'), 'title' => array('text', 'il_grp_member'), 'description' => array('text', 'Member role template of groups'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2003-08-15 10:07:28'), 'last_update' => array('timestamp', '2016-12-16 15:06:38'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '82'), 'type' => array('text', 'rolt'), 'title' => array('text', 'il_grp_status_closed'), 'description' => array('text', 'Group role template'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2003-08-15 10:07:29'), 'last_update' => array('timestamp', '2003-08-15 13:21:38'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '83'), 'type' => array('text', 'rolt'), 'title' => array('text', 'il_grp_status_open'), 'description' => array('text', 'Group role template'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2003-08-15 10:07:29'), 'last_update' => array('timestamp', '2003-08-15 13:21:25'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '84'), 'type' => array('text', 'typ'), 'title' => array('text', 'exc'), 'description' => array('text', 'Exercise object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2003-11-30 21:22:49'), 'last_update' => array('timestamp', '2003-11-30 21:22:49'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '85'), 'type' => array('text', 'typ'), 'title' => array('text', 'auth'), 'description' => array('text', 'Authentication settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2003-11-30 21:22:49'), 'last_update' => array('timestamp', '2003-11-30 21:22:49'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '86'), 'type' => array('text', 'auth'), 'title' => array('text', 'Authentication settings'), 'description' => array('text', 'Select and configure authentication mode for all user accounts'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2003-11-30 21:22:49'), 'last_update' => array('timestamp', '2003-11-30 21:22:49'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '87'), 'type' => array('text', 'typ'), 'title' => array('text', 'fold'), 'description' => array('text', 'Folder object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2003-11-30 21:22:50'), 'last_update' => array('timestamp', '2003-11-30 21:22:50'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '88'), 'type' => array('text', 'typ'), 'title' => array('text', 'file'), 'description' => array('text', 'File object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2003-11-30 21:22:50'), 'last_update' => array('timestamp', '2003-11-30 21:22:50'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '89'), 'type' => array('text', 'lng'), 'title' => array('text', 'fr'), 'description' => array('text', 'not_installed'), 'owner' => array('integer', '6'), 'create_date' => array('timestamp', '2004-01-20 12:22:17'), 'last_update' => array('timestamp', '2004-01-20 12:22:17'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '90'), 'type' => array('text', 'lng'), 'title' => array('text', 'nl'), 'description' => array('text', 'not_installed'), 'owner' => array('integer', '6'), 'create_date' => array('timestamp', '2004-01-20 12:22:17'), 'last_update' => array('timestamp', '2004-01-20 12:22:17'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '91'), 'type' => array('text', 'lng'), 'title' => array('text', 'pl'), 'description' => array('text', 'not_installed'), 'owner' => array('integer', '6'), 'create_date' => array('timestamp', '2004-01-20 12:22:17'), 'last_update' => array('timestamp', '2004-01-20 12:22:17'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '93'), 'type' => array('text', 'lng'), 'title' => array('text', 'zh'), 'description' => array('text', 'not_installed'), 'owner' => array('integer', '6'), 'create_date' => array('timestamp', '2004-01-20 12:22:17'), 'last_update' => array('timestamp', '2004-01-20 12:22:17'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '94'), 'type' => array('text', 'typ'), 'title' => array('text', 'tst'), 'description' => array('text', 'Test object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2004-02-18 21:17:40'), 'last_update' => array('timestamp', '2004-02-18 21:17:40'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '95'), 'type' => array('text', 'typ'), 'title' => array('text', 'qpl'), 'description' => array('text', 'Question pool object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2004-02-18 21:17:40'), 'last_update' => array('timestamp', '2004-02-18 21:17:40'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '99'), 'type' => array('text', 'typ'), 'title' => array('text', 'recf'), 'description' => array('text', 'RecoveryFolder object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2004-03-09 18:13:16'), 'last_update' => array('timestamp', '2004-03-09 18:13:16'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '100'), 'type' => array('text', 'recf'), 'title' => array('text', '__Restored Objects'), 'description' => array('text', 'Contains objects restored by recovery tool'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2004-03-09 18:13:16'), 'last_update' => array('timestamp', '2004-03-09 18:13:16'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '101'), 'type' => array('text', 'typ'), 'title' => array('text', 'mep'), 'description' => array('text', 'Media pool object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2004-04-19 00:09:14'), 'last_update' => array('timestamp', '2004-04-19 00:09:14'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '102'), 'type' => array('text', 'typ'), 'title' => array('text', 'htlm'), 'description' => array('text', 'HTML LM object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2004-04-19 00:09:15'), 'last_update' => array('timestamp', '2004-04-19 00:09:15'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '103'), 'type' => array('text', 'typ'), 'title' => array('text', 'svy'), 'description' => array('text', 'Survey object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2004-05-15 01:18:59'), 'last_update' => array('timestamp', '2004-05-15 01:18:59'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '104'), 'type' => array('text', 'typ'), 'title' => array('text', 'spl'), 'description' => array('text', 'Question pool object (Survey)'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2004-05-15 01:18:59'), 'last_update' => array('timestamp', '2004-05-15 01:18:59'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '106'), 'type' => array('text', 'typ'), 'title' => array('text', 'cals'), 'description' => array('text', 'Calendar Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2004-06-21 01:27:18'), 'last_update' => array('timestamp', '2004-06-21 01:27:18'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '107'), 'type' => array('text', 'cals'), 'title' => array('text', 'Calendar Settings'), 'description' => array('text', 'Configure Calendar Settings here'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2004-06-21 01:27:18'), 'last_update' => array('timestamp', '2004-06-21 01:27:18'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '108'), 'type' => array('text', 'typ'), 'title' => array('text', 'trac'), 'description' => array('text', 'UserTracking object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2004-07-11 01:03:12'), 'last_update' => array('timestamp', '2004-07-11 01:03:12'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '109'), 'type' => array('text', 'trac'), 'title' => array('text', '__User Tracking'), 'description' => array('text', 'System user tracking'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2004-07-11 01:03:12'), 'last_update' => array('timestamp', '2004-07-11 01:03:12'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '110'), 'type' => array('text', 'rolt'), 'title' => array('text', 'il_crs_admin'), 'description' => array('text', 'Administrator template for course admins'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2004-09-02 09:49:43'), 'last_update' => array('timestamp', '2016-12-16 15:00:10'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '111'), 'type' => array('text', 'rolt'), 'title' => array('text', 'il_crs_tutor'), 'description' => array('text', 'Tutor template for course tutors'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2004-09-02 09:49:43'), 'last_update' => array('timestamp', '2016-12-16 15:03:56'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '112'), 'type' => array('text', 'rolt'), 'title' => array('text', 'il_crs_member'), 'description' => array('text', 'Member template for course members'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2004-09-02 09:49:43'), 'last_update' => array('timestamp', '2016-12-16 15:00:53'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '115'), 'type' => array('text', 'typ'), 'title' => array('text', 'assf'), 'description' => array('text', 'AssessmentFolder object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2005-01-07 17:21:15'), 'last_update' => array('timestamp', '2005-01-07 17:21:15'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '116'), 'type' => array('text', 'assf'), 'title' => array('text', '__Test&Assessment'), 'description' => array('text', 'Test&Assessment Administration'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2005-01-07 17:21:15'), 'last_update' => array('timestamp', '2005-01-07 17:21:15'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '117'), 'type' => array('text', 'typ'), 'title' => array('text', 'stys'), 'description' => array('text', 'Style Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2005-03-02 08:59:01'), 'last_update' => array('timestamp', '2005-03-02 08:59:01'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '118'), 'type' => array('text', 'stys'), 'title' => array('text', 'System Style Settings'), 'description' => array('text', 'Manage system skin and style settings here'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2005-03-02 08:59:01'), 'last_update' => array('timestamp', '2005-03-02 08:59:01'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '121'), 'type' => array('text', 'typ'), 'title' => array('text', 'crsg'), 'description' => array('text', 'Course grouping object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2005-03-02 08:59:02'), 'last_update' => array('timestamp', '2005-03-02 08:59:02'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '122'), 'type' => array('text', 'typ'), 'title' => array('text', 'webr'), 'description' => array('text', 'Link resource object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2005-03-13 22:41:38'), 'last_update' => array('timestamp', '2005-03-13 22:41:38'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '123'), 'type' => array('text', 'typ'), 'title' => array('text', 'seas'), 'description' => array('text', 'Search settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2005-06-20 09:50:00'), 'last_update' => array('timestamp', '2005-06-20 09:50:00'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '124'), 'type' => array('text', 'seas'), 'title' => array('text', 'Search settings'), 'description' => array('text', 'Search settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2005-06-20 09:50:00'), 'last_update' => array('timestamp', '2005-06-20 09:50:00'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '125'), 'type' => array('text', 'rolt'), 'title' => array('text', 'Local Administrator'), 'description' => array('text', 'Role template for local administrators.'), 'owner' => array('integer', '6'), 'create_date' => array('timestamp', '2005-07-20 15:33:13'), 'last_update' => array('timestamp', '2016-12-16 15:09:46'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '127'), 'type' => array('text', 'typ'), 'title' => array('text', 'extt'), 'description' => array('text', 'external tools settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2005-07-20 18:10:04'), 'last_update' => array('timestamp', '2005-07-20 18:10:04'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '128'), 'type' => array('text', 'extt'), 'title' => array('text', 'External tools settings'), 'description' => array('text', 'Configuring external tools'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2005-07-20 18:10:04'), 'last_update' => array('timestamp', '2005-07-20 18:10:04'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '131'), 'type' => array('text', 'rolt'), 'title' => array('text', 'il_crs_non_member'), 'description' => array('text', 'Non-member template for course object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2005-11-07 12:41:21'), 'last_update' => array('timestamp', '2015-12-22 15:35:30'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '135'), 'type' => array('text', 'typ'), 'title' => array('text', 'adve'), 'description' => array('text', 'Advanced editing object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2006-07-11 18:43:23'), 'last_update' => array('timestamp', '2006-07-11 18:43:23'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '136'), 'type' => array('text', 'adve'), 'title' => array('text', '__AdvancedEditing'), 'description' => array('text', 'Advanced Editing'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2006-07-11 18:43:23'), 'last_update' => array('timestamp', '2006-07-11 18:43:23'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '137'), 'type' => array('text', 'typ'), 'title' => array('text', 'ps'), 'description' => array('text', 'Privacy security settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2007-02-26 17:58:49'), 'last_update' => array('timestamp', '2007-02-26 17:58:49'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '138'), 'type' => array('text', 'ps'), 'title' => array('text', '__PrivacySecurity'), 'description' => array('text', 'Privacy and Security'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2007-02-26 17:58:49'), 'last_update' => array('timestamp', '2007-02-26 17:58:49'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '139'), 'type' => array('text', 'typ'), 'title' => array('text', 'nwss'), 'description' => array('text', 'News settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2007-02-26 17:58:50'), 'last_update' => array('timestamp', '2007-02-26 17:58:50'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '140'), 'type' => array('text', 'nwss'), 'title' => array('text', '__NewsSettings'), 'description' => array('text', 'News Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2007-02-26 17:58:50'), 'last_update' => array('timestamp', '2007-02-26 17:58:50'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '141'), 'type' => array('text', 'typ'), 'title' => array('text', 'feed'), 'description' => array('text', 'External Feed'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2007-02-26 17:58:50'), 'last_update' => array('timestamp', '2007-02-26 17:58:50'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '142'), 'type' => array('text', 'typ'), 'title' => array('text', 'mcst'), 'description' => array('text', 'Media Cast'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2007-04-03 13:43:46'), 'last_update' => array('timestamp', '2007-04-03 13:43:46'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '143'), 'type' => array('text', 'typ'), 'title' => array('text', 'dshs'), 'description' => array('text', 'Dashboard Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2007-04-03 13:43:47'), 'last_update' => array('timestamp', '2007-04-03 13:43:47'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '144'), 'type' => array('text', 'dshs'), 'title' => array('text', '__DashboardSettings'), 'description' => array('text', 'Dashboard Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2007-04-03 13:43:47'), 'last_update' => array('timestamp', '2007-04-03 13:43:47'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '145'), 'type' => array('text', 'typ'), 'title' => array('text', 'rcrs'), 'description' => array('text', 'Remote Course Object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2007-09-25 19:47:53'), 'last_update' => array('timestamp', '2007-09-25 19:47:53'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '146'), 'type' => array('text', 'typ'), 'title' => array('text', 'mds'), 'description' => array('text', 'Meta Data settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2007-09-25 19:47:53'), 'last_update' => array('timestamp', '2007-09-25 19:47:53'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '147'), 'type' => array('text', 'mds'), 'title' => array('text', '__MetaDataSettings'), 'description' => array('text', 'Meta Data Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2007-09-25 19:47:53'), 'last_update' => array('timestamp', '2007-09-25 19:47:53'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '148'), 'type' => array('text', 'rolt'), 'title' => array('text', 'il_frm_moderator'), 'description' => array('text', 'Moderator template for forum moderators'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2007-11-27 14:43:12'), 'last_update' => array('timestamp', '2007-11-27 14:43:12'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '149'), 'type' => array('text', 'typ'), 'title' => array('text', 'cmps'), 'description' => array('text', 'Component settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2008-06-02 16:08:54'), 'last_update' => array('timestamp', '2008-06-02 16:08:54'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '150'), 'type' => array('text', 'cmps'), 'title' => array('text', '__ComponentSettings'), 'description' => array('text', 'Component Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2008-06-02 16:08:54'), 'last_update' => array('timestamp', '2008-06-02 16:08:54'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '151'), 'type' => array('text', 'typ'), 'title' => array('text', 'facs'), 'description' => array('text', 'File Access settings object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2008-06-02 16:08:55'), 'last_update' => array('timestamp', '2008-06-02 16:08:55'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '152'), 'type' => array('text', 'facs'), 'title' => array('text', 'Files'), 'description' => array('text', 'Settings for files and file handling'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2008-06-02 16:08:55'), 'last_update' => array('timestamp', '2016-12-16 15:43:54'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '153'), 'type' => array('text', 'typ'), 'title' => array('text', 'svyf'), 'description' => array('text', 'Survey Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2008-06-02 16:08:55'), 'last_update' => array('timestamp', '2008-06-02 16:08:55'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '154'), 'type' => array('text', 'svyf'), 'title' => array('text', '__SurveySettings'), 'description' => array('text', 'Survey Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2008-06-02 16:08:55'), 'last_update' => array('timestamp', '2008-06-02 16:08:55'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '155'), 'type' => array('text', 'typ'), 'title' => array('text', 'sess'), 'description' => array('text', 'Session object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2008-06-02 16:08:55'), 'last_update' => array('timestamp', '2008-06-02 16:08:55'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '156'), 'type' => array('text', 'typ'), 'title' => array('text', 'mcts'), 'description' => array('text', 'Mediacast settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2008-06-02 16:08:56'), 'last_update' => array('timestamp', '2008-06-02 16:08:56'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '157'), 'type' => array('text', 'mcts'), 'title' => array('text', '__MediacastSettings'), 'description' => array('text', 'Mediacast Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2008-06-02 16:08:56'), 'last_update' => array('timestamp', '2008-06-02 16:08:56'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '158'), 'type' => array('text', 'typ'), 'title' => array('text', 'wiki'), 'description' => array('text', 'Wiki'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2008-06-02 16:08:57'), 'last_update' => array('timestamp', '2008-06-02 16:08:57'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '159'), 'type' => array('text', 'typ'), 'title' => array('text', 'crsr'), 'description' => array('text', 'Course Reference Object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2008-09-23 19:24:09'), 'last_update' => array('timestamp', '2008-09-23 19:24:09'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '160'), 'type' => array('text', 'typ'), 'title' => array('text', 'catr'), 'description' => array('text', 'Category Reference Object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2008-09-23 19:24:09'), 'last_update' => array('timestamp', '2008-09-23 19:24:09'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '161'), 'type' => array('text', 'typ'), 'title' => array('text', 'tags'), 'description' => array('text', 'Tagging settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2008-09-23 19:24:09'), 'last_update' => array('timestamp', '2008-09-23 19:24:09'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '162'), 'type' => array('text', 'tags'), 'title' => array('text', '__TaggingSettings'), 'description' => array('text', 'Tagging Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2008-09-23 19:24:09'), 'last_update' => array('timestamp', '2008-09-23 19:24:09'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '163'), 'type' => array('text', 'typ'), 'title' => array('text', 'cert'), 'description' => array('text', 'Certificate settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2009-07-20 13:03:21'), 'last_update' => array('timestamp', '2009-07-20 13:03:21'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '164'), 'type' => array('text', 'cert'), 'title' => array('text', '__CertificateSettings'), 'description' => array('text', 'Certificate Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2009-07-20 13:03:21'), 'last_update' => array('timestamp', '2009-07-20 13:03:21'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '165'), 'type' => array('text', 'typ'), 'title' => array('text', 'lrss'), 'description' => array('text', 'Learning resources settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2009-07-20 13:03:21'), 'last_update' => array('timestamp', '2009-07-20 13:03:21'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '166'), 'type' => array('text', 'lrss'), 'title' => array('text', '__LearningResourcesSettings'), 'description' => array('text', 'Learning Resources Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2009-07-20 13:03:21'), 'last_update' => array('timestamp', '2009-07-20 13:03:21'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '167'), 'type' => array('text', 'typ'), 'title' => array('text', 'accs'), 'description' => array('text', 'Accessibility settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2009-07-20 13:07:28'), 'last_update' => array('timestamp', '2009-07-20 13:07:28'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '168'), 'type' => array('text', 'accs'), 'title' => array('text', '__AccessibilitySettings'), 'description' => array('text', 'Accessibility Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2009-07-20 13:07:28'), 'last_update' => array('timestamp', '2009-07-20 13:07:28'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '169'), 'type' => array('text', 'typ'), 'title' => array('text', 'mobs'), 'description' => array('text', 'Media Object/Pool settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2009-07-20 13:08:42'), 'last_update' => array('timestamp', '2009-07-20 13:08:42'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '170'), 'type' => array('text', 'mobs'), 'title' => array('text', '__MediaObjectSettings'), 'description' => array('text', 'Media Object/Pool Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2009-07-20 13:08:42'), 'last_update' => array('timestamp', '2009-07-20 13:08:42'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '171'), 'type' => array('text', 'typ'), 'title' => array('text', 'frma'), 'description' => array('text', 'Forum administration'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2010-07-19 16:42:55'), 'last_update' => array('timestamp', '2010-07-19 16:42:55'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '172'), 'type' => array('text', 'frma'), 'title' => array('text', '__ForumAdministration'), 'description' => array('text', 'Forum Administration'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2010-07-19 16:42:55'), 'last_update' => array('timestamp', '2010-07-19 16:42:55'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '173'), 'type' => array('text', 'typ'), 'title' => array('text', 'book'), 'description' => array('text', 'Booking Manager'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2010-07-19 16:43:10'), 'last_update' => array('timestamp', '2010-07-19 16:43:10'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '174'), 'type' => array('text', 'typ'), 'title' => array('text', 'skmg'), 'description' => array('text', 'Skill Management'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2011-08-07 11:39:00'), 'last_update' => array('timestamp', '2011-08-07 11:39:00'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '175'), 'type' => array('text', 'skmg'), 'title' => array('text', '__SkillManagement'), 'description' => array('text', 'Skill Management'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2011-08-07 11:39:00'), 'last_update' => array('timestamp', '2011-08-07 11:39:00'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '176'), 'type' => array('text', 'typ'), 'title' => array('text', 'blga'), 'description' => array('text', 'Blog administration'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2011-08-07 11:39:04'), 'last_update' => array('timestamp', '2011-08-07 11:39:04'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '177'), 'type' => array('text', 'blga'), 'title' => array('text', '__BlogAdministration'), 'description' => array('text', 'Blog Administration'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2011-08-07 11:39:04'), 'last_update' => array('timestamp', '2011-08-07 11:39:04'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '178'), 'type' => array('text', 'typ'), 'title' => array('text', 'prfa'), 'description' => array('text', 'Portfolio administration'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2011-08-07 11:39:04'), 'last_update' => array('timestamp', '2011-08-07 11:39:04'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '179'), 'type' => array('text', 'prfa'), 'title' => array('text', '__PortfolioAdministration'), 'description' => array('text', 'Portfolio Administration'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2011-08-07 11:39:04'), 'last_update' => array('timestamp', '2011-08-07 11:39:04'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '180'), 'type' => array('text', 'typ'), 'title' => array('text', 'chtr'), 'description' => array('text', 'Chatroom Object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2011-08-07 11:39:06'), 'last_update' => array('timestamp', '2011-08-07 11:39:06'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '181'), 'type' => array('text', 'chta'), 'title' => array('text', 'Chatroom Admin'), 'description' => array('text', 'Chatroom General Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2011-08-07 11:39:06'), 'last_update' => array('timestamp', '2011-08-07 11:39:06'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '182'), 'type' => array('text', 'typ'), 'title' => array('text', 'chta'), 'description' => array('text', 'Chatroom Administration Type'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2011-08-07 11:39:08'), 'last_update' => array('timestamp', '2011-08-07 11:39:08'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '183'), 'type' => array('text', 'typ'), 'title' => array('text', 'otpl'), 'description' => array('text', 'Object Template administration'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2011-10-04 16:53:24'), 'last_update' => array('timestamp', '2011-10-04 16:53:24'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '184'), 'type' => array('text', 'otpl'), 'title' => array('text', '__ObjectTemplateAdministration'), 'description' => array('text', 'Object Template Administration'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2011-10-04 16:53:24'), 'last_update' => array('timestamp', '2011-10-04 16:53:24'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '185'), 'type' => array('text', 'chtr'), 'title' => array('text', 'Public Chatroom'), 'description' => array('text', 'Public Chatroom'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2011-10-04 16:53:25'), 'last_update' => array('timestamp', '2011-10-04 16:53:25'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '186'), 'type' => array('text', 'rolf'), 'title' => array('text', '185'), 'description' => array('text', '(ref_id )'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2011-10-04 16:53:25'), 'last_update' => array('timestamp', '2011-10-04 16:53:25'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '187'), 'type' => array('text', 'role'), 'title' => array('text', 'il_chat_moderator_46'), 'description' => array('text', 'Moderator of chat obj_no.185'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2011-10-04 16:53:25'), 'last_update' => array('timestamp', '2011-10-04 16:53:25'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '188'), 'type' => array('text', 'rolt'), 'title' => array('text', 'il_chat_moderator'), 'description' => array('text', 'Moderator template for chat moderators'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2011-10-04 16:53:25'), 'last_update' => array('timestamp', '2011-10-04 16:53:25'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '189'), 'type' => array('text', 'typ'), 'title' => array('text', 'blog'), 'description' => array('text', 'Blog Object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2012-09-04 14:25:29'), 'last_update' => array('timestamp', '2012-09-04 14:25:29'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '190'), 'type' => array('text', 'typ'), 'title' => array('text', 'dcl'), 'description' => array('text', 'Data Collection Object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2012-09-04 14:25:30'), 'last_update' => array('timestamp', '2012-09-04 14:25:30'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '191'), 'type' => array('text', 'typ'), 'title' => array('text', 'poll'), 'description' => array('text', 'Poll Object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2012-09-04 14:25:41'), 'last_update' => array('timestamp', '2012-09-04 14:25:41'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '192'), 'type' => array('text', 'typ'), 'title' => array('text', 'hlps'), 'description' => array('text', 'Help Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2012-09-04 14:25:48'), 'last_update' => array('timestamp', '2012-09-04 14:25:48'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '193'), 'type' => array('text', 'hlps'), 'title' => array('text', 'HelpSettings'), 'description' => array('text', 'Help Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2012-09-04 14:25:48'), 'last_update' => array('timestamp', '2012-09-04 14:25:48'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '194'), 'type' => array('text', 'typ'), 'title' => array('text', 'itgr'), 'description' => array('text', 'Item Group'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2012-09-04 14:25:52'), 'last_update' => array('timestamp', '2012-09-04 14:25:52'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '195'), 'type' => array('text', 'typ'), 'title' => array('text', 'rcat'), 'description' => array('text', 'Remote Category Object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2012-09-04 14:26:14'), 'last_update' => array('timestamp', '2012-09-04 14:26:14'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '196'), 'type' => array('text', 'typ'), 'title' => array('text', 'rwik'), 'description' => array('text', 'Remote Wiki Object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2012-09-04 14:26:14'), 'last_update' => array('timestamp', '2012-09-04 14:26:14'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '197'), 'type' => array('text', 'typ'), 'title' => array('text', 'rlm'), 'description' => array('text', 'Remote Learning Module Object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2012-09-04 14:26:15'), 'last_update' => array('timestamp', '2012-09-04 14:26:15'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '198'), 'type' => array('text', 'typ'), 'title' => array('text', 'rglo'), 'description' => array('text', 'Remote Glossary Object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2012-09-04 14:26:15'), 'last_update' => array('timestamp', '2012-09-04 14:26:15'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '199'), 'type' => array('text', 'typ'), 'title' => array('text', 'rfil'), 'description' => array('text', 'Remote File Object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2012-09-04 14:26:16'), 'last_update' => array('timestamp', '2012-09-04 14:26:16'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '200'), 'type' => array('text', 'typ'), 'title' => array('text', 'rgrp'), 'description' => array('text', 'Remote Group Object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2012-09-04 14:26:16'), 'last_update' => array('timestamp', '2012-09-04 14:26:16'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '201'), 'type' => array('text', 'typ'), 'title' => array('text', 'rtst'), 'description' => array('text', 'Remote Test Object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2012-09-04 14:26:17'), 'last_update' => array('timestamp', '2012-09-04 14:26:17'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '202'), 'type' => array('text', 'rolt'), 'title' => array('text', 'il_blog_contributor'), 'description' => array('text', 'Contributor template for blogs'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2012-10-27 19:30:37'), 'last_update' => array('timestamp', '2012-10-27 19:30:37'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '203'), 'type' => array('text', 'typ'), 'title' => array('text', 'ecss'), 'description' => array('text', 'ECS Administration'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2012-11-23 17:12:57'), 'last_update' => array('timestamp', '2012-11-23 17:12:57'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '204'), 'type' => array('text', 'ecss'), 'title' => array('text', '__ECSSettings'), 'description' => array('text', 'ECS Administration'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2012-11-23 17:12:57'), 'last_update' => array('timestamp', '2012-11-23 17:12:57'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '205'), 'type' => array('text', 'typ'), 'title' => array('text', 'tos'), 'description' => array('text', 'Terms of Service'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2013-10-11 18:59:35'), 'last_update' => array('timestamp', '2013-10-11 18:59:35'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '206'), 'type' => array('text', 'tos'), 'title' => array('text', 'Terms of Service'), 'description' => array('text', 'Terms of Service: Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2013-10-11 18:59:35'), 'last_update' => array('timestamp', '2013-10-11 18:59:35'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '207'), 'type' => array('text', 'typ'), 'title' => array('text', 'bibl'), 'description' => array('text', 'Bibliographic Object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2013-10-11 18:59:37'), 'last_update' => array('timestamp', '2013-10-11 18:59:37'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '208'), 'type' => array('text', 'typ'), 'title' => array('text', 'sysc'), 'description' => array('text', 'System Check'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2013-10-11 18:59:40'), 'last_update' => array('timestamp', '2013-10-11 18:59:40'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '209'), 'type' => array('text', 'sysc'), 'title' => array('text', 'System Check'), 'description' => array('text', 'System Check'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2013-10-11 18:59:40'), 'last_update' => array('timestamp', '2013-10-11 18:59:40'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '210'), 'type' => array('text', 'typ'), 'title' => array('text', 'cld'), 'description' => array('text', 'Cloud Folder'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2013-10-11 18:59:40'), 'last_update' => array('timestamp', '2013-10-11 18:59:40'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '211'), 'type' => array('text', 'typ'), 'title' => array('text', 'reps'), 'description' => array('text', 'Repository Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2013-10-11 18:59:42'), 'last_update' => array('timestamp', '2013-10-11 18:59:42'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '212'), 'type' => array('text', 'reps'), 'title' => array('text', 'Repository Settings'), 'description' => array('text', 'Repository Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2013-10-11 18:59:42'), 'last_update' => array('timestamp', '2013-10-11 18:59:42'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '213'), 'type' => array('text', 'typ'), 'title' => array('text', 'crss'), 'description' => array('text', 'Course Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2013-10-11 18:59:42'), 'last_update' => array('timestamp', '2013-10-11 18:59:42'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '214'), 'type' => array('text', 'crss'), 'title' => array('text', 'Course Settings'), 'description' => array('text', 'Course Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2013-10-11 18:59:42'), 'last_update' => array('timestamp', '2013-10-11 18:59:42'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '215'), 'type' => array('text', 'typ'), 'title' => array('text', 'grps'), 'description' => array('text', 'Group Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2013-10-11 18:59:42'), 'last_update' => array('timestamp', '2013-10-11 18:59:42'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '216'), 'type' => array('text', 'grps'), 'title' => array('text', 'Group Settings'), 'description' => array('text', 'Group Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2013-10-11 18:59:42'), 'last_update' => array('timestamp', '2013-10-11 18:59:42'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '217'), 'type' => array('text', 'typ'), 'title' => array('text', 'wbrs'), 'description' => array('text', 'WebResource Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2013-10-11 18:59:42'), 'last_update' => array('timestamp', '2013-10-11 18:59:42'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '218'), 'type' => array('text', 'wbrs'), 'title' => array('text', 'WebResource Settings'), 'description' => array('text', 'WebResource Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2013-10-11 18:59:42'), 'last_update' => array('timestamp', '2013-10-11 18:59:42'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '219'), 'type' => array('text', 'typ'), 'title' => array('text', 'prtt'), 'description' => array('text', 'Portfolio Template Object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2013-10-11 19:04:51'), 'last_update' => array('timestamp', '2013-10-11 19:04:51'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '220'), 'type' => array('text', 'typ'), 'title' => array('text', 'orgu'), 'description' => array('text', 'Organisational Unit'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2013-10-11 19:04:52'), 'last_update' => array('timestamp', '2013-10-11 19:04:52'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '221'), 'type' => array('text', 'orgu'), 'title' => array('text', '__OrgUnitAdministration'), 'description' => array('text', 'Organisationsal Units'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2013-10-11 19:04:52'), 'last_update' => array('timestamp', '2013-10-11 19:04:52'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '222'), 'type' => array('text', 'rolt'), 'title' => array('text', 'il_orgu_superior'), 'description' => array('text', 'OrgUnit Superior Role Template'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2013-10-11 19:04:52'), 'last_update' => array('timestamp', '2013-10-11 19:04:52'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '223'), 'type' => array('text', 'typ'), 'title' => array('text', 'wiks'), 'description' => array('text', 'Wiki Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2013-11-06 17:13:57'), 'last_update' => array('timestamp', '2013-11-06 17:13:57'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '224'), 'type' => array('text', 'wiks'), 'title' => array('text', 'Wiki Settings'), 'description' => array('text', 'Wiki Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2013-11-06 17:13:57'), 'last_update' => array('timestamp', '2013-11-06 17:13:57'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '225'), 'type' => array('text', 'typ'), 'title' => array('text', 'excs'), 'description' => array('text', 'Exercise Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2014-09-23 21:48:42'), 'last_update' => array('timestamp', '2014-09-23 21:48:42'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '226'), 'type' => array('text', 'excs'), 'title' => array('text', 'Exercise Settings'), 'description' => array('text', 'Exercise Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2014-09-23 21:48:42'), 'last_update' => array('timestamp', '2014-09-23 21:48:42'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '227'), 'type' => array('text', 'typ'), 'title' => array('text', 'taxs'), 'description' => array('text', 'Taxonomy Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2014-09-23 21:48:42'), 'last_update' => array('timestamp', '2014-09-23 21:48:42'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '228'), 'type' => array('text', 'taxs'), 'title' => array('text', 'Taxonomy Settings'), 'description' => array('text', 'Taxonomy Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2014-09-23 21:48:42'), 'last_update' => array('timestamp', '2014-09-23 21:48:42'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '229'), 'type' => array('text', 'typ'), 'title' => array('text', 'bibs'), 'description' => array('text', 'BibliographicAdmin'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2014-09-23 21:48:55'), 'last_update' => array('timestamp', '2014-09-23 21:48:55'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '230'), 'type' => array('text', 'bibs'), 'title' => array('text', 'BibliographicAdmin'), 'description' => array('text', 'BibliographicAdmin'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2014-09-23 21:48:55'), 'last_update' => array('timestamp', '2014-09-23 21:48:55'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '231'), 'type' => array('text', 'rolt'), 'title' => array('text', 'il_blog_editor'), 'description' => array('text', 'Editor template for blogs'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2015-09-30 12:57:25'), 'last_update' => array('timestamp', '2015-12-22 15:28:30'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '232'), 'type' => array('text', 'typ'), 'title' => array('text', 'awra'), 'description' => array('text', 'Awareness Tool Administration'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2015-09-30 12:57:29'), 'last_update' => array('timestamp', '2015-09-30 12:57:29'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '233'), 'type' => array('text', 'awra'), 'title' => array('text', '__AwarenessToolAdministration'), 'description' => array('text', 'Awareness Tool Administration'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2015-09-30 12:57:29'), 'last_update' => array('timestamp', '2015-09-30 12:57:29'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '234'), 'type' => array('text', 'typ'), 'title' => array('text', 'logs'), 'description' => array('text', 'Logging Administration'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2015-09-30 12:57:31'), 'last_update' => array('timestamp', '2015-09-30 12:57:31'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '235'), 'type' => array('text', 'logs'), 'title' => array('text', '__LoggingSettings'), 'description' => array('text', 'Logging Administration'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2015-09-30 12:57:31'), 'last_update' => array('timestamp', '2015-09-30 12:57:31'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '236'), 'type' => array('text', 'typ'), 'title' => array('text', 'prg'), 'description' => array('text', 'StudyProgramme'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2015-09-30 12:57:34'), 'last_update' => array('timestamp', '2015-09-30 12:57:34'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '237'), 'type' => array('text', 'typ'), 'title' => array('text', 'prgs'), 'description' => array('text', 'StudyProgrammeAdmin'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2015-09-30 12:57:35'), 'last_update' => array('timestamp', '2015-09-30 12:57:35'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '238'), 'type' => array('text', 'prgs'), 'title' => array('text', 'StudyProgrammeAdmin'), 'description' => array('text', 'StudyProgrammeAdmin'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2015-09-30 12:57:35'), 'last_update' => array('timestamp', '2015-09-30 12:57:35'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '239'), 'type' => array('text', 'typ'), 'title' => array('text', 'cadm'), 'description' => array('text', 'Contact'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2015-11-17 15:20:05'), 'last_update' => array('timestamp', '2015-11-17 15:20:05'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '240'), 'type' => array('text', 'cadm'), 'title' => array('text', 'Contact'), 'description' => array('text', 'Contact'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2015-11-17 15:20:05'), 'last_update' => array('timestamp', '2015-11-17 15:20:05'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '241'), 'type' => array('text', 'lng'), 'title' => array('text', 'ka'), 'description' => array('text', 'not_installed'), 'owner' => array('integer', '6'), 'create_date' => array('timestamp', '2015-12-22 14:32:40'), 'last_update' => array('timestamp', '2015-12-22 14:32:40'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '242'), 'type' => array('text', 'lng'), 'title' => array('text', 'ar'), 'description' => array('text', 'not_installed'), 'owner' => array('integer', '6'), 'create_date' => array('timestamp', '2015-12-22 14:32:40'), 'last_update' => array('timestamp', '2015-12-22 14:32:40'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '243'), 'type' => array('text', 'lng'), 'title' => array('text', 'bg'), 'description' => array('text', 'not_installed'), 'owner' => array('integer', '6'), 'create_date' => array('timestamp', '2015-12-22 14:32:40'), 'last_update' => array('timestamp', '2015-12-22 14:32:40'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '244'), 'type' => array('text', 'lng'), 'title' => array('text', 'sq'), 'description' => array('text', 'not_installed'), 'owner' => array('integer', '6'), 'create_date' => array('timestamp', '2015-12-22 14:32:40'), 'last_update' => array('timestamp', '2015-12-22 14:32:40'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '245'), 'type' => array('text', 'lng'), 'title' => array('text', 'ro'), 'description' => array('text', 'not_installed'), 'owner' => array('integer', '6'), 'create_date' => array('timestamp', '2015-12-22 14:32:40'), 'last_update' => array('timestamp', '2015-12-22 14:32:40'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '246'), 'type' => array('text', 'lng'), 'title' => array('text', 'sk'), 'description' => array('text', 'not_installed'), 'owner' => array('integer', '6'), 'create_date' => array('timestamp', '2015-12-22 14:32:40'), 'last_update' => array('timestamp', '2015-12-22 14:32:40'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '247'), 'type' => array('text', 'lng'), 'title' => array('text', 'da'), 'description' => array('text', 'not_installed'), 'owner' => array('integer', '6'), 'create_date' => array('timestamp', '2015-12-22 14:32:40'), 'last_update' => array('timestamp', '2015-12-22 14:32:40'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '248'), 'type' => array('text', 'lng'), 'title' => array('text', 'hu'), 'description' => array('text', 'not_installed'), 'owner' => array('integer', '6'), 'create_date' => array('timestamp', '2015-12-22 14:32:40'), 'last_update' => array('timestamp', '2015-12-22 14:32:40'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '249'), 'type' => array('text', 'lng'), 'title' => array('text', 'uk'), 'description' => array('text', 'not_installed'), 'owner' => array('integer', '6'), 'create_date' => array('timestamp', '2015-12-22 14:32:40'), 'last_update' => array('timestamp', '2015-12-22 14:32:40'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '250'), 'type' => array('text', 'lng'), 'title' => array('text', 'fa'), 'description' => array('text', 'not_installed'), 'owner' => array('integer', '6'), 'create_date' => array('timestamp', '2015-12-22 14:32:40'), 'last_update' => array('timestamp', '2015-12-22 14:32:40'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '251'), 'type' => array('text', 'lng'), 'title' => array('text', 'sr'), 'description' => array('text', 'not_installed'), 'owner' => array('integer', '6'), 'create_date' => array('timestamp', '2015-12-22 14:32:40'), 'last_update' => array('timestamp', '2015-12-22 14:32:40'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '252'), 'type' => array('text', 'lng'), 'title' => array('text', 'pt'), 'description' => array('text', 'not_installed'), 'owner' => array('integer', '6'), 'create_date' => array('timestamp', '2015-12-22 14:32:40'), 'last_update' => array('timestamp', '2015-12-22 14:32:40'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '253'), 'type' => array('text', 'lng'), 'title' => array('text', 'ja'), 'description' => array('text', 'not_installed'), 'owner' => array('integer', '6'), 'create_date' => array('timestamp', '2015-12-22 14:32:40'), 'last_update' => array('timestamp', '2015-12-22 14:32:40'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '254'), 'type' => array('text', 'lng'), 'title' => array('text', 'vi'), 'description' => array('text', 'not_installed'), 'owner' => array('integer', '6'), 'create_date' => array('timestamp', '2015-12-22 14:32:40'), 'last_update' => array('timestamp', '2015-12-22 14:32:40'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '255'), 'type' => array('text', 'lng'), 'title' => array('text', 'ru'), 'description' => array('text', 'not_installed'), 'owner' => array('integer', '6'), 'create_date' => array('timestamp', '2015-12-22 14:32:40'), 'last_update' => array('timestamp', '2015-12-22 14:32:40'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '256'), 'type' => array('text', 'lng'), 'title' => array('text', 'et'), 'description' => array('text', 'not_installed'), 'owner' => array('integer', '6'), 'create_date' => array('timestamp', '2015-12-22 14:32:40'), 'last_update' => array('timestamp', '2015-12-22 14:32:40'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '257'), 'type' => array('text', 'lng'), 'title' => array('text', 'lt'), 'description' => array('text', 'not_installed'), 'owner' => array('integer', '6'), 'create_date' => array('timestamp', '2015-12-22 14:32:40'), 'last_update' => array('timestamp', '2015-12-22 14:32:40'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '258'), 'type' => array('text', 'lng'), 'title' => array('text', 'cs'), 'description' => array('text', 'not_installed'), 'owner' => array('integer', '6'), 'create_date' => array('timestamp', '2015-12-22 14:32:40'), 'last_update' => array('timestamp', '2015-12-22 14:32:40'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '259'), 'type' => array('text', 'lng'), 'title' => array('text', 'tr'), 'description' => array('text', 'not_installed'), 'owner' => array('integer', '6'), 'create_date' => array('timestamp', '2015-12-22 14:32:40'), 'last_update' => array('timestamp', '2015-12-22 14:32:40'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '260'), 'type' => array('text', 'lng'), 'title' => array('text', 'el'), 'description' => array('text', 'not_installed'), 'owner' => array('integer', '6'), 'create_date' => array('timestamp', '2015-12-22 14:32:40'), 'last_update' => array('timestamp', '2015-12-22 14:32:40'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '261'), 'type' => array('text', 'typ'), 'title' => array('text', 'grpr'), 'description' => array('text', 'Group Reference Object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2016-09-02 13:26:19'), 'last_update' => array('timestamp', '2016-09-02 13:26:19'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '262'), 'type' => array('text', 'typ'), 'title' => array('text', 'bdga'), 'description' => array('text', 'Badge Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2016-09-02 13:26:21'), 'last_update' => array('timestamp', '2016-09-02 13:26:21'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '263'), 'type' => array('text', 'bdga'), 'title' => array('text', 'Badge Settings'), 'description' => array('text', 'Badge Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2016-09-02 13:26:21'), 'last_update' => array('timestamp', '2016-09-02 13:26:21'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '264'), 'type' => array('text', 'typ'), 'title' => array('text', 'wfe'), 'description' => array('text', 'WorkflowEngine'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2016-09-02 13:33:13'), 'last_update' => array('timestamp', '2016-09-02 13:33:13'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '265'), 'type' => array('text', 'wfe'), 'title' => array('text', 'WorkflowEngine'), 'description' => array('text', 'WorkflowEngine'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2016-09-02 13:33:13'), 'last_update' => array('timestamp', '2016-09-02 13:33:13'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '266'), 'type' => array('text', 'typ'), 'title' => array('text', 'iass'), 'description' => array('text', 'Individual Assessment'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2016-09-02 13:33:17'), 'last_update' => array('timestamp', '2016-09-02 13:33:17'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '267'), 'type' => array('text', 'rolt'), 'title' => array('text', 'il_iass_member'), 'description' => array('text', 'Member of a manual assessment object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2016-09-02 13:33:17'), 'last_update' => array('timestamp', '2016-09-02 13:33:17'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '268'), 'type' => array('text', 'rolt'), 'title' => array('text', 'il_sess_participant'), 'description' => array('text', 'Session participant template'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2018-01-25 08:42:46'), 'last_update' => array('timestamp', '2018-01-25 08:42:46'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '269'), 'type' => array('text', 'rolt'), 'title' => array('text', 'il_sess_status_closed'), 'description' => array('text', 'Closed session template'), 'owner' => array('integer', '0'), 'create_date' => array('timestamp', '2018-01-25 08:42:46'), 'last_update' => array('timestamp', '2018-01-25 08:42:46'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '270'), 'type' => array('text', 'typ'), 'title' => array('text', 'pdfg'), 'description' => array('text', 'PDFGeneration'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2018-01-25 08:42:49'), 'last_update' => array('timestamp', '2018-01-25 08:42:49'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '271'), 'type' => array('text', 'pdfg'), 'title' => array('text', 'PDFGeneration'), 'description' => array('text', 'PDFGeneration'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2018-01-25 08:42:49'), 'last_update' => array('timestamp', '2018-01-25 08:42:49'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '272'), 'type' => array('text', 'typ'), 'title' => array('text', 'ltis'), 'description' => array('text', 'LTI Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2018-01-25 08:42:57'), 'last_update' => array('timestamp', '2018-01-25 08:42:57'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '273'), 'type' => array('text', 'ltis'), 'title' => array('text', 'LTI Settings'), 'description' => array('text', 'LTI Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2018-01-25 08:42:57'), 'last_update' => array('timestamp', '2018-01-25 08:42:57'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '274'), 'type' => array('text', 'typ'), 'title' => array('text', 'copa'), 'description' => array('text', 'Content Page Object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2020-11-20 17:12:55'), 'last_update' => array('timestamp', '2020-11-20 17:12:55'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '275'), 'type' => array('text', 'typ'), 'title' => array('text', 'mme'), 'description' => array('text', 'Main Menu'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2020-11-20 17:13:00'), 'last_update' => array('timestamp', '2020-11-20 17:13:00'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '276'), 'type' => array('text', 'mme'), 'title' => array('text', 'Main Menu'), 'description' => array('text', 'Main Menu'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2020-11-20 17:13:00'), 'last_update' => array('timestamp', '2020-11-20 17:13:00'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '277'), 'type' => array('text', 'typ'), 'title' => array('text', 'lso'), 'description' => array('text', 'Learning Sequence'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2020-11-20 17:13:02'), 'last_update' => array('timestamp', '2020-11-20 17:13:02'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '278'), 'type' => array('text', 'rolt'), 'title' => array('text', 'il_lso_admin'), 'description' => array('text', 'Admin template for learning sequences'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2020-11-20 17:13:02'), 'last_update' => array('timestamp', '2020-11-20 17:13:02'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '279'), 'type' => array('text', 'rolt'), 'title' => array('text', 'il_lso_member'), 'description' => array('text', 'Member template for learning sequences'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2020-11-20 17:13:02'), 'last_update' => array('timestamp', '2020-11-20 17:13:02'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '280'), 'type' => array('text', 'typ'), 'title' => array('text', 'lti'), 'description' => array('text', 'LTI Consumer Object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2020-11-20 17:13:08'), 'last_update' => array('timestamp', '2020-11-20 17:13:08'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '281'), 'type' => array('text', 'typ'), 'title' => array('text', 'cmix'), 'description' => array('text', 'cmi5/xAPI Object'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2020-11-20 17:13:08'), 'last_update' => array('timestamp', '2020-11-20 17:13:08'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '282'), 'type' => array('text', 'typ'), 'title' => array('text', 'cmis'), 'description' => array('text', 'cmi5/xAPI Administration'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2020-11-20 17:13:08'), 'last_update' => array('timestamp', '2020-11-20 17:13:08'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '283'), 'type' => array('text', 'cmis'), 'title' => array('text', 'cmi5/xAPI Administration'), 'description' => array('text', 'cmi5/xAPI Administration'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2020-11-20 17:13:08'), 'last_update' => array('timestamp', '2020-11-20 17:13:08'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '284'), 'type' => array('text', 'typ'), 'title' => array('text', 'nots'), 'description' => array('text', 'Notes Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2020-11-20 17:13:10'), 'last_update' => array('timestamp', '2020-11-20 17:13:10'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '285'), 'type' => array('text', 'nots'), 'title' => array('text', 'Notes Settings'), 'description' => array('text', 'Notes Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2020-11-20 17:13:10'), 'last_update' => array('timestamp', '2020-11-20 17:13:10'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '286'), 'type' => array('text', 'typ'), 'title' => array('text', 'coms'), 'description' => array('text', 'Comments Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2020-11-20 17:13:10'), 'last_update' => array('timestamp', '2020-11-20 17:13:10'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '287'), 'type' => array('text', 'coms'), 'title' => array('text', 'Comments Settings'), 'description' => array('text', 'Comments Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2020-11-20 17:13:10'), 'last_update' => array('timestamp', '2020-11-20 17:13:10'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '288'), 'type' => array('text', 'typ'), 'title' => array('text', 'lhts'), 'description' => array('text', 'Learning History Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2020-11-20 17:13:10'), 'last_update' => array('timestamp', '2020-11-20 17:13:10'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '289'), 'type' => array('text', 'lhts'), 'title' => array('text', 'Learning History Settings'), 'description' => array('text', 'Learning History Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2020-11-20 17:13:10'), 'last_update' => array('timestamp', '2020-11-20 17:13:10'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '290'), 'type' => array('text', 'typ'), 'title' => array('text', 'prss'), 'description' => array('text', 'Personal Resources Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2020-11-20 17:13:10'), 'last_update' => array('timestamp', '2020-11-20 17:13:10'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '291'), 'type' => array('text', 'prss'), 'title' => array('text', 'Personal Resources Settings'), 'description' => array('text', 'Personal Resources Settings'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2020-11-20 17:13:10'), 'last_update' => array('timestamp', '2020-11-20 17:13:10'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '292'), 'type' => array('text', 'typ'), 'title' => array('text', 'prgr'), 'description' => array('text', 'Study Programme Reference'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2020-11-20 17:13:12'), 'last_update' => array('timestamp', '2020-11-20 17:13:12'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '293'), 'type' => array('text', 'typ'), 'title' => array('text', 'lsos'), 'description' => array('text', 'LearningSequenceAdmin'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2020-11-20 17:13:14'), 'last_update' => array('timestamp', '2020-11-20 17:13:14'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '294'), 'type' => array('text', 'lsos'), 'title' => array('text', 'LearningSequenceAdmin'), 'description' => array('text', 'LearningSequenceAdmin'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2020-11-20 17:13:14'), 'last_update' => array('timestamp', '2020-11-20 17:13:14'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '295'), 'type' => array('text', 'typ'), 'title' => array('text', 'cpad'), 'description' => array('text', 'ContentPageAdministration'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2020-11-20 17:13:15'), 'last_update' => array('timestamp', '2020-11-20 17:13:15'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '296'), 'type' => array('text', 'cpad'), 'title' => array('text', 'ContentPageAdministration'), 'description' => array('text', 'ContentPageAdministration'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2020-11-20 17:13:15'), 'last_update' => array('timestamp', '2020-11-20 17:13:15'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '297'), 'type' => array('text', 'typ'), 'title' => array('text', 'fils'), 'description' => array('text', 'File Services'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2020-11-20 17:13:17'), 'last_update' => array('timestamp', '2020-11-20 17:13:17'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '298'), 'type' => array('text', 'fils'), 'title' => array('text', 'File Services'), 'description' => array('text', 'File Services'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2020-11-20 17:13:17'), 'last_update' => array('timestamp', '2020-11-20 17:13:17'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '299'), 'type' => array('text', 'typ'), 'title' => array('text', 'wbdv'), 'description' => array('text', 'WebDAV'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2020-11-20 17:13:17'), 'last_update' => array('timestamp', '2020-11-20 17:13:17'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '300'), 'type' => array('text', 'wbdv'), 'title' => array('text', 'WebDAV'), 'description' => array('text', 'WebDAV'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2020-11-20 17:13:17'), 'last_update' => array('timestamp', '2020-11-20 17:13:17'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '301'), 'type' => array('text', 'typ'), 'title' => array('text', 'adn'), 'description' => array('text', 'Administrative Notifications'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2020-11-20 17:13:17'), 'last_update' => array('timestamp', '2020-11-20 17:13:17'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));

$ilDB->insert("object_data", array(
'obj_id' => array('integer', '302'), 'type' => array('text', 'adn'), 'title' => array('text', 'Administrative Notifications'), 'description' => array('text', 'Administrative Notifications'), 'owner' => array('integer', '-1'), 'create_date' => array('timestamp', '2020-11-20 17:13:17'), 'last_update' => array('timestamp', '2020-11-20 17:13:17'), 'import_id' => array('text', ''), 'offline' => array('integer', '')));


//
// object_data_del
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"tstamp" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"type" => array (
		"notnull" => false
		,"length" => 4
		,"fixed" => true
		,"type" => "text"
	)
	,"description" => array (
		"notnull" => false
		,"type" => "clob"
	)
);
$ilDB->createTable("object_data_del", $fields);

$pk_fields = array("obj_id");
$ilDB->addPrimaryKey("object_data_del", $pk_fields);


//
// object_description
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"description" => array (
		"notnull" => false
		,"type" => "clob"
	)
);
$ilDB->createTable("object_description", $fields);

$pk_fields = array("obj_id");
$ilDB->addPrimaryKey("object_description", $pk_fields);

$ilDB->insert("object_description", array(
'obj_id' => array('integer', '152'), 'description' => array('clob', 'Settings for files and file handling')));


//
// object_reference
//
$fields = array (
	"ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"deleted" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"deleted_by" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("object_reference", $fields);

$pk_fields = array("ref_id");
$ilDB->addPrimaryKey("object_reference", $pk_fields);

$in_fields = array("obj_id");
$ilDB->addIndex("object_reference", $in_fields, "i1", false);

$in_fields = array("deleted");
$ilDB->addIndex("object_reference", $in_fields, "i2", false);

$ilDB->createSequence("object_reference", 80);

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '1'), 'obj_id' => array('integer', '1'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '7'), 'obj_id' => array('integer', '7'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '8'), 'obj_id' => array('integer', '8'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '9'), 'obj_id' => array('integer', '9'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '10'), 'obj_id' => array('integer', '10'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '11'), 'obj_id' => array('integer', '11'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '12'), 'obj_id' => array('integer', '12'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '14'), 'obj_id' => array('integer', '98'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '15'), 'obj_id' => array('integer', '100'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '16'), 'obj_id' => array('integer', '107'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '17'), 'obj_id' => array('integer', '109'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '18'), 'obj_id' => array('integer', '86'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '20'), 'obj_id' => array('integer', '116'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '21'), 'obj_id' => array('integer', '118'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '22'), 'obj_id' => array('integer', '124'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '23'), 'obj_id' => array('integer', '128'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '26'), 'obj_id' => array('integer', '136'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '27'), 'obj_id' => array('integer', '138'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '28'), 'obj_id' => array('integer', '140'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '29'), 'obj_id' => array('integer', '144'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '30'), 'obj_id' => array('integer', '147'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '31'), 'obj_id' => array('integer', '150'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '32'), 'obj_id' => array('integer', '152'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '33'), 'obj_id' => array('integer', '154'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '34'), 'obj_id' => array('integer', '157'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '35'), 'obj_id' => array('integer', '162'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '36'), 'obj_id' => array('integer', '164'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '37'), 'obj_id' => array('integer', '166'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '38'), 'obj_id' => array('integer', '168'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '39'), 'obj_id' => array('integer', '170'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '40'), 'obj_id' => array('integer', '172'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '41'), 'obj_id' => array('integer', '175'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '42'), 'obj_id' => array('integer', '177'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '43'), 'obj_id' => array('integer', '179'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '44'), 'obj_id' => array('integer', '181'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '45'), 'obj_id' => array('integer', '184'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '46'), 'obj_id' => array('integer', '185'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '47'), 'obj_id' => array('integer', '186'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '48'), 'obj_id' => array('integer', '193'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '49'), 'obj_id' => array('integer', '204'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '50'), 'obj_id' => array('integer', '206'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '51'), 'obj_id' => array('integer', '209'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '52'), 'obj_id' => array('integer', '212'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '53'), 'obj_id' => array('integer', '214'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '54'), 'obj_id' => array('integer', '216'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '55'), 'obj_id' => array('integer', '218'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '56'), 'obj_id' => array('integer', '221'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '57'), 'obj_id' => array('integer', '224'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '58'), 'obj_id' => array('integer', '226'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '59'), 'obj_id' => array('integer', '228'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '60'), 'obj_id' => array('integer', '230'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '61'), 'obj_id' => array('integer', '233'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '62'), 'obj_id' => array('integer', '235'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '63'), 'obj_id' => array('integer', '238'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '64'), 'obj_id' => array('integer', '240'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '65'), 'obj_id' => array('integer', '263'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '66'), 'obj_id' => array('integer', '265'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '67'), 'obj_id' => array('integer', '271'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '68'), 'obj_id' => array('integer', '273'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '69'), 'obj_id' => array('integer', '276'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '70'), 'obj_id' => array('integer', '283'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '71'), 'obj_id' => array('integer', '285'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '72'), 'obj_id' => array('integer', '287'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '73'), 'obj_id' => array('integer', '289'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '74'), 'obj_id' => array('integer', '291'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '75'), 'obj_id' => array('integer', '294'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '76'), 'obj_id' => array('integer', '296'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '77'), 'obj_id' => array('integer', '298'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '78'), 'obj_id' => array('integer', '300'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));

$ilDB->insert("object_reference", array(
'ref_id' => array('integer', '79'), 'obj_id' => array('integer', '302'), 'deleted' => array('timestamp', ''), 'deleted_by' => array('integer', '0')));


//
// object_reference_ws
//
$fields = array (
	"wsp_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"deleted" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
);
$ilDB->createTable("object_reference_ws", $fields);

$pk_fields = array("wsp_id");
$ilDB->addPrimaryKey("object_reference_ws", $pk_fields);

$in_fields = array("obj_id");
$ilDB->addIndex("object_reference_ws", $in_fields, "i1", false);

$in_fields = array("deleted");
$ilDB->addIndex("object_reference_ws", $in_fields, "i2", false);

$ilDB->createSequence("object_reference_ws", 1);


//
// object_translation
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 128
		,"fixed" => false
		,"type" => "text"
	)
	,"description" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
	,"lang_code" => array (
		"notnull" => true
		,"length" => 2
		,"default" => ""
		,"fixed" => true
		,"type" => "text"
	)
	,"lang_default" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("object_translation", $fields);

$pk_fields = array("obj_id","lang_code");
$ilDB->addPrimaryKey("object_translation", $pk_fields);

$ilDB->insert("object_translation", array(
'obj_id' => array('integer', '9'), 'title' => array('text', 'Open Source eLearning'), 'description' => array('text', ''), 'lang_code' => array('text', 'en'), 'lang_default' => array('integer', '1')));


//
// openid_provider
//
$fields = array (
	"provider_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"enabled" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"name" => array (
		"notnull" => false
		,"length" => 128
		,"fixed" => false
		,"type" => "text"
	)
	,"url" => array (
		"notnull" => false
		,"length" => 512
		,"fixed" => false
		,"type" => "text"
	)
	,"image" => array (
		"notnull" => false
		,"length" => 2
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("openid_provider", $fields);

$pk_fields = array("provider_id");
$ilDB->addPrimaryKey("openid_provider", $pk_fields);

$ilDB->createSequence("openid_provider", 2);

$ilDB->insert("openid_provider", array(
'provider_id' => array('integer', '1'), 'enabled' => array('integer', '1'), 'name' => array('text', 'MyOpenID'), 'url' => array('text', 'http://%s.myopenid.com'), 'image' => array('integer', '1')));


//
// orgu_data
//
$fields = array (
	"orgu_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"orgu_type_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("orgu_data", $fields);

$pk_fields = array("orgu_id");
$ilDB->addPrimaryKey("orgu_data", $pk_fields);


//
// orgu_obj_pos_settings
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"active" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("orgu_obj_pos_settings", $fields);

$pk_fields = array("obj_id");
$ilDB->addPrimaryKey("orgu_obj_pos_settings", $pk_fields);


//
// orgu_obj_type_settings
//
$fields = array (
	"obj_type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"active" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"activation_default" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"changeable" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("orgu_obj_type_settings", $fields);

$pk_fields = array("obj_type");
$ilDB->addPrimaryKey("orgu_obj_type_settings", $pk_fields);


//
// orgu_path_storage
//
$fields = array (
	"ref_id" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"obj_id" => array (
		"notnull" => false
		,"length" => 8
		,"unsigned" => false
		,"type" => "integer"
	)
	,"path" => array (
		"notnull" => false
		,"type" => "clob"
	)
);
$ilDB->createTable("orgu_path_storage", $fields);

$pk_fields = array("ref_id");
$ilDB->addPrimaryKey("orgu_path_storage", $pk_fields);


//
// orgu_types
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"default_lang" => array (
		"notnull" => true
		,"length" => 4
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"icon" => array (
		"notnull" => false
		,"length" => 256
		,"fixed" => false
		,"type" => "text"
	)
	,"owner" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"create_date" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"last_update" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
);
$ilDB->createTable("orgu_types", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("orgu_types", $pk_fields);

$ilDB->createSequence("orgu_types", 1);


//
// orgu_types_adv_md_rec
//
$fields = array (
	"type_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"rec_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("orgu_types_adv_md_rec", $fields);

$pk_fields = array("type_id","rec_id");
$ilDB->addPrimaryKey("orgu_types_adv_md_rec", $pk_fields);


//
// orgu_types_trans
//
$fields = array (
	"orgu_type_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"lang" => array (
		"notnull" => true
		,"length" => 4
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"member" => array (
		"notnull" => true
		,"length" => 32
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"value" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("orgu_types_trans", $fields);

$pk_fields = array("orgu_type_id","lang","member");
$ilDB->addPrimaryKey("orgu_types_trans", $pk_fields);


//
// osc_activity
//
$fields = array (
	"conversation_id" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"timestamp" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"is_closed" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("osc_activity", $fields);

$pk_fields = array("conversation_id","user_id");
$ilDB->addPrimaryKey("osc_activity", $pk_fields);


//
// osc_conversation
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"is_group" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"participants" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("osc_conversation", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("osc_conversation", $pk_fields);


//
// osc_messages
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"conversation_id" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"message" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"timestamp" => array (
		"notnull" => true
		,"length" => 8
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("osc_messages", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("osc_messages", $pk_fields);

$in_fields = array("user_id");
$ilDB->addIndex("osc_messages", $in_fields, "i1", false);

$in_fields = array("conversation_id");
$ilDB->addIndex("osc_messages", $in_fields, "i2", false);

$in_fields = array("conversation_id","user_id","timestamp");
$ilDB->addIndex("osc_messages", $in_fields, "i3", false);


//
// page_anchor
//
$fields = array (
	"page_parent_type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => " "
		,"fixed" => false
		,"type" => "text"
	)
	,"page_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"anchor_name" => array (
		"notnull" => true
		,"length" => 120
		,"default" => " "
		,"fixed" => false
		,"type" => "text"
	)
	,"page_lang" => array (
		"notnull" => true
		,"length" => 2
		,"default" => "-"
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("page_anchor", $fields);

$pk_fields = array("page_parent_type","page_id","page_lang","anchor_name");
$ilDB->addPrimaryKey("page_anchor", $pk_fields);


//
// page_editor_settings
//
$fields = array (
	"settings_grp" => array (
		"notnull" => true
		,"length" => 10
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"name" => array (
		"notnull" => true
		,"length" => 30
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"value" => array (
		"notnull" => false
		,"length" => 30
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("page_editor_settings", $fields);

$pk_fields = array("settings_grp","name");
$ilDB->addPrimaryKey("page_editor_settings", $pk_fields);

$ilDB->insert("page_editor_settings", array(
'settings_grp' => array('text', 'rep'), 'name' => array('text', 'active_acc'), 'value' => array('text', '1')));

$ilDB->insert("page_editor_settings", array(
'settings_grp' => array('text', 'rep'), 'name' => array('text', 'active_code'), 'value' => array('text', '1')));

$ilDB->insert("page_editor_settings", array(
'settings_grp' => array('text', 'rep'), 'name' => array('text', 'active_com'), 'value' => array('text', '1')));

$ilDB->insert("page_editor_settings", array(
'settings_grp' => array('text', 'rep'), 'name' => array('text', 'active_emp'), 'value' => array('text', '1')));

$ilDB->insert("page_editor_settings", array(
'settings_grp' => array('text', 'rep'), 'name' => array('text', 'active_fn'), 'value' => array('text', '1')));

$ilDB->insert("page_editor_settings", array(
'settings_grp' => array('text', 'rep'), 'name' => array('text', 'active_imp'), 'value' => array('text', '1')));

$ilDB->insert("page_editor_settings", array(
'settings_grp' => array('text', 'rep'), 'name' => array('text', 'active_quot'), 'value' => array('text', '1')));

$ilDB->insert("page_editor_settings", array(
'settings_grp' => array('text', 'rep'), 'name' => array('text', 'active_str'), 'value' => array('text', '1')));

$ilDB->insert("page_editor_settings", array(
'settings_grp' => array('text', 'rep'), 'name' => array('text', 'active_sub'), 'value' => array('text', '1')));

$ilDB->insert("page_editor_settings", array(
'settings_grp' => array('text', 'rep'), 'name' => array('text', 'active_sup'), 'value' => array('text', '1')));

$ilDB->insert("page_editor_settings", array(
'settings_grp' => array('text', 'rep'), 'name' => array('text', 'active_tex'), 'value' => array('text', '1')));

$ilDB->insert("page_editor_settings", array(
'settings_grp' => array('text', 'rep'), 'name' => array('text', 'active_xln'), 'value' => array('text', '1')));


//
// page_history
//
$fields = array (
	"page_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"parent_type" => array (
		"notnull" => true
		,"length" => 4
		,"default" => " "
		,"fixed" => false
		,"type" => "text"
	)
	,"hdate" => array (
		"notnull" => true
		,"default" => "1970-01-01 00:00:00"
		,"type" => "timestamp"
	)
	,"parent_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"nr" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"content" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"ilias_version" => array (
		"notnull" => false
		,"length" => 20
		,"fixed" => false
		,"type" => "text"
	)
	,"lang" => array (
		"notnull" => true
		,"length" => 2
		,"default" => "-"
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("page_history", $fields);

$pk_fields = array("page_id","parent_type","hdate","lang");
$ilDB->addPrimaryKey("page_history", $pk_fields);

$in_fields = array("page_id");
$ilDB->addIndex("page_history", $in_fields, "i1", false);

$in_fields = array("parent_id","parent_type","hdate");
$ilDB->addIndex("page_history", $in_fields, "i2", false);


//
// page_layout
//
$fields = array (
	"layout_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"content" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 128
		,"fixed" => false
		,"type" => "text"
	)
	,"description" => array (
		"notnull" => false
		,"length" => 255
		,"fixed" => false
		,"type" => "text"
	)
	,"active" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"style_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"special_page" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"mod_scorm" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"mod_portfolio" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
	,"mod_lm" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"type" => "integer"
	)
);
$ilDB->createTable("page_layout", $fields);

$pk_fields = array("layout_id");
$ilDB->addPrimaryKey("page_layout", $pk_fields);

$ilDB->createSequence("page_layout", 6);

$ilDB->insert("page_layout", array(
'layout_id' => array('integer', '1'), 'content' => array('clob', ''), 'title' => array('text', '1A Simple text page with accompanying media'), 'description' => array('text', 'Example description'), 'active' => array('integer', '1'), 'style_id' => array('integer', '0'), 'special_page' => array('integer', '0'), 'mod_scorm' => array('integer', '1'), 'mod_portfolio' => array('integer', '0'), 'mod_lm' => array('integer', '')));

$ilDB->insert("page_layout", array(
'layout_id' => array('integer', '2'), 'content' => array('clob', ''), 'title' => array('text', '1C Text page with accompanying media and test'), 'description' => array('text', ''), 'active' => array('integer', '1'), 'style_id' => array('integer', '0'), 'special_page' => array('integer', '0'), 'mod_scorm' => array('integer', '1'), 'mod_portfolio' => array('integer', '0'), 'mod_lm' => array('integer', '')));

$ilDB->insert("page_layout", array(
'layout_id' => array('integer', '3'), 'content' => array('clob', ''), 'title' => array('text', '1E Text page with accompanying media followed by test and text'), 'description' => array('text', ''), 'active' => array('integer', '1'), 'style_id' => array('integer', '0'), 'special_page' => array('integer', '0'), 'mod_scorm' => array('integer', '1'), 'mod_portfolio' => array('integer', '0'), 'mod_lm' => array('integer', '')));

$ilDB->insert("page_layout", array(
'layout_id' => array('integer', '4'), 'content' => array('clob', ''), 'title' => array('text', '2C Simple media page with accompanying text and test'), 'description' => array('text', ''), 'active' => array('integer', '1'), 'style_id' => array('integer', '0'), 'special_page' => array('integer', '0'), 'mod_scorm' => array('integer', '1'), 'mod_portfolio' => array('integer', '0'), 'mod_lm' => array('integer', '')));

$ilDB->insert("page_layout", array(
'layout_id' => array('integer', '5'), 'content' => array('clob', ''), 'title' => array('text', '7C Vertical component navigation page with media and text'), 'description' => array('text', ''), 'active' => array('integer', '1'), 'style_id' => array('integer', '0'), 'special_page' => array('integer', '0'), 'mod_scorm' => array('integer', '1'), 'mod_portfolio' => array('integer', '0'), 'mod_lm' => array('integer', '')));


//
// page_object
//
$fields = array (
	"page_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"parent_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"content" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"parent_type" => array (
		"notnull" => true
		,"length" => 4
		,"default" => "lm"
		,"fixed" => false
		,"type" => "text"
	)
	,"last_change_user" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"view_cnt" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"last_change" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"created" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"create_user" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"render_md5" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"rendered_content" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"rendered_time" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"activation_start" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"activation_end" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"active" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "1"
		,"type" => "integer"
	)
	,"is_empty" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"inactive_elements" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"int_links" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"show_activation_info" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"lang" => array (
		"notnull" => true
		,"length" => 2
		,"default" => "-"
		,"fixed" => false
		,"type" => "text"
	)
	,"edit_lock_user" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"edit_lock_ts" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("page_object", $fields);

$pk_fields = array("page_id","parent_type","lang");
$ilDB->addPrimaryKey("page_object", $pk_fields);

$in_fields = array("parent_id","parent_type","last_change");
$ilDB->addIndex("page_object", $in_fields, "i3", false);

$ilDB->insert("page_object", array(
'page_id' => array('integer', '1'), 'parent_id' => array('integer', ''), 'content' => array('clob', '<PageObject></PageObject>'), 'parent_type' => array('text', 'impr'), 'last_change_user' => array('integer', '6'), 'view_cnt' => array('integer', '0'), 'last_change' => array('timestamp', '2016-12-16 15:25:17'), 'created' => array('timestamp', '2016-12-16 15:25:17'), 'create_user' => array('integer', '6'), 'render_md5' => array('text', '52bee1212f8a154aac268a0c20b77437'), 'rendered_content' => array('clob', '<a class="small" id="ilPageShowAdvContent" style="display:none; text-align:right;" href="#"><span>{{{{{LV_show_adv}}}}}</span><span>{{{{{LV_hide_adv}}}}}</span></a><h1 class="ilc_page_title_PageTitle">Legal Notice</h1><!--COPage-PageTop-->
<div xmlns:xhtml="http://www.w3.org/1999/xhtml" style="clear:both;"><!--Break--></div>
'), 'rendered_time' => array('timestamp', '2016-12-16 15:25:17'), 'activation_start' => array('timestamp', ''), 'activation_end' => array('timestamp', ''), 'active' => array('integer', '1'), 'is_empty' => array('integer', '0'), 'inactive_elements' => array('integer', '0'), 'int_links' => array('integer', '0'), 'show_activation_info' => array('integer', '0'), 'lang' => array('text', '-'), 'edit_lock_user' => array('integer', ''), 'edit_lock_ts' => array('integer', '0')));

$ilDB->insert("page_object", array(
'page_id' => array('integer', '1'), 'parent_id' => array('integer', '0'), 'content' => array('clob', '<PageObject><PageContent PCID="9f77db1d8a478497d69b99d938faa8ff"><Paragraph Language="en" Characteristic="Headline1">Headline 1</Paragraph></PageContent><PageContent PCID="134d24457cbc90ea1bf1a1323d7c3a89"><Table Language="en" Border="0px" CellPadding="2px" CellSpacing="0px" HorizontalAlign="Left" Width="100%"><TableRow PCID="ccade07caf9fd13e8c7012f29c9510be"><TableData PCID="a4e417c08feebeafb1487e60a2e245a4" Width="66%"><PageContent PCID="1f77eb1d8a478497d69b99d938fda8f"><PlaceHolder ContentClass="Text" Height="500px"/></PageContent></TableData><TableData PCID="46ac4936082485f457c7041278b5c5f5"><PageContent PCID="2e77eb1d8a478497d69b99d938fda8e"><PlaceHolder ContentClass="Media" Height="300px"/></PageContent></TableData> </TableRow></Table></PageContent></PageObject>'), 'parent_type' => array('text', 'stys'), 'last_change_user' => array('integer', '0'), 'view_cnt' => array('integer', '0'), 'last_change' => array('timestamp', ''), 'created' => array('timestamp', ''), 'create_user' => array('integer', '0'), 'render_md5' => array('text', ''), 'rendered_content' => array('clob', ''), 'rendered_time' => array('timestamp', ''), 'activation_start' => array('timestamp', ''), 'activation_end' => array('timestamp', ''), 'active' => array('integer', '1'), 'is_empty' => array('integer', '0'), 'inactive_elements' => array('integer', '0'), 'int_links' => array('integer', '0'), 'show_activation_info' => array('integer', '0'), 'lang' => array('text', '-'), 'edit_lock_user' => array('integer', '0'), 'edit_lock_ts' => array('integer', '0')));

$ilDB->insert("page_object", array(
'page_id' => array('integer', '2'), 'parent_id' => array('integer', '0'), 'content' => array('clob', '<PageObject><PageContent PCID="9f77db1d8a478497d69b99d938faa8ff"><Paragraph Language="en" Characteristic="Headline1">Headline 1</Paragraph></PageContent><PageContent PCID="134d24457cbc90ea1bf1a1323d7c3a89"><Table Language="en" Border="0px" CellPadding="2px" CellSpacing="0px" HorizontalAlign="Left" Width="100%"><TableRow PCID="ccade07caf9fd13e8c7012f29c9510be"><TableData PCID="a4e417c08feebeafb1487e60a2e245a4" Width="66%"><PageContent PCID="1f77eb1d8a478497d69b99d938fda8f"><PlaceHolder ContentClass="Text" Height="300px"/></PageContent><PageContent PCID="3f77eb1d8a478493d69b99d438fda8f"><PlaceHolder ContentClass="Question" Height="200px"/></PageContent></TableData><TableData PCID="46ac4936082485f457c7041278b5c5f5"><PageContent PCID="2e77eb1d8a478497d69b99d938fda8e"><PlaceHolder ContentClass="Media" Height="300px"/></PageContent></TableData> </TableRow></Table></PageContent></PageObject>'), 'parent_type' => array('text', 'stys'), 'last_change_user' => array('integer', '0'), 'view_cnt' => array('integer', '0'), 'last_change' => array('timestamp', ''), 'created' => array('timestamp', ''), 'create_user' => array('integer', '0'), 'render_md5' => array('text', ''), 'rendered_content' => array('clob', ''), 'rendered_time' => array('timestamp', ''), 'activation_start' => array('timestamp', ''), 'activation_end' => array('timestamp', ''), 'active' => array('integer', '1'), 'is_empty' => array('integer', '0'), 'inactive_elements' => array('integer', '0'), 'int_links' => array('integer', '0'), 'show_activation_info' => array('integer', '0'), 'lang' => array('text', '-'), 'edit_lock_user' => array('integer', '0'), 'edit_lock_ts' => array('integer', '0')));

$ilDB->insert("page_object", array(
'page_id' => array('integer', '3'), 'parent_id' => array('integer', '0'), 'content' => array('clob', '<PageObject><PageContent PCID="9f77db1d8a478497d69b99d938faa8ff"><Paragraph Language="en" Characteristic="Headline1">Headline 1</Paragraph></PageContent><PageContent PCID="134d24457cbc90ea1bf1a1323d7c3a89"><Table Language="en" Border="0px" CellPadding="2px" CellSpacing="0px" HorizontalAlign="Left" Width="100%"><TableRow PCID="ccade07caf9fd13e8c7012f29c9510be"><TableData PCID="a4e417c08feebeafb1487e60a2e245a4" Width="66%"><PageContent PCID="1f77eb1d8a478497d69b99d938fda8f"><PlaceHolder ContentClass="Text" Height="300px"/></PageContent><PageContent PCID="3f77eb1d8a478493d69b99d438fda8f"><PlaceHolder ContentClass="Question" Height="200px"/></PageContent><PageContent PCID="9b77eb1d8a478197d69b99d938fea8f"><PlaceHolder ContentClass="Text" Height="200px"/></PageContent></TableData><TableData PCID="46ac4936082485f457c7041278b5c5f5"><PageContent PCID="2e77eb1d8a478497d69b99d938fda8e"><PlaceHolder ContentClass="Media" Height="300px"/></PageContent></TableData> </TableRow></Table></PageContent></PageObject>'), 'parent_type' => array('text', 'stys'), 'last_change_user' => array('integer', '0'), 'view_cnt' => array('integer', '0'), 'last_change' => array('timestamp', ''), 'created' => array('timestamp', ''), 'create_user' => array('integer', '0'), 'render_md5' => array('text', ''), 'rendered_content' => array('clob', ''), 'rendered_time' => array('timestamp', ''), 'activation_start' => array('timestamp', ''), 'activation_end' => array('timestamp', ''), 'active' => array('integer', '1'), 'is_empty' => array('integer', '0'), 'inactive_elements' => array('integer', '0'), 'int_links' => array('integer', '0'), 'show_activation_info' => array('integer', '0'), 'lang' => array('text', '-'), 'edit_lock_user' => array('integer', '0'), 'edit_lock_ts' => array('integer', '0')));

$ilDB->insert("page_object", array(
'page_id' => array('integer', '4'), 'parent_id' => array('integer', '0'), 'content' => array('clob', '<PageObject><PageContent PCID="9f77db1d8a478497d69b99d938faa8ff"><Paragraph Language="en" Characteristic="Headline1">Headline 1</Paragraph></PageContent><PageContent PCID="134d24457cbc90ea1bf1a1323d7c3a89"><Table Language="en" Border="0px" CellPadding="2px" CellSpacing="0px" HorizontalAlign="Left" Width="100%"><TableRow PCID="ccade07caf9fd13e8c7012f29c9510be"><TableData PCID="46ac4936082485f457c7041278b5c5f5"><PageContent PCID="2e77eb1d8a478497d69b99d938fda8e"><PlaceHolder ContentClass="Media" Height="300px"/></PageContent></TableData><TableData PCID="a4e417c08feebeafb1487e60a2e245a4" Width="66%"><PageContent PCID="1f77eb1d8a478497d69b99d938fda8f"><PlaceHolder ContentClass="Text" Height="300px"/></PageContent><PageContent PCID="3f77eb1d8a478493d69b99d438fda8f"><PlaceHolder ContentClass="Question" Height="200px"/></PageContent></TableData></TableRow></Table></PageContent></PageObject>'), 'parent_type' => array('text', 'stys'), 'last_change_user' => array('integer', '0'), 'view_cnt' => array('integer', '0'), 'last_change' => array('timestamp', ''), 'created' => array('timestamp', ''), 'create_user' => array('integer', '0'), 'render_md5' => array('text', ''), 'rendered_content' => array('clob', ''), 'rendered_time' => array('timestamp', ''), 'activation_start' => array('timestamp', ''), 'activation_end' => array('timestamp', ''), 'active' => array('integer', '1'), 'is_empty' => array('integer', '0'), 'inactive_elements' => array('integer', '0'), 'int_links' => array('integer', '0'), 'show_activation_info' => array('integer', '0'), 'lang' => array('text', '-'), 'edit_lock_user' => array('integer', '0'), 'edit_lock_ts' => array('integer', '0')));

$ilDB->insert("page_object", array(
'page_id' => array('integer', '5'), 'parent_id' => array('integer', '0'), 'content' => array('clob', '<PageObject><PageContent PCID="9f77db1d8a478497d69b99d938faa8ff"><Paragraph Language="en" Characteristic="Headline1">Headline 1</Paragraph></PageContent><PageContent PCID="134d24457cbc90ea1bf1a1323d7c3a89"><Table Language="en" Border="0px" CellPadding="2px" CellSpacing="0px" HorizontalAlign="Left" Width="100%"><TableRow PCID="ccade07caf9fd13e8c7012f29c9510be"><TableData PCID="a4e417c08feebeafb1487e60a2e245a4" Width="100%"><PageContent PCID="1f77eb1d8a478497d69b99d938fda8f"><PlaceHolder ContentClass="Text" Height="300px"/></PageContent></TableData> </TableRow><TableRow PCID="efade08caf9fd13e8c7012f29c9510be"><TableData PCID="a4e417c08feebeafb1487e60a2e245a4" Width="100%"><PageContent PCID="124d24457cbc90ea1bf1a1323d7c3b89"><Table Language="en" Border="0px" CellPadding="2px" CellSpacing="0px" HorizontalAlign="Left" Width="100%"><TableRow PCID="dfade09caf9fd13e8c7012f29c9510be"><TableData PCID="e4e417c08feebeafb1487e60a2e245a5" Width="33%"><PageContent PCID="3e77eb1d8a478497d69b99d938fda8f"><PlaceHolder ContentClass="Media" Height="150px"/></PageContent><PageContent PCID="4e77eb1d8a478497d69b99d938fda8e"><PlaceHolder ContentClass="Text" Height="250px"/></PageContent></TableData><TableData PCID="a4e417c08feebeafb1487e60a2e245a5" Width="33%"><PageContent PCID="3a77eb1d8a478497d69b99d938fda8f"><PlaceHolder ContentClass="Media" Height="150px"/></PageContent><PageContent PCID="4ea7eb1d8a478497d69b99d938fda8e"><PlaceHolder ContentClass="Text" Height="250px"/></PageContent></TableData><TableData PCID="b4e417c08feebeafb1487e60a2e245a5" Width="33%"><PageContent PCID="3b77eb1d8a478497d69b99d938fda8f"><PlaceHolder ContentClass="Media" Height="150px"/></PageContent><PageContent PCID="4b77eb1d8a478497d69b99d938fda8e"><PlaceHolder ContentClass="Text" Height="250px"/></PageContent></TableData></TableRow></Table></PageContent></TableData></TableRow></Table></PageContent></PageObject>'), 'parent_type' => array('text', 'stys'), 'last_change_user' => array('integer', '0'), 'view_cnt' => array('integer', '0'), 'last_change' => array('timestamp', ''), 'created' => array('timestamp', ''), 'create_user' => array('integer', '0'), 'render_md5' => array('text', ''), 'rendered_content' => array('clob', ''), 'rendered_time' => array('timestamp', ''), 'activation_start' => array('timestamp', ''), 'activation_end' => array('timestamp', ''), 'active' => array('integer', '1'), 'is_empty' => array('integer', '0'), 'inactive_elements' => array('integer', '0'), 'int_links' => array('integer', '0'), 'show_activation_info' => array('integer', '0'), 'lang' => array('text', '-'), 'edit_lock_user' => array('integer', '0'), 'edit_lock_ts' => array('integer', '0')));


//
// page_pc_usage
//
$fields = array (
	"pc_type" => array (
		"notnull" => true
		,"length" => 30
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"pc_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usage_type" => array (
		"notnull" => true
		,"length" => 30
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"usage_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usage_hist_nr" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"usage_lang" => array (
		"notnull" => true
		,"length" => 2
		,"default" => "-"
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("page_pc_usage", $fields);

$pk_fields = array("pc_type","pc_id","usage_type","usage_id","usage_hist_nr","usage_lang");
$ilDB->addPrimaryKey("page_pc_usage", $pk_fields);


//
// page_qst_answer
//
$fields = array (
	"qst_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"try" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"passed" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"points" => array (
		"notnull" => true
		,"default" => "0"
		,"type" => "float"
	)
	,"unlocked" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("page_qst_answer", $fields);

$pk_fields = array("qst_id","user_id");
$ilDB->addPrimaryKey("page_qst_answer", $pk_fields);


//
// page_question
//
$fields = array (
	"page_parent_type" => array (
		"notnull" => true
		,"length" => 4
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"page_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"question_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"page_lang" => array (
		"notnull" => true
		,"length" => 2
		,"default" => "-"
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("page_question", $fields);

$pk_fields = array("page_parent_type","page_id","question_id","page_lang");
$ilDB->addPrimaryKey("page_question", $pk_fields);

$in_fields = array("page_parent_type","page_id","page_lang");
$ilDB->addIndex("page_question", $in_fields, "i1", false);

$in_fields = array("question_id");
$ilDB->addIndex("page_question", $in_fields, "i2", false);


//
// page_style_usage
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"page_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"page_type" => array (
		"notnull" => true
		,"length" => 10
		,"default" => ""
		,"fixed" => true
		,"type" => "text"
	)
	,"page_nr" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"template" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"stype" => array (
		"notnull" => false
		,"length" => 30
		,"fixed" => false
		,"type" => "text"
	)
	,"sname" => array (
		"notnull" => false
		,"length" => 30
		,"fixed" => true
		,"type" => "text"
	)
	,"page_lang" => array (
		"notnull" => true
		,"length" => 2
		,"default" => "-"
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("page_style_usage", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("page_style_usage", $pk_fields);

$in_fields = array("page_id","page_type","page_lang","page_nr");
$ilDB->addIndex("page_style_usage", $in_fields, "i1", false);

$ilDB->createSequence("page_style_usage", 1);


//
// pdfgen_conf
//
$fields = array (
	"conf_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"renderer" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"service" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"purpose" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"config" => array (
		"notnull" => false
		,"type" => "clob"
	)
);
$ilDB->createTable("pdfgen_conf", $fields);

$pk_fields = array("conf_id");
$ilDB->addPrimaryKey("pdfgen_conf", $pk_fields);

$ilDB->createSequence("pdfgen_conf", 1);


//
// pdfgen_map
//
$fields = array (
	"map_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"service" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"purpose" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"preferred" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"selected" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("pdfgen_map", $fields);

$pk_fields = array("map_id");
$ilDB->addPrimaryKey("pdfgen_map", $pk_fields);

$ilDB->createSequence("pdfgen_map", 6);

$ilDB->insert("pdfgen_map", array(
'map_id' => array('integer', '1'), 'service' => array('text', 'Test'), 'purpose' => array('text', 'PrintViewOfQuestions'), 'preferred' => array('text', 'WkhtmlToPdf'), 'selected' => array('text', 'WkhtmlToPdf')));

$ilDB->insert("pdfgen_map", array(
'map_id' => array('integer', '2'), 'service' => array('text', 'Test'), 'purpose' => array('text', 'UserResult'), 'preferred' => array('text', 'WkhtmlToPdf'), 'selected' => array('text', 'WkhtmlToPdf')));

$ilDB->insert("pdfgen_map", array(
'map_id' => array('integer', '3'), 'service' => array('text', 'Wiki'), 'purpose' => array('text', 'ContentExport'), 'preferred' => array('text', 'WkhtmlToPdf'), 'selected' => array('text', 'WkhtmlToPdf')));

$ilDB->insert("pdfgen_map", array(
'map_id' => array('integer', '4'), 'service' => array('text', 'Portfolio'), 'purpose' => array('text', 'ContentExport'), 'preferred' => array('text', 'WkhtmlToPdf'), 'selected' => array('text', 'WkhtmlToPdf')));

$ilDB->insert("pdfgen_map", array(
'map_id' => array('integer', '5'), 'service' => array('text', 'Survey'), 'purpose' => array('text', 'Results'), 'preferred' => array('text', 'WkhtmlToPdf'), 'selected' => array('text', 'WkhtmlToPdf')));


//
// pdfgen_purposes
//
$fields = array (
	"purpose_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"service" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"purpose" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("pdfgen_purposes", $fields);

$pk_fields = array("purpose_id");
$ilDB->addPrimaryKey("pdfgen_purposes", $pk_fields);

$ilDB->createSequence("pdfgen_purposes", 6);

$ilDB->insert("pdfgen_purposes", array(
'purpose_id' => array('integer', '1'), 'service' => array('text', 'Test'), 'purpose' => array('text', 'PrintViewOfQuestions')));

$ilDB->insert("pdfgen_purposes", array(
'purpose_id' => array('integer', '2'), 'service' => array('text', 'Test'), 'purpose' => array('text', 'UserResult')));

$ilDB->insert("pdfgen_purposes", array(
'purpose_id' => array('integer', '3'), 'service' => array('text', 'Wiki'), 'purpose' => array('text', 'ContentExport')));

$ilDB->insert("pdfgen_purposes", array(
'purpose_id' => array('integer', '4'), 'service' => array('text', 'Portfolio'), 'purpose' => array('text', 'ContentExport')));

$ilDB->insert("pdfgen_purposes", array(
'purpose_id' => array('integer', '5'), 'service' => array('text', 'Survey'), 'purpose' => array('text', 'Results')));


//
// pdfgen_renderer
//
$fields = array (
	"renderer_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"renderer" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"path" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("pdfgen_renderer", $fields);

$pk_fields = array("renderer_id");
$ilDB->addPrimaryKey("pdfgen_renderer", $pk_fields);

$ilDB->createSequence("pdfgen_renderer", 5);

$ilDB->insert("pdfgen_renderer", array(
'renderer_id' => array('integer', '1'), 'renderer' => array('text', 'TCPDF'), 'path' => array('text', 'Services/PDFGeneration/classes/renderer/tcpdf/class.ilTCPDFRenderer.php')));

$ilDB->insert("pdfgen_renderer", array(
'renderer_id' => array('integer', '4'), 'renderer' => array('text', 'WkhtmlToPdf'), 'path' => array('text', 'Services/PDFGeneration/classes/renderer/wkhtmltopdf/class.ilWkhtmlToPdfRenderer.php')));


//
// pdfgen_renderer_avail
//
$fields = array (
	"availability_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"service" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"purpose" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"renderer" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("pdfgen_renderer_avail", $fields);

$pk_fields = array("availability_id");
$ilDB->addPrimaryKey("pdfgen_renderer_avail", $pk_fields);

$ilDB->createSequence("pdfgen_renderer_avail", 13);

$ilDB->insert("pdfgen_renderer_avail", array(
'availability_id' => array('integer', '3'), 'service' => array('text', 'Test'), 'purpose' => array('text', 'PrintViewOfQuestions'), 'renderer' => array('text', 'TCPDF')));

$ilDB->insert("pdfgen_renderer_avail", array(
'availability_id' => array('integer', '4'), 'service' => array('text', 'Test'), 'purpose' => array('text', 'UserResult'), 'renderer' => array('text', 'TCPDF')));

$ilDB->insert("pdfgen_renderer_avail", array(
'availability_id' => array('integer', '5'), 'service' => array('text', 'Wiki'), 'purpose' => array('text', 'ContentExport'), 'renderer' => array('text', 'WkhtmlToPdf')));

$ilDB->insert("pdfgen_renderer_avail", array(
'availability_id' => array('integer', '6'), 'service' => array('text', 'Portfolio'), 'purpose' => array('text', 'ContentExport'), 'renderer' => array('text', 'WkhtmlToPdf')));

$ilDB->insert("pdfgen_renderer_avail", array(
'availability_id' => array('integer', '10'), 'service' => array('text', 'Test'), 'purpose' => array('text', 'PrintViewOfQuestions'), 'renderer' => array('text', 'WkhtmlToPdf')));

$ilDB->insert("pdfgen_renderer_avail", array(
'availability_id' => array('integer', '9'), 'service' => array('text', 'Test'), 'purpose' => array('text', 'UserResult'), 'renderer' => array('text', 'WkhtmlToPdf')));

$ilDB->insert("pdfgen_renderer_avail", array(
'availability_id' => array('integer', '12'), 'service' => array('text', 'Survey'), 'purpose' => array('text', 'Results'), 'renderer' => array('text', 'WkhtmlToPdf')));


//
// personal_clipboard
//
$fields = array (
	"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"item_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"type" => array (
		"notnull" => true
		,"length" => 4
		,"default" => ""
		,"fixed" => true
		,"type" => "text"
	)
	,"title" => array (
		"notnull" => false
		,"length" => 70
		,"fixed" => true
		,"type" => "text"
	)
	,"insert_time" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"parent" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"order_nr" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("personal_clipboard", $fields);

$pk_fields = array("user_id","item_id","type");
$ilDB->addPrimaryKey("personal_clipboard", $pk_fields);

$in_fields = array("item_id","type");
$ilDB->addIndex("personal_clipboard", $in_fields, "it", false);


//
// personal_pc_clipboard
//
$fields = array (
	"user_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"content" => array (
		"notnull" => false
		,"type" => "clob"
	)
	,"insert_time" => array (
		"notnull" => true
		,"default" => ""
		,"type" => "timestamp"
	)
	,"order_nr" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("personal_pc_clipboard", $fields);

$pk_fields = array("user_id","insert_time","order_nr");
$ilDB->addPrimaryKey("personal_pc_clipboard", $pk_fields);

$in_fields = array("user_id");
$ilDB->addIndex("personal_pc_clipboard", $in_fields, "i1", false);


//
// pg_amd_page_list
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"field_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"data" => array (
		"notnull" => false
		,"length" => 4000
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("pg_amd_page_list", $fields);

$pk_fields = array("id","field_id");
$ilDB->addPrimaryKey("pg_amd_page_list", $pk_fields);

$ilDB->createSequence("pg_amd_page_list", 1);


//
// post_conditions
//
$fields = array (
	"ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"value" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"condition_operator" => array (
		"notnull" => true
		,"length" => 32
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("post_conditions", $fields);

$pk_fields = array("ref_id","condition_operator","value");
$ilDB->addPrimaryKey("post_conditions", $pk_fields);


//
// preview_data
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"render_date" => array (
		"notnull" => true
		,"default" => "1970-01-01 00:00:00"
		,"type" => "timestamp"
	)
	,"render_status" => array (
		"notnull" => true
		,"length" => 20
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("preview_data", $fields);

$pk_fields = array("obj_id");
$ilDB->addPrimaryKey("preview_data", $pk_fields);


//
// prg_auto_content
//
$fields = array (
	"prg_obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"cat_ref_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"title" => array (
		"notnull" => true
		,"length" => 255
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"last_usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"last_edited" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
);
$ilDB->createTable("prg_auto_content", $fields);

$pk_fields = array("prg_obj_id","cat_ref_id");
$ilDB->addPrimaryKey("prg_auto_content", $pk_fields);


//
// prg_auto_membership
//
$fields = array (
	"prg_obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"source_type" => array (
		"notnull" => true
		,"length" => 8
		,"default" => ""
		,"fixed" => false
		,"type" => "text"
	)
	,"source_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"enabled" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"last_usr_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => ""
		,"type" => "integer"
	)
	,"last_edited" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
);
$ilDB->createTable("prg_auto_membership", $fields);

$pk_fields = array("prg_obj_id","source_type","source_id");
$ilDB->addPrimaryKey("prg_auto_membership", $pk_fields);


//
// prg_settings
//
$fields = array (
	"obj_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"last_change" => array (
		"notnull" => true
		,"default" => "1970-01-01 00:00:00"
		,"type" => "timestamp"
	)
	,"subtype_id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"points" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"lp_mode" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"status" => array (
		"notnull" => true
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"deadline_period" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"deadline_date" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"vq_period" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "-1"
		,"type" => "integer"
	)
	,"vq_date" => array (
		"notnull" => false
		,"type" => "timestamp"
	)
	,"vq_restart_period" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "-1"
		,"type" => "integer"
	)
	,"rm_nr_by_usr_days" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"proc_end_no_success" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"send_re_assigned_mail" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"send_info_to_re_assign_mail" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"send_risky_to_fail_mail" => array (
		"notnull" => false
		,"length" => 1
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
);
$ilDB->createTable("prg_settings", $fields);

$pk_fields = array("obj_id");
$ilDB->addPrimaryKey("prg_settings", $pk_fields);

$ilDB->createSequence("prg_settings", 1);


//
// prg_translations
//
$fields = array (
	"id" => array (
		"notnull" => true
		,"length" => 4
		,"unsigned" => false
		,"default" => "0"
		,"type" => "integer"
	)
	,"prg_type_id" => array (
		"notnull" => false
		,"length" => 4
		,"unsigned" => false
		,"type" => "integer"
	)
	,"lang" => array (
		"notnull" => false
		,"length" => 4
		,"fixed" => false
		,"type" => "text"
	)
	,"member" => array (
		"notnull" => false
		,"length" => 32
		,"fixed" => false
		,"type" => "text"
	)
	,"value" => array (
		"notnull" => false
		,"length" => 3500
		,"fixed" => false
		,"type" => "text"
	)
);
$ilDB->createTable("prg_translations", $fields);

$pk_fields = array("id");
$ilDB->addPrimaryKey("prg_translations", $pk_fields);

$ilDB->createSequence("prg_translations", 1);


//
// prg_type
//
$fields = array (
	"id" => arra